/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.OrderedMap;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PixmapPacker
implements Disposable {
    static Pattern indexPattern = Pattern.compile("(.+)_(\\d+)$");
    int alphaThreshold;
    private Color c;
    boolean disposed;
    boolean duplicateBorder;
    PackStrategy packStrategy;
    boolean packToTexture;
    int padding;
    Pixmap.Format pageFormat;
    int pageHeight;
    int pageWidth;
    final Array<Page> pages;
    boolean stripWhitespaceX;
    boolean stripWhitespaceY;
    Color transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);

    public PixmapPacker(int n, int n2, Pixmap.Format format, int n3, boolean bl) {
        this(n, n2, format, n3, bl, false, false, new GuillotineStrategy());
    }

    public PixmapPacker(int n, int n2, Pixmap.Format format, int n3, boolean bl, PackStrategy packStrategy) {
        this(n, n2, format, n3, bl, false, false, packStrategy);
    }

    public PixmapPacker(int n, int n2, Pixmap.Format format, int n3, boolean bl, boolean bl2, boolean bl3, PackStrategy packStrategy) {
        this.pages = new Array();
        this.c = new Color();
        this.pageWidth = n;
        this.pageHeight = n2;
        this.pageFormat = format;
        this.padding = n3;
        this.duplicateBorder = bl;
        this.stripWhitespaceX = bl2;
        this.stripWhitespaceY = bl3;
        this.packStrategy = packStrategy;
    }

    private int[] getPads(Pixmap object, int[] nArray) {
        int n = ((Pixmap)object).getHeight() - 1;
        int n2 = ((Pixmap)object).getWidth() - 1;
        int n3 = this.getSplitPoint((Pixmap)object, 1, n, true, true);
        int n4 = this.getSplitPoint((Pixmap)object, n2, 1, true, false);
        int n5 = n3 != 0 ? this.getSplitPoint((Pixmap)object, n3 + 1, n, false, true) : 0;
        int n6 = n4 != 0 ? this.getSplitPoint((Pixmap)object, n2, n4 + 1, false, false) : 0;
        this.getSplitPoint((Pixmap)object, n5 + 1, n, true, true);
        this.getSplitPoint((Pixmap)object, n2, n6 + 1, true, false);
        if (n3 == 0 && n5 == 0 && n4 == 0 && n6 == 0) {
            return null;
        }
        n = -1;
        if (n3 == 0 && n5 == 0) {
            n5 = -1;
            n3 = -1;
        } else if (n3 > 0) {
            --n3;
            n5 = ((Pixmap)object).getWidth() - 2 - (n5 - 1);
        } else {
            n5 = ((Pixmap)object).getWidth() - 2;
        }
        if (n4 == 0 && n6 == 0) {
            n4 = -1;
            n6 = n;
        } else if (n4 > 0) {
            --n4;
            n6 = ((Pixmap)object).getHeight() - 2 - (n6 - 1);
        } else {
            n6 = ((Pixmap)object).getHeight() - 2;
        }
        object = new int[4];
        object[0] = n3;
        object[1] = n5;
        object[2] = n4;
        object[3] = n6;
        if (nArray != null && Arrays.equals((int[])object, nArray)) {
            return null;
        }
        return object;
    }

    private int getSplitPoint(Pixmap pixmap, int n, int n2, boolean bl, boolean bl2) {
        int[] nArray = new int[4];
        int n3 = bl2 ? pixmap.getWidth() : pixmap.getHeight();
        int n4 = bl ? 255 : 0;
        for (int i = bl2 ? n : n2; i != n3; ++i) {
            if (bl2) {
                n = i;
            } else {
                n2 = i;
            }
            int n5 = pixmap.getPixel(n, n2);
            this.c.set(n5);
            nArray[0] = (int)(this.c.r * 255.0f);
            nArray[1] = (int)(this.c.g * 255.0f);
            nArray[2] = (int)(this.c.b * 255.0f);
            nArray[3] = (int)(this.c.a * 255.0f);
            if (nArray[3] == n4) {
                return i;
            }
            if (bl || nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 255) continue;
            PrintStream printStream = System.out;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n);
            stringBuilder.append("  ");
            stringBuilder.append(n2);
            stringBuilder.append(" ");
            stringBuilder.append(nArray);
            stringBuilder.append(" ");
            printStream.println(stringBuilder.toString());
        }
        return 0;
    }

    private int[] getSplits(Pixmap pixmap) {
        int n = this.getSplitPoint(pixmap, 1, 0, true, true);
        int n2 = this.getSplitPoint(pixmap, n, 0, false, true);
        int n3 = this.getSplitPoint(pixmap, 0, 1, true, false);
        int n4 = this.getSplitPoint(pixmap, 0, n3, false, false);
        this.getSplitPoint(pixmap, n2 + 1, 0, true, true);
        this.getSplitPoint(pixmap, 0, n4 + 1, true, false);
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            return null;
        }
        if (n != 0) {
            --n;
            n2 = pixmap.getWidth() - 2 - (n2 - 1);
        } else {
            n2 = pixmap.getWidth() - 2;
        }
        n4 = n3 != 0 ? pixmap.getHeight() - 2 - (n4 - 1) : pixmap.getHeight() - 2;
        return new int[]{n, n2, --n3, n4};
    }

    @Override
    public void dispose() {
        synchronized (this) {
            try {
                for (Page page : this.pages) {
                    if (page.texture != null) continue;
                    page.image.dispose();
                }
                this.disposed = true;
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public TextureAtlas generateTextureAtlas(Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2, boolean bl) {
        synchronized (this) {
            TextureAtlas textureAtlas = new TextureAtlas();
            this.updateTextureAtlas(textureAtlas, textureFilter, textureFilter2, bl);
            return textureAtlas;
        }
    }

    public boolean getDuplicateBorder() {
        return this.duplicateBorder;
    }

    public boolean getPackToTexture() {
        return this.packToTexture;
    }

    public int getPadding() {
        return this.padding;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Page getPage(String string2) {
        synchronized (this) {
            Page page222;
            Rectangle rectangle;
            Iterator<Page> iterator = this.pages.iterator();
            do {
                if (!iterator.hasNext()) return null;
                page222 = iterator.next();
            } while ((rectangle = (Rectangle)page222.rects.get(string2)) == null);
            return page222;
        }
    }

    public Pixmap.Format getPageFormat() {
        return this.pageFormat;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPageIndex(String string2) {
        synchronized (this) {
            int n = 0;
            while (true) {
                block4: {
                    if (n >= this.pages.size) return -1;
                    Rectangle rectangle = (Rectangle)this.pages.get((int)n).rects.get(string2);
                    if (rectangle == null) break block4;
                    return n;
                }
                ++n;
            }
        }
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public Array<Page> getPages() {
        return this.pages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Rectangle getRect(String string2) {
        synchronized (this) {
            Rectangle rectangle;
            Iterator<Page> iterator = this.pages.iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while ((rectangle = (Rectangle)iterator.next().rects.get(string2)) == null);
            return rectangle;
        }
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }

    public Rectangle pack(Pixmap object) {
        synchronized (this) {
            object = this.pack(null, (Pixmap)object);
            return object;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Rectangle pack(String var1_1, Pixmap var2_3) {
        var3_4 = var1_1;
        var4_5 = var2_3;
        synchronized (this) {
            block34: {
                block30: {
                    block29: {
                        block33: {
                            block28: {
                                block27: {
                                    block32: {
                                        block31: {
                                            block26: {
                                                var5_6 = this.disposed;
                                                var6_7 = null;
                                                if (!var5_6) break block26;
                                                return null;
                                            }
                                            if (var3_4 == null) ** GOTO lbl20
                                            if (this.getRect((String)var1_1) != null) {
                                                var2_3 = new StringBuilder();
                                                var2_3.append("Pixmap has already been packed with name: ");
                                                var2_3.append((String)var3_4);
                                                var1_1 = new GdxRuntimeException(var2_3.toString());
                                                throw var1_1;
                                            }
lbl20:
                                            // 3 sources

                                            var7_8 = 0;
                                            var8_9 = var3_4 != null && var3_4.endsWith(".9") != false ? 1 : 0;
                                            if (var8_9 == 0) break block31;
                                            var6_7 = new PixmapPackerRectangle(0, 0, var2_3.getWidth() - 2, var2_3.getHeight() - 2);
                                            var1_1 = new Pixmap(var2_3.getWidth() - 2, var2_3.getHeight() - 2, var2_3.getFormat());
                                            var1_1.setBlending(Pixmap.Blending.None);
                                            var6_7.splits = this.getSplits((Pixmap)var4_5);
                                            var6_7.pads = this.getPads((Pixmap)var4_5, var6_7.splits);
                                            var1_1.drawPixmap((Pixmap)var2_3, 0, 0, 1, 1, var2_3.getWidth() - 1, var2_3.getHeight() - 1);
                                            var3_4 = var3_4.split("\\.")[0];
                                            var2_3 = var1_1;
                                            var4_5 = var6_7;
                                            ** GOTO lbl105
                                        }
                                        if (this.stripWhitespaceX || this.stripWhitespaceY) break block32;
                                        var9_10 = new PixmapPackerRectangle(0, 0, var2_3.getWidth(), var2_3.getHeight());
                                        var1_1 = var4_5;
                                        var2_3 = var6_7;
                                        var4_5 = var9_10;
                                        ** GOTO lbl105
                                    }
                                    var10_11 = var2_3.getWidth();
                                    var11_12 = var2_3.getHeight();
                                    var12_13 = var2_3.getHeight();
                                    if (!this.stripWhitespaceY) break block27;
                                    var8_9 = 0;
                                    block13: for (var13_14 = 0; var13_14 < var2_3.getHeight(); ++var8_9, ++var13_14) {
                                        for (var14_15 = 0; var14_15 < var2_3.getWidth(); ++var14_15) {
                                            if ((var4_5.getPixel(var14_15, var13_14) & 255) > this.alphaThreshold) break block13;
                                        }
                                    }
                                    var13_14 = var2_3.getHeight();
                                    break block28;
                                }
                                var8_9 = 0;
                                var14_15 = var12_13;
                                break block33;
                            }
                            block15: while ((var14_15 = var13_14 - 1) >= var8_9) {
                                for (var13_14 = 0; var13_14 < var2_3.getWidth(); ++var13_14) {
                                    if ((var4_5.getPixel(var13_14, var14_15) & 255) > this.alphaThreshold) break block15;
                                }
                                --var12_13;
                                var13_14 = var14_15;
                            }
                            var14_15 = var12_13;
                        }
                        var13_14 = var2_3.getWidth();
                        if (!this.stripWhitespaceX) break block29;
                        var12_13 = 0;
                        block17: while (var7_8 < var2_3.getWidth()) {
                            for (var15_16 = var8_9; var15_16 < var14_15; ++var15_16) {
                                if ((var4_5.getPixel(var7_8, var15_16) & 255) > this.alphaThreshold) break block17;
                            }
                            ++var12_13;
                            ++var7_8;
                        }
                        var7_8 = var2_3.getWidth();
                        break block30;
                    }
                    var12_13 = 0;
                    break block34;
                }
                block19: while ((var15_16 = var7_8 - 1) >= var12_13) {
                    for (var7_8 = var8_9; var7_8 < var14_15; ++var7_8) {
                        if ((var4_5.getPixel(var15_16, var7_8) & 255) > this.alphaThreshold) break block19;
                        continue;
                    }
                    --var13_14;
                    var7_8 = var15_16;
                }
            }
            var13_14 -= var12_13;
            var14_15 -= var8_9;
            var1_1 = new Pixmap(var13_14, var14_15, var2_3.getFormat());
            var1_1.setBlending(Pixmap.Blending.None);
            var1_1.drawPixmap((Pixmap)var2_3, 0, 0, var12_13, var8_9, var13_14, var14_15);
            var2_3 = var1_1;
            var4_5 = new PixmapPackerRectangle(0, 0, var13_14, var14_15, var12_13, var8_9, var10_11, var11_12);
            var1_1 = var2_3;
lbl105:
            // 3 sources

            if (var4_5.getWidth() > (float)this.pageWidth || var4_5.getHeight() > (float)this.pageHeight) ** GOTO lbl149
            var6_7 = this.packStrategy.pack(this, (String)var3_4, (Rectangle)var4_5);
            if (var3_4 != null) {
                var6_7.rects.put((String)var3_4, (PixmapPackerRectangle)var4_5);
                var6_7.addedRects.add((String)var3_4);
            }
            var12_13 = (int)var4_5.x;
            var16_17 = (int)var4_5.y;
            var14_15 = (int)var4_5.width;
            var17_18 = (int)var4_5.height;
            if (this.packToTexture && !this.duplicateBorder && var6_7.texture != null && !var6_7.dirty) {
                var6_7.texture.bind();
                Gdx.gl.glTexSubImage2D(var6_7.texture.glTarget, 0, var12_13, var16_17, var14_15, var17_18, var1_1.getGLFormat(), var1_1.getGLType(), var1_1.getPixels());
            } else {
                var6_7.dirty = true;
            }
            var6_7.image.drawPixmap((Pixmap)var1_1, var12_13, var16_17);
            if (!this.duplicateBorder) ** GOTO lbl146
            var11_12 = var1_1.getWidth();
            var18_19 = var1_1.getHeight();
            var3_4 = var6_7.image;
            var13_14 = var12_13 - 1;
            var7_8 = var16_17 - 1;
            var3_4.drawPixmap((Pixmap)var1_1, 0, 0, 1, 1, var13_14, var7_8, 1, 1);
            var3_4 = var6_7.image;
            var15_16 = var11_12 - 1;
            var8_9 = var12_13 + var14_15;
            var3_4.drawPixmap((Pixmap)var1_1, var15_16, 0, 1, 1, var8_9, var7_8, 1, 1);
            var3_4 = var6_7.image;
            var19_20 = var18_19 - 1;
            var10_11 = var16_17 + var17_18;
            var3_4.drawPixmap((Pixmap)var1_1, 0, var19_20, 1, 1, var13_14, var10_11, 1, 1);
            var6_7.image.drawPixmap((Pixmap)var1_1, var15_16, var19_20, 1, 1, var8_9, var10_11, 1, 1);
            var6_7.image.drawPixmap((Pixmap)var1_1, 0, 0, var11_12, 1, var12_13, var7_8, var14_15, 1);
            var6_7.image.drawPixmap((Pixmap)var1_1, 0, var19_20, var11_12, 1, var12_13, var10_11, var14_15, 1);
            var6_7.image.drawPixmap((Pixmap)var1_1, 0, 0, 1, var18_19, var13_14, var16_17, 1, var17_18);
            var6_7.image.drawPixmap((Pixmap)var1_1, var15_16, 0, 1, var18_19, var8_9, var16_17, 1, var17_18);
lbl146:
            // 2 sources

            if (var2_3 == null) return var4_5;
            var2_3.dispose();
            return var4_5;
lbl149:
            // 1 sources

            if (var3_4 == null) {
                var1_1 = new GdxRuntimeException("Page size too small for pixmap.");
                throw var1_1;
            }
            var2_3 = new StringBuilder();
            var2_3.append("Page size too small for pixmap: ");
            var2_3.append((String)var3_4);
            var1_1 = new GdxRuntimeException(var2_3.toString());
            throw var1_1;
        }
    }

    public void setDuplicateBorder(boolean bl) {
        this.duplicateBorder = bl;
    }

    public void setPackToTexture(boolean bl) {
        this.packToTexture = bl;
    }

    public void setPadding(int n) {
        this.padding = n;
    }

    public void setPageFormat(Pixmap.Format format) {
        this.pageFormat = format;
    }

    public void setPageHeight(int n) {
        this.pageHeight = n;
    }

    public void setPageWidth(int n) {
        this.pageWidth = n;
    }

    public void setTransparentColor(Color color2) {
        this.transparentColor.set(color2);
    }

    public void sort(Array<Pixmap> array) {
        this.packStrategy.sort(array);
    }

    public void updatePageTextures(Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2, boolean bl) {
        synchronized (this) {
            try {
                Iterator<Page> iterator = this.pages.iterator();
                while (iterator.hasNext()) {
                    iterator.next().updateTexture(textureFilter, textureFilter2, bl);
                }
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public void updateTextureAtlas(TextureAtlas textureAtlas, Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2, boolean bl) {
        synchronized (this) {
            this.updateTextureAtlas(textureAtlas, textureFilter, textureFilter2, bl, true);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateTextureAtlas(TextureAtlas textureAtlas, Texture.TextureFilter object, Texture.TextureFilter object2, boolean bl, boolean bl2) {
        synchronized (this) {
            void var4_7;
            this.updatePageTextures((Texture.TextureFilter)((Object)object), (Texture.TextureFilter)((Object)object2), (boolean)var4_7);
            Iterator<Page> iterator = this.pages.iterator();
            while (iterator.hasNext()) {
                Page page = iterator.next();
                if (page.addedRects.size <= 0) continue;
                for (String string2 : page.addedRects) {
                    void var5_8;
                    PixmapPackerRectangle pixmapPackerRectangle = (PixmapPackerRectangle)page.rects.get(string2);
                    TextureAtlas.AtlasRegion atlasRegion = new TextureAtlas.AtlasRegion(page.texture, (int)pixmapPackerRectangle.x, (int)pixmapPackerRectangle.y, (int)pixmapPackerRectangle.width, (int)pixmapPackerRectangle.height);
                    if (pixmapPackerRectangle.splits != null) {
                        atlasRegion.splits = pixmapPackerRectangle.splits;
                        atlasRegion.pads = pixmapPackerRectangle.pads;
                    }
                    int n = -1;
                    object = string2;
                    int n2 = n;
                    if (var5_8 != false) {
                        Matcher matcher = indexPattern.matcher(string2);
                        object = string2;
                        n2 = n;
                        if (matcher.matches()) {
                            object = matcher.group(1);
                            n2 = Integer.parseInt(matcher.group(2));
                        }
                    }
                    atlasRegion.name = object;
                    atlasRegion.index = n2;
                    atlasRegion.offsetX = pixmapPackerRectangle.offsetX;
                    atlasRegion.offsetY = (int)((float)pixmapPackerRectangle.originalHeight - pixmapPackerRectangle.height - (float)pixmapPackerRectangle.offsetY);
                    atlasRegion.originalWidth = pixmapPackerRectangle.originalWidth;
                    atlasRegion.originalHeight = pixmapPackerRectangle.originalHeight;
                    textureAtlas.getRegions().add(atlasRegion);
                }
                page.addedRects.clear();
                textureAtlas.getTextures().add(page.texture);
            }
            return;
        }
    }

    public void updateTextureRegions(Array<TextureRegion> array, Texture.TextureFilter object, Texture.TextureFilter textureFilter, boolean bl) {
        synchronized (this) {
            try {
                this.updatePageTextures((Texture.TextureFilter)((Object)object), textureFilter, bl);
                while (array.size < this.pages.size) {
                    object = new TextureRegion(this.pages.get((int)array.size).texture);
                    array.add((TextureRegion)object);
                }
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public static class GuillotineStrategy
    implements PackStrategy {
        Comparator<Pixmap> comparator;

        private Node insert(Node node, Rectangle rectangle) {
            if (!node.full && node.leftChild != null && node.rightChild != null) {
                Node node2;
                Node node3 = node2 = this.insert(node.leftChild, rectangle);
                if (node2 == null) {
                    node3 = this.insert(node.rightChild, rectangle);
                }
                return node3;
            }
            if (node.full) {
                return null;
            }
            if (node.rect.width == rectangle.width && node.rect.height == rectangle.height) {
                return node;
            }
            if (!(node.rect.width < rectangle.width) && !(node.rect.height < rectangle.height)) {
                node.leftChild = new Node();
                node.rightChild = new Node();
                if ((int)node.rect.width - (int)rectangle.width > (int)node.rect.height - (int)rectangle.height) {
                    node.leftChild.rect.x = node.rect.x;
                    node.leftChild.rect.y = node.rect.y;
                    node.leftChild.rect.width = rectangle.width;
                    node.leftChild.rect.height = node.rect.height;
                    node.rightChild.rect.x = node.rect.x + rectangle.width;
                    node.rightChild.rect.y = node.rect.y;
                    node.rightChild.rect.width = node.rect.width - rectangle.width;
                    node.rightChild.rect.height = node.rect.height;
                } else {
                    node.leftChild.rect.x = node.rect.x;
                    node.leftChild.rect.y = node.rect.y;
                    node.leftChild.rect.width = node.rect.width;
                    node.leftChild.rect.height = rectangle.height;
                    node.rightChild.rect.x = node.rect.x;
                    node.rightChild.rect.y = node.rect.y + rectangle.height;
                    node.rightChild.rect.width = node.rect.width;
                    node.rightChild.rect.height = node.rect.height - rectangle.height;
                }
                return this.insert(node.leftChild, rectangle);
            }
            return null;
        }

        @Override
        public Page pack(PixmapPacker pixmapPacker, String object, Rectangle rectangle) {
            Node node;
            if (pixmapPacker.pages.size == 0) {
                object = new GuillotinePage(pixmapPacker);
                pixmapPacker.pages.add((Page)object);
            } else {
                object = (GuillotinePage)pixmapPacker.pages.peek();
            }
            int n = pixmapPacker.padding;
            float f = rectangle.width;
            float f2 = n;
            rectangle.width = f + f2;
            rectangle.height += f2;
            Node node2 = node = this.insert(((GuillotinePage)object).root, rectangle);
            if (node == null) {
                object = new GuillotinePage(pixmapPacker);
                pixmapPacker.pages.add((Page)object);
                node2 = this.insert(((GuillotinePage)object).root, rectangle);
            }
            node2.full = true;
            rectangle.set(node2.rect.x, node2.rect.y, node2.rect.width - f2, node2.rect.height - f2);
            return object;
        }

        @Override
        public void sort(Array<Pixmap> array) {
            if (this.comparator == null) {
                this.comparator = new Comparator<Pixmap>(){

                    @Override
                    public int compare(Pixmap pixmap, Pixmap pixmap2) {
                        return Math.max(pixmap.getWidth(), pixmap.getHeight()) - Math.max(pixmap2.getWidth(), pixmap2.getHeight());
                    }
                };
            }
            array.sort(this.comparator);
        }

        static class GuillotinePage
        extends Page {
            Node root = new Node();

            public GuillotinePage(PixmapPacker pixmapPacker) {
                super(pixmapPacker);
                this.root.rect.x = pixmapPacker.padding;
                this.root.rect.y = pixmapPacker.padding;
                this.root.rect.width = pixmapPacker.pageWidth - pixmapPacker.padding * 2;
                this.root.rect.height = pixmapPacker.pageHeight - pixmapPacker.padding * 2;
            }
        }

        static final class Node {
            public boolean full;
            public Node leftChild;
            public final Rectangle rect = new Rectangle();
            public Node rightChild;

            Node() {
            }
        }
    }

    public static interface PackStrategy {
        public Page pack(PixmapPacker var1, String var2, Rectangle var3);

        public void sort(Array<Pixmap> var1);
    }

    public static class Page {
        final Array<String> addedRects;
        boolean dirty;
        Pixmap image;
        OrderedMap<String, PixmapPackerRectangle> rects = new OrderedMap();
        Texture texture;

        public Page(PixmapPacker pixmapPacker) {
            this.addedRects = new Array();
            this.image = new Pixmap(pixmapPacker.pageWidth, pixmapPacker.pageHeight, pixmapPacker.pageFormat);
            this.image.setBlending(Pixmap.Blending.None);
            this.image.setColor(pixmapPacker.getTransparentColor());
            this.image.fill();
        }

        public Pixmap getPixmap() {
            return this.image;
        }

        public OrderedMap<String, PixmapPackerRectangle> getRects() {
            return this.rects;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public boolean updateTexture(Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2, boolean bl) {
            Disposable disposable = this.texture;
            if (disposable != null) {
                if (!this.dirty) {
                    return false;
                }
                ((Texture)disposable).load(((Texture)disposable).getTextureData());
            } else {
                disposable = this.image;
                this.texture = new Texture(new PixmapTextureData((Pixmap)disposable, ((Pixmap)disposable).getFormat(), bl, false, true)){

                    @Override
                    public void dispose() {
                        super.dispose();
                        Page.this.image.dispose();
                    }
                };
                this.texture.setFilter(textureFilter, textureFilter2);
            }
            this.dirty = false;
            return true;
        }
    }

    public static class PixmapPackerRectangle
    extends Rectangle {
        int offsetX;
        int offsetY;
        int originalHeight;
        int originalWidth;
        int[] pads;
        int[] splits;

        PixmapPackerRectangle(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
            this.offsetX = 0;
            this.offsetY = 0;
            this.originalWidth = n3;
            this.originalHeight = n4;
        }

        PixmapPackerRectangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            super(n, n2, n3, n4);
            this.offsetX = n5;
            this.offsetY = n6;
            this.originalWidth = n7;
            this.originalHeight = n8;
        }
    }

    public static class SkylineStrategy
    implements PackStrategy {
        Comparator<Pixmap> comparator;

        @Override
        public Page pack(PixmapPacker object, String object2, Rectangle rectangle) {
            float f;
            int n = ((PixmapPacker)object).padding;
            int n2 = ((PixmapPacker)object).pageWidth;
            int n3 = n * 2;
            int n4 = n2 - n3;
            int n5 = ((PixmapPacker)object).pageHeight - n3;
            int n6 = (int)rectangle.width + n;
            int n7 = (int)rectangle.height + n;
            int n8 = ((PixmapPacker)object).pages.size;
            for (n3 = 0; n3 < n8; ++n3) {
                Object object3;
                SkylinePage.Row row;
                SkylinePage skylinePage = (SkylinePage)((PixmapPacker)object).pages.get(n3);
                int n9 = skylinePage.rows.size;
                object2 = null;
                for (n2 = 0; n2 < n9 - 1; ++n2) {
                    block10: {
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        row = skylinePage.rows.get(n2);
                                        if (row.x + n6 < n4) break block9;
                                        object3 = object2;
                                        break block10;
                                    }
                                    if (row.y + n7 < n5) break block11;
                                    object3 = object2;
                                    break block10;
                                }
                                if (n7 <= row.height) break block12;
                                object3 = object2;
                                break block10;
                            }
                            if (object2 == null) break block13;
                            object3 = object2;
                            if (row.height >= ((SkylinePage.Row)object2).height) break block10;
                        }
                        object3 = row;
                    }
                    object2 = object3;
                }
                object3 = object2;
                if (object2 == null) {
                    row = skylinePage.rows.peek();
                    if (row.y + n7 >= n5) continue;
                    if (row.x + n6 < n4) {
                        row.height = Math.max(row.height, n7);
                        object3 = row;
                    } else {
                        object3 = object2;
                        if (row.y + row.height + n7 < n5) {
                            object3 = new SkylinePage.Row();
                            ((SkylinePage.Row)object3).y = row.y + row.height;
                            ((SkylinePage.Row)object3).height = n7;
                            skylinePage.rows.add((SkylinePage.Row)object3);
                        }
                    }
                }
                if (object3 == null) continue;
                rectangle.x = ((SkylinePage.Row)object3).x;
                rectangle.y = ((SkylinePage.Row)object3).y;
                ((SkylinePage.Row)object3).x += n6;
                return skylinePage;
            }
            object2 = new SkylinePage((PixmapPacker)object);
            ((PixmapPacker)object).pages.add((Page)object2);
            object = new SkylinePage.Row();
            ((SkylinePage.Row)object).x = n6 + n;
            ((SkylinePage.Row)object).y = n;
            ((SkylinePage.Row)object).height = n7;
            ((SkylinePage)object2).rows.add((SkylinePage.Row)object);
            rectangle.x = f = (float)n;
            rectangle.y = f;
            return object2;
        }

        @Override
        public void sort(Array<Pixmap> array) {
            if (this.comparator == null) {
                this.comparator = new Comparator<Pixmap>(){

                    @Override
                    public int compare(Pixmap pixmap, Pixmap pixmap2) {
                        return pixmap.getHeight() - pixmap2.getHeight();
                    }
                };
            }
            array.sort(this.comparator);
        }

        static class SkylinePage
        extends Page {
            Array<Row> rows = new Array();

            public SkylinePage(PixmapPacker pixmapPacker) {
                super(pixmapPacker);
            }

            static class Row {
                int height;
                int x;
                int y;

                Row() {
                }
            }
        }
    }
}

