/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class CpuSpriteBatch
extends SpriteBatch {
    private final Affine2 adjustAffine;
    private boolean adjustNeeded;
    private boolean haveIdentityRealMatrix = true;
    private final Affine2 tmpAffine;
    private final Matrix4 virtualMatrix = new Matrix4();

    public CpuSpriteBatch() {
        this(1000);
    }

    public CpuSpriteBatch(int n) {
        this(n, null);
    }

    public CpuSpriteBatch(int n, ShaderProgram shaderProgram) {
        super(n, shaderProgram);
        this.adjustAffine = new Affine2();
        this.tmpAffine = new Affine2();
    }

    private static boolean checkEqual(Matrix4 object, Affine2 affine2) {
        boolean bl;
        object = ((Matrix4)object).getValues();
        boolean bl2 = bl = false;
        if (object[0] == affine2.m00) {
            bl2 = bl;
            if (object[1] == affine2.m10) {
                bl2 = bl;
                if (object[4] == affine2.m01) {
                    bl2 = bl;
                    if (object[5] == affine2.m11) {
                        bl2 = bl;
                        if (object[12] == affine2.m02) {
                            bl2 = bl;
                            if (object[13] == affine2.m12) {
                                bl2 = true;
                            }
                        }
                    }
                }
            }
        }
        return bl2;
    }

    private static boolean checkEqual(Matrix4 matrix4, Matrix4 matrix42) {
        boolean bl = true;
        if (matrix4 == matrix42) {
            return true;
        }
        if (matrix4.val[0] != matrix42.val[0] || matrix4.val[1] != matrix42.val[1] || matrix4.val[4] != matrix42.val[4] || matrix4.val[5] != matrix42.val[5] || matrix4.val[12] != matrix42.val[12] || matrix4.val[13] != matrix42.val[13]) {
            bl = false;
        }
        return bl;
    }

    private static boolean checkIdt(Matrix4 object) {
        boolean bl;
        object = ((Matrix4)object).getValues();
        boolean bl2 = bl = false;
        if (object[0] == 1.0f) {
            bl2 = bl;
            if (object[1] == 0.0f) {
                bl2 = bl;
                if (object[4] == 0.0f) {
                    bl2 = bl;
                    if (object[5] == 1.0f) {
                        bl2 = bl;
                        if (object[12] == 0.0f) {
                            bl2 = bl;
                            if (object[13] == 0.0f) {
                                bl2 = true;
                            }
                        }
                    }
                }
            }
        }
        return bl2;
    }

    private void drawAdjusted(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        float f10 = 1.0f / (float)texture.getWidth();
        float f11 = 1.0f / (float)texture.getHeight();
        this.drawAdjustedUV(texture, f, f2, f3, f4, f5, f6, f7, f8, f9, (float)n * f10, (float)(n2 + n4) * f11, f10 * (float)(n + n3), f11 * (float)n2, bl, bl2);
    }

    private void drawAdjusted(Texture object, float[] fArray, int n, int n2) {
        if (this.drawing) {
            if (object != this.lastTexture) {
                this.switchTexture((Texture)object);
            }
            object = this.adjustAffine;
            int n3 = Math.min(this.vertices.length - this.idx, n2);
            int n4 = n;
            n = n3;
            do {
                n3 = n2 - n;
                n2 = n4;
                while (n > 0) {
                    float f = fArray[n2];
                    float f2 = fArray[n2 + 1];
                    this.vertices[this.idx] = ((Affine2)object).m00 * f + ((Affine2)object).m01 * f2 + ((Affine2)object).m02;
                    this.vertices[this.idx + 1] = ((Affine2)object).m10 * f + ((Affine2)object).m11 * f2 + ((Affine2)object).m12;
                    this.vertices[this.idx + 2] = fArray[n2 + 2];
                    this.vertices[this.idx + 3] = fArray[n2 + 3];
                    this.vertices[this.idx + 4] = fArray[n2 + 4];
                    this.idx += 5;
                    n2 += 5;
                    n -= 5;
                }
                if (n3 > 0) {
                    super.flush();
                    n = Math.min(this.vertices.length, n3);
                }
                n4 = n2;
                n2 = n3;
            } while (n3 > 0);
            return;
        }
        object = new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
        throw object;
    }

    private void drawAdjusted(TextureRegion textureRegion, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.drawAdjustedUV(textureRegion.texture, f, f2, f3, f4, f5, f6, f7, f8, f9, textureRegion.u, textureRegion.v2, textureRegion.u2, textureRegion.v, false, false);
    }

    private void drawAdjusted(TextureRegion object, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl) {
        block10: {
            float f10;
            float f11;
            float f12;
            float f13;
            block12: {
                block11: {
                    if (!this.drawing) break block10;
                    if (((TextureRegion)object).texture != this.lastTexture) {
                        this.switchTexture(((TextureRegion)object).texture);
                    } else if (this.idx == this.vertices.length) {
                        super.flush();
                    }
                    f13 = f + f3;
                    f12 = f2 + f4;
                    f11 = -f3;
                    f10 = -f4;
                    f5 -= f3;
                    f6 -= f4;
                    if (f7 != 1.0f) break block11;
                    f4 = f5;
                    f = f6;
                    f3 = f11;
                    f2 = f10;
                    if (f8 == 1.0f) break block12;
                }
                f3 = f11 * f7;
                f2 = f10 * f8;
                f4 = f5 * f7;
                f = f6 * f8;
            }
            if (f9 != 0.0f) {
                f6 = MathUtils.cosDeg(f9);
                f9 = MathUtils.sinDeg(f9);
                f7 = f6 * f3;
                f5 = f7 - f9 * f2;
                f8 = f2 * f6 + (f3 *= f9);
                f2 = f9 * f;
                f10 = f3 + (f *= f6);
                f6 = f6 * f4 - f2;
                f4 = f + f9 * f4;
                f9 = f6 - (f7 -= f2) + f5;
                f = f4;
                f2 = f10;
                f3 = f5;
                f5 = f4 - (f10 - f8);
                f4 = f6;
                f6 = f9;
            } else {
                f6 = f4;
                f9 = f;
                f7 = f3;
                f5 = f2;
                f8 = f2;
                f2 = f;
                f = f9;
            }
            f9 = f3 + f13;
            f10 = f8 + f12;
            f11 = f7 + f13;
            float f14 = f2 + f12;
            float f15 = f4 + f13;
            float f16 = f + f12;
            f13 = f6 + f13;
            f12 = f5 + f12;
            if (bl) {
                f4 = ((TextureRegion)object).u2;
                f5 = ((TextureRegion)object).v2;
                f6 = ((TextureRegion)object).u;
                f2 = ((TextureRegion)object).v2;
                f3 = ((TextureRegion)object).u;
                f7 = ((TextureRegion)object).v;
                f8 = ((TextureRegion)object).u2;
                f = ((TextureRegion)object).v;
            } else {
                f4 = ((TextureRegion)object).u;
                f5 = ((TextureRegion)object).v;
                f6 = ((TextureRegion)object).u2;
                f2 = ((TextureRegion)object).v;
                f3 = ((TextureRegion)object).u2;
                f7 = ((TextureRegion)object).v2;
                f8 = ((TextureRegion)object).u;
                f = ((TextureRegion)object).v2;
            }
            object = this.adjustAffine;
            this.vertices[this.idx + 0] = ((Affine2)object).m00 * f9 + ((Affine2)object).m01 * f10 + ((Affine2)object).m02;
            this.vertices[this.idx + 1] = ((Affine2)object).m10 * f9 + ((Affine2)object).m11 * f10 + ((Affine2)object).m12;
            this.vertices[this.idx + 2] = this.colorPacked;
            this.vertices[this.idx + 3] = f4;
            this.vertices[this.idx + 4] = f5;
            this.vertices[this.idx + 5] = ((Affine2)object).m00 * f11 + ((Affine2)object).m01 * f14 + ((Affine2)object).m02;
            this.vertices[this.idx + 6] = ((Affine2)object).m10 * f11 + ((Affine2)object).m11 * f14 + ((Affine2)object).m12;
            this.vertices[this.idx + 7] = this.colorPacked;
            this.vertices[this.idx + 8] = f6;
            this.vertices[this.idx + 9] = f2;
            this.vertices[this.idx + 10] = ((Affine2)object).m00 * f15 + ((Affine2)object).m01 * f16 + ((Affine2)object).m02;
            this.vertices[this.idx + 11] = ((Affine2)object).m10 * f15 + ((Affine2)object).m11 * f16 + ((Affine2)object).m12;
            this.vertices[this.idx + 12] = this.colorPacked;
            this.vertices[this.idx + 13] = f3;
            this.vertices[this.idx + 14] = f7;
            this.vertices[this.idx + 15] = ((Affine2)object).m00 * f13 + ((Affine2)object).m01 * f12 + ((Affine2)object).m02;
            this.vertices[this.idx + 16] = ((Affine2)object).m10 * f13 + ((Affine2)object).m11 * f12 + ((Affine2)object).m12;
            this.vertices[this.idx + 17] = this.colorPacked;
            this.vertices[this.idx + 18] = f8;
            this.vertices[this.idx + 19] = f;
            this.idx += 20;
            return;
        }
        throw new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
    }

    private void drawAdjusted(TextureRegion object, float f, float f2, Affine2 affine2) {
        if (this.drawing) {
            if (((TextureRegion)object).texture != this.lastTexture) {
                this.switchTexture(((TextureRegion)object).texture);
            } else if (this.idx == this.vertices.length) {
                super.flush();
            }
            float f3 = affine2.m02;
            float f4 = affine2.m12;
            float f5 = affine2.m01 * f2 + affine2.m02;
            float f6 = affine2.m11 * f2 + affine2.m12;
            float f7 = affine2.m00 * f + affine2.m01 * f2 + affine2.m02;
            float f8 = affine2.m10 * f + affine2.m11 * f2 + affine2.m12;
            f2 = affine2.m00 * f + affine2.m02;
            float f9 = affine2.m10 * f + affine2.m12;
            float f10 = ((TextureRegion)object).u;
            float f11 = ((TextureRegion)object).v2;
            float f12 = ((TextureRegion)object).u2;
            f = ((TextureRegion)object).v;
            object = this.adjustAffine;
            this.vertices[this.idx + 0] = ((Affine2)object).m00 * f3 + ((Affine2)object).m01 * f4 + ((Affine2)object).m02;
            this.vertices[this.idx + 1] = ((Affine2)object).m10 * f3 + ((Affine2)object).m11 * f4 + ((Affine2)object).m12;
            this.vertices[this.idx + 2] = this.colorPacked;
            this.vertices[this.idx + 3] = f10;
            this.vertices[this.idx + 4] = f11;
            this.vertices[this.idx + 5] = ((Affine2)object).m00 * f5 + ((Affine2)object).m01 * f6 + ((Affine2)object).m02;
            this.vertices[this.idx + 6] = ((Affine2)object).m10 * f5 + ((Affine2)object).m11 * f6 + ((Affine2)object).m12;
            this.vertices[this.idx + 7] = this.colorPacked;
            this.vertices[this.idx + 8] = f10;
            this.vertices[this.idx + 9] = f;
            this.vertices[this.idx + 10] = ((Affine2)object).m00 * f7 + ((Affine2)object).m01 * f8 + ((Affine2)object).m02;
            this.vertices[this.idx + 11] = ((Affine2)object).m10 * f7 + ((Affine2)object).m11 * f8 + ((Affine2)object).m12;
            this.vertices[this.idx + 12] = this.colorPacked;
            this.vertices[this.idx + 13] = f12;
            this.vertices[this.idx + 14] = f;
            this.vertices[this.idx + 15] = ((Affine2)object).m00 * f2 + ((Affine2)object).m01 * f9 + ((Affine2)object).m02;
            this.vertices[this.idx + 16] = ((Affine2)object).m10 * f2 + ((Affine2)object).m11 * f9 + ((Affine2)object).m12;
            this.vertices[this.idx + 17] = this.colorPacked;
            this.vertices[this.idx + 18] = f12;
            this.vertices[this.idx + 19] = f11;
            this.idx += 20;
            return;
        }
        throw new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
    }

    private void drawAdjustedUV(Texture object, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, boolean bl, boolean bl2) {
        block12: {
            float f14;
            float f15;
            float f16;
            float f17;
            block14: {
                block13: {
                    if (!this.drawing) break block12;
                    if (object != this.lastTexture) {
                        this.switchTexture((Texture)object);
                    } else if (this.idx == this.vertices.length) {
                        super.flush();
                    }
                    f17 = f + f3;
                    f16 = f2 + f4;
                    f15 = -f3;
                    f14 = -f4;
                    f5 -= f3;
                    f6 -= f4;
                    if (f7 != 1.0f) break block13;
                    f = f5;
                    f2 = f6;
                    f4 = f15;
                    f3 = f14;
                    if (f8 == 1.0f) break block14;
                }
                f4 = f15 * f7;
                f3 = f14 * f8;
                f = f5 * f7;
                f2 = f6 * f8;
            }
            if (f9 != 0.0f) {
                f6 = MathUtils.cosDeg(f9);
                f7 = MathUtils.sinDeg(f9);
                f8 = f6 * f4;
                f5 = f8 - f7 * f3;
                f9 = f4 * f7;
                f3 = f3 * f6 + f9;
                f4 = f7 * f2;
                f14 = f2 * f6;
                f9 += f14;
                f2 = f6 * f - f4;
                f14 += f7 * f;
                f6 = f2 - (f8 -= f4) + f5;
                f = f2;
                f7 = f14;
                f2 = f9;
                f4 = f5;
                f5 = f14 - (f9 - f3);
            } else {
                f6 = f;
                f7 = f2;
                f8 = f4;
                f5 = f3;
            }
            f9 = f4 + f17;
            f14 = f3 + f16;
            f8 += f17;
            f15 = f2 + f16;
            float f18 = f + f17;
            f7 += f16;
            f6 += f17;
            f5 += f16;
            if (bl) {
                f = f10;
                f2 = f12;
            } else {
                f2 = f10;
                f = f12;
            }
            if (bl2) {
                f4 = f13;
                f3 = f11;
            } else {
                f3 = f13;
                f4 = f11;
            }
            object = this.adjustAffine;
            this.vertices[this.idx + 0] = ((Affine2)object).m00 * f9 + ((Affine2)object).m01 * f14 + ((Affine2)object).m02;
            this.vertices[this.idx + 1] = ((Affine2)object).m10 * f9 + ((Affine2)object).m11 * f14 + ((Affine2)object).m12;
            this.vertices[this.idx + 2] = this.colorPacked;
            this.vertices[this.idx + 3] = f2;
            this.vertices[this.idx + 4] = f4;
            this.vertices[this.idx + 5] = ((Affine2)object).m00 * f8 + ((Affine2)object).m01 * f15 + ((Affine2)object).m02;
            this.vertices[this.idx + 6] = ((Affine2)object).m10 * f8 + ((Affine2)object).m11 * f15 + ((Affine2)object).m12;
            this.vertices[this.idx + 7] = this.colorPacked;
            this.vertices[this.idx + 8] = f2;
            this.vertices[this.idx + 9] = f3;
            this.vertices[this.idx + 10] = ((Affine2)object).m00 * f18 + ((Affine2)object).m01 * f7 + ((Affine2)object).m02;
            this.vertices[this.idx + 11] = ((Affine2)object).m10 * f18 + ((Affine2)object).m11 * f7 + ((Affine2)object).m12;
            this.vertices[this.idx + 12] = this.colorPacked;
            this.vertices[this.idx + 13] = f;
            this.vertices[this.idx + 14] = f3;
            this.vertices[this.idx + 15] = ((Affine2)object).m00 * f6 + ((Affine2)object).m01 * f5 + ((Affine2)object).m02;
            this.vertices[this.idx + 16] = ((Affine2)object).m10 * f6 + ((Affine2)object).m11 * f5 + ((Affine2)object).m12;
            this.vertices[this.idx + 17] = this.colorPacked;
            this.vertices[this.idx + 18] = f;
            this.vertices[this.idx + 19] = f4;
            this.idx += 20;
            return;
        }
        throw new IllegalStateException("CpuSpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(Texture texture, float f, float f2) {
        if (!this.adjustNeeded) {
            super.draw(texture, f, f2);
        } else {
            this.drawAdjusted(texture, f, f2, 0.0f, 0.0f, texture.getWidth(), texture.getHeight(), 1.0f, 1.0f, 0.0f, 0, 1, 1, 0, false, false);
        }
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4) {
        if (!this.adjustNeeded) {
            super.draw(texture, f, f2, f3, f4);
        } else {
            this.drawAdjusted(texture, f, f2, 0.0f, 0.0f, f3, f4, 1.0f, 1.0f, 0.0f, 0, 1, 1, 0, false, false);
        }
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (!this.adjustNeeded) {
            super.draw(texture, f, f2, f3, f4, f5, f6, f7, f8);
        } else {
            this.drawAdjustedUV(texture, f, f2, 0.0f, 0.0f, f3, f4, 1.0f, 1.0f, 0.0f, f5, f6, f7, f8, false, false);
        }
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (!this.adjustNeeded) {
            super.draw(texture, f, f2, f3, f4, f5, f6, f7, f8, f9, n, n2, n3, n4, bl, bl2);
        } else {
            this.drawAdjusted(texture, f, f2, f3, f4, f5, f6, f7, f8, f9, n, n2, n3, n4, bl, bl2);
        }
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (!this.adjustNeeded) {
            super.draw(texture, f, f2, f3, f4, n, n2, n3, n4, bl, bl2);
        } else {
            this.drawAdjusted(texture, f, f2, 0.0f, 0.0f, f3, f4, 1.0f, 1.0f, 0.0f, n, n2, n3, n4, bl, bl2);
        }
    }

    @Override
    public void draw(Texture texture, float f, float f2, int n, int n2, int n3, int n4) {
        if (!this.adjustNeeded) {
            super.draw(texture, f, f2, n, n2, n3, n4);
        } else {
            this.drawAdjusted(texture, f, f2, 0.0f, 0.0f, n3, n4, 1.0f, 1.0f, 0.0f, n, n2, n3, n4, false, false);
        }
    }

    @Override
    public void draw(Texture texture, float[] fArray, int n, int n2) {
        if (n2 % 20 == 0) {
            if (!this.adjustNeeded) {
                super.draw(texture, fArray, n, n2);
            } else {
                this.drawAdjusted(texture, fArray, n, n2);
            }
            return;
        }
        throw new GdxRuntimeException("invalid vertex count");
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2) {
        if (!this.adjustNeeded) {
            super.draw(textureRegion, f, f2);
        } else {
            this.drawAdjusted(textureRegion, f, f2, 0.0f, 0.0f, textureRegion.getRegionWidth(), textureRegion.getRegionHeight(), 1.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4) {
        if (!this.adjustNeeded) {
            super.draw(textureRegion, f, f2, f3, f4);
        } else {
            this.drawAdjusted(textureRegion, f, f2, 0.0f, 0.0f, f3, f4, 1.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (!this.adjustNeeded) {
            super.draw(textureRegion, f, f2, f3, f4, f5, f6, f7, f8, f9);
        } else {
            this.drawAdjusted(textureRegion, f, f2, f3, f4, f5, f6, f7, f8, f9);
        }
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl) {
        if (!this.adjustNeeded) {
            super.draw(textureRegion, f, f2, f3, f4, f5, f6, f7, f8, f9, bl);
        } else {
            this.drawAdjusted(textureRegion, f, f2, f3, f4, f5, f6, f7, f8, f9, bl);
        }
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, Affine2 affine2) {
        if (!this.adjustNeeded) {
            super.draw(textureRegion, f, f2, affine2);
        } else {
            this.drawAdjusted(textureRegion, f, f2, affine2);
        }
    }

    public void flushAndSyncTransformMatrix() {
        this.flush();
        if (this.adjustNeeded) {
            this.haveIdentityRealMatrix = CpuSpriteBatch.checkIdt(this.virtualMatrix);
            if (!this.haveIdentityRealMatrix && this.virtualMatrix.det() == 0.0f) {
                throw new GdxRuntimeException("Transform matrix is singular, can't sync");
            }
            this.adjustNeeded = false;
            super.setTransformMatrix(this.virtualMatrix);
        }
    }

    @Override
    public Matrix4 getTransformMatrix() {
        Matrix4 matrix4 = this.adjustNeeded ? this.virtualMatrix : super.getTransformMatrix();
        return matrix4;
    }

    public void setTransformMatrix(Affine2 affine2) {
        Matrix4 matrix4 = super.getTransformMatrix();
        if (CpuSpriteBatch.checkEqual(matrix4, affine2)) {
            this.adjustNeeded = false;
        } else {
            this.virtualMatrix.setAsAffine(affine2);
            if (this.isDrawing()) {
                this.adjustNeeded = true;
                if (this.haveIdentityRealMatrix) {
                    this.adjustAffine.set(affine2);
                } else {
                    this.adjustAffine.set(matrix4).inv().mul(affine2);
                }
            } else {
                matrix4.setAsAffine(affine2);
                this.haveIdentityRealMatrix = CpuSpriteBatch.checkIdt(matrix4);
            }
        }
    }

    @Override
    public void setTransformMatrix(Matrix4 matrix4) {
        Matrix4 matrix42 = super.getTransformMatrix();
        if (CpuSpriteBatch.checkEqual(matrix42, matrix4)) {
            this.adjustNeeded = false;
        } else if (this.isDrawing()) {
            this.virtualMatrix.setAsAffine(matrix4);
            this.adjustNeeded = true;
            if (this.haveIdentityRealMatrix) {
                this.adjustAffine.set(matrix4);
            } else {
                this.tmpAffine.set(matrix4);
                this.adjustAffine.set(matrix42).inv().mul(this.tmpAffine);
            }
        } else {
            matrix42.setAsAffine(matrix4);
            this.haveIdentityRealMatrix = CpuSpriteBatch.checkIdt(matrix42);
        }
    }
}

