/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class VertexAttributes
implements Iterable<VertexAttribute>,
Comparable<VertexAttributes> {
    private final VertexAttribute[] attributes;
    private ReadonlyIterable<VertexAttribute> iterable;
    private long mask = -1L;
    public final int vertexSize;

    public VertexAttributes(VertexAttribute ... object) {
        if (((VertexAttribute[])object).length != 0) {
            VertexAttribute[] vertexAttributeArray = new VertexAttribute[((VertexAttribute[])object).length];
            for (int i = 0; i < ((VertexAttribute[])object).length; ++i) {
                vertexAttributeArray[i] = object[i];
            }
            this.attributes = vertexAttributeArray;
            this.vertexSize = this.calculateOffsets();
            return;
        }
        object = new IllegalArgumentException("attributes must be >= 1");
        throw object;
    }

    private int calculateOffsets() {
        Object object;
        int n = 0;
        for (int i = 0; i < ((VertexAttribute[])(object = this.attributes)).length; ++i) {
            object = object[i];
            ((VertexAttribute)object).offset = n;
            n += ((VertexAttribute)object).getSizeInBytes();
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(VertexAttributes vertexAttributes) {
        int n;
        VertexAttribute[] vertexAttributeArray = this.attributes;
        int n2 = vertexAttributeArray.length;
        VertexAttribute[] vertexAttributeArray2 = vertexAttributes.attributes;
        if (n2 != vertexAttributeArray2.length) {
            n = vertexAttributeArray.length;
            n2 = vertexAttributeArray2.length;
            return n - n2;
        }
        long l = this.getMask();
        long l2 = vertexAttributes.getMask();
        n2 = -1;
        if (l != l2) {
            if (l >= l2) return 1;
            return n2;
        }
        n = this.attributes.length - 1;
        while (n >= 0) {
            VertexAttribute vertexAttribute = this.attributes[n];
            VertexAttribute vertexAttribute2 = vertexAttributes.attributes[n];
            if (vertexAttribute.usage != vertexAttribute2.usage) {
                n = vertexAttribute.usage;
                n2 = vertexAttribute2.usage;
                return n - n2;
            }
            if (vertexAttribute.unit != vertexAttribute2.unit) {
                n = vertexAttribute.unit;
                n2 = vertexAttribute2.unit;
                return n - n2;
            }
            if (vertexAttribute.numComponents != vertexAttribute2.numComponents) {
                n = vertexAttribute.numComponents;
                n2 = vertexAttribute2.numComponents;
                return n - n2;
            }
            if (vertexAttribute.normalized != vertexAttribute2.normalized) {
                if (!vertexAttribute.normalized) return n2;
                return 1;
            }
            if (vertexAttribute.type != vertexAttribute2.type) {
                n = vertexAttribute.type;
                n2 = vertexAttribute2.type;
                return n - n2;
            }
            --n;
        }
        return 0;
    }

    public boolean equals(Object vertexAttributeArray) {
        if (vertexAttributeArray == this) {
            return true;
        }
        if (!(vertexAttributeArray instanceof VertexAttributes)) {
            return false;
        }
        VertexAttributes vertexAttributes = (VertexAttributes)vertexAttributeArray;
        if (this.attributes.length != vertexAttributes.attributes.length) {
            return false;
        }
        for (int i = 0; i < (vertexAttributeArray = this.attributes).length; ++i) {
            if (vertexAttributeArray[i].equals(vertexAttributes.attributes[i])) continue;
            return false;
        }
        return true;
    }

    public VertexAttribute findByUsage(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.get((int)i).usage != n) continue;
            return this.get(i);
        }
        return null;
    }

    public VertexAttribute get(int n) {
        return this.attributes[n];
    }

    public long getMask() {
        if (this.mask == -1L) {
            VertexAttribute[] vertexAttributeArray;
            long l = 0L;
            for (int i = 0; i < (vertexAttributeArray = this.attributes).length; ++i) {
                l |= (long)vertexAttributeArray[i].usage;
            }
            this.mask = l;
        }
        return this.mask;
    }

    public long getMaskWithSizePacked() {
        return this.getMask() | (long)this.attributes.length << 32;
    }

    public int getOffset(int n) {
        return this.getOffset(n, 0);
    }

    public int getOffset(int n, int n2) {
        VertexAttribute vertexAttribute = this.findByUsage(n);
        if (vertexAttribute == null) {
            return n2;
        }
        return vertexAttribute.offset / 4;
    }

    public int hashCode() {
        VertexAttribute[] vertexAttributeArray;
        long l = this.attributes.length * 61;
        for (int i = 0; i < (vertexAttributeArray = this.attributes).length; ++i) {
            l = l * 61L + (long)vertexAttributeArray[i].hashCode();
        }
        return (int)(l ^ l >> 32);
    }

    @Override
    public Iterator<VertexAttribute> iterator() {
        if (this.iterable == null) {
            this.iterable = new ReadonlyIterable<VertexAttribute>(this.attributes);
        }
        return this.iterable.iterator();
    }

    public int size() {
        return this.attributes.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < this.attributes.length; ++i) {
            stringBuilder.append("(");
            stringBuilder.append(this.attributes[i].alias);
            stringBuilder.append(", ");
            stringBuilder.append(this.attributes[i].usage);
            stringBuilder.append(", ");
            stringBuilder.append(this.attributes[i].numComponents);
            stringBuilder.append(", ");
            stringBuilder.append(this.attributes[i].offset);
            stringBuilder.append(")");
            stringBuilder.append("\n");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static class ReadonlyIterable<T>
    implements Iterable<T> {
        private final T[] array;
        private ReadonlyIterator iterator1;
        private ReadonlyIterator iterator2;

        public ReadonlyIterable(T[] TArray) {
            this.array = TArray;
        }

        @Override
        public Iterator<T> iterator() {
            if (Collections.allocateIterators) {
                return new ReadonlyIterator<T>(this.array);
            }
            if (this.iterator1 == null) {
                this.iterator1 = new ReadonlyIterator<T>(this.array);
                this.iterator2 = new ReadonlyIterator<T>(this.array);
            }
            if (!this.iterator1.valid) {
                ReadonlyIterator readonlyIterator = this.iterator1;
                readonlyIterator.index = 0;
                readonlyIterator.valid = true;
                this.iterator2.valid = false;
                return readonlyIterator;
            }
            ReadonlyIterator readonlyIterator = this.iterator2;
            readonlyIterator.index = 0;
            readonlyIterator.valid = true;
            this.iterator1.valid = false;
            return readonlyIterator;
        }
    }

    private static class ReadonlyIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final T[] array;
        int index;
        boolean valid = true;

        public ReadonlyIterator(T[] TArray) {
            this.array = TArray;
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                boolean bl = this.index < this.array.length;
                return bl;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public T next() {
            int n = this.index;
            T[] TArray = this.array;
            if (n < TArray.length) {
                if (this.valid) {
                    this.index = n + 1;
                    return TArray[n];
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException(String.valueOf(n));
        }

        @Override
        public void remove() {
            throw new GdxRuntimeException("Remove not allowed.");
        }

        public void reset() {
            this.index = 0;
        }
    }

    public static final class Usage {
        public static final int BiNormal = 256;
        public static final int BoneWeight = 64;
        public static final int ColorPacked = 4;
        public static final int ColorUnpacked = 2;
        public static final int Generic = 32;
        public static final int Normal = 8;
        public static final int Position = 1;
        public static final int Tangent = 128;
        public static final int TextureCoordinates = 16;
    }
}

