/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

public final class VertexAttribute {
    public String alias;
    public final boolean normalized;
    public final int numComponents;
    public int offset;
    public final int type;
    public int unit;
    public final int usage;
    private final int usageIndex;

    public VertexAttribute(int n, int n2, int n3, boolean bl, String string2) {
        this(n, n2, n3, bl, string2, 0);
    }

    public VertexAttribute(int n, int n2, int n3, boolean bl, String string2, int n4) {
        this.usage = n;
        this.numComponents = n2;
        this.type = n3;
        this.normalized = bl;
        this.alias = string2;
        this.unit = n4;
        this.usageIndex = Integer.numberOfTrailingZeros(n);
    }

    public VertexAttribute(int n, int n2, String string2) {
        this(n, n2, string2, 0);
    }

    public VertexAttribute(int n, int n2, String string2, int n3) {
        int n4 = n == 4 ? 5121 : 5126;
        boolean bl = n == 4;
        this(n, n2, n4, bl, string2, n3);
    }

    public static VertexAttribute Binormal() {
        return new VertexAttribute(256, 3, "a_binormal");
    }

    public static VertexAttribute BoneWeight(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("a_boneWeight");
        stringBuilder.append(n);
        return new VertexAttribute(64, 2, stringBuilder.toString(), n);
    }

    public static VertexAttribute ColorPacked() {
        return new VertexAttribute(4, 4, 5121, true, "a_color");
    }

    public static VertexAttribute ColorUnpacked() {
        return new VertexAttribute(2, 4, 5126, false, "a_color");
    }

    public static VertexAttribute Normal() {
        return new VertexAttribute(8, 3, "a_normal");
    }

    public static VertexAttribute Position() {
        return new VertexAttribute(1, 3, "a_position");
    }

    public static VertexAttribute Tangent() {
        return new VertexAttribute(128, 3, "a_tangent");
    }

    public static VertexAttribute TexCoords(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("a_texCoord");
        stringBuilder.append(n);
        return new VertexAttribute(16, 2, stringBuilder.toString(), n);
    }

    public VertexAttribute copy() {
        return new VertexAttribute(this.usage, this.numComponents, this.type, this.normalized, this.alias, this.unit);
    }

    public boolean equals(VertexAttribute vertexAttribute) {
        boolean bl = vertexAttribute != null && this.usage == vertexAttribute.usage && this.numComponents == vertexAttribute.numComponents && this.type == vertexAttribute.type && this.normalized == vertexAttribute.normalized && this.alias.equals(vertexAttribute.alias) && this.unit == vertexAttribute.unit;
        return bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VertexAttribute)) {
            return false;
        }
        return this.equals((VertexAttribute)object);
    }

    public int getKey() {
        return (this.usageIndex << 8) + (this.unit & 0xFF);
    }

    public int getSizeInBytes() {
        int n = this.type;
        if (n != 5126 && n != 5132) {
            switch (n) {
                default: {
                    return 0;
                }
                case 5122: 
                case 5123: {
                    return this.numComponents * 2;
                }
                case 5120: 
                case 5121: 
            }
            return this.numComponents;
        }
        return this.numComponents * 4;
    }

    public int hashCode() {
        return (this.getKey() * 541 + this.numComponents) * 541 + this.alias.hashCode();
    }
}

