/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android.surfaceview;

import android.content.Context;
import android.opengl.GLDebugHelper;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GLSurfaceViewAPI18
extends SurfaceView
implements SurfaceHolder.Callback {
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    private static final boolean LOG_ATTACH_DETACH = false;
    private static final boolean LOG_EGL = false;
    private static final boolean LOG_PAUSE_RESUME = false;
    private static final boolean LOG_RENDERER = false;
    private static final boolean LOG_RENDERER_DRAW_FRAME = false;
    private static final boolean LOG_SURFACE = false;
    private static final boolean LOG_THREADS = false;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    private static final String TAG = "GLSurfaceViewAPI18";
    private static final GLThreadManager sGLThreadManager = new GLThreadManager();
    private int mDebugFlags;
    private boolean mDetached;
    private GLSurfaceView.EGLConfigChooser mEGLConfigChooser;
    private int mEGLContextClientVersion;
    private EGLContextFactory mEGLContextFactory;
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private GLThread mGLThread;
    private GLWrapper mGLWrapper;
    private boolean mPreserveEGLContextOnPause;
    private GLSurfaceView.Renderer mRenderer;
    private final WeakReference<GLSurfaceViewAPI18> mThisWeakRef = new WeakReference<GLSurfaceViewAPI18>(this);

    public GLSurfaceViewAPI18(Context context) {
        super(context);
        this.init();
    }

    public GLSurfaceViewAPI18(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    static /* synthetic */ GLSurfaceView.Renderer access$1000(GLSurfaceViewAPI18 gLSurfaceViewAPI18) {
        return gLSurfaceViewAPI18.mRenderer;
    }

    static /* synthetic */ boolean access$900(GLSurfaceViewAPI18 gLSurfaceViewAPI18) {
        return gLSurfaceViewAPI18.mPreserveEGLContextOnPause;
    }

    private void checkRenderThreadState() {
        if (this.mGLThread == null) {
            return;
        }
        throw new IllegalStateException("setRenderer has already been called for this instance.");
    }

    private void init() {
        SurfaceHolder surfaceHolder = this.getHolder();
        surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        if (Build.VERSION.SDK_INT <= 8) {
            surfaceHolder.setFormat(4);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getDebugFlags() {
        return this.mDebugFlags;
    }

    public boolean getPreserveEGLContextOnPause() {
        return this.mPreserveEGLContextOnPause;
    }

    public int getRenderMode() {
        return this.mGLThread.getRenderMode();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mDetached && this.mRenderer != null) {
            GLThread gLThread = this.mGLThread;
            int n = gLThread != null ? gLThread.getRenderMode() : 1;
            this.mGLThread = new GLThread(this.mThisWeakRef);
            if (n != 1) {
                this.mGLThread.setRenderMode(n);
            }
            this.mGLThread.start();
        }
        this.mDetached = false;
    }

    protected void onDetachedFromWindow() {
        GLThread gLThread = this.mGLThread;
        if (gLThread != null) {
            gLThread.requestExitAndWait();
        }
        this.mDetached = true;
        super.onDetachedFromWindow();
    }

    public void onPause() {
        this.mGLThread.onPause();
    }

    public void onResume() {
        this.mGLThread.onResume();
    }

    public void queueEvent(Runnable runnable) {
        this.mGLThread.queueEvent(runnable);
    }

    public void requestRender() {
        this.mGLThread.requestRender();
    }

    public void setDebugFlags(int n) {
        this.mDebugFlags = n;
    }

    public void setEGLConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setEGLConfigChooser(new ComponentSizeChooser(n, n2, n3, n4, n5, n6));
    }

    public void setEGLConfigChooser(GLSurfaceView.EGLConfigChooser eGLConfigChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = eGLConfigChooser;
    }

    public void setEGLConfigChooser(boolean bl) {
        this.setEGLConfigChooser(new SimpleEGLConfigChooser(bl));
    }

    public void setEGLContextClientVersion(int n) {
        this.checkRenderThreadState();
        this.mEGLContextClientVersion = n;
    }

    public void setEGLContextFactory(EGLContextFactory eGLContextFactory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = eGLContextFactory;
    }

    public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory eGLWindowSurfaceFactory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = eGLWindowSurfaceFactory;
    }

    public void setGLWrapper(GLWrapper gLWrapper) {
        this.mGLWrapper = gLWrapper;
    }

    public void setPreserveEGLContextOnPause(boolean bl) {
        this.mPreserveEGLContextOnPause = bl;
    }

    public void setRenderMode(int n) {
        this.mGLThread.setRenderMode(n);
    }

    public void setRenderer(GLSurfaceView.Renderer renderer) {
        this.checkRenderThreadState();
        if (this.mEGLConfigChooser == null) {
            this.mEGLConfigChooser = new SimpleEGLConfigChooser(true);
        }
        if (this.mEGLContextFactory == null) {
            this.mEGLContextFactory = new DefaultContextFactory();
        }
        if (this.mEGLWindowSurfaceFactory == null) {
            this.mEGLWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
        }
        this.mRenderer = renderer;
        this.mGLThread = new GLThread(this.mThisWeakRef);
        this.mGLThread.start();
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        this.mGLThread.onWindowResize(n2, n3);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mGLThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mGLThread.surfaceDestroyed();
    }

    private abstract class BaseConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] nArray) {
            this.mConfigSpec = this.filterConfigSpec(nArray);
        }

        private int[] filterConfigSpec(int[] nArray) {
            if (GLSurfaceViewAPI18.this.mEGLContextClientVersion != 2) {
                return nArray;
            }
            int n = nArray.length;
            int[] nArray2 = new int[n + 2];
            int n2 = n - 1;
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray2[n2] = 12352;
            nArray2[n] = 4;
            nArray2[n + 1] = 12344;
            return nArray2;
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            if (eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, null, 0, nArray)) {
                int n = nArray[0];
                if (n > 0) {
                    EGLConfig[] eGLConfigArray = new EGLConfig[n];
                    if (eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, eGLConfigArray, n, nArray)) {
                        if ((eGL10 = this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray)) != null) {
                            return eGL10;
                        }
                        throw new IllegalArgumentException("No config chosen");
                    }
                    throw new IllegalArgumentException("eglChooseConfig#2 failed");
                }
                throw new IllegalArgumentException("No configs match configSpec");
            }
            throw new IllegalArgumentException("eglChooseConfig failed");
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser {
        protected int mAlphaSize;
        protected int mBlueSize;
        protected int mDepthSize;
        protected int mGreenSize;
        protected int mRedSize;
        protected int mStencilSize;
        private int[] mValue;

        public ComponentSizeChooser(int n, int n2, int n3, int n4, int n5, int n6) {
            super(new int[]{12324, n, 12323, n2, 12322, n3, 12321, n4, 12325, n5, 12326, n6, 12344});
            this.mValue = new int[1];
            this.mRedSize = n;
            this.mGreenSize = n2;
            this.mBlueSize = n3;
            this.mAlphaSize = n4;
            this.mDepthSize = n5;
            this.mStencilSize = n6;
        }

        private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.mValue)) {
                return this.mValue[0];
            }
            return n2;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            for (EGLConfig eGLConfig : eGLConfigArray) {
                int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                if (n < this.mDepthSize || n2 < this.mStencilSize) continue;
                n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                if (n2 != this.mRedSize || n3 != this.mGreenSize || n != this.mBlueSize || n4 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }
    }

    private class DefaultContextFactory
    implements EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private DefaultContextFactory() {
        }

        @Override
        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, GLSurfaceViewAPI18.this.mEGLContextClientVersion, 12344};
            EGLContext eGLContext = EGL10.EGL_NO_CONTEXT;
            if (GLSurfaceViewAPI18.this.mEGLContextClientVersion == 0) {
                nArray = null;
            }
            return eGL10.eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray);
        }

        @Override
        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            if (!eGL10.eglDestroyContext(eGLDisplay, eGLContext)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("display:");
                stringBuilder.append(eGLDisplay);
                stringBuilder.append(" context: ");
                stringBuilder.append(eGLContext);
                Log.e((String)"DefaultContextFactory", (String)stringBuilder.toString());
                EglHelper.throwEglException("eglDestroyContex", eGL10.eglGetError());
            }
        }
    }

    private static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object) {
            Object var5_6 = null;
            try {
                eGL10 = eGL10.eglCreateWindowSurface(eGLDisplay, eGLConfig, object, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)GLSurfaceViewAPI18.TAG, (String)"eglCreateWindowSurface", (Throwable)illegalArgumentException);
                eGL10 = var5_6;
            }
            return eGL10;
        }

        @Override
        public void destroySurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
            eGL10.eglDestroySurface(eGLDisplay, eGLSurface);
        }
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    private static class EglHelper {
        EGL10 mEgl;
        EGLConfig mEglConfig;
        EGLContext mEglContext;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        private WeakReference<GLSurfaceViewAPI18> mGLSurfaceViewWeakRef;

        public EglHelper(WeakReference<GLSurfaceViewAPI18> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        private void destroySurfaceImp() {
            Object object = this.mEglSurface;
            if (object != null && object != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                object = (GLSurfaceViewAPI18)((Object)this.mGLSurfaceViewWeakRef.get());
                if (object != null) {
                    ((GLSurfaceViewAPI18)((Object)object)).mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                }
                this.mEglSurface = null;
            }
        }

        public static String formatEglError(String string2, int n) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(" failed: ");
            stringBuilder.append(EglHelper.getErrorString(n));
            return stringBuilder.toString();
        }

        private static String getErrorString(int n) {
            switch (n) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("0x");
                    stringBuilder.append(Integer.toHexString(n));
                    return stringBuilder.toString();
                }
                case 12302: {
                    return "EGL_CONTEXT_LOST";
                }
                case 12301: {
                    return "EGL_BAD_SURFACE";
                }
                case 12300: {
                    return "EGL_BAD_PARAMETER";
                }
                case 12299: {
                    return "EGL_BAD_NATIVE_WINDOW";
                }
                case 12298: {
                    return "EGL_BAD_NATIVE_PIXMAP";
                }
                case 12297: {
                    return "EGL_BAD_MATCH";
                }
                case 12296: {
                    return "EGL_BAD_DISPLAY";
                }
                case 12295: {
                    return "EGL_BAD_CURRENT_SURFACE";
                }
                case 12294: {
                    return "EGL_BAD_CONTEXT";
                }
                case 12293: {
                    return "EGL_BAD_CONFIG";
                }
                case 12292: {
                    return "EGL_BAD_ATTRIBUTE";
                }
                case 12291: {
                    return "EGL_BAD_ALLOC";
                }
                case 12290: {
                    return "EGL_BAD_ACCESS";
                }
                case 12289: {
                    return "EGL_NOT_INITIALIZED";
                }
                case 12288: 
            }
            return "EGL_SUCCESS";
        }

        public static void logEglErrorAsWarning(String string2, String string3, int n) {
            Log.w((String)string2, (String)EglHelper.formatEglError(string3, n));
        }

        private void throwEglException(String string2) {
            EglHelper.throwEglException(string2, this.mEgl.eglGetError());
        }

        public static void throwEglException(String string2, int n) {
            throw new RuntimeException(EglHelper.formatEglError(string2, n));
        }

        GL createGL() {
            GL gL = this.mEglContext.getGL();
            GLSurfaceViewAPI18 gLSurfaceViewAPI18 = (GLSurfaceViewAPI18)((Object)this.mGLSurfaceViewWeakRef.get());
            Object object = gL;
            if (gLSurfaceViewAPI18 != null) {
                GL gL2 = gL;
                if (gLSurfaceViewAPI18.mGLWrapper != null) {
                    gL2 = gLSurfaceViewAPI18.mGLWrapper.wrap(gL);
                }
                object = gL2;
                if ((gLSurfaceViewAPI18.mDebugFlags & 3) != 0) {
                    int n = 0;
                    object = null;
                    if ((gLSurfaceViewAPI18.mDebugFlags & 1) != 0) {
                        n = 1;
                    }
                    if ((gLSurfaceViewAPI18.mDebugFlags & 2) != 0) {
                        object = new LogWriter();
                    }
                    object = GLDebugHelper.wrap((GL)gL2, (int)n, (Writer)object);
                }
            }
            return object;
        }

        public boolean createSurface() {
            if (this.mEgl != null) {
                if (this.mEglDisplay != null) {
                    if (this.mEglConfig != null) {
                        this.destroySurfaceImp();
                        GLSurfaceViewAPI18 gLSurfaceViewAPI18 = (GLSurfaceViewAPI18)((Object)this.mGLSurfaceViewWeakRef.get());
                        this.mEglSurface = gLSurfaceViewAPI18 != null ? gLSurfaceViewAPI18.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, gLSurfaceViewAPI18.getHolder()) : null;
                        gLSurfaceViewAPI18 = this.mEglSurface;
                        if (gLSurfaceViewAPI18 != null && gLSurfaceViewAPI18 != EGL10.EGL_NO_SURFACE) {
                            EGL10 eGL10 = this.mEgl;
                            gLSurfaceViewAPI18 = this.mEglDisplay;
                            EGLSurface eGLSurface = this.mEglSurface;
                            if (!eGL10.eglMakeCurrent((EGLDisplay)gLSurfaceViewAPI18, eGLSurface, eGLSurface, this.mEglContext)) {
                                EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.mEgl.eglGetError());
                                return false;
                            }
                            return true;
                        }
                        if (this.mEgl.eglGetError() == 12299) {
                            Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                        }
                        return false;
                    }
                    throw new RuntimeException("mEglConfig not initialized");
                }
                throw new RuntimeException("eglDisplay not initialized");
            }
            throw new RuntimeException("egl not initialized");
        }

        public void destroySurface() {
            this.destroySurfaceImp();
        }

        public void finish() {
            Object object;
            if (this.mEglContext != null) {
                object = (GLSurfaceViewAPI18)((Object)this.mGLSurfaceViewWeakRef.get());
                if (object != null) {
                    ((GLSurfaceViewAPI18)((Object)object)).mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                }
                this.mEglContext = null;
            }
            if ((object = this.mEglDisplay) != null) {
                this.mEgl.eglTerminate(object);
                this.mEglDisplay = null;
            }
        }

        public void start() {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mEglDisplay != EGL10.EGL_NO_DISPLAY) {
                Object object = new int[2];
                if (this.mEgl.eglInitialize(this.mEglDisplay, object)) {
                    object = (Object)((GLSurfaceViewAPI18)((Object)this.mGLSurfaceViewWeakRef.get()));
                    if (object == null) {
                        this.mEglConfig = null;
                        this.mEglContext = null;
                    } else {
                        this.mEglConfig = ((GLSurfaceViewAPI18)((Object)object)).mEGLConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
                        this.mEglContext = ((GLSurfaceViewAPI18)((Object)object)).mEGLContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
                    }
                    object = this.mEglContext;
                    if (object == null || object == EGL10.EGL_NO_CONTEXT) {
                        this.mEglContext = null;
                        this.throwEglException("createContext");
                    }
                    this.mEglSurface = null;
                    return;
                }
                throw new RuntimeException("eglInitialize failed");
            }
            throw new RuntimeException("eglGetDisplay failed");
        }

        public int swap() {
            if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }
    }

    static class GLThread
    extends Thread {
        private EglHelper mEglHelper;
        private ArrayList<Runnable> mEventQueue = new ArrayList();
        private boolean mExited;
        private boolean mFinishedCreatingEglSurface;
        private WeakReference<GLSurfaceViewAPI18> mGLSurfaceViewWeakRef;
        private boolean mHasSurface;
        private boolean mHaveEglContext;
        private boolean mHaveEglSurface;
        private int mHeight = 0;
        private boolean mPaused;
        private boolean mRenderComplete;
        private int mRenderMode = 1;
        private boolean mRequestPaused;
        private boolean mRequestRender = true;
        private boolean mShouldExit;
        private boolean mShouldReleaseEglContext;
        private boolean mSizeChanged = true;
        private boolean mSurfaceIsBad;
        private boolean mWaitingForSurface;
        private int mWidth = 0;

        GLThread(WeakReference<GLSurfaceViewAPI18> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        static /* synthetic */ boolean access$1102(GLThread gLThread, boolean bl) {
            gLThread.mExited = bl;
            return bl;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void guardedRun() throws InterruptedException {
            this.mEglHelper = new EglHelper(this.mGLSurfaceViewWeakRef);
            this.mHaveEglContext = false;
            this.mHaveEglSurface = false;
            var1_1 = 0;
            var2_2 = 0;
            var3_3 = 0;
            var4_4 = null;
            var5_6 = 0;
            var6_7 = 0;
            var7_8 = 0;
            var8_9 = 0;
            var9_10 = 0;
            var10_11 = 0;
            var11_12 = 0;
            block25: while (true) {
                var12_13 = null;
                block26: while (true) {
                    var13_17 /* !! */  = GLSurfaceViewAPI18.access$800();
                    // MONITORENTER : var13_17 /* !! */ 
                    var14_18 = var11_12;
                    var11_12 = var7_8;
                    var7_8 = var2_2;
                    while (true) {
                        block60: {
                            block61: {
                                block63: {
                                    block56: {
                                        block57: {
                                            block59: {
                                                block58: {
                                                    if (this.mShouldExit) {
                                                        // MONITOREXIT : var13_17 /* !! */ 
                                                        var4_4 = GLSurfaceViewAPI18.access$800();
                                                        // MONITORENTER : var4_4
                                                        this.stopEglSurfaceLocked();
                                                        this.stopEglContextLocked();
                                                        // MONITOREXIT : var4_4
                                                        return;
                                                    }
                                                    if (this.mEventQueue.isEmpty()) break block58;
                                                    var12_13 = this.mEventQueue.remove(0);
                                                    var2_2 = var7_8;
                                                    var7_8 = var11_12;
                                                    var11_12 = var14_18;
                                                    break block59;
                                                }
                                                if (this.mPaused != this.mRequestPaused) {
                                                    var15_19 = this.mRequestPaused;
                                                    this.mPaused = this.mRequestPaused;
                                                    GLSurfaceViewAPI18.access$800().notifyAll();
                                                } else {
                                                    var15_19 = false;
                                                }
                                                if (this.mShouldReleaseEglContext) {
                                                    this.stopEglSurfaceLocked();
                                                    this.stopEglContextLocked();
                                                    this.mShouldReleaseEglContext = false;
                                                    var3_3 = 1;
                                                }
                                                var16_20 = var1_1;
                                                if (var1_1 != 0) {
                                                    this.stopEglSurfaceLocked();
                                                    this.stopEglContextLocked();
                                                    var16_20 = 0;
                                                }
                                                if (var15_19 && this.mHaveEglSurface) {
                                                    this.stopEglSurfaceLocked();
                                                }
                                                if (var15_19 && this.mHaveEglContext && (!(var18_22 = (var17_21 = (GLSurfaceViewAPI18)this.mGLSurfaceViewWeakRef.get()) == null ? false : GLSurfaceViewAPI18.access$900(var17_21)) || GLSurfaceViewAPI18.access$800().shouldReleaseEGLContextWhenPausing())) {
                                                    this.stopEglContextLocked();
                                                }
                                                if (var15_19 && GLSurfaceViewAPI18.access$800().shouldTerminateEGLWhenPausing()) {
                                                    this.mEglHelper.finish();
                                                }
                                                if (!this.mHasSurface && !this.mWaitingForSurface) {
                                                    if (this.mHaveEglSurface) {
                                                        this.stopEglSurfaceLocked();
                                                    }
                                                    this.mWaitingForSurface = true;
                                                    this.mSurfaceIsBad = false;
                                                    GLSurfaceViewAPI18.access$800().notifyAll();
                                                }
                                                if (this.mHasSurface && this.mWaitingForSurface) {
                                                    this.mWaitingForSurface = false;
                                                    GLSurfaceViewAPI18.access$800().notifyAll();
                                                }
                                                var2_2 = var7_8;
                                                if (var7_8 != 0) {
                                                    this.mRenderComplete = true;
                                                    GLSurfaceViewAPI18.access$800().notifyAll();
                                                    var2_2 = 0;
                                                    var14_18 = 0;
                                                }
                                                var19_23 = var3_3;
                                                var20_24 = var11_12;
                                                var21_25 = var8_9;
                                                var22_26 = var9_10;
                                                var23_27 = var10_11;
                                                if (!this.readyToDraw()) break block60;
                                                var1_1 = var3_3;
                                                var7_8 = var11_12;
                                                if (!this.mHaveEglContext) {
                                                    if (var3_3 != 0) {
                                                        var1_1 = 0;
                                                        var7_8 = var11_12;
                                                    } else {
                                                        var15_19 = GLSurfaceViewAPI18.access$800().tryAcquireEglContextLocked(this);
                                                        var1_1 = var3_3;
                                                        var7_8 = var11_12;
                                                        if (var15_19) {
                                                            try {
                                                                this.mEglHelper.start();
                                                                this.mHaveEglContext = true;
                                                            }
                                                            catch (RuntimeException var4_5) {
                                                                GLSurfaceViewAPI18.access$800().releaseEglContextLocked(this);
                                                                throw var4_5;
                                                            }
                                                            GLSurfaceViewAPI18.access$800().notifyAll();
                                                            var7_8 = 1;
                                                            var1_1 = var3_3;
                                                        }
                                                    }
                                                }
                                                if (this.mHaveEglContext && !this.mHaveEglSurface) {
                                                    this.mHaveEglSurface = true;
                                                    var10_11 = 1;
                                                    var9_10 = 1;
                                                    var8_9 = 1;
                                                } else {
                                                    var11_12 = var8_9;
                                                    var8_9 = var10_11;
                                                    var10_11 = var11_12;
                                                }
                                                if (!this.mHaveEglSurface) break block61;
                                                if (this.mSizeChanged) {
                                                    var5_6 = this.mWidth;
                                                    var6_7 = this.mHeight;
                                                    this.mSizeChanged = false;
                                                    var10_11 = 1;
                                                    var8_9 = 1;
                                                    var11_12 = 1;
                                                } else {
                                                    var11_12 = var14_18;
                                                }
                                                this.mRequestRender = false;
                                                GLSurfaceViewAPI18.access$800().notifyAll();
                                                var3_3 = var10_11;
                                                var10_11 = var8_9;
                                                var8_9 = var3_3;
                                                var3_3 = var1_1;
                                                var1_1 = var16_20;
                                            }
                                            // MONITOREXIT : var13_17 /* !! */ 
                                            if (var12_13 == null) ** GOTO lbl137
                                            var12_13.run();
                                            continue block25;
lbl137:
                                            // 1 sources

                                            var16_20 = var8_9;
                                            if (var8_9 == 0) ** GOTO lbl-1000
                                            if (this.mEglHelper.createSurface()) ** break block62
                                            {
                                                var13_17 /* !! */  = GLSurfaceViewAPI18.access$800();
                                                // MONITORENTER : var13_17 /* !! */ 
                                            }
                                            this.mFinishedCreatingEglSurface = true;
                                            this.mSurfaceIsBad = true;
                                            GLSurfaceViewAPI18.access$800().notifyAll();
                                            // MONITOREXIT : var13_17 /* !! */ 
                                            var14_18 = var8_9;
                                            var13_17 /* !! */  = var4_4;
                                            var22_26 = var1_1;
                                            break block63;
                                            {
                                                var13_17 /* !! */  = GLSurfaceViewAPI18.access$800();
                                                // MONITORENTER : var13_17 /* !! */ 
                                                this.mFinishedCreatingEglSurface = true;
                                                GLSurfaceViewAPI18.access$800().notifyAll();
                                            }
                                            // MONITOREXIT : var13_17 /* !! */ 
                                            var16_20 = 0;
lbl-1000:
                                            // 2 sources

                                            {
                                                var8_9 = var9_10;
                                                if (var9_10 != 0) {
                                                    var4_4 = (GL10)this.mEglHelper.createGL();
                                                    GLSurfaceViewAPI18.access$800().checkGLDriver((GL10)var4_4);
                                                    var8_9 = 0;
                                                }
                                                var19_23 = var7_8;
                                                if (var7_8 != 0) {
                                                    var13_17 /* !! */  = (GLSurfaceViewAPI18)this.mGLSurfaceViewWeakRef.get();
                                                    if (var13_17 /* !! */  != null) {
                                                        GLSurfaceViewAPI18.access$1000((GLSurfaceViewAPI18)var13_17 /* !! */ ).onSurfaceCreated((GL10)var4_4, this.mEglHelper.mEglConfig);
                                                    }
                                                    var19_23 = 0;
                                                }
                                                var23_27 = var10_11;
                                                if (var10_11 != 0) {
                                                    var13_17 /* !! */  = (GLSurfaceViewAPI18)this.mGLSurfaceViewWeakRef.get();
                                                    if (var13_17 /* !! */  != null) {
                                                        GLSurfaceViewAPI18.access$1000((GLSurfaceViewAPI18)var13_17 /* !! */ ).onSurfaceChanged((GL10)var4_4, var5_6, var6_7);
                                                    }
                                                    var23_27 = 0;
                                                }
                                                if ((var13_17 /* !! */  = (GLSurfaceViewAPI18)this.mGLSurfaceViewWeakRef.get()) != null) {
                                                    GLSurfaceViewAPI18.access$1000((GLSurfaceViewAPI18)var13_17 /* !! */ ).onDrawFrame((GL10)var4_4);
                                                }
                                                if ((var10_11 = this.mEglHelper.swap()) == 12288) break block56;
                                                if (var10_11 == 12302) break block57;
                                                EglHelper.logEglErrorAsWarning("GLThread", "eglSwapBuffers", var10_11);
                                                var13_17 /* !! */  = GLSurfaceViewAPI18.access$800();
                                                // MONITORENTER : var13_17 /* !! */ 
                                            }
                                            this.mSurfaceIsBad = true;
                                            GLSurfaceViewAPI18.access$800().notifyAll();
                                            // MONITOREXIT : var13_17 /* !! */ 
                                            break block56;
                                        }
                                        var1_1 = 1;
                                    }
                                    var22_26 = var1_1;
                                    var13_17 /* !! */  = var4_4;
                                    var7_8 = var19_23;
                                    var14_18 = var16_20;
                                    var9_10 = var8_9;
                                    var10_11 = var23_27;
                                    if (var11_12 != 0) {
                                        var2_2 = 1;
                                        var22_26 = var1_1;
                                        var13_17 /* !! */  = var4_4;
                                        var7_8 = var19_23;
                                        var14_18 = var16_20;
                                        var9_10 = var8_9;
                                        var10_11 = var23_27;
                                    }
                                }
                                var1_1 = var22_26;
                                var4_4 = var13_17 /* !! */ ;
                                var8_9 = var14_18;
                                continue block26;
                            }
                            var23_27 = var8_9;
                            var22_26 = var9_10;
                            var21_25 = var10_11;
                            var20_24 = var7_8;
                            var19_23 = var1_1;
                        }
                        GLSurfaceViewAPI18.access$800().wait();
                        var1_1 = var16_20;
                        var7_8 = var2_2;
                        var3_3 = var19_23;
                        var11_12 = var20_24;
                        var8_9 = var21_25;
                        var9_10 = var22_26;
                        var10_11 = var23_27;
                    }
                    break;
                }
                break;
            }
            catch (Throwable var12_14) {
                var4_4 = GLSurfaceViewAPI18.access$800();
                // MONITORENTER : var4_4
                this.stopEglSurfaceLocked();
                this.stopEglContextLocked();
                // MONITOREXIT : var4_4
                {
                    catch (Throwable var12_15) {}
                    {
                        // MONITOREXIT : var4_4
                        throw var12_15;
                    }
                }
                throw var12_14;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean readyToDraw() {
            boolean bl = this.mPaused;
            boolean bl2 = true;
            if (bl) return false;
            if (!this.mHasSurface) return false;
            if (this.mSurfaceIsBad) return false;
            if (this.mWidth <= 0) return false;
            if (this.mHeight <= 0) return false;
            bl = bl2;
            if (this.mRequestRender) return bl;
            if (this.mRenderMode != 1) return false;
            return bl2;
        }

        private void stopEglContextLocked() {
            if (this.mHaveEglContext) {
                this.mEglHelper.finish();
                this.mHaveEglContext = false;
                sGLThreadManager.releaseEglContextLocked(this);
            }
        }

        private void stopEglSurfaceLocked() {
            if (this.mHaveEglSurface) {
                this.mHaveEglSurface = false;
                this.mEglHelper.destroySurface();
            }
        }

        public boolean ableToDraw() {
            boolean bl = this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRenderMode;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onPause() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    boolean bl = this.mPaused;
                    if (bl) return;
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onResume() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = false;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    if (!this.mPaused) return;
                    boolean bl = this.mRenderComplete;
                    if (bl) return;
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onWindowResize(int n, int n2) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mWidth = n;
                this.mHeight = n2;
                this.mSizeChanged = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    if (this.mPaused) return;
                    if (this.mRenderComplete) return;
                    boolean bl = this.ableToDraw();
                    if (!bl) return;
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void queueEvent(Runnable runnable) {
            if (runnable != null) {
                GLThreadManager gLThreadManager = sGLThreadManager;
                synchronized (gLThreadManager) {
                    this.mEventQueue.add(runnable);
                    sGLThreadManager.notifyAll();
                    return;
                }
            }
            throw new IllegalArgumentException("r must not be null");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.mShouldExit = true;
                sGLThreadManager.notifyAll();
                while (!(bl = this.mExited)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        public void requestReleaseEglContextLocked() {
            this.mShouldReleaseEglContext = true;
            sGLThreadManager.notifyAll();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = new StringBuilder();
            var1_1.append("GLThread ");
            var1_1.append(this.getId());
            this.setName(var1_1.toString());
            try {
                this.guardedRun();
lbl9:
                // 2 sources

                while (true) {
                    GLSurfaceViewAPI18.access$800().threadExiting(this);
                    break;
                }
            }
            catch (Throwable var1_2) {
                GLSurfaceViewAPI18.access$800().threadExiting(this);
                throw var1_2;
            }
            return;
            catch (InterruptedException var1_3) {
                ** continue;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setRenderMode(int n) {
            if (n >= 0 && n <= 1) {
                GLThreadManager gLThreadManager = sGLThreadManager;
                synchronized (gLThreadManager) {
                    this.mRenderMode = n;
                    sGLThreadManager.notifyAll();
                    return;
                }
            }
            throw new IllegalArgumentException("renderMode");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = true;
                this.mFinishedCreatingEglSurface = false;
                sGLThreadManager.notifyAll();
                while (this.mWaitingForSurface) {
                    if (this.mFinishedCreatingEglSurface) return;
                    boolean bl = this.mExited;
                    if (bl) return;
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = false;
                sGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface) {
                    boolean bl = this.mExited;
                    if (bl) return;
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }
    }

    private static class GLThreadManager {
        private static String TAG = "GLThreadManager";
        private static final int kGLES_20 = 131072;
        private static final String kMSM7K_RENDERER_PREFIX = "Q3Dimension MSM7500 ";
        private GLThread mEglOwner;
        private boolean mGLESDriverCheckComplete;
        private int mGLESVersion;
        private boolean mGLESVersionCheckComplete;
        private boolean mLimitedGLESContexts;
        private boolean mMultipleGLESContextsAllowed;

        private GLThreadManager() {
        }

        private void checkGLESVersion() {
            if (!this.mGLESVersionCheckComplete) {
                this.mGLESVersion = 131072;
                if (this.mGLESVersion >= 131072) {
                    this.mMultipleGLESContextsAllowed = true;
                }
                this.mGLESVersionCheckComplete = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void checkGLDriver(GL10 object) {
            synchronized (this) {
                if (!this.mGLESDriverCheckComplete) {
                    boolean bl;
                    this.checkGLESVersion();
                    object = object.glGetString(7937);
                    int n = this.mGLESVersion;
                    boolean bl2 = false;
                    if (n < 131072) {
                        bl = !((String)object).startsWith(kMSM7K_RENDERER_PREFIX);
                        this.mMultipleGLESContextsAllowed = bl;
                        this.notifyAll();
                    }
                    bl = bl2;
                    if (!this.mMultipleGLESContextsAllowed) {
                        bl = true;
                    }
                    this.mLimitedGLESContexts = bl;
                    this.mGLESDriverCheckComplete = true;
                }
                return;
            }
        }

        public void releaseEglContextLocked(GLThread gLThread) {
            if (this.mEglOwner == gLThread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public boolean shouldReleaseEGLContextWhenPausing() {
            synchronized (this) {
                boolean bl = this.mLimitedGLESContexts;
                return bl;
            }
        }

        public boolean shouldTerminateEGLWhenPausing() {
            synchronized (this) {
                this.checkGLESVersion();
                boolean bl = this.mMultipleGLESContextsAllowed;
                return bl ^ true;
            }
        }

        public void threadExiting(GLThread gLThread) {
            synchronized (this) {
                GLThread.access$1102(gLThread, true);
                if (this.mEglOwner == gLThread) {
                    this.mEglOwner = null;
                }
                this.notifyAll();
                return;
            }
        }

        public boolean tryAcquireEglContextLocked(GLThread gLThread) {
            GLThread gLThread2 = this.mEglOwner;
            if (gLThread2 != gLThread && gLThread2 != null) {
                this.checkGLESVersion();
                if (this.mMultipleGLESContextsAllowed) {
                    return true;
                }
                gLThread = this.mEglOwner;
                if (gLThread != null) {
                    gLThread.requestReleaseEglContextLocked();
                }
                return false;
            }
            this.mEglOwner = gLThread;
            this.notifyAll();
            return true;
        }
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }

    static class LogWriter
    extends Writer {
        private StringBuilder mBuilder = new StringBuilder();

        LogWriter() {
        }

        private void flushBuilder() {
            if (this.mBuilder.length() > 0) {
                Log.v((String)"GLSurfaceView", (String)this.mBuilder.toString());
                StringBuilder stringBuilder = this.mBuilder;
                stringBuilder.delete(0, stringBuilder.length());
            }
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                if (c == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.mBuilder.append(c);
            }
        }
    }

    private class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser(boolean bl) {
            int n = bl ? 16 : 0;
            super(8, 8, 8, 0, n, 0);
        }
    }
}

