/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.media.MediaPlayer;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.android.AndroidAudio;
import java.io.IOException;
import java.util.List;

public class AndroidMusic
implements MediaPlayer.OnCompletionListener,
Music {
    private final AndroidAudio audio;
    private boolean isPrepared = true;
    protected Music.OnCompletionListener onCompletionListener;
    private MediaPlayer player;
    private float volume = 1.0f;
    protected boolean wasPlaying = false;

    AndroidMusic(AndroidAudio androidAudio, MediaPlayer mediaPlayer) {
        this.audio = androidAudio;
        this.player = mediaPlayer;
        this.onCompletionListener = null;
        this.player.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dispose() {
        Throwable throwable222;
        Object object;
        block12: {
            object = this.player;
            if (object == null) {
                return;
            }
            object.release();
            this.player = null;
            this.onCompletionListener = null;
            object = this.audio.musics;
            {
                List<AndroidMusic> list;
                catch (Throwable throwable222) {
                    break block12;
                }
                catch (Throwable throwable3) {}
                {
                    Gdx.app.log("AndroidMusic", "error while disposing AndroidMusic instance, non-fatal");
                    this.player = null;
                    this.onCompletionListener = null;
                    list = this.audio.musics;
                }
                synchronized (list) {
                    this.audio.musics.remove(this);
                    return;
                }
            }
            synchronized (object) {
                this.audio.musics.remove(this);
                return;
            }
        }
        this.player = null;
        this.onCompletionListener = null;
        object = this.audio.musics;
        synchronized (object) {
            this.audio.musics.remove(this);
            throw throwable222;
        }
    }

    public float getDuration() {
        MediaPlayer mediaPlayer = this.player;
        if (mediaPlayer == null) {
            return 0.0f;
        }
        return (float)mediaPlayer.getDuration() / 1000.0f;
    }

    @Override
    public float getPosition() {
        MediaPlayer mediaPlayer = this.player;
        if (mediaPlayer == null) {
            return 0.0f;
        }
        return (float)mediaPlayer.getCurrentPosition() / 1000.0f;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public boolean isLooping() {
        MediaPlayer mediaPlayer = this.player;
        if (mediaPlayer == null) {
            return false;
        }
        try {
            boolean bl = mediaPlayer.isLooping();
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isPlaying() {
        MediaPlayer mediaPlayer = this.player;
        if (mediaPlayer == null) {
            return false;
        }
        try {
            boolean bl = mediaPlayer.isPlaying();
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        if (this.onCompletionListener != null) {
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    AndroidMusic.this.onCompletionListener.onCompletion(AndroidMusic.this);
                }
            });
        }
    }

    @Override
    public void pause() {
        MediaPlayer mediaPlayer = this.player;
        if (mediaPlayer == null) {
            return;
        }
        try {
            if (mediaPlayer.isPlaying()) {
                this.player.pause();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.wasPlaying = false;
    }

    @Override
    public void play() {
        block7: {
            MediaPlayer mediaPlayer = this.player;
            if (mediaPlayer == null) {
                return;
            }
            try {
                boolean bl = mediaPlayer.isPlaying();
                if (!bl) break block7;
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        try {
            if (!this.isPrepared) {
                this.player.prepare();
                this.isPrepared = true;
            }
            this.player.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    @Override
    public void setLooping(boolean bl) {
        MediaPlayer mediaPlayer = this.player;
        if (mediaPlayer == null) {
            return;
        }
        mediaPlayer.setLooping(bl);
    }

    @Override
    public void setOnCompletionListener(Music.OnCompletionListener onCompletionListener) {
        this.onCompletionListener = onCompletionListener;
    }

    @Override
    public void setPan(float f, float f2) {
        float f3;
        if (this.player == null) {
            return;
        }
        if (f < 0.0f) {
            f = f2 * (1.0f - Math.abs(f));
            f3 = f2;
        } else if (f > 0.0f) {
            f3 = f2 * (1.0f - Math.abs(f));
            f = f2;
        } else {
            f = f3 = f2;
        }
        this.player.setVolume(f3, f);
        this.volume = f2;
    }

    @Override
    public void setPosition(float f) {
        MediaPlayer mediaPlayer = this.player;
        if (mediaPlayer == null) {
            return;
        }
        try {
            if (!this.isPrepared) {
                mediaPlayer.prepare();
                this.isPrepared = true;
            }
            this.player.seekTo((int)(f * 1000.0f));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    @Override
    public void setVolume(float f) {
        MediaPlayer mediaPlayer = this.player;
        if (mediaPlayer == null) {
            return;
        }
        mediaPlayer.setVolume(f, f);
        this.volume = f;
    }

    @Override
    public void stop() {
        MediaPlayer mediaPlayer = this.player;
        if (mediaPlayer == null) {
            return;
        }
        if (this.isPrepared) {
            mediaPlayer.seekTo(0);
        }
        this.player.stop();
        this.isPrepared = false;
    }
}

