/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Color_GameData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class Alliance
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Color_GameData allianceColor;
    private int iCivilizationsSize;
    private int iFormationTurnID = 1;
    private List<Integer> lCivilizations;
    private String sAllianceName;

    protected Alliance(String string2) {
        this.sAllianceName = string2;
        this.lCivilizations = new ArrayList<Integer>();
        this.iCivilizationsSize = 0;
        this.allianceColor = CFG.getRandomColorGameData();
    }

    protected final void addCivilization(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.iCivilizationsSize; ++n2) {
            if (this.lCivilizations.get(n2) != n) continue;
            return;
        }
        this.lCivilizations.add(n);
        this.iCivilizationsSize = this.lCivilizations.size();
        for (n2 = n3; n2 < this.iCivilizationsSize - 1; ++n2) {
            CFG.game.setCivRelation_OfCivB(this.lCivilizations.get(n2), n, Math.min(CFG.game.getCivRelation_OfCivB(this.lCivilizations.get(n2), n), 65.0f));
            CFG.game.setCivRelation_OfCivB(n, this.lCivilizations.get(n2), Math.min(CFG.game.getCivRelation_OfCivB(n, this.lCivilizations.get(n2)), 65.0f));
        }
    }

    protected final int countEconomy() {
        int n = 0;
        for (int i = 0; i < this.getCivilizationsSize(); ++i) {
            n += CFG.game.getCiv(this.getCivilization(i)).countEconomy();
        }
        return n;
    }

    protected final int countPopulation() {
        int n = 0;
        for (int i = 0; i < this.getCivilizationsSize(); ++i) {
            n += CFG.game.getCiv(this.getCivilization(i)).countPopulation();
        }
        return n;
    }

    protected final int countProvinces() {
        int n = 0;
        for (int i = 0; i < this.getCivilizationsSize(); ++i) {
            n += CFG.game.getCiv(this.getCivilization(i)).getNumOfProvinces();
        }
        return n;
    }

    protected final String getAllianceName() {
        return this.sAllianceName;
    }

    protected final int getCivilization(int n) {
        return this.lCivilizations.get(n);
    }

    protected final int getCivilizationsSize() {
        return this.iCivilizationsSize;
    }

    protected final Color_GameData getColorOfAlliance() {
        return this.allianceColor;
    }

    protected final int getFormationTurnID() {
        return this.iFormationTurnID;
    }

    protected final void moveDown(int n) {
        List<Integer> list = this.lCivilizations;
        int n2 = n + 1;
        int n3 = list.get(n2);
        list = this.lCivilizations;
        list.set(n2, list.get(n));
        this.lCivilizations.set(n, n3);
    }

    protected final void moveUp(int n) {
        if (n == 0) {
            return;
        }
        List<Integer> list = this.lCivilizations;
        int n2 = n - 1;
        int n3 = list.get(n2);
        list = this.lCivilizations;
        list.set(n2, list.get(n));
        this.lCivilizations.set(n, n3);
    }

    protected final void removeCivilization(int n) {
        int n2 = 0;
        for (int i = 0; i < this.iCivilizationsSize; ++i) {
            if (this.lCivilizations.get(i) != n) continue;
            this.lCivilizations.remove(i);
            this.iCivilizationsSize = this.lCivilizations.size();
            for (i = n2; i < this.iCivilizationsSize; ++i) {
                if (!(CFG.game.getCivRelation_OfCivB(this.lCivilizations.get(i), n) > 0.0f) && !(CFG.game.getCivRelation_OfCivB(n, this.lCivilizations.get(i)) > 0.0f)) continue;
                CFG.game.setCivRelation_OfCivB(this.lCivilizations.get(i), n, 0.0f);
                CFG.game.setCivRelation_OfCivB(n, this.lCivilizations.get(i), 0.0f);
            }
            return;
        }
    }

    protected final void setAllianceName(String string2) {
        this.sAllianceName = string2;
    }

    protected final void setColorOfAlliance(Color_GameData color_GameData) {
        this.allianceColor = color_GameData;
    }

    protected final void setFormationTurnID(int n) {
        this.iFormationTurnID = n;
    }

    protected final void updateCivilizationID(int n, int n2) {
        block2: {
            try {
                this.lCivilizations.set(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!CFG.LOGS) break block2;
                CFG.exceptionStack(indexOutOfBoundsException);
            }
        }
    }

    protected final void updateCivsIDs_AfterRemoveCiv(int n) {
        for (int i = 0; i < this.getCivilizationsSize(); ++i) {
            if (this.getCivilization(i) <= n) continue;
            List<Integer> list = this.lCivilizations;
            list.set(i, list.get(i) - 1);
        }
    }
}

