/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.rangecoder;

import com.badlogic.gdx.utils.compression.rangecoder.Decoder;
import java.io.IOException;

public class BitTreeDecoder {
    short[] Models;
    int NumBitLevels;

    public BitTreeDecoder(int n) {
        this.NumBitLevels = n;
        this.Models = new short[1 << n];
    }

    public static int ReverseDecode(short[] sArray, int n, Decoder decoder, int n2) throws IOException {
        int n3 = 0;
        int n4 = 1;
        for (int i = 0; i < n2; ++i) {
            int n5 = decoder.DecodeBit(sArray, n + n4);
            n4 = (n4 << 1) + n5;
            n3 |= n5 << i;
        }
        return n3;
    }

    public int Decode(Decoder decoder) throws IOException {
        int n = 1;
        for (int i = this.NumBitLevels; i != 0; --i) {
            n = decoder.DecodeBit(this.Models, n) + (n << 1);
        }
        return n - (1 << this.NumBitLevels);
    }

    public void Init() {
        Decoder.InitBitModels(this.Models);
    }

    public int ReverseDecode(Decoder decoder) throws IOException {
        int n = 0;
        int n2 = 1;
        for (int i = 0; i < this.NumBitLevels; ++i) {
            int n3 = decoder.DecodeBit(this.Models, n2);
            n2 = (n2 << 1) + n3;
            n |= n3 << i;
        }
        return n;
    }
}

