/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.lz;

import com.badlogic.gdx.utils.compression.lz.InWindow;
import java.io.IOException;

public class BinTree
extends InWindow {
    private static final int[] CrcTable = new int[256];
    static final int kBT2HashSize = 65536;
    static final int kEmptyHashValue = 0;
    static final int kHash2Size = 1024;
    static final int kHash3Offset = 1024;
    static final int kHash3Size = 65536;
    static final int kMaxValForNormalize = 0x3FFFFFFF;
    static final int kStartMaxLen = 1;
    boolean HASH_ARRAY = true;
    int _cutValue = 255;
    int _cyclicBufferPos;
    int _cyclicBufferSize = 0;
    int[] _hash;
    int _hashMask;
    int _hashSizeSum = 0;
    int _matchMaxLen;
    int[] _son;
    int kFixHashSize = 66560;
    int kMinMatchCheck = 4;
    int kNumHashDirectBytes = 0;

    static {
        for (int i = 0; i < 256; ++i) {
            int n = i;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1) != 0) {
                    n = n >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n >>>= 1;
            }
            BinTree.CrcTable[i] = n;
        }
    }

    public boolean Create(int n, int n2, int n3, int n4) {
        if (n > 0x3FFFFEFF) {
            return false;
        }
        this._cutValue = (n3 >> 1) + 16;
        super.Create(n2 += n, n4 + n3, (n2 + n3 + n4) / 2 + 256);
        this._matchMaxLen = n3;
        n2 = n + 1;
        if (this._cyclicBufferSize != n2) {
            this._cyclicBufferSize = n2;
            this._son = new int[n2 * 2];
        }
        n2 = 65536;
        if (this.HASH_ARRAY) {
            --n;
            n |= n >> 1;
            n |= n >> 2;
            n |= n >> 4;
            n = n2 = (n | n >> 8) >> 1 | 0xFFFF;
            if (n2 > 0x1000000) {
                n = n2 >> 1;
            }
            this._hashMask = n;
            n2 = this.kFixHashSize + (n + 1);
        }
        if (n2 != this._hashSizeSum) {
            this._hashSizeSum = n2;
            this._hash = new int[n2];
        }
        return true;
    }

    public int GetMatches(int[] nArray) throws IOException {
        int n;
        block19: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            Object[] objectArray;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            block21: {
                block22: {
                    block20: {
                        if (this._pos + this._matchMaxLen <= this._streamPos) {
                            n12 = this._matchMaxLen;
                        } else {
                            n12 = n11 = this._streamPos - this._pos;
                            if (n11 < this.kMinMatchCheck) {
                                this.MovePos();
                                return 0;
                            }
                        }
                        n10 = this._pos > this._cyclicBufferSize ? this._pos - this._cyclicBufferSize : 0;
                        n9 = this._bufferOffset + this._pos;
                        if (this.HASH_ARRAY) {
                            n = CrcTable[this._bufferBase[n9] & 0xFF] ^ this._bufferBase[n9 + 1] & 0xFF;
                            n11 = n & 0x3FF;
                            n8 = n ^ (this._bufferBase[n9 + 2] & 0xFF) << 8;
                            n = 0xFFFF & n8;
                            n7 = (n8 ^ CrcTable[this._bufferBase[n9 + 3] & 0xFF] << 5) & this._hashMask;
                        } else {
                            n7 = this._bufferBase[n9] & 0xFF ^ (this._bufferBase[n9 + 1] & 0xFF) << 8;
                            n11 = 0;
                            n = 0;
                        }
                        objectArray = this._hash;
                        n6 = objectArray[this.kFixHashSize + n7];
                        if (!this.HASH_ARRAY) break block20;
                        n5 = objectArray[n11];
                        n4 = objectArray[n += 1024];
                        objectArray[n11] = this._pos;
                        this._hash[n] = this._pos;
                        n11 = 2;
                        if (n5 > n10 && this._bufferBase[this._bufferOffset + n5] == this._bufferBase[n9]) {
                            nArray[0] = 2;
                            nArray[1] = this._pos - n5 - 1;
                            n = 2;
                        } else {
                            n11 = 0;
                            n = 1;
                        }
                        n3 = n11;
                        n8 = n;
                        n2 = n5;
                        if (n4 > n10) {
                            n3 = n11;
                            n8 = n;
                            n2 = n5;
                            if (this._bufferBase[this._bufferOffset + n4] == this._bufferBase[n9]) {
                                n = n11;
                                if (n4 == n5) {
                                    n = n11 - 2;
                                }
                                n11 = n + 1;
                                nArray[n] = 3;
                                n3 = n11 + 1;
                                nArray[n11] = this._pos - n4 - 1;
                                n2 = n4;
                                n8 = 3;
                            }
                        }
                        n11 = n3;
                        n = n8;
                        if (n3 == 0) break block21;
                        n11 = n3;
                        n = n8;
                        if (n2 != n6) break block21;
                        n11 = n3 - 2;
                        break block22;
                    }
                    n11 = 0;
                }
                n = 1;
            }
            this._hash[this.kFixHashSize + n7] = this._pos;
            n8 = this._cyclicBufferPos;
            n2 = (n8 << 1) + 1;
            n4 = n8 << 1;
            n7 = this.kNumHashDirectBytes;
            if (n7 != 0 && n6 > n10 && (n3 = this._bufferBase[this._bufferOffset + n6 + this.kNumHashDirectBytes]) != (objectArray = (Object[])this._bufferBase)[n9 + (n8 = this.kNumHashDirectBytes)]) {
                n = n11 + 1;
                nArray[n11] = n8;
                n11 = n + 1;
                nArray[n] = this._pos - n6 - 1;
                n = n8;
            }
            n3 = this._cutValue;
            n8 = n11;
            n11 = n7;
            n5 = n;
            n = n8;
            n8 = n3;
            n3 = n10;
            while (n6 > n3 && n8 != 0) {
                int n13;
                int n14 = this._pos - n6;
                n10 = this._cyclicBufferPos;
                n10 = n14 <= n10 ? (n10 -= n14) : n10 - n14 + this._cyclicBufferSize;
                int n15 = n10 << 1;
                int n16 = this._bufferOffset + n6;
                n10 = Math.min(n7, n11);
                if (this._bufferBase[n16 + n10] == this._bufferBase[n9 + n10]) {
                    n13 = n10;
                    n10 = n11;
                    while ((n11 = n13 + 1) != n12 && this._bufferBase[n16 + n11] == this._bufferBase[n9 + n11]) {
                        n13 = n11;
                    }
                    if (n5 < n11) {
                        n5 = n + 1;
                        nArray[n] = n11;
                        n = n5 + 1;
                        nArray[n5] = n14 - 1;
                        if (n11 == n12) {
                            nArray = this._son;
                            nArray[n4] = nArray[n15];
                            nArray[n2] = nArray[n15 + 1];
                            break block19;
                        }
                        n5 = n11;
                    }
                } else {
                    n13 = n11;
                    n11 = n10;
                    n10 = n13;
                }
                if ((this._bufferBase[n16 + n11] & 0xFF) < (this._bufferBase[n9 + n11] & 0xFF)) {
                    objectArray = this._son;
                    objectArray[n4] = n6;
                    n4 = n15 + 1;
                    n10 = objectArray[n4];
                } else {
                    objectArray = this._son;
                    objectArray[n2] = n6;
                    n6 = objectArray[n15];
                    n2 = n15;
                    n7 = n11;
                    n11 = n10;
                    n10 = n6;
                }
                --n8;
                n6 = n10;
            }
            nArray = this._son;
            nArray[n4] = 0;
            nArray[n2] = 0;
        }
        this.MovePos();
        return n;
    }

    @Override
    public void Init() throws IOException {
        super.Init();
        for (int i = 0; i < this._hashSizeSum; ++i) {
            this._hash[i] = 0;
        }
        this._cyclicBufferPos = 0;
        this.ReduceOffsets(-1);
    }

    @Override
    public void MovePos() throws IOException {
        int n;
        this._cyclicBufferPos = n = this._cyclicBufferPos + 1;
        if (n >= this._cyclicBufferSize) {
            this._cyclicBufferPos = 0;
        }
        super.MovePos();
        if (this._pos == 0x3FFFFFFF) {
            this.Normalize();
        }
    }

    void Normalize() {
        int n = this._pos;
        int n2 = this._cyclicBufferSize;
        this.NormalizeLinks(this._son, n2 * 2, n -= n2);
        this.NormalizeLinks(this._hash, this._hashSizeSum, n);
        this.ReduceOffsets(n);
    }

    void NormalizeLinks(int[] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            n3 = n3 <= n2 ? 0 : (n3 -= n2);
            nArray[i] = n3;
        }
    }

    public void SetCutValue(int n) {
        this._cutValue = n;
    }

    public void SetType(int n) {
        boolean bl = n > 2;
        this.HASH_ARRAY = bl;
        if (this.HASH_ARRAY) {
            this.kNumHashDirectBytes = 0;
            this.kMinMatchCheck = 4;
            this.kFixHashSize = 66560;
        } else {
            this.kNumHashDirectBytes = 2;
            this.kMinMatchCheck = 3;
            this.kFixHashSize = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void Skip(int var1_1) throws IOException {
        var2_2 = var1_1;
        do {
            block12: {
                if (this._pos + this._matchMaxLen > this._streamPos) break block12;
                var3_3 = this._matchMaxLen;
                ** GOTO lbl-1000
            }
            var3_3 = var1_1 = this._streamPos - this._pos;
            if (var1_1 < this.kMinMatchCheck) {
                this.MovePos();
            } else lbl-1000:
            // 2 sources

            {
                block11: {
                    var4_4 = this._pos > this._cyclicBufferSize ? this._pos - this._cyclicBufferSize : 0;
                    var5_5 = this._bufferOffset + this._pos;
                    if (this.HASH_ARRAY) {
                        var1_1 = BinTree.CrcTable[this._bufferBase[var5_5] & 255] ^ this._bufferBase[var5_5 + 1] & 255;
                        this._hash[var1_1 & 1023] = this._pos;
                        this._hash[(65535 & (var1_1 ^= (this._bufferBase[var5_5 + 2] & 255) << 8)) + 1024] = this._pos;
                        var1_1 = (var1_1 ^ BinTree.CrcTable[this._bufferBase[var5_5 + 3] & 255] << 5) & this._hashMask;
                    } else {
                        var1_1 = this._bufferBase[var5_5] & 255 ^ (this._bufferBase[var5_5 + 1] & 255) << 8;
                    }
                    var6_6 = this._hash;
                    var7_7 = this.kFixHashSize;
                    var8_8 = var6_6[var7_7 + var1_1];
                    var6_6[var7_7 + var1_1] = this._pos;
                    var1_1 = this._cyclicBufferPos;
                    var9_9 = (var1_1 << 1) + 1;
                    var10_10 = var1_1 << 1;
                    var11_11 = this.kNumHashDirectBytes;
                    var12_12 = var11_11;
                    for (var7_7 = this._cutValue; var8_8 > var4_4 && var7_7 != 0; --var7_7) {
                        var13_13 = this._pos - var8_8;
                        var1_1 = this._cyclicBufferPos;
                        var1_1 = var13_13 <= var1_1 ? (var1_1 -= var13_13) : var1_1 - var13_13 + this._cyclicBufferSize;
                        var14_14 = var1_1 << 1;
                        var15_15 = this._bufferOffset + var8_8;
                        var1_1 = var13_13 = Math.min(var11_11, var12_12);
                        if (this._bufferBase[var15_15 + var13_13] == this._bufferBase[var5_5 + var13_13]) {
                            var1_1 = var13_13;
                            while ((var13_13 = var1_1 + 1) != var3_3) {
                                var1_1 = var13_13;
                                if (this._bufferBase[var15_15 + var13_13] == this._bufferBase[var5_5 + var13_13]) continue;
                            }
                            var1_1 = var13_13;
                            if (var13_13 == var3_3) {
                                var6_6 = this._son;
                                var6_6[var10_10] = var6_6[var14_14];
                                var6_6[var9_9] = var6_6[var14_14 + 1];
                                break block11;
                            }
                        }
                        if ((this._bufferBase[var15_15 + var1_1] & 255) < (this._bufferBase[var5_5 + var1_1] & 255)) {
                            var6_6 = this._son;
                            var6_6[var10_10] = var8_8;
                            var10_10 = var14_14 + 1;
                            var8_8 = var6_6[var10_10];
                            var12_12 = var1_1;
                            var1_1 = var8_8;
                        } else {
                            var6_6 = this._son;
                            var6_6[var9_9] = var8_8;
                            var8_8 = var6_6[var14_14];
                            var9_9 = var14_14;
                            var11_11 = var1_1;
                            var1_1 = var8_8;
                        }
                        var8_8 = var1_1;
                    }
                    var6_6 = this._son;
                    var6_6[var10_10] = 0;
                    var6_6[var9_9] = 0;
                }
                this.MovePos();
            }
            var2_2 = var1_1 = var2_2 - 1;
        } while (var1_1 != 0);
    }
}

