/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.StringBuilder;
import java.text.MessageFormat;
import java.util.Locale;

class TextFormatter {
    private StringBuilder buffer = new StringBuilder();
    private MessageFormat messageFormat;

    public TextFormatter(Locale locale, boolean bl) {
        if (bl) {
            this.messageFormat = new MessageFormat("", locale);
        }
    }

    private String replaceEscapeChars(String string2) {
        StringBuilder stringBuilder = this.buffer;
        stringBuilder.setLength(0);
        int n = string2.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '\'') {
                this.buffer.append("''");
                n2 = 1;
                continue;
            }
            if (c == '{') {
                int n3;
                for (n3 = i + 1; n3 < n && string2.charAt(n3) == '{'; ++n3) {
                }
                int n4 = n3 - i;
                if ((i = n4 / 2) > 0) {
                    this.buffer.append('\'');
                    n2 = i;
                    do {
                        this.buffer.append('{');
                        n2 = i = n2 - 1;
                    } while (i > 0);
                    this.buffer.append('\'');
                    n2 = 1;
                }
                if (n4 % 2 != 0) {
                    this.buffer.append('{');
                }
                i = n3 - 1;
                continue;
            }
            this.buffer.append(c);
        }
        if (n2 != 0) {
            string2 = this.buffer.toString();
        }
        return string2;
    }

    private String simpleFormat(String object, Object ... objectArray) {
        this.buffer.setLength(0);
        int n = ((String)object).length();
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c = ((String)object).charAt(i);
            if (n2 < 0) {
                if (c == '{') {
                    n3 = i + 1;
                    if (n3 < n && ((String)object).charAt(n3) == '{') {
                        this.buffer.append(c);
                        i = n3;
                    } else {
                        n2 = 0;
                    }
                    n3 = 1;
                    continue;
                }
                this.buffer.append(c);
                continue;
            }
            if (c == '}') {
                if (n2 < objectArray.length) {
                    if (((String)object).charAt(i - 1) != '{') {
                        if (objectArray[n2] == null) {
                            this.buffer.append("null");
                        } else {
                            this.buffer.append(objectArray[n2].toString());
                        }
                        n2 = -1;
                        continue;
                    }
                    throw new IllegalArgumentException("Missing argument index after a left curly brace");
                }
                object = new java.lang.StringBuilder();
                ((java.lang.StringBuilder)object).append("Argument index out of bounds: ");
                ((java.lang.StringBuilder)object).append(n2);
                throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
            }
            if (c >= '0' && c <= '9') {
                n2 = n2 * 10 + (c - 48);
                continue;
            }
            object = new java.lang.StringBuilder();
            ((java.lang.StringBuilder)object).append("Unexpected '");
            ((java.lang.StringBuilder)object).append(c);
            ((java.lang.StringBuilder)object).append("' while parsing argument index");
            throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
        }
        if (n2 < 0) {
            if (n3 != 0) {
                object = this.buffer.toString();
            }
            return object;
        }
        object = new IllegalArgumentException("Unmatched braces in the pattern.");
        throw object;
    }

    public String format(String string2, Object ... objectArray) {
        MessageFormat messageFormat = this.messageFormat;
        if (messageFormat != null) {
            messageFormat.applyPattern(this.replaceEscapeChars(string2));
            return this.messageFormat.format(objectArray);
        }
        return this.simpleFormat(string2, objectArray);
    }
}

