/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

public class PauseableThread
extends Thread {
    boolean exit = false;
    boolean paused = false;
    final Runnable runnable;

    public PauseableThread(Runnable runnable) {
        this.runnable = runnable;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void onPause() {
        this.paused = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onResume() {
        synchronized (this) {
            this.paused = false;
            this.notifyAll();
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            // MONITORENTER : this
            try {
                while (this.paused) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.exit) {
                return;
            }
            this.runnable.run();
            continue;
            break;
        }
        catch (Throwable throwable) {}
        // MONITOREXIT : this
        throw throwable;
    }

    public void stopThread() {
        this.exit = true;
        if (this.paused) {
            this.onResume();
        }
    }
}

