/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public abstract class FlushablePool<T>
extends Pool<T> {
    protected Array<T> obtained = new Array();

    public FlushablePool() {
    }

    public FlushablePool(int n) {
        super(n);
    }

    public FlushablePool(int n, int n2) {
        super(n, n2);
    }

    public void flush() {
        super.freeAll(this.obtained);
        this.obtained.clear();
    }

    @Override
    public void free(T t) {
        this.obtained.removeValue(t, true);
        super.free(t);
    }

    @Override
    public void freeAll(Array<T> array) {
        this.obtained.removeAll(array, true);
        super.freeAll(array);
    }

    @Override
    public T obtain() {
        Object t = super.obtain();
        this.obtained.add(t);
        return t;
    }
}

