/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class BufferUtils {
    static int allocatedUnsafe;
    static Array<ByteBuffer> unsafeBuffers;

    static {
        unsafeBuffers = new Array();
        allocatedUnsafe = 0;
    }

    private static int bytesToElements(Buffer buffer, int n) {
        if (buffer instanceof ByteBuffer) {
            return n;
        }
        if (buffer instanceof ShortBuffer) {
            return n >>> 1;
        }
        if (buffer instanceof CharBuffer) {
            return n >>> 1;
        }
        if (buffer instanceof IntBuffer) {
            return n >>> 2;
        }
        if (buffer instanceof LongBuffer) {
            return n >>> 3;
        }
        if (buffer instanceof FloatBuffer) {
            return n >>> 2;
        }
        if (buffer instanceof DoubleBuffer) {
            return n >>> 3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Can't copy to a ");
        stringBuilder.append(buffer.getClass().getName());
        stringBuilder.append(" instance");
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    public static native void clear(ByteBuffer var0, int var1);

    public static void copy(Buffer buffer, Buffer buffer2, int n) {
        n = BufferUtils.elementsToBytes(buffer, n);
        buffer2.limit(buffer2.position() + BufferUtils.bytesToElements(buffer2, n));
        BufferUtils.copyJni(buffer, BufferUtils.positionInBytes(buffer), buffer2, BufferUtils.positionInBytes(buffer2), n);
    }

    public static void copy(byte[] byArray, int n, Buffer buffer, int n2) {
        buffer.limit(buffer.position() + BufferUtils.bytesToElements(buffer, n2));
        BufferUtils.copyJni(byArray, n, buffer, BufferUtils.positionInBytes(buffer), n2);
    }

    public static void copy(char[] cArray, int n, int n2, Buffer buffer) {
        BufferUtils.copyJni(cArray, n, buffer, BufferUtils.positionInBytes(buffer), n2 << 1);
    }

    public static void copy(char[] cArray, int n, Buffer buffer, int n2) {
        int n3 = buffer.position();
        buffer.limit(n3 + BufferUtils.bytesToElements(buffer, n2 <<= 1));
        BufferUtils.copyJni(cArray, n, buffer, BufferUtils.positionInBytes(buffer), n2);
    }

    public static void copy(double[] dArray, int n, int n2, Buffer buffer) {
        BufferUtils.copyJni(dArray, n, buffer, BufferUtils.positionInBytes(buffer), n2 << 3);
    }

    public static void copy(double[] dArray, int n, Buffer buffer, int n2) {
        int n3 = buffer.position();
        buffer.limit(n3 + BufferUtils.bytesToElements(buffer, n2 <<= 3));
        BufferUtils.copyJni(dArray, n, buffer, BufferUtils.positionInBytes(buffer), n2);
    }

    public static void copy(float[] fArray, int n, int n2, Buffer buffer) {
        BufferUtils.copyJni(fArray, n, buffer, BufferUtils.positionInBytes(buffer), n2 << 2);
    }

    public static void copy(float[] fArray, int n, Buffer buffer, int n2) {
        int n3 = buffer.position();
        buffer.limit(n3 + BufferUtils.bytesToElements(buffer, n2 <<= 2));
        BufferUtils.copyJni(fArray, n, buffer, BufferUtils.positionInBytes(buffer), n2);
    }

    public static void copy(float[] fArray, Buffer buffer, int n, int n2) {
        if (buffer instanceof ByteBuffer) {
            buffer.limit(n << 2);
        } else if (buffer instanceof FloatBuffer) {
            buffer.limit(n);
        }
        BufferUtils.copyJni(fArray, buffer, n, n2);
        buffer.position(0);
    }

    public static void copy(int[] nArray, int n, int n2, Buffer buffer) {
        BufferUtils.copyJni(nArray, n, buffer, BufferUtils.positionInBytes(buffer), n2 << 2);
    }

    public static void copy(int[] nArray, int n, Buffer buffer, int n2) {
        int n3 = buffer.position();
        buffer.limit(n3 + BufferUtils.bytesToElements(buffer, n2 <<= 2));
        BufferUtils.copyJni(nArray, n, buffer, BufferUtils.positionInBytes(buffer), n2);
    }

    public static void copy(long[] lArray, int n, int n2, Buffer buffer) {
        BufferUtils.copyJni(lArray, n, buffer, BufferUtils.positionInBytes(buffer), n2 << 3);
    }

    public static void copy(long[] lArray, int n, Buffer buffer, int n2) {
        int n3 = buffer.position();
        buffer.limit(n3 + BufferUtils.bytesToElements(buffer, n2 <<= 3));
        BufferUtils.copyJni(lArray, n, buffer, BufferUtils.positionInBytes(buffer), n2);
    }

    public static void copy(short[] sArray, int n, Buffer buffer, int n2) {
        int n3 = buffer.position();
        buffer.limit(n3 + BufferUtils.bytesToElements(buffer, n2 <<= 1));
        BufferUtils.copyJni(sArray, n, buffer, BufferUtils.positionInBytes(buffer), n2);
    }

    private static native void copyJni(Buffer var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(byte[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(char[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(double[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(float[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(float[] var0, Buffer var1, int var2, int var3);

    private static native void copyJni(int[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(long[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(short[] var0, int var1, Buffer var2, int var3, int var4);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void disposeUnsafeByteBuffer(ByteBuffer object) {
        int n = ((Buffer)object).capacity();
        Array<ByteBuffer> array = unsafeBuffers;
        synchronized (array) {
            if (unsafeBuffers.removeValue((ByteBuffer)object, true)) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
                allocatedUnsafe -= n;
                BufferUtils.freeMemory((ByteBuffer)object);
                return;
            }
            object = new IllegalArgumentException("buffer not allocated with newUnsafeByteBuffer or already disposed");
            throw object;
        }
    }

    private static int elementsToBytes(Buffer buffer, int n) {
        if (buffer instanceof ByteBuffer) {
            return n;
        }
        if (buffer instanceof ShortBuffer) {
            return n << 1;
        }
        if (buffer instanceof CharBuffer) {
            return n << 1;
        }
        if (buffer instanceof IntBuffer) {
            return n << 2;
        }
        if (buffer instanceof LongBuffer) {
            return n << 3;
        }
        if (buffer instanceof FloatBuffer) {
            return n << 2;
        }
        if (buffer instanceof DoubleBuffer) {
            return n << 3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Can't copy to a ");
        stringBuilder.append(buffer.getClass().getName());
        stringBuilder.append(" instance");
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    private static native long find(Buffer var0, int var1, int var2, Buffer var3, int var4, int var5);

    private static native long find(Buffer var0, int var1, int var2, Buffer var3, int var4, int var5, float var6);

    private static native long find(Buffer var0, int var1, int var2, float[] var3, int var4, int var5);

    private static native long find(Buffer var0, int var1, int var2, float[] var3, int var4, int var5, float var6);

    private static native long find(float[] var0, int var1, int var2, Buffer var3, int var4, int var5);

    private static native long find(float[] var0, int var1, int var2, Buffer var3, int var4, int var5, float var6);

    private static native long find(float[] var0, int var1, int var2, float[] var3, int var4, int var5);

    private static native long find(float[] var0, int var1, int var2, float[] var3, int var4, int var5, float var6);

    public static long findFloats(Buffer buffer, int n, Buffer buffer2, int n2) {
        return BufferUtils.find(buffer, BufferUtils.positionInBytes(buffer), n, buffer2, BufferUtils.positionInBytes(buffer2), n2);
    }

    public static long findFloats(Buffer buffer, int n, Buffer buffer2, int n2, float f) {
        return BufferUtils.find(buffer, BufferUtils.positionInBytes(buffer), n, buffer2, BufferUtils.positionInBytes(buffer2), n2, f);
    }

    public static long findFloats(Buffer buffer, int n, float[] fArray, int n2) {
        return BufferUtils.find(buffer, BufferUtils.positionInBytes(buffer), n, fArray, 0, n2);
    }

    public static long findFloats(Buffer buffer, int n, float[] fArray, int n2, float f) {
        return BufferUtils.find(buffer, BufferUtils.positionInBytes(buffer), n, fArray, 0, n2, f);
    }

    public static long findFloats(float[] fArray, int n, Buffer buffer, int n2) {
        return BufferUtils.find(fArray, 0, n, buffer, BufferUtils.positionInBytes(buffer), n2);
    }

    public static long findFloats(float[] fArray, int n, Buffer buffer, int n2, float f) {
        return BufferUtils.find(fArray, 0, n, buffer, BufferUtils.positionInBytes(buffer), n2, f);
    }

    public static long findFloats(float[] fArray, int n, float[] fArray2, int n2) {
        return BufferUtils.find(fArray, 0, n, fArray2, 0, n2);
    }

    public static long findFloats(float[] fArray, int n, float[] fArray2, int n2, float f) {
        return BufferUtils.find(fArray, 0, n, fArray2, 0, n2, f);
    }

    private static native void freeMemory(ByteBuffer var0);

    public static int getAllocatedBytesUnsafe() {
        return allocatedUnsafe;
    }

    private static native long getBufferAddress(Buffer var0);

    public static long getUnsafeBufferAddress(Buffer buffer) {
        return BufferUtils.getBufferAddress(buffer) + (long)buffer.position();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isUnsafeByteBuffer(ByteBuffer byteBuffer) {
        Array<ByteBuffer> array = unsafeBuffers;
        synchronized (array) {
            return unsafeBuffers.contains(byteBuffer, true);
        }
    }

    public static ByteBuffer newByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public static CharBuffer newCharBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asCharBuffer();
    }

    private static native ByteBuffer newDisposableByteBuffer(int var0);

    public static DoubleBuffer newDoubleBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 8);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asDoubleBuffer();
    }

    public static FloatBuffer newFloatBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asFloatBuffer();
    }

    public static IntBuffer newIntBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asIntBuffer();
    }

    public static LongBuffer newLongBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 8);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asLongBuffer();
    }

    public static ShortBuffer newShortBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asShortBuffer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer newUnsafeByteBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newDisposableByteBuffer(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        allocatedUnsafe += n;
        Array<ByteBuffer> array = unsafeBuffers;
        synchronized (array) {
            unsafeBuffers.add(byteBuffer);
            return byteBuffer;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer newUnsafeByteBuffer(ByteBuffer byteBuffer) {
        allocatedUnsafe += byteBuffer.capacity();
        Array<ByteBuffer> array = unsafeBuffers;
        synchronized (array) {
            unsafeBuffers.add(byteBuffer);
            return byteBuffer;
        }
    }

    private static int positionInBytes(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return buffer.position();
        }
        if (buffer instanceof ShortBuffer) {
            return buffer.position() << 1;
        }
        if (buffer instanceof CharBuffer) {
            return buffer.position() << 1;
        }
        if (buffer instanceof IntBuffer) {
            return buffer.position() << 2;
        }
        if (buffer instanceof LongBuffer) {
            return buffer.position() << 3;
        }
        if (buffer instanceof FloatBuffer) {
            return buffer.position() << 2;
        }
        if (buffer instanceof DoubleBuffer) {
            return buffer.position() << 3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Can't copy to a ");
        stringBuilder.append(buffer.getClass().getName());
        stringBuilder.append(" instance");
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    public static void transform(Buffer buffer, int n, int n2, int n3, Matrix3 matrix3) {
        BufferUtils.transform(buffer, n, n2, n3, matrix3, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transform(Buffer buffer, int n, int n2, int n3, Matrix3 matrix3, int n4) {
        if (n != 2) {
            if (n != 3) throw new IllegalArgumentException();
            BufferUtils.transformV3M3Jni(buffer, n2, n3, matrix3.val, BufferUtils.positionInBytes(buffer) + n4);
            return;
        } else {
            BufferUtils.transformV2M3Jni(buffer, n2, n3, matrix3.val, BufferUtils.positionInBytes(buffer) + n4);
        }
    }

    public static void transform(Buffer buffer, int n, int n2, int n3, Matrix4 matrix4) {
        BufferUtils.transform(buffer, n, n2, n3, matrix4, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transform(Buffer buffer, int n, int n2, int n3, Matrix4 matrix4, int n4) {
        if (n != 2) {
            if (n != 3) {
                if (n != 4) throw new IllegalArgumentException();
                BufferUtils.transformV4M4Jni(buffer, n2, n3, matrix4.val, BufferUtils.positionInBytes(buffer) + n4);
                return;
            } else {
                BufferUtils.transformV3M4Jni(buffer, n2, n3, matrix4.val, BufferUtils.positionInBytes(buffer) + n4);
            }
            return;
        } else {
            BufferUtils.transformV2M4Jni(buffer, n2, n3, matrix4.val, BufferUtils.positionInBytes(buffer) + n4);
        }
    }

    public static void transform(float[] fArray, int n, int n2, int n3, Matrix3 matrix3) {
        BufferUtils.transform(fArray, n, n2, n3, matrix3, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transform(float[] fArray, int n, int n2, int n3, Matrix3 matrix3, int n4) {
        if (n != 2) {
            if (n != 3) throw new IllegalArgumentException();
            BufferUtils.transformV3M3Jni(fArray, n2, n3, matrix3.val, n4);
            return;
        } else {
            BufferUtils.transformV2M3Jni(fArray, n2, n3, matrix3.val, n4);
        }
    }

    public static void transform(float[] fArray, int n, int n2, int n3, Matrix4 matrix4) {
        BufferUtils.transform(fArray, n, n2, n3, matrix4, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transform(float[] fArray, int n, int n2, int n3, Matrix4 matrix4, int n4) {
        if (n != 2) {
            if (n != 3) {
                if (n != 4) throw new IllegalArgumentException();
                BufferUtils.transformV4M4Jni(fArray, n2, n3, matrix4.val, n4);
                return;
            } else {
                BufferUtils.transformV3M4Jni(fArray, n2, n3, matrix4.val, n4);
            }
            return;
        } else {
            BufferUtils.transformV2M4Jni(fArray, n2, n3, matrix4.val, n4);
        }
    }

    private static native void transformV2M3Jni(Buffer var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV2M3Jni(float[] var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV2M4Jni(Buffer var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV2M4Jni(float[] var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV3M3Jni(Buffer var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV3M3Jni(float[] var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV3M4Jni(Buffer var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV3M4Jni(float[] var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV4M4Jni(Buffer var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV4M4Jni(float[] var0, int var1, int var2, float[] var3, int var4);
}

