/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.StringBuilder;

public class Base64Coder {
    public static final CharMap regularMap = new CharMap('+', '/');
    private static final String systemLineSeparator = "\n";
    public static final CharMap urlsafeMap = new CharMap('-', '_');

    private Base64Coder() {
    }

    public static byte[] decode(String string2) {
        return Base64Coder.decode(string2.toCharArray());
    }

    public static byte[] decode(String string2, CharMap charMap) {
        return Base64Coder.decode(string2.toCharArray(), charMap);
    }

    public static byte[] decode(char[] cArray) {
        return Base64Coder.decode(cArray, 0, cArray.length, Base64Coder.regularMap.decodingMap);
    }

    public static byte[] decode(char[] cArray, int n, int n2, CharMap charMap) {
        return Base64Coder.decode(cArray, n, n2, charMap.decodingMap);
    }

    public static byte[] decode(char[] object, int n, int n2, byte[] byArray) {
        if (n2 % 4 == 0) {
            while (n2 > 0 && object[n + n2 - 1] == '=') {
                --n2;
            }
            int n3 = n2 * 3 / 4;
            byte[] byArray2 = new byte[n3];
            int n4 = n2 + n;
            int n5 = 0;
            while (n < n4) {
                int n6;
                n2 = n + 1;
                char c = object[n];
                n = n2 + 1;
                char c2 = object[n2];
                int n7 = 65;
                if (n < n4) {
                    n2 = n + 1;
                    n6 = object[n];
                } else {
                    n2 = n;
                    n6 = 65;
                }
                n = n2;
                if (n2 < n4) {
                    n7 = object[n2];
                    n = n2 + 1;
                }
                if (c <= '\u007f' && c2 <= '\u007f' && n6 <= 127 && n7 <= 127) {
                    byte by = byArray[c];
                    c = byArray[c2];
                    n6 = byArray[n6];
                    n7 = byArray[n7];
                    if (by >= 0 && c >= '\u0000' && n6 >= 0 && n7 >= 0) {
                        n2 = n5 + 1;
                        byArray2[n5] = (byte)(by << 2 | c >>> 4);
                        if (n2 < n3) {
                            n5 = n2 + 1;
                            byArray2[n2] = (byte)((c & 0xF) << 4 | n6 >>> 2);
                            n2 = n5;
                        }
                        if (n2 < n3) {
                            n5 = n2 + 1;
                            byArray2[n2] = (byte)((n6 & 3) << 6 | n7);
                            n2 = n5;
                        }
                        n5 = n2;
                        continue;
                    }
                    throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
                }
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            return byArray2;
        }
        object = new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        throw object;
    }

    public static byte[] decode(char[] cArray, CharMap charMap) {
        return Base64Coder.decode(cArray, 0, cArray.length, charMap);
    }

    public static byte[] decode(char[] cArray, byte[] byArray) {
        return Base64Coder.decode(cArray, 0, cArray.length, byArray);
    }

    public static byte[] decodeLines(String string2) {
        return Base64Coder.decodeLines(string2, Base64Coder.regularMap.decodingMap);
    }

    public static byte[] decodeLines(String string2, CharMap charMap) {
        return Base64Coder.decodeLines(string2, charMap.decodingMap);
    }

    public static byte[] decodeLines(String string2, byte[] byArray) {
        char[] cArray = new char[string2.length()];
        int n = 0;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n2 = n;
            if (c != ' ') {
                n2 = n;
                if (c != '\r') {
                    n2 = n;
                    if (c != '\n') {
                        n2 = n;
                        if (c != '\t') {
                            cArray[n] = c;
                            n2 = n + 1;
                        }
                    }
                }
            }
            n = n2;
        }
        return Base64Coder.decode(cArray, 0, n, byArray);
    }

    public static String decodeString(String string2) {
        return Base64Coder.decodeString(string2, false);
    }

    public static String decodeString(String object, boolean bl) {
        char[] cArray = ((String)object).toCharArray();
        object = bl ? urlsafeMap : regularMap;
        return new String(Base64Coder.decode(cArray, ((CharMap)object).decodingMap));
    }

    public static char[] encode(byte[] byArray) {
        return Base64Coder.encode(byArray, Base64Coder.regularMap.encodingMap);
    }

    public static char[] encode(byte[] byArray, int n) {
        return Base64Coder.encode(byArray, 0, n, Base64Coder.regularMap.encodingMap);
    }

    public static char[] encode(byte[] byArray, int n, int n2, CharMap charMap) {
        return Base64Coder.encode(byArray, n, n2, charMap.encodingMap);
    }

    public static char[] encode(byte[] byArray, int n, int n2, char[] cArray) {
        int n3 = (n2 * 4 + 2) / 3;
        char[] cArray2 = new char[(n2 + 2) / 3 * 4];
        int n4 = n2 + n;
        n2 = 0;
        while (n < n4) {
            int n5;
            int n6;
            int n7 = n + 1;
            int n8 = byArray[n] & 0xFF;
            if (n7 < n4) {
                n = n7 + 1;
                n7 = byArray[n7] & 0xFF;
            } else {
                n = n7;
                n7 = 0;
            }
            if (n < n4) {
                n6 = n + 1;
                n5 = byArray[n] & 0xFF;
                n = n6;
            } else {
                n5 = 0;
            }
            n6 = n2 + 1;
            cArray2[n2] = cArray[n8 >>> 2];
            int n9 = n6 + 1;
            cArray2[n6] = cArray[(n8 & 3) << 4 | n7 >>> 4];
            n6 = 61;
            n2 = n9 < n3 ? cArray[(n7 & 0xF) << 2 | n5 >>> 6] : 61;
            cArray2[n9] = (char)n2;
            n7 = n9 + 1;
            n2 = n6;
            if (n7 < n3) {
                n2 = cArray[n5 & 0x3F];
            }
            cArray2[n7] = (char)n2;
            n2 = n7 + 1;
        }
        return cArray2;
    }

    public static char[] encode(byte[] byArray, CharMap charMap) {
        return Base64Coder.encode(byArray, 0, byArray.length, charMap);
    }

    public static char[] encode(byte[] byArray, char[] cArray) {
        return Base64Coder.encode(byArray, 0, byArray.length, cArray);
    }

    public static String encodeLines(byte[] byArray) {
        return Base64Coder.encodeLines(byArray, 0, byArray.length, 76, systemLineSeparator, Base64Coder.regularMap.encodingMap);
    }

    public static String encodeLines(byte[] byArray, int n, int n2, int n3, String string2, CharMap charMap) {
        return Base64Coder.encodeLines(byArray, n, n2, n3, string2, charMap.encodingMap);
    }

    public static String encodeLines(byte[] object, int n, int n2, int n3, String string2, char[] cArray) {
        int n4 = n3 * 3 / 4;
        if (n4 > 0) {
            int n5;
            n3 = (n2 + n4 - 1) / n4;
            StringBuilder stringBuilder = new StringBuilder((n2 + 2) / 3 * 4 + n3 * string2.length());
            for (n3 = 0; n3 < n2; n3 += n5) {
                n5 = Math.min(n2 - n3, n4);
                stringBuilder.append(Base64Coder.encode(object, n + n3, n5, cArray));
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        object = new IllegalArgumentException();
        throw object;
    }

    public static String encodeString(String string2) {
        return Base64Coder.encodeString(string2, false);
    }

    public static String encodeString(String object, boolean bl) {
        byte[] byArray = ((String)object).getBytes();
        object = bl ? urlsafeMap : regularMap;
        return new String(Base64Coder.encode(byArray, ((CharMap)object).encodingMap));
    }

    public static class CharMap {
        protected final byte[] decodingMap;
        protected final char[] encodingMap = new char[64];

        public CharMap(char c, char c2) {
            this.decodingMap = new byte[128];
            char c3 = '\u0000';
            int n = 65;
            int n2 = 0;
            while (n <= 90) {
                this.encodingMap[n2] = (char)n;
                n = (char)(n + 1);
                ++n2;
            }
            n = 97;
            while (n <= 122) {
                this.encodingMap[n2] = (char)n;
                n = (char)(n + 1);
                ++n2;
            }
            n = 48;
            while (n <= 57) {
                this.encodingMap[n2] = (char)n;
                n = (char)(n + 1);
                ++n2;
            }
            Object[] objectArray = this.encodingMap;
            objectArray[n2] = c;
            objectArray[n2 + 1] = c2;
            c2 = '\u0000';
            while (true) {
                objectArray = this.decodingMap;
                if (c2 >= objectArray.length) break;
                objectArray[c2] = (char)-1;
                c2 = (char)(c2 + 1);
            }
            for (c = c3; c < '@'; c = (char)(c + 1)) {
                this.decodingMap[this.encodingMap[c]] = (byte)c;
            }
        }

        public byte[] getDecodingMap() {
            return this.decodingMap;
        }

        public char[] getEncodingMap() {
            return this.encodingMap;
        }
    }
}

