/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class AtomicQueue<T> {
    private final AtomicReferenceArray<T> queue;
    private final AtomicInteger readIndex;
    private final AtomicInteger writeIndex = new AtomicInteger();

    public AtomicQueue(int n) {
        this.readIndex = new AtomicInteger();
        this.queue = new AtomicReferenceArray(n);
    }

    private int next(int n) {
        return (n + 1) % this.queue.length();
    }

    public T poll() {
        int n = this.readIndex.get();
        if (n == this.writeIndex.get()) {
            return null;
        }
        T t = this.queue.get(n);
        this.readIndex.set(this.next(n));
        return t;
    }

    public boolean put(T t) {
        int n = this.writeIndex.get();
        int n2 = this.readIndex.get();
        int n3 = this.next(n);
        if (n3 == n2) {
            return false;
        }
        this.queue.set(n, t);
        this.writeIndex.set(n3);
        return true;
    }
}

