/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.SnapshotArray;

public class WidgetGroup
extends Group
implements Layout {
    private boolean fillParent;
    private boolean layoutEnabled = true;
    private boolean needsLayout = true;

    public WidgetGroup() {
    }

    public WidgetGroup(Actor ... actorArray) {
        int n = actorArray.length;
        for (int i = 0; i < n; ++i) {
            this.addActor(actorArray[i]);
        }
    }

    private void setLayoutEnabled(Group actor, boolean bl) {
        SnapshotArray<Actor> snapshotArray = actor.getChildren();
        int n = snapshotArray.size;
        for (int i = 0; i < n; ++i) {
            actor = (Actor)snapshotArray.get(i);
            if (actor instanceof Layout) {
                ((Layout)((Object)actor)).setLayoutEnabled(bl);
                continue;
            }
            if (!(actor instanceof Group)) continue;
            this.setLayoutEnabled((Group)actor, bl);
        }
    }

    @Override
    protected void childrenChanged() {
        this.invalidateHierarchy();
    }

    @Override
    public void draw(Batch batch, float f) {
        this.validate();
        super.draw(batch, f);
    }

    @Override
    public float getMaxHeight() {
        return 0.0f;
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getPrefHeight() {
        return 0.0f;
    }

    @Override
    public float getPrefWidth() {
        return 0.0f;
    }

    @Override
    public void invalidate() {
        this.needsLayout = true;
    }

    @Override
    public void invalidateHierarchy() {
        this.invalidate();
        Group group = this.getParent();
        if (group instanceof Layout) {
            ((Layout)((Object)group)).invalidateHierarchy();
        }
    }

    @Override
    public void layout() {
    }

    public boolean needsLayout() {
        return this.needsLayout;
    }

    @Override
    public void pack() {
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.validate();
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.validate();
    }

    @Override
    public void setFillParent(boolean bl) {
        this.fillParent = bl;
    }

    @Override
    public void setLayoutEnabled(boolean bl) {
        this.layoutEnabled = bl;
        this.setLayoutEnabled(this, bl);
    }

    @Override
    protected void sizeChanged() {
        this.invalidate();
    }

    @Override
    public void validate() {
        if (!this.layoutEnabled) {
            return;
        }
        Group group = this.getParent();
        if (this.fillParent && group != null) {
            float f;
            float f2;
            Stage stage = this.getStage();
            if (stage != null && group == stage.getRoot()) {
                f2 = stage.getWidth();
                f = stage.getHeight();
            } else {
                f2 = group.getWidth();
                f = group.getHeight();
            }
            if (this.getWidth() != f2 || this.getHeight() != f) {
                this.setWidth(f2);
                this.setHeight(f);
                this.invalidate();
            }
        }
        if (!this.needsLayout) {
            return;
        }
        this.needsLayout = false;
        this.layout();
        if (this.needsLayout) {
            if (group instanceof WidgetGroup) {
                return;
            }
            for (int i = 0; i < 5; ++i) {
                this.needsLayout = false;
                this.layout();
                if (!this.needsLayout) break;
            }
        }
    }
}

