/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.SnapshotArray;

public class VerticalGroup
extends WidgetGroup {
    private int align = 2;
    private int columnAlign;
    private FloatArray columnSizes;
    private boolean expand;
    private float fill;
    private float lastPrefWidth;
    private float padBottom;
    private float padLeft;
    private float padRight;
    private float padTop;
    private float prefHeight;
    private float prefWidth;
    private boolean reverse;
    private boolean round = true;
    private boolean sizeInvalid = true;
    private float space;
    private boolean wrap;
    private float wrapSpace;

    public VerticalGroup() {
        this.setTouchable(Touchable.childrenOnly);
    }

    private void computeSize() {
        int n = 0;
        int n2 = 0;
        this.sizeInvalid = false;
        SnapshotArray<Actor> snapshotArray = this.getChildren();
        int n3 = snapshotArray.size;
        this.prefWidth = 0.0f;
        if (this.wrap) {
            float f;
            float f2;
            float f3;
            this.prefHeight = 0.0f;
            FloatArray floatArray = this.columnSizes;
            if (floatArray == null) {
                this.columnSizes = new FloatArray();
            } else {
                floatArray.clear();
            }
            floatArray = this.columnSizes;
            float f4 = this.space;
            float f5 = this.wrapSpace;
            float f6 = this.padTop + this.padBottom;
            float f7 = this.getHeight() - f6;
            if (this.reverse) {
                n2 = n3 - 1;
                n3 = -1;
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
                n = -1;
            } else {
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
                n = 1;
            }
            while (n2 != n3) {
                float f8;
                float f9;
                float f10;
                Object object = (Actor)snapshotArray.get(n2);
                if (object instanceof Layout) {
                    object = (Layout)object;
                    f10 = object.getPrefWidth();
                    float f11 = object.getPrefHeight();
                    f9 = f10;
                    f8 = f11;
                    if (f11 > f7) {
                        f8 = Math.max(f7, object.getMinHeight());
                        f9 = f10;
                    }
                } else {
                    f9 = ((Actor)object).getWidth();
                    f8 = ((Actor)object).getHeight();
                }
                f10 = f3 > 0.0f ? f4 : 0.0f;
                if (f3 + (f10 = f8 + f10) > f7 && f3 > 0.0f) {
                    floatArray.add(f3);
                    floatArray.add(f2);
                    this.prefHeight = Math.max(this.prefHeight, f3 + f6);
                    f3 = f;
                    if (f > 0.0f) {
                        f3 = f + f5;
                    }
                    f = f3 + f2;
                    f3 = 0.0f;
                    f2 = 0.0f;
                } else {
                    f8 = f10;
                }
                f3 += f8;
                f2 = Math.max(f2, f9);
                n2 += n;
            }
            floatArray.add(f3);
            floatArray.add(f2);
            this.prefHeight = Math.max(this.prefHeight, f3 + f6);
            f3 = f;
            if (f > 0.0f) {
                f3 = f + f5;
            }
            this.prefWidth = Math.max(this.prefWidth, f3 + f2);
        } else {
            this.prefHeight = this.padTop + this.padBottom + this.space * (float)(n3 - 1);
            for (n2 = n; n2 < n3; ++n2) {
                Object object = (Actor)snapshotArray.get(n2);
                if (object instanceof Layout) {
                    object = (Layout)object;
                    this.prefWidth = Math.max(this.prefWidth, object.getPrefWidth());
                    this.prefHeight += object.getPrefHeight();
                    continue;
                }
                this.prefWidth = Math.max(this.prefWidth, ((Actor)object).getWidth());
                this.prefHeight += ((Actor)object).getHeight();
            }
        }
        this.prefWidth += this.padLeft + this.padRight;
        if (this.round) {
            this.prefWidth = Math.round(this.prefWidth);
            this.prefHeight = Math.round(this.prefHeight);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void layoutWrapped() {
        var1_1 = this;
        var2_2 = this.getPrefWidth();
        if (var2_2 != var1_1.lastPrefWidth) {
            var1_1.lastPrefWidth = var2_2;
            this.invalidateHierarchy();
        }
        var3_3 = var1_1.align;
        var4_4 = var1_1.round;
        var5_5 = var1_1.space;
        var6_6 = var1_1.padLeft;
        var7_7 = var1_1.fill;
        var8_8 = var1_1.wrapSpace;
        var9_9 = var1_1.prefHeight - var1_1.padTop - var1_1.padBottom;
        var10_10 = this.getHeight();
        var11_11 = var1_1.prefHeight - var1_1.padTop + var5_5;
        if ((var3_3 & 16) != 0) {
            var2_2 = this.getWidth() - var2_2;
lbl17:
            // 2 sources

            while (true) {
                var12_12 = var6_6 + var2_2;
                break;
            }
        } else {
            var12_12 = var6_6;
            if ((var3_3 & 8) == 0) {
                var2_2 = (this.getWidth() - var2_2) / 2.0f;
                ** continue;
            }
        }
        if ((var3_3 & 2) != 0) {
            var2_2 = var10_10 - var1_1.prefHeight;
lbl26:
            // 2 sources

            while (true) {
                var2_2 = var11_11 + var2_2;
                break;
            }
        } else {
            var2_2 = var11_11;
            if ((var3_3 & 4) == 0) {
                var2_2 = (var10_10 - var1_1.prefHeight) / 2.0f;
                ** continue;
            }
        }
        var13_13 = var10_10 - var1_1.padTop;
        var14_14 = var1_1.columnAlign;
        var15_15 = var1_1.columnSizes;
        var16_16 = this.getChildren();
        var3_3 = var16_16.size;
        var17_17 = var1_1.reverse;
        var18_18 = -1;
        if (var17_17) {
            --var3_3;
            var19_19 = -1;
        } else {
            var18_18 = var3_3;
            var3_3 = 0;
            var19_19 = 1;
        }
        var6_6 = 0.0f;
        var20_20 = 0;
        var21_21 = 0.0f;
        while (var3_3 != var18_18) {
            block28: {
                block27: {
                    block26: {
                        var22_22 = (Actor)var16_16.get(var3_3);
                        var1_1 = null;
                        if (!(var22_22 instanceof Layout)) break block26;
                        var23_23 = (Layout)var22_22;
                        var24_24 = var23_23.getPrefWidth();
                        var25_25 = var23_23.getPrefHeight();
                        var11_11 = var24_24;
                        var1_1 = var23_23;
                        var10_10 = var25_25;
                        if (!(var25_25 > var13_13)) break block27;
                        var11_11 = var24_24;
                        var24_24 = Math.max(var13_13, var23_23.getMinHeight());
                        var1_1 = var23_23;
                        break block28;
                    }
                    var11_11 = var22_22.getWidth();
                    var10_10 = var22_22.getHeight();
                }
                var24_24 = var10_10;
            }
            if (!(var6_6 - var24_24 - var5_5 < this.padBottom) && var20_20 != 0) {
                var10_10 = var6_6;
            } else {
                if ((var14_14 & 4) != 0) {
                    var6_6 = var9_9 - var15_15.get(var20_20);
lbl76:
                    // 2 sources

                    while (true) {
                        var6_6 = var2_2 - var6_6;
                        break;
                    }
                } else {
                    if ((var14_14 & 2) == 0) {
                        var6_6 = (var9_9 - var15_15.get(var20_20)) / 2.0f;
                        ** continue;
                    }
                    var6_6 = var2_2;
                }
                var10_10 = var12_12;
                if (var20_20 > 0) {
                    var10_10 = var12_12 + var8_8 + var21_21;
                }
                var21_21 = var15_15.get(var20_20 + 1);
                var20_20 += 2;
                var12_12 = var10_10;
                var10_10 = var6_6;
            }
            if (var7_7 > 0.0f) {
                var11_11 = var21_21 * var7_7;
            }
            if (var1_1 != null) {
                var6_6 = Math.max(var11_11, var1_1.getMinWidth());
                var25_25 = var1_1.getMaxWidth();
                var11_11 = var6_6;
                if (var25_25 > 0.0f) {
                    var11_11 = var6_6;
                    if (var6_6 > var25_25) {
                        var11_11 = var25_25;
                    }
                }
            }
            var6_6 = (var14_14 & 16) != 0 ? var12_12 + (var21_21 - var11_11) : ((var14_14 & 8) == 0 ? var12_12 + (var21_21 - var11_11) / 2.0f : var12_12);
            var10_10 -= var24_24 + var5_5;
            if (var4_4) {
                var22_22.setBounds(Math.round(var6_6), Math.round(var10_10), Math.round(var11_11), Math.round(var24_24));
            } else {
                var22_22.setBounds(var6_6, var10_10, var11_11, var24_24);
            }
            if (var1_1 != null) {
                var1_1.validate();
            }
            var3_3 += var19_19;
            var6_6 = var10_10;
        }
    }

    public VerticalGroup align(int n) {
        this.align = n;
        return this;
    }

    public VerticalGroup bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return this;
    }

    public VerticalGroup center() {
        this.align = 1;
        return this;
    }

    public VerticalGroup columnAlign(int n) {
        this.columnAlign = n;
        return this;
    }

    public VerticalGroup columnBottom() {
        this.columnAlign |= 4;
        this.columnAlign &= 0xFFFFFFFD;
        return this;
    }

    public VerticalGroup columnCenter() {
        this.columnAlign = 1;
        return this;
    }

    public VerticalGroup columnLeft() {
        this.columnAlign |= 8;
        this.columnAlign &= 0xFFFFFFEF;
        return this;
    }

    public VerticalGroup columnRight() {
        this.columnAlign |= 0x10;
        this.columnAlign &= 0xFFFFFFF7;
        return this;
    }

    public VerticalGroup columnTop() {
        this.columnAlign |= 2;
        this.columnAlign &= 0xFFFFFFFB;
        return this;
    }

    @Override
    protected void drawDebugBounds(ShapeRenderer shapeRenderer) {
        super.drawDebugBounds(shapeRenderer);
        if (!this.getDebug()) {
            return;
        }
        shapeRenderer.set(ShapeRenderer.ShapeType.Line);
        if (this.getStage() != null) {
            shapeRenderer.setColor(this.getStage().getDebugColor());
        }
        shapeRenderer.rect(this.getX() + this.padLeft, this.getY() + this.padBottom, this.getOriginX(), this.getOriginY(), this.getWidth() - this.padLeft - this.padRight, this.getHeight() - this.padBottom - this.padTop, this.getScaleX(), this.getScaleY(), this.getRotation());
    }

    public VerticalGroup expand() {
        this.expand = true;
        return this;
    }

    public VerticalGroup expand(boolean bl) {
        this.expand = bl;
        return this;
    }

    public VerticalGroup fill() {
        this.fill = 1.0f;
        return this;
    }

    public VerticalGroup fill(float f) {
        this.fill = f;
        return this;
    }

    public int getAlign() {
        return this.align;
    }

    public boolean getExpand() {
        return this.expand;
    }

    public float getFill() {
        return this.fill;
    }

    public float getPadBottom() {
        return this.padBottom;
    }

    public float getPadLeft() {
        return this.padLeft;
    }

    public float getPadRight() {
        return this.padRight;
    }

    public float getPadTop() {
        return this.padTop;
    }

    @Override
    public float getPrefHeight() {
        if (this.wrap) {
            return 0.0f;
        }
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public float getSpace() {
        return this.space;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public float getWrapSpace() {
        return this.wrapSpace;
    }

    public VerticalGroup grow() {
        this.expand = true;
        this.fill = 1.0f;
        return this;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void layout() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        int n;
        boolean bl;
        block20: {
            block19: {
                block18: {
                    if (this.sizeInvalid) {
                        this.computeSize();
                    }
                    if (this.wrap) {
                        this.layoutWrapped();
                        return;
                    }
                    bl = this.round;
                    n = this.align;
                    f8 = this.space;
                    f7 = this.padLeft;
                    f6 = this.fill;
                    f5 = this.expand ? this.getWidth() : this.prefWidth;
                    f4 = f5 - f7 - this.padRight;
                    f3 = this.prefHeight - this.padTop + f8;
                    if ((n & 2) == 0) break block18;
                    f5 = this.getHeight() - this.prefHeight;
                    break block19;
                }
                f2 = f3;
                if ((n & 4) != 0) break block20;
                f5 = (this.getHeight() - this.prefHeight) / 2.0f;
            }
            f2 = f3 + f5;
        }
        f5 = (n & 8) != 0 ? f7 : ((n & 0x10) != 0 ? this.getWidth() - this.padRight - f4 : f7 + (this.getWidth() - f7 - this.padRight - f4) / 2.0f);
        int n2 = this.columnAlign;
        SnapshotArray<Actor> snapshotArray = this.getChildren();
        n = 0;
        int n3 = snapshotArray.size;
        boolean bl2 = this.reverse;
        int n4 = -1;
        if (bl2) {
            n = n3 - 1;
            n3 = -1;
            f = f2;
        } else {
            n4 = 1;
            f = f2;
        }
        while (n != n3) {
            Actor actor = (Actor)snapshotArray.get(n);
            Layout layout = null;
            if (actor instanceof Layout) {
                layout = (Layout)((Object)actor);
                f7 = layout.getPrefWidth();
                f2 = layout.getPrefHeight();
            } else {
                f7 = actor.getWidth();
                f2 = actor.getHeight();
            }
            f3 = f7;
            if (f6 > 0.0f) {
                f3 = f4 * f6;
            }
            f7 = f3;
            if (layout != null) {
                float f9 = Math.max(f3, layout.getMinWidth());
                f3 = layout.getMaxWidth();
                f7 = f9;
                if (f3 > 0.0f) {
                    f7 = f9;
                    if (f9 > f3) {
                        f7 = f3;
                    }
                }
            }
            f3 = (n2 & 0x10) != 0 ? f4 - f7 + f5 : ((n2 & 8) == 0 ? (f4 - f7) / 2.0f + f5 : f5);
            f -= f2 + f8;
            if (bl) {
                actor.setBounds(Math.round(f3), Math.round(f), Math.round(f7), Math.round(f2));
            } else {
                actor.setBounds(f3, f, f7, f2);
            }
            if (layout != null) {
                layout.validate();
            }
            n += n4;
        }
        return;
    }

    public VerticalGroup left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return this;
    }

    public VerticalGroup pad(float f) {
        this.padTop = f;
        this.padLeft = f;
        this.padBottom = f;
        this.padRight = f;
        return this;
    }

    public VerticalGroup pad(float f, float f2, float f3, float f4) {
        this.padTop = f;
        this.padLeft = f2;
        this.padBottom = f3;
        this.padRight = f4;
        return this;
    }

    public VerticalGroup padBottom(float f) {
        this.padBottom = f;
        return this;
    }

    public VerticalGroup padLeft(float f) {
        this.padLeft = f;
        return this;
    }

    public VerticalGroup padRight(float f) {
        this.padRight = f;
        return this;
    }

    public VerticalGroup padTop(float f) {
        this.padTop = f;
        return this;
    }

    public VerticalGroup reverse() {
        this.reverse = true;
        return this;
    }

    public VerticalGroup reverse(boolean bl) {
        this.reverse = bl;
        return this;
    }

    public VerticalGroup right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return this;
    }

    public void setRound(boolean bl) {
        this.round = bl;
    }

    public VerticalGroup space(float f) {
        this.space = f;
        return this;
    }

    public VerticalGroup top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return this;
    }

    public VerticalGroup wrap() {
        this.wrap = true;
        return this;
    }

    public VerticalGroup wrap(boolean bl) {
        this.wrap = bl;
        return this;
    }

    public VerticalGroup wrapSpace(float f) {
        this.wrapSpace = f;
        return this;
    }
}

