/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class TextTooltip
extends Tooltip<Label> {
    public TextTooltip(String string2, Skin skin) {
        this(string2, TooltipManager.getInstance(), skin.get(TextTooltipStyle.class));
    }

    public TextTooltip(String string2, Skin skin, String string3) {
        this(string2, TooltipManager.getInstance(), skin.get(string3, TextTooltipStyle.class));
    }

    public TextTooltip(String string2, TextTooltipStyle textTooltipStyle) {
        this(string2, TooltipManager.getInstance(), textTooltipStyle);
    }

    public TextTooltip(String string2, TooltipManager tooltipManager, Skin skin) {
        this(string2, tooltipManager, skin.get(TextTooltipStyle.class));
    }

    public TextTooltip(String string2, TooltipManager tooltipManager, Skin skin, String string3) {
        this(string2, tooltipManager, skin.get(string3, TextTooltipStyle.class));
    }

    public TextTooltip(String object, final TooltipManager tooltipManager, TextTooltipStyle textTooltipStyle) {
        super(null, tooltipManager);
        object = new Label((CharSequence)object, textTooltipStyle.label);
        ((Label)object).setWrap(true);
        this.container.setActor(object);
        this.container.width(new Value(){

            @Override
            public float get(Actor actor) {
                return Math.min(tooltipManager.maxWidth, ((Label)TextTooltip.this.container.getActor()).getGlyphLayout().width);
            }
        });
        this.setStyle(textTooltipStyle);
    }

    public void setStyle(TextTooltipStyle textTooltipStyle) {
        if (textTooltipStyle != null) {
            if (textTooltipStyle instanceof TextTooltipStyle) {
                ((Label)this.container.getActor()).setStyle(textTooltipStyle.label);
                this.container.setBackground(textTooltipStyle.background);
                this.container.maxWidth(textTooltipStyle.wrapWidth);
                return;
            }
            throw new IllegalArgumentException("style must be a TextTooltipStyle.");
        }
        throw new NullPointerException("style cannot be null");
    }

    public static class TextTooltipStyle {
        public Drawable background;
        public Label.LabelStyle label;
        public float wrapWidth;

        public TextTooltipStyle() {
        }

        public TextTooltipStyle(Label.LabelStyle labelStyle, Drawable drawable2) {
            this.label = labelStyle;
            this.background = drawable2;
        }

        public TextTooltipStyle(TextTooltipStyle textTooltipStyle) {
            this.label = new Label.LabelStyle(textTooltipStyle.label);
            this.background = textTooltipStyle.background;
        }
    }
}

