/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class TextArea
extends TextField {
    int cursorLine;
    int firstLineShowing;
    private String lastText;
    IntArray linesBreak;
    private int linesShowing;
    float moveOffset;
    private float prefRows;

    public TextArea(String string2, Skin skin) {
        super(string2, skin);
    }

    public TextArea(String string2, Skin skin, String string3) {
        super(string2, skin, string3);
    }

    public TextArea(String string2, TextField.TextFieldStyle textFieldStyle) {
        super(string2, textFieldStyle);
    }

    private int calculateCurrentLineIndex(int n) {
        int n2;
        for (n2 = 0; n2 < this.linesBreak.size && n > this.linesBreak.items[n2]; ++n2) {
        }
        return n2;
    }

    @Override
    protected void calculateOffsets() {
        super.calculateOffsets();
        if (!this.text.equals(this.lastText)) {
            this.lastText = this.text;
            BitmapFont bitmapFont = this.style.font;
            float f = this.getWidth();
            float f2 = this.style.background != null ? this.style.background.getLeftWidth() + this.style.background.getRightWidth() : 0.0f;
            this.linesBreak.clear();
            Pool<GlyphLayout> pool = Pools.get(GlyphLayout.class);
            GlyphLayout glyphLayout = pool.obtain();
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.text.length(); ++i) {
                int n3;
                int n4 = this.text.charAt(i);
                if (n4 != 13 && n4 != 10) {
                    if (!this.continueCursor(i, 0)) {
                        n2 = i;
                    }
                    glyphLayout.setText(bitmapFont, this.text.subSequence(n, i + 1));
                    n3 = n;
                    n4 = n2;
                    if (glyphLayout.width > f - f2) {
                        n4 = n2;
                        if (n >= n2) {
                            n4 = i - 1;
                        }
                        this.linesBreak.add(n);
                        IntArray intArray = this.linesBreak;
                        intArray.add(++n4);
                        n3 = n4;
                    }
                } else {
                    this.linesBreak.add(n);
                    this.linesBreak.add(i);
                    n3 = i + 1;
                    n4 = n2;
                }
                n = n3;
                n2 = n4;
            }
            pool.free(glyphLayout);
            if (n < this.text.length()) {
                this.linesBreak.add(n);
                this.linesBreak.add(this.text.length());
            }
            this.showCursor();
        }
    }

    @Override
    protected boolean continueCursor(int n, int n2) {
        int[] nArray;
        int n3 = this.calculateCurrentLineIndex(n + n2);
        boolean bl = super.continueCursor(n, n2) && (n3 < 0 || n3 >= this.linesBreak.size - 2 || (nArray = this.linesBreak.items)[n2 = n3 + 1] != n || this.linesBreak.items[n2] == this.linesBreak.items[n3 + 2]);
        return bl;
    }

    @Override
    protected InputListener createInputListener() {
        return new TextAreaListener();
    }

    @Override
    protected void drawCursor(Drawable drawable2, Batch batch, BitmapFont bitmapFont, float f, float f2) {
        float f3 = this.cursor < this.glyphPositions.size && this.cursorLine * 2 < this.linesBreak.size ? this.glyphPositions.get(this.cursor) - this.glyphPositions.get(this.linesBreak.items[this.cursorLine * 2]) : 0.0f;
        drawable2.draw(batch, f + f3 + this.fontOffset + bitmapFont.getData().cursorX, f2 - bitmapFont.getDescent() / 2.0f - (float)(this.cursorLine - this.firstLineShowing + 1) * bitmapFont.getLineHeight(), drawable2.getMinWidth(), bitmapFont.getLineHeight());
    }

    @Override
    protected void drawSelection(Drawable drawable2, Batch batch, BitmapFont bitmapFont, float f, float f2) {
        int n;
        int n2 = Math.min(this.cursor, this.selectionStart);
        int n3 = Math.max(this.cursor, this.selectionStart);
        float f3 = 0.0f;
        for (int i = this.firstLineShowing * 2; (n = i + 1) < this.linesBreak.size && i < (this.firstLineShowing + this.linesShowing) * 2; i += 2) {
            int n4 = this.linesBreak.get(i);
            int n5 = this.linesBreak.get(n);
            if (!(n2 < n4 && n2 < n5 && n3 < n4 && n3 < n5 || n2 > n4 && n2 > n5 && n3 > n4 && n3 > n5)) {
                n4 = Math.max(this.linesBreak.get(i), n2);
                n = Math.min(this.linesBreak.get(n), n3);
                float f4 = this.glyphPositions.get(n4);
                float f5 = this.glyphPositions.get(this.linesBreak.get(i));
                float f6 = this.glyphPositions.get(n);
                float f7 = this.glyphPositions.get(n4);
                drawable2.draw(batch, f + (f4 - f5) + this.fontOffset, f2 - this.textHeight - bitmapFont.getDescent() - f3, f6 - f7, bitmapFont.getLineHeight());
            }
            f3 += bitmapFont.getLineHeight();
        }
    }

    @Override
    protected void drawText(Batch batch, BitmapFont bitmapFont, float f, float f2) {
        float f3 = 0.0f;
        for (int i = this.firstLineShowing * 2; i < (this.firstLineShowing + this.linesShowing) * 2 && i < this.linesBreak.size; i += 2) {
            bitmapFont.draw(batch, this.displayText, f, f2 + f3, this.linesBreak.items[i], this.linesBreak.items[i + 1], 0.0f, 8, false);
            f3 -= bitmapFont.getLineHeight();
        }
    }

    public int getCursorLine() {
        return this.cursorLine;
    }

    public float getCursorX() {
        return this.textOffset + this.fontOffset + this.style.font.getData().cursorX;
    }

    public float getCursorY() {
        BitmapFont bitmapFont = this.style.font;
        return -(-bitmapFont.getDescent() / 2.0f - (float)(this.cursorLine - this.firstLineShowing + 1) * bitmapFont.getLineHeight());
    }

    public int getFirstLineShowing() {
        return this.firstLineShowing;
    }

    public int getLines() {
        return this.linesBreak.size / 2 + this.newLineAtEnd();
    }

    public int getLinesShowing() {
        return this.linesShowing;
    }

    @Override
    public float getPrefHeight() {
        float f;
        if (this.prefRows <= 0.0f) {
            return super.getPrefHeight();
        }
        float f2 = f = this.textHeight * this.prefRows;
        if (this.style.background != null) {
            f2 = Math.max(f + this.style.background.getBottomHeight() + this.style.background.getTopHeight(), this.style.background.getMinHeight());
        }
        return f2;
    }

    @Override
    protected float getTextY(BitmapFont bitmapFont, Drawable drawable2) {
        float f;
        float f2 = f = this.getHeight();
        if (drawable2 != null) {
            f2 = (int)(f - drawable2.getTopHeight());
        }
        return f2;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.writeEnters = true;
        this.linesBreak = new IntArray();
        this.cursorLine = 0;
        this.firstLineShowing = 0;
        this.moveOffset = -1.0f;
        this.linesShowing = 0;
    }

    @Override
    protected int letterUnderCursor(float f) {
        if (this.linesBreak.size > 0) {
            int n;
            if (this.cursorLine * 2 >= this.linesBreak.size) {
                return this.text.length();
            }
            float[] fArray = this.glyphPositions.items;
            f += fArray[n];
            int n2 = this.linesBreak.items[this.cursorLine * 2 + 1];
            for (n = this.linesBreak.items[this.cursorLine * 2]; n < n2 && !(fArray[n] > f); ++n) {
            }
            if (n > 0 && fArray[n] - f <= f - fArray[n - 1]) {
                return n;
            }
            return Math.max(0, n - 1);
        }
        return 0;
    }

    @Override
    protected void moveCursor(boolean bl, boolean bl2) {
        int n;
        int n2 = bl ? 1 : -1;
        int n3 = this.cursorLine * 2 + n2;
        if (n3 >= 0 && (n = n3 + 1) < this.linesBreak.size && this.linesBreak.items[n3] == this.cursor && this.linesBreak.items[n] == this.cursor) {
            this.cursorLine += n2;
            if (bl2) {
                super.moveCursor(bl, bl2);
            }
            this.showCursor();
        } else {
            super.moveCursor(bl, bl2);
        }
        this.updateCurrentLine();
    }

    public void moveCursorLine(int n) {
        if (n < 0) {
            this.cursorLine = 0;
            this.cursor = 0;
            this.moveOffset = -1.0f;
        } else if (n >= this.getLines()) {
            int n2 = this.getLines() - 1;
            this.cursor = this.text.length();
            if (n > this.getLines() || n2 == this.cursorLine) {
                this.moveOffset = -1.0f;
            }
            this.cursorLine = n2;
        } else if (n != this.cursorLine) {
            float f = this.moveOffset;
            float f2 = 0.0f;
            if (f < 0.0f) {
                if (this.linesBreak.size > this.cursorLine * 2) {
                    f2 = this.glyphPositions.get(this.cursor) - this.glyphPositions.get(this.linesBreak.get(this.cursorLine * 2));
                }
                this.moveOffset = f2;
            }
            this.cursorLine = n;
            n = this.cursorLine * 2 >= this.linesBreak.size ? this.text.length() : this.linesBreak.get(this.cursorLine * 2);
            this.cursor = n;
            while (this.cursor < this.text.length() && this.cursor <= this.linesBreak.get(this.cursorLine * 2 + 1) - 1 && this.glyphPositions.get(this.cursor) - this.glyphPositions.get(this.linesBreak.get(this.cursorLine * 2)) < this.moveOffset) {
                ++this.cursor;
            }
            this.showCursor();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean newLineAtEnd() {
        int n = this.text.length();
        boolean bl = true;
        if (n == 0) return false;
        boolean bl2 = bl;
        if (this.text.charAt(this.text.length() - 1) == '\n') return bl2;
        if (this.text.charAt(this.text.length() - 1) != '\r') return false;
        return bl;
    }

    public void setPrefRows(float f) {
        this.prefRows = f;
    }

    @Override
    public void setSelection(int n, int n2) {
        super.setSelection(n, n2);
        this.updateCurrentLine();
    }

    void showCursor() {
        this.updateCurrentLine();
        this.updateFirstLineShowing();
    }

    @Override
    protected void sizeChanged() {
        float f;
        this.lastText = null;
        BitmapFont bitmapFont = this.style.font;
        Drawable drawable2 = this.style.background;
        float f2 = this.getHeight();
        if (drawable2 == null) {
            f = 0.0f;
        } else {
            f = drawable2.getBottomHeight();
            f = drawable2.getTopHeight() + f;
        }
        this.linesShowing = (int)Math.floor((f2 - f) / bitmapFont.getLineHeight());
    }

    void updateCurrentLine() {
        int n;
        int n2 = this.calculateCurrentLineIndex(this.cursor);
        int n3 = n2 / 2;
        if (!(n2 % 2 != 0 && (n = n2 + 1) < this.linesBreak.size && this.cursor == this.linesBreak.items[n2] && this.linesBreak.items[n] == this.linesBreak.items[n2] || n3 >= this.linesBreak.size / 2 && this.text.length() != 0 && this.text.charAt(this.text.length() - 1) != '\n' && this.text.charAt(this.text.length() - 1) != '\r')) {
            this.cursorLine = n3;
        }
        this.updateFirstLineShowing();
    }

    void updateFirstLineShowing() {
        int n = this.cursorLine;
        int n2 = this.firstLineShowing;
        if (n != n2) {
            int n3;
            n = n >= n2 ? 1 : -1;
            while ((n3 = this.firstLineShowing) > (n2 = this.cursorLine) || n3 + this.linesShowing - 1 < n2) {
                this.firstLineShowing += n;
            }
        }
    }

    public class TextAreaListener
    extends TextField.TextFieldClickListener {
        public TextAreaListener() {
            super(TextArea.this);
        }

        @Override
        protected void goEnd(boolean bl) {
            if (!bl && TextArea.this.cursorLine < TextArea.this.getLines()) {
                if (TextArea.this.cursorLine * 2 + 1 < TextArea.this.linesBreak.size) {
                    TextArea textArea = TextArea.this;
                    textArea.cursor = textArea.linesBreak.get(TextArea.this.cursorLine * 2 + 1);
                }
            } else {
                TextArea textArea = TextArea.this;
                textArea.cursor = textArea.text.length();
            }
        }

        @Override
        protected void goHome(boolean bl) {
            if (bl) {
                TextArea.this.cursor = 0;
            } else if (TextArea.this.cursorLine * 2 < TextArea.this.linesBreak.size) {
                TextArea textArea = TextArea.this;
                textArea.cursor = textArea.linesBreak.get(TextArea.this.cursorLine * 2);
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean keyDown(InputEvent var1_1, int var2_2) {
            var3_3 = super.keyDown((InputEvent)var1_1, var2_2);
            if (TextArea.this.hasKeyboardFocus()) {
                var3_3 = Gdx.input.isKeyPressed(59);
                var4_4 = false;
                var5_5 = var3_3 || Gdx.input.isKeyPressed(60);
                if (var2_2 == 20) {
                    if (var5_5) {
                        if (!TextArea.this.hasSelection) {
                            var1_1 = TextArea.this;
                            var1_1.selectionStart = var1_1.cursor;
                            TextArea.this.hasSelection = true;
                        }
                    } else {
                        TextArea.this.clearSelection();
                    }
                    var1_1 = TextArea.this;
                    var1_1.moveCursorLine(var1_1.cursorLine + 1);
lbl16:
                    // 2 sources

                    while (true) {
                        var5_5 = true;
                        break;
                    }
                } else {
                    if (var2_2 == 19) {
                        if (var5_5) {
                            if (!TextArea.this.hasSelection) {
                                var1_1 = TextArea.this;
                                var1_1.selectionStart = var1_1.cursor;
                                TextArea.this.hasSelection = true;
                            }
                        } else {
                            TextArea.this.clearSelection();
                        }
                        var1_1 = TextArea.this;
                        var1_1.moveCursorLine(var1_1.cursorLine - 1);
                        ** continue;
                    }
                    TextArea.this.moveOffset = -1.0f;
                    var5_5 = var4_4;
                }
                if (var5_5) {
                    this.scheduleKeyRepeatTask(var2_2);
                }
                TextArea.this.showCursor();
                return true;
            }
            return var3_3;
        }

        @Override
        public boolean keyTyped(InputEvent inputEvent, char c) {
            boolean bl = super.keyTyped(inputEvent, c);
            TextArea.this.showCursor();
            return bl;
        }

        @Override
        protected void setCursorPosition(float f, float f2) {
            float f3;
            Object object = TextArea.this;
            ((TextArea)object).moveOffset = -1.0f;
            object = ((TextArea)object).style.background;
            BitmapFont bitmapFont = TextArea.this.style.font;
            float f4 = f3 = TextArea.this.getHeight();
            float f5 = f;
            if (object != null) {
                f4 = f3 - object.getTopHeight();
                f5 = f - object.getLeftWidth();
            }
            f5 = Math.max(0.0f, f5);
            f = f2;
            if (object != null) {
                f = f2 - object.getTopHeight();
            }
            TextArea.this.cursorLine = (int)Math.floor((f4 - f) / bitmapFont.getLineHeight()) + TextArea.this.firstLineShowing;
            object = TextArea.this;
            ((TextArea)object).cursorLine = Math.max(0, Math.min(((TextArea)object).cursorLine, TextArea.this.getLines() - 1));
            super.setCursorPosition(f5, f);
            TextArea.this.updateCurrentLine();
        }
    }
}

