/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class SplitPane
extends WidgetGroup {
    boolean cursorOverHandle;
    private Actor firstWidget;
    private Rectangle firstWidgetBounds;
    Rectangle handleBounds;
    Vector2 handlePosition;
    Vector2 lastPoint;
    float maxAmount;
    float minAmount;
    private Actor secondWidget;
    private Rectangle secondWidgetBounds;
    float splitAmount;
    SplitPaneStyle style;
    private Rectangle tempScissors;
    boolean vertical;

    public SplitPane(Actor actor, Actor actor2, boolean bl, Skin skin) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("default-");
        String string2 = bl ? "vertical" : "horizontal";
        stringBuilder.append(string2);
        this(actor, actor2, bl, skin, stringBuilder.toString());
    }

    public SplitPane(Actor actor, Actor actor2, boolean bl, Skin skin, String string2) {
        this(actor, actor2, bl, skin.get(string2, SplitPaneStyle.class));
    }

    public SplitPane(Actor actor, Actor actor2, boolean bl, SplitPaneStyle splitPaneStyle) {
        this.splitAmount = 0.5f;
        this.maxAmount = 1.0f;
        this.firstWidgetBounds = new Rectangle();
        this.secondWidgetBounds = new Rectangle();
        this.handleBounds = new Rectangle();
        this.tempScissors = new Rectangle();
        this.lastPoint = new Vector2();
        this.handlePosition = new Vector2();
        this.vertical = bl;
        this.setStyle(splitPaneStyle);
        this.setFirstWidget(actor);
        this.setSecondWidget(actor2);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.initialize();
    }

    private void calculateHorizBoundsAndPositions() {
        Drawable drawable2 = this.style.handle;
        float f = this.getHeight();
        float f2 = this.getWidth() - drawable2.getMinWidth();
        float f3 = (int)(this.splitAmount * f2);
        float f4 = drawable2.getMinWidth();
        this.firstWidgetBounds.set(0.0f, 0.0f, f3, f);
        this.secondWidgetBounds.set(f3 + f4, 0.0f, f2 - f3, f);
        this.handleBounds.set(f3, 0.0f, f4, f);
    }

    private void calculateVertBoundsAndPositions() {
        Drawable drawable2 = this.style.handle;
        float f = this.getWidth();
        float f2 = this.getHeight();
        float f3 = f2 - drawable2.getMinHeight();
        float f4 = (int)(this.splitAmount * f3);
        float f5 = drawable2.getMinHeight();
        this.firstWidgetBounds.set(0.0f, f2 - f4, f, f4);
        this.secondWidgetBounds.set(0.0f, 0.0f, f, f3 -= f4);
        this.handleBounds.set(0.0f, f3, f, f5);
    }

    private void initialize() {
        this.addListener(new InputListener(){
            int draggingPointer = -1;

            @Override
            public boolean mouseMoved(InputEvent object, float f, float f2) {
                object = SplitPane.this;
                ((SplitPane)object).cursorOverHandle = ((SplitPane)object).handleBounds.contains(f, f2);
                return false;
            }

            @Override
            public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
                if (this.draggingPointer != -1) {
                    return false;
                }
                if (n == 0 && n2 != 0) {
                    return false;
                }
                if (SplitPane.this.handleBounds.contains(f, f2)) {
                    this.draggingPointer = n;
                    SplitPane.this.lastPoint.set(f, f2);
                    SplitPane.this.handlePosition.set(SplitPane.this.handleBounds.x, SplitPane.this.handleBounds.y);
                    return true;
                }
                return false;
            }

            @Override
            public void touchDragged(InputEvent object, float f, float f2, int n) {
                if (n != this.draggingPointer) {
                    return;
                }
                object = SplitPane.this.style.handle;
                if (!SplitPane.this.vertical) {
                    float f3 = SplitPane.this.lastPoint.x;
                    float f4 = SplitPane.this.getWidth() - object.getMinWidth();
                    SplitPane.this.handlePosition.x = f3 = SplitPane.this.handlePosition.x + (f - f3);
                    f3 = Math.min(f4, Math.max(0.0f, f3));
                    object = SplitPane.this;
                    ((SplitPane)object).splitAmount = f3 / f4;
                    ((SplitPane)object).lastPoint.set(f, f2);
                } else {
                    float f5 = SplitPane.this.lastPoint.y;
                    float f6 = SplitPane.this.getHeight() - object.getMinHeight();
                    SplitPane.this.handlePosition.y = f5 = SplitPane.this.handlePosition.y + (f2 - f5);
                    f5 = Math.min(f6, Math.max(0.0f, f5));
                    object = SplitPane.this;
                    ((SplitPane)object).splitAmount = 1.0f - f5 / f6;
                    ((SplitPane)object).lastPoint.set(f, f2);
                }
                SplitPane.this.invalidate();
            }

            @Override
            public void touchUp(InputEvent inputEvent, float f, float f2, int n, int n2) {
                if (n == this.draggingPointer) {
                    this.draggingPointer = -1;
                }
            }
        });
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use SplitPane#setWidget.");
    }

    @Override
    public void addActorAt(int n, Actor actor) {
        throw new UnsupportedOperationException("Use SplitPane#setWidget.");
    }

    @Override
    public void addActorBefore(Actor actor, Actor actor2) {
        throw new UnsupportedOperationException("Use SplitPane#setWidget.");
    }

    protected void clampSplitAmount() {
        float f;
        float f2 = this.minAmount;
        float f3 = this.maxAmount;
        if (this.vertical) {
            float f4 = this.getHeight() - this.style.handle.getMinHeight();
            Actor actor = this.firstWidget;
            float f5 = f2;
            if (actor instanceof Layout) {
                f5 = Math.max(f2, Math.min(((Layout)((Object)actor)).getMinHeight() / f4, 1.0f));
            }
            actor = this.secondWidget;
            f = f5;
            f2 = f3;
            if (actor instanceof Layout) {
                f2 = Math.min(f3, 1.0f - Math.min(((Layout)((Object)actor)).getMinHeight() / f4, 1.0f));
                f = f5;
            }
        } else {
            float f6 = this.getWidth() - this.style.handle.getMinWidth();
            Actor actor = this.firstWidget;
            float f7 = f2;
            if (actor instanceof Layout) {
                f7 = Math.max(f2, Math.min(((Layout)((Object)actor)).getMinWidth() / f6, 1.0f));
            }
            actor = this.secondWidget;
            f = f7;
            f2 = f3;
            if (actor instanceof Layout) {
                f2 = Math.min(f3, 1.0f - Math.min(((Layout)((Object)actor)).getMinWidth() / f6, 1.0f));
                f = f7;
            }
        }
        this.splitAmount = f > f2 ? (f + f2) * 0.5f : Math.max(Math.min(this.splitAmount, f2), f);
    }

    @Override
    public void draw(Batch batch, float f) {
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        this.validate();
        Color color2 = this.getColor();
        f = color2.a * f;
        this.applyTransform(batch, this.computeTransform());
        Actor actor = this.firstWidget;
        if (actor != null && actor.isVisible()) {
            batch.flush();
            stage.calculateScissors(this.firstWidgetBounds, this.tempScissors);
            if (ScissorStack.pushScissors(this.tempScissors)) {
                this.firstWidget.draw(batch, f);
                batch.flush();
                ScissorStack.popScissors();
            }
        }
        if ((actor = this.secondWidget) != null && actor.isVisible()) {
            batch.flush();
            stage.calculateScissors(this.secondWidgetBounds, this.tempScissors);
            if (ScissorStack.pushScissors(this.tempScissors)) {
                this.secondWidget.draw(batch, f);
                batch.flush();
                ScissorStack.popScissors();
            }
        }
        batch.setColor(color2.r, color2.g, color2.b, f);
        this.style.handle.draw(batch, this.handleBounds.x, this.handleBounds.y, this.handleBounds.width, this.handleBounds.height);
        this.resetTransform(batch);
    }

    public float getMaxSplitAmount() {
        return this.maxAmount;
    }

    @Override
    public float getMinHeight() {
        Actor actor = this.firstWidget;
        boolean bl = actor instanceof Layout;
        float f = 0.0f;
        float f2 = bl ? ((Layout)((Object)actor)).getMinHeight() : 0.0f;
        actor = this.secondWidget;
        if (actor instanceof Layout) {
            f = ((Layout)((Object)actor)).getMinHeight();
        }
        if (!this.vertical) {
            return Math.max(f2, f);
        }
        return f2 + this.style.handle.getMinHeight() + f;
    }

    public float getMinSplitAmount() {
        return this.minAmount;
    }

    @Override
    public float getMinWidth() {
        Actor actor = this.firstWidget;
        boolean bl = actor instanceof Layout;
        float f = 0.0f;
        float f2 = bl ? ((Layout)((Object)actor)).getMinWidth() : 0.0f;
        actor = this.secondWidget;
        if (actor instanceof Layout) {
            f = ((Layout)((Object)actor)).getMinWidth();
        }
        if (this.vertical) {
            return Math.max(f2, f);
        }
        return f2 + this.style.handle.getMinWidth() + f;
    }

    @Override
    public float getPrefHeight() {
        Actor actor = this.firstWidget;
        float f = 0.0f;
        float f2 = actor == null ? 0.0f : (actor instanceof Layout ? ((Layout)((Object)actor)).getPrefHeight() : actor.getHeight());
        actor = this.secondWidget;
        if (actor != null) {
            f = actor instanceof Layout ? ((Layout)((Object)actor)).getPrefHeight() : actor.getHeight();
        }
        if (!this.vertical) {
            return Math.max(f2, f);
        }
        return f2 + this.style.handle.getMinHeight() + f;
    }

    @Override
    public float getPrefWidth() {
        Actor actor = this.firstWidget;
        float f = 0.0f;
        float f2 = actor == null ? 0.0f : (actor instanceof Layout ? ((Layout)((Object)actor)).getPrefWidth() : actor.getWidth());
        actor = this.secondWidget;
        if (actor != null) {
            f = actor instanceof Layout ? ((Layout)((Object)actor)).getPrefWidth() : actor.getWidth();
        }
        if (this.vertical) {
            return Math.max(f2, f);
        }
        return f2 + this.style.handle.getMinWidth() + f;
    }

    public float getSplitAmount() {
        return this.splitAmount;
    }

    public SplitPaneStyle getStyle() {
        return this.style;
    }

    public boolean isCursorOverHandle() {
        return this.cursorOverHandle;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    @Override
    public void layout() {
        Rectangle rectangle;
        this.clampSplitAmount();
        if (!this.vertical) {
            this.calculateHorizBoundsAndPositions();
        } else {
            this.calculateVertBoundsAndPositions();
        }
        Actor actor = this.firstWidget;
        if (actor != null) {
            rectangle = this.firstWidgetBounds;
            actor.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (actor instanceof Layout) {
                ((Layout)((Object)actor)).validate();
            }
        }
        if ((actor = this.secondWidget) != null) {
            rectangle = this.secondWidgetBounds;
            actor.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (actor instanceof Layout) {
                ((Layout)((Object)actor)).validate();
            }
        }
    }

    @Override
    public boolean removeActor(Actor actor) {
        if (actor != null) {
            if (actor == this.firstWidget) {
                this.setFirstWidget(null);
                return true;
            }
            if (actor == this.secondWidget) {
                this.setSecondWidget(null);
            }
            return true;
        }
        throw new IllegalArgumentException("actor cannot be null.");
    }

    @Override
    public boolean removeActor(Actor actor, boolean bl) {
        if (actor != null) {
            if (actor == this.firstWidget) {
                super.removeActor(actor, bl);
                this.firstWidget = null;
                this.invalidate();
                return true;
            }
            if (actor == this.secondWidget) {
                super.removeActor(actor, bl);
                this.secondWidget = null;
                this.invalidate();
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("actor cannot be null.");
    }

    public void setFirstWidget(Actor actor) {
        Actor actor2 = this.firstWidget;
        if (actor2 != null) {
            super.removeActor(actor2);
        }
        this.firstWidget = actor;
        if (actor != null) {
            super.addActor(actor);
        }
        this.invalidate();
    }

    public void setMaxSplitAmount(float f) {
        if (!(f < 0.0f) && !(f > 1.0f)) {
            this.maxAmount = f;
            return;
        }
        throw new GdxRuntimeException("maxAmount has to be >= 0 and <= 1");
    }

    public void setMinSplitAmount(float f) {
        if (!(f < 0.0f) && !(f > 1.0f)) {
            this.minAmount = f;
            return;
        }
        throw new GdxRuntimeException("minAmount has to be >= 0 and <= 1");
    }

    public void setSecondWidget(Actor actor) {
        Actor actor2 = this.secondWidget;
        if (actor2 != null) {
            super.removeActor(actor2);
        }
        this.secondWidget = actor;
        if (actor != null) {
            super.addActor(actor);
        }
        this.invalidate();
    }

    public void setSplitAmount(float f) {
        this.splitAmount = f;
        this.invalidate();
    }

    public void setStyle(SplitPaneStyle splitPaneStyle) {
        this.style = splitPaneStyle;
        this.invalidateHierarchy();
    }

    public void setVertical(boolean bl) {
        if (this.vertical == bl) {
            return;
        }
        this.vertical = bl;
        this.invalidateHierarchy();
    }

    public static class SplitPaneStyle {
        public Drawable handle;

        public SplitPaneStyle() {
        }

        public SplitPaneStyle(SplitPaneStyle splitPaneStyle) {
            this.handle = splitPaneStyle.handle;
        }

        public SplitPaneStyle(Drawable drawable2) {
            this.handle = drawable2;
        }
    }
}

