/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ArraySelection;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.OrderedSet;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class SelectBox<T>
extends Widget
implements Disableable {
    static final Vector2 temp = new Vector2();
    private int alignment = 8;
    private ClickListener clickListener;
    boolean disabled;
    final Array<T> items = new Array();
    private float prefHeight;
    private float prefWidth;
    SelectBoxList<T> selectBoxList;
    final ArraySelection<T> selection = new ArraySelection<T>(this.items);
    SelectBoxStyle style;

    public SelectBox(SelectBoxStyle object) {
        this.setStyle((SelectBoxStyle)object);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.selection.setActor(this);
        this.selection.setRequired(true);
        this.selectBoxList = new SelectBoxList(this);
        this.clickListener = object = new ClickListener(){

            @Override
            public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
                if (n == 0 && n2 != 0) {
                    return false;
                }
                if (SelectBox.this.disabled) {
                    return false;
                }
                if (SelectBox.this.selectBoxList.hasParent()) {
                    SelectBox.this.hideList();
                } else {
                    SelectBox.this.showList();
                }
                return true;
            }
        };
        this.addListener((EventListener)object);
    }

    public SelectBox(Skin skin) {
        this(skin.get(SelectBoxStyle.class));
    }

    public SelectBox(Skin skin, String string2) {
        this(skin.get(string2, SelectBoxStyle.class));
    }

    public void clearItems() {
        if (this.items.size == 0) {
            return;
        }
        this.items.clear();
        this.selection.clear();
        this.invalidateHierarchy();
    }

    @Override
    public void draw(Batch batch, float f) {
        this.validate();
        Drawable drawable2 = this.disabled && this.style.backgroundDisabled != null ? this.style.backgroundDisabled : (this.selectBoxList.hasParent() && this.style.backgroundOpen != null ? this.style.backgroundOpen : (this.clickListener.isOver() && this.style.backgroundOver != null ? this.style.backgroundOver : (this.style.background != null ? this.style.background : null)));
        BitmapFont bitmapFont = this.style.font;
        Color color2 = this.disabled && this.style.disabledFontColor != null ? this.style.disabledFontColor : this.style.fontColor;
        Color color3 = this.getColor();
        float f2 = this.getX();
        float f3 = this.getY();
        float f4 = this.getWidth();
        float f5 = this.getHeight();
        batch.setColor(color3.r, color3.g, color3.b, color3.a * f);
        if (drawable2 != null) {
            drawable2.draw(batch, f2, f3, f4, f5);
        }
        if ((color3 = this.selection.first()) != null) {
            float f6;
            if (drawable2 != null) {
                f4 -= drawable2.getLeftWidth() + drawable2.getRightWidth();
                f6 = drawable2.getBottomHeight();
                float f7 = drawable2.getTopHeight();
                f2 += drawable2.getLeftWidth();
                f5 = (f5 - (f6 + f7)) / 2.0f + drawable2.getBottomHeight();
                f6 = bitmapFont.getData().capHeight;
            } else {
                f5 /= 2.0f;
                f6 = bitmapFont.getData().capHeight;
            }
            f5 = (int)(f5 + f6 / 2.0f);
            bitmapFont.setColor(color2.r, color2.g, color2.b, color2.a * f);
            this.drawItem(batch, bitmapFont, color3, f2, f3 + f5, f4);
        }
    }

    protected GlyphLayout drawItem(Batch batch, BitmapFont bitmapFont, T object, float f, float f2, float f3) {
        object = this.toString(object);
        return bitmapFont.draw(batch, (CharSequence)object, f, f2, 0, ((String)object).length(), f3, this.alignment, false, "...");
    }

    public Array<T> getItems() {
        return this.items;
    }

    public List<T> getList() {
        return this.selectBoxList.list;
    }

    public int getMaxListCount() {
        return this.selectBoxList.maxListCount;
    }

    @Override
    public float getPrefHeight() {
        this.validate();
        return this.prefHeight;
    }

    @Override
    public float getPrefWidth() {
        this.validate();
        return this.prefWidth;
    }

    public ScrollPane getScrollPane() {
        return this.selectBoxList;
    }

    public T getSelected() {
        return this.selection.first();
    }

    public int getSelectedIndex() {
        OrderedSet orderedSet = this.selection.items();
        int n = orderedSet.size == 0 ? -1 : this.items.indexOf(orderedSet.first(), false);
        return n;
    }

    public ArraySelection<T> getSelection() {
        return this.selection;
    }

    public SelectBoxStyle getStyle() {
        return this.style;
    }

    public void hideList() {
        this.selectBoxList.hide();
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void layout() {
        float f;
        block8: {
            float f2;
            float f3;
            block7: {
                SelectBoxList<T> selectBoxList = this.style.background;
                BitmapFont bitmapFont = this.style.font;
                this.prefHeight = selectBoxList != null ? Math.max(selectBoxList.getTopHeight() + selectBoxList.getBottomHeight() + bitmapFont.getCapHeight() - bitmapFont.getDescent() * 2.0f, selectBoxList.getMinHeight()) : bitmapFont.getCapHeight() - bitmapFont.getDescent() * 2.0f;
                Pool<GlyphLayout> pool = Pools.get(GlyphLayout.class);
                Object object = pool.obtain();
                f3 = 0.0f;
                f2 = 0.0f;
                for (int i = 0; i < this.items.size; ++i) {
                    ((GlyphLayout)object).setText(bitmapFont, this.toString(this.items.get(i)));
                    f2 = Math.max(((GlyphLayout)object).width, f2);
                }
                pool.free((GlyphLayout)object);
                this.prefWidth = f2;
                if (selectBoxList != null) {
                    this.prefWidth += selectBoxList.getLeftWidth() + selectBoxList.getRightWidth();
                }
                selectBoxList = this.style.listStyle;
                object = this.style.scrollStyle;
                f2 = f = f2 + ((List.ListStyle)((Object)selectBoxList)).selection.getLeftWidth() + ((List.ListStyle)((Object)selectBoxList)).selection.getRightWidth();
                if (((ScrollPane.ScrollPaneStyle)object).background != null) {
                    f2 = f + (((ScrollPane.ScrollPaneStyle)object).background.getLeftWidth() + ((ScrollPane.ScrollPaneStyle)object).background.getRightWidth());
                }
                if ((selectBoxList = this.selectBoxList) == null) break block7;
                f = f2;
                if (selectBoxList.disableY) break block8;
            }
            f = this.style.scrollStyle.vScroll != null ? this.style.scrollStyle.vScroll.getMinWidth() : 0.0f;
            if (this.style.scrollStyle.vScrollKnob != null) {
                f3 = this.style.scrollStyle.vScrollKnob.getMinWidth();
            }
            f = f2 + Math.max(f, f3);
        }
        this.prefWidth = Math.max(this.prefWidth, f);
    }

    protected void onHide(Actor actor) {
        actor.getColor().a = 1.0f;
        actor.addAction(Actions.sequence((Action)Actions.fadeOut(0.15f, Interpolation.fade), (Action)Actions.removeActor()));
    }

    protected void onShow(Actor actor, boolean bl) {
        actor.getColor().a = 0.0f;
        actor.addAction(Actions.fadeIn(0.3f, Interpolation.fade));
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    @Override
    public void setDisabled(boolean bl) {
        if (bl && !this.disabled) {
            this.hideList();
        }
        this.disabled = bl;
    }

    public void setItems(Array<T> array) {
        if (array != null) {
            float f = this.getPrefWidth();
            Array<T> array2 = this.items;
            if (array != array2) {
                array2.clear();
                this.items.addAll(array);
            }
            this.selection.validate();
            this.selectBoxList.list.setItems(this.items);
            this.invalidate();
            if (f != this.getPrefWidth()) {
                this.invalidateHierarchy();
            }
            return;
        }
        throw new IllegalArgumentException("newItems cannot be null.");
    }

    public void setItems(T ... TArray) {
        if (TArray != null) {
            float f = this.getPrefWidth();
            this.items.clear();
            this.items.addAll(TArray);
            this.selection.validate();
            this.selectBoxList.list.setItems(this.items);
            this.invalidate();
            if (f != this.getPrefWidth()) {
                this.invalidateHierarchy();
            }
            return;
        }
        throw new IllegalArgumentException("newItems cannot be null.");
    }

    public void setMaxListCount(int n) {
        this.selectBoxList.maxListCount = n;
    }

    public void setScrollingDisabled(boolean bl) {
        this.selectBoxList.setScrollingDisabled(true, bl);
        this.invalidateHierarchy();
    }

    public void setSelected(T t) {
        if (this.items.contains(t, false)) {
            this.selection.set(t);
        } else if (this.items.size > 0) {
            this.selection.set(this.items.first());
        } else {
            this.selection.clear();
        }
    }

    public void setSelectedIndex(int n) {
        this.selection.set(this.items.get(n));
    }

    @Override
    protected void setStage(Stage stage) {
        if (stage == null) {
            this.selectBoxList.hide();
        }
        super.setStage(stage);
    }

    public void setStyle(SelectBoxStyle selectBoxStyle) {
        if (selectBoxStyle != null) {
            this.style = selectBoxStyle;
            SelectBoxList<T> selectBoxList = this.selectBoxList;
            if (selectBoxList != null) {
                selectBoxList.setStyle(selectBoxStyle.scrollStyle);
                this.selectBoxList.list.setStyle(selectBoxStyle.listStyle);
            }
            this.invalidateHierarchy();
            return;
        }
        throw new IllegalArgumentException("style cannot be null.");
    }

    public void showList() {
        if (this.items.size == 0) {
            return;
        }
        if (this.getStage() != null) {
            this.selectBoxList.show(this.getStage());
        }
    }

    protected String toString(T t) {
        return t.toString();
    }

    static class SelectBoxList<T>
    extends ScrollPane {
        private InputListener hideListener;
        final List<T> list;
        int maxListCount;
        private Actor previousScrollFocus;
        private final Vector2 screenPosition = new Vector2();
        private final SelectBox<T> selectBox;

        public SelectBoxList(final SelectBox<T> selectBox) {
            super(null, selectBox.style.scrollStyle);
            this.selectBox = selectBox;
            this.setOverscroll(false, false);
            this.setFadeScrollBars(false);
            this.setScrollingDisabled(true, false);
            this.list = new List<T>(selectBox.style.listStyle){

                @Override
                public String toString(T t) {
                    return selectBox.toString(t);
                }
            };
            this.list.setTouchable(Touchable.disabled);
            this.list.setTypeToSelect(true);
            this.setActor(this.list);
            this.list.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent inputEvent, float f, float f2) {
                    selectBox.selection.choose(SelectBoxList.this.list.getSelected());
                    SelectBoxList.this.hide();
                }

                @Override
                public boolean mouseMoved(InputEvent inputEvent, float f, float f2) {
                    int n = SelectBoxList.this.list.getItemIndexAt(f2);
                    if (n != -1) {
                        SelectBoxList.this.list.setSelectedIndex(n);
                    }
                    return true;
                }
            });
            this.addListener(new InputListener(){

                @Override
                public void exit(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
                    if (actor == null || !SelectBoxList.this.isAscendantOf(actor)) {
                        SelectBoxList.this.list.selection.set(selectBox.getSelected());
                    }
                }
            });
            this.hideListener = new InputListener(){

                @Override
                public boolean keyDown(InputEvent inputEvent, int n) {
                    if (n != 66) {
                        if (n != 131) {
                            return false;
                        }
                    } else {
                        selectBox.selection.choose(SelectBoxList.this.list.getSelected());
                    }
                    SelectBoxList.this.hide();
                    inputEvent.stop();
                    return true;
                }

                @Override
                public boolean touchDown(InputEvent object, float f, float f2, int n, int n2) {
                    if (SelectBoxList.this.isAscendantOf((Actor)(object = ((Event)object).getTarget()))) {
                        return false;
                    }
                    SelectBoxList.this.list.selection.set(selectBox.getSelected());
                    SelectBoxList.this.hide();
                    return false;
                }
            };
        }

        @Override
        public void act(float f) {
            super.act(f);
            this.toFront();
        }

        @Override
        public void draw(Batch batch, float f) {
            this.selectBox.localToStageCoordinates(temp.set(0.0f, 0.0f));
            if (!temp.equals(this.screenPosition)) {
                this.hide();
            }
            super.draw(batch, f);
        }

        public void hide() {
            if (this.list.isTouchable() && this.hasParent()) {
                this.list.setTouchable(Touchable.disabled);
                Stage stage = this.getStage();
                if (stage != null) {
                    stage.removeCaptureListener(this.hideListener);
                    stage.removeListener(this.list.getKeyListener());
                    Actor actor = this.previousScrollFocus;
                    if (actor != null && actor.getStage() == null) {
                        this.previousScrollFocus = null;
                    }
                    if ((actor = stage.getScrollFocus()) == null || this.isAscendantOf(actor)) {
                        stage.setScrollFocus(this.previousScrollFocus);
                    }
                }
                this.clearActions();
                this.selectBox.onHide(this);
            }
        }

        @Override
        protected void setStage(Stage stage) {
            Stage stage2 = this.getStage();
            if (stage2 != null) {
                stage2.removeCaptureListener(this.hideListener);
                stage2.removeListener(this.list.getKeyListener());
            }
            super.setStage(stage);
        }

        public void show(Stage stage) {
            if (this.list.isTouchable()) {
                return;
            }
            stage.addActor(this);
            stage.addCaptureListener(this.hideListener);
            stage.addListener(this.list.getKeyListener());
            this.selectBox.localToStageCoordinates(this.screenPosition.set(0.0f, 0.0f));
            float f = this.list.getItemHeight();
            int n = this.maxListCount;
            n = n <= 0 ? this.selectBox.items.size : Math.min(n, this.selectBox.items.size);
            float f2 = (float)n * f;
            Object object = this.getStyle().background;
            float f3 = f2;
            if (object != null) {
                f3 = f2 + (object.getTopHeight() + object.getBottomHeight());
            }
            object = this.list.getStyle().background;
            f2 = f3;
            if (object != null) {
                f2 = f3 + (object.getTopHeight() + object.getBottomHeight());
            }
            float f4 = this.screenPosition.y;
            float f5 = stage.getCamera().viewportHeight - this.screenPosition.y - this.selectBox.getHeight();
            boolean bl = true;
            f3 = f2;
            boolean bl2 = bl;
            if (f2 > f4) {
                if (f5 > f4) {
                    bl2 = false;
                    f3 = Math.min(f2, f5);
                } else {
                    f3 = f4;
                    bl2 = bl;
                }
            }
            if (bl2) {
                this.setY(this.screenPosition.y - f3);
            } else {
                this.setY(this.screenPosition.y + this.selectBox.getHeight());
            }
            this.setX(this.screenPosition.x);
            this.setHeight(f3);
            this.validate();
            f2 = f4 = Math.max(this.getPrefWidth(), this.selectBox.getWidth());
            if (this.getPrefHeight() > f3) {
                f2 = f4;
                if (!this.disableY) {
                    f2 = f4 + this.getScrollBarWidth();
                }
            }
            this.setWidth(f2);
            this.validate();
            this.scrollTo(0.0f, this.list.getHeight() - (float)this.selectBox.getSelectedIndex() * f - f / 2.0f, 0.0f, 0.0f, true, true);
            this.updateVisualScroll();
            this.previousScrollFocus = null;
            object = stage.getScrollFocus();
            if (object != null && !((Actor)object).isDescendantOf(this)) {
                this.previousScrollFocus = object;
            }
            stage.setScrollFocus(this);
            this.list.selection.set(this.selectBox.getSelected());
            this.list.setTouchable(Touchable.enabled);
            this.clearActions();
            this.selectBox.onShow(this, bl2);
        }
    }

    public static class SelectBoxStyle {
        public Drawable background;
        public Drawable backgroundDisabled;
        public Drawable backgroundOpen;
        public Drawable backgroundOver;
        public Color disabledFontColor;
        public BitmapFont font;
        public Color fontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public List.ListStyle listStyle;
        public ScrollPane.ScrollPaneStyle scrollStyle;

        public SelectBoxStyle() {
        }

        public SelectBoxStyle(BitmapFont bitmapFont, Color color2, Drawable drawable2, ScrollPane.ScrollPaneStyle scrollPaneStyle, List.ListStyle listStyle) {
            this.font = bitmapFont;
            this.fontColor.set(color2);
            this.background = drawable2;
            this.scrollStyle = scrollPaneStyle;
            this.listStyle = listStyle;
        }

        public SelectBoxStyle(SelectBoxStyle selectBoxStyle) {
            this.font = selectBoxStyle.font;
            this.fontColor.set(selectBoxStyle.fontColor);
            Color color2 = selectBoxStyle.disabledFontColor;
            if (color2 != null) {
                this.disabledFontColor = new Color(color2);
            }
            this.background = selectBoxStyle.background;
            this.backgroundOver = selectBoxStyle.backgroundOver;
            this.backgroundOpen = selectBoxStyle.backgroundOpen;
            this.backgroundDisabled = selectBoxStyle.backgroundDisabled;
            this.scrollStyle = new ScrollPane.ScrollPaneStyle(selectBoxStyle.scrollStyle);
            this.listStyle = new List.ListStyle(selectBoxStyle.listStyle);
        }
    }
}

