/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ActorGestureListener;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;

public class ScrollPane
extends WidgetGroup {
    float amountX;
    float amountY;
    float areaHeight;
    float areaWidth;
    boolean cancelTouchFocus = true;
    private boolean clamp = true;
    boolean disableX;
    boolean disableY;
    int draggingPointer = -1;
    float fadeAlpha;
    float fadeAlphaSeconds = 1.0f;
    float fadeDelay;
    float fadeDelaySeconds = 1.0f;
    boolean fadeScrollBars = true;
    boolean flickScroll = true;
    private ActorGestureListener flickScrollListener;
    float flingTime = 1.0f;
    float flingTimer;
    private boolean forceScrollX;
    private boolean forceScrollY;
    final Rectangle hKnobBounds;
    final Rectangle hScrollBounds = new Rectangle();
    boolean hScrollOnBottom = true;
    final Vector2 lastPoint;
    float maxX;
    float maxY;
    private float overscrollDistance = 50.0f;
    private float overscrollSpeedMax = 200.0f;
    private float overscrollSpeedMin = 30.0f;
    private boolean overscrollX = true;
    private boolean overscrollY = true;
    boolean scrollBarTouch = true;
    boolean scrollX;
    boolean scrollY;
    private boolean scrollbarsOnTop;
    boolean smoothScrolling = true;
    private ScrollPaneStyle style;
    boolean touchScrollH;
    boolean touchScrollV;
    final Rectangle vKnobBounds;
    final Rectangle vScrollBounds = new Rectangle();
    boolean vScrollOnRight = true;
    private boolean variableSizeKnobs = true;
    float velocityX;
    float velocityY;
    float visualAmountX;
    float visualAmountY;
    private Actor widget;
    private final Rectangle widgetAreaBounds;
    private final Rectangle widgetCullingArea;

    public ScrollPane(Actor actor) {
        this(actor, new ScrollPaneStyle());
    }

    public ScrollPane(Actor actor, ScrollPaneStyle scrollPaneStyle) {
        this.hKnobBounds = new Rectangle();
        this.vKnobBounds = new Rectangle();
        this.widgetAreaBounds = new Rectangle();
        this.widgetCullingArea = new Rectangle();
        this.lastPoint = new Vector2();
        if (scrollPaneStyle != null) {
            this.style = scrollPaneStyle;
            this.setActor(actor);
            this.setSize(150.0f, 150.0f);
            this.addCaptureListener(new InputListener(){
                private float handlePosition;

                @Override
                public boolean mouseMoved(InputEvent inputEvent, float f, float f2) {
                    if (!ScrollPane.this.flickScroll) {
                        ScrollPane.this.setScrollbarsVisible(true);
                    }
                    return false;
                }

                @Override
                public boolean touchDown(InputEvent object, float f, float f2, int n, int n2) {
                    int n3 = ScrollPane.this.draggingPointer;
                    int n4 = -1;
                    if (n3 != -1) {
                        return false;
                    }
                    if (n == 0 && n2 != 0) {
                        return false;
                    }
                    if (ScrollPane.this.getStage() != null) {
                        ScrollPane.this.getStage().setScrollFocus(ScrollPane.this);
                    }
                    if (!ScrollPane.this.flickScroll) {
                        ScrollPane.this.setScrollbarsVisible(true);
                    }
                    if (ScrollPane.this.fadeAlpha == 0.0f) {
                        return false;
                    }
                    if (ScrollPane.this.scrollBarTouch && ScrollPane.this.scrollX && ScrollPane.this.hScrollBounds.contains(f, f2)) {
                        ((Event)object).stop();
                        ScrollPane.this.setScrollbarsVisible(true);
                        if (ScrollPane.this.hKnobBounds.contains(f, f2)) {
                            ScrollPane.this.lastPoint.set(f, f2);
                            this.handlePosition = ScrollPane.this.hKnobBounds.x;
                            object = ScrollPane.this;
                            ((ScrollPane)object).touchScrollH = true;
                            ((ScrollPane)object).draggingPointer = n;
                            return true;
                        }
                        object = ScrollPane.this;
                        float f3 = ((ScrollPane)object).amountX;
                        f2 = ScrollPane.this.areaWidth;
                        if (!(f < ScrollPane.this.hKnobBounds.x)) {
                            n4 = 1;
                        }
                        ((ScrollPane)object).setScrollX(f3 + f2 * (float)n4);
                        return true;
                    }
                    if (ScrollPane.this.scrollBarTouch && ScrollPane.this.scrollY && ScrollPane.this.vScrollBounds.contains(f, f2)) {
                        ((Event)object).stop();
                        ScrollPane.this.setScrollbarsVisible(true);
                        if (ScrollPane.this.vKnobBounds.contains(f, f2)) {
                            ScrollPane.this.lastPoint.set(f, f2);
                            this.handlePosition = ScrollPane.this.vKnobBounds.y;
                            object = ScrollPane.this;
                            ((ScrollPane)object).touchScrollV = true;
                            ((ScrollPane)object).draggingPointer = n;
                            return true;
                        }
                        object = ScrollPane.this;
                        float f4 = ((ScrollPane)object).amountY;
                        f = ScrollPane.this.areaHeight;
                        if (f2 < ScrollPane.this.vKnobBounds.y) {
                            n4 = 1;
                        }
                        ((ScrollPane)object).setScrollY(f4 + f * (float)n4);
                        return true;
                    }
                    return false;
                }

                @Override
                public void touchDragged(InputEvent object, float f, float f2, int n) {
                    if (n != ScrollPane.this.draggingPointer) {
                        return;
                    }
                    if (ScrollPane.this.touchScrollH) {
                        float f3 = ScrollPane.this.lastPoint.x;
                        this.handlePosition = f3 = this.handlePosition + (f - f3);
                        f3 = Math.max(ScrollPane.this.hScrollBounds.x, f3);
                        f3 = Math.min(ScrollPane.this.hScrollBounds.x + ScrollPane.this.hScrollBounds.width - ScrollPane.this.hKnobBounds.width, f3);
                        float f4 = ScrollPane.this.hScrollBounds.width - ScrollPane.this.hKnobBounds.width;
                        if (f4 != 0.0f) {
                            object = ScrollPane.this;
                            ((ScrollPane)object).setScrollPercentX((f3 - ((ScrollPane)object).hScrollBounds.x) / f4);
                        }
                        ScrollPane.this.lastPoint.set(f, f2);
                    } else if (ScrollPane.this.touchScrollV) {
                        float f5 = ScrollPane.this.lastPoint.y;
                        this.handlePosition = f5 = this.handlePosition + (f2 - f5);
                        f5 = Math.max(ScrollPane.this.vScrollBounds.y, f5);
                        float f6 = Math.min(ScrollPane.this.vScrollBounds.y + ScrollPane.this.vScrollBounds.height - ScrollPane.this.vKnobBounds.height, f5);
                        f5 = ScrollPane.this.vScrollBounds.height - ScrollPane.this.vKnobBounds.height;
                        if (f5 != 0.0f) {
                            object = ScrollPane.this;
                            ((ScrollPane)object).setScrollPercentY(1.0f - (f6 - ((ScrollPane)object).vScrollBounds.y) / f5);
                        }
                        ScrollPane.this.lastPoint.set(f, f2);
                    }
                }

                @Override
                public void touchUp(InputEvent inputEvent, float f, float f2, int n, int n2) {
                    if (n != ScrollPane.this.draggingPointer) {
                        return;
                    }
                    ScrollPane.this.cancel();
                }
            });
            this.flickScrollListener = new ActorGestureListener(){

                @Override
                public void fling(InputEvent object, float f, float f2, int n) {
                    if (Math.abs(f) > 150.0f && ScrollPane.this.scrollX) {
                        object = ScrollPane.this;
                        ((ScrollPane)object).flingTimer = ((ScrollPane)object).flingTime;
                        object = ScrollPane.this;
                        ((ScrollPane)object).velocityX = f;
                        if (((ScrollPane)object).cancelTouchFocus) {
                            ScrollPane.this.cancelTouchFocus();
                        }
                    }
                    if (Math.abs(f2) > 150.0f && ScrollPane.this.scrollY) {
                        object = ScrollPane.this;
                        ((ScrollPane)object).flingTimer = ((ScrollPane)object).flingTime;
                        object = ScrollPane.this;
                        ((ScrollPane)object).velocityY = -f2;
                        if (((ScrollPane)object).cancelTouchFocus) {
                            ScrollPane.this.cancelTouchFocus();
                        }
                    }
                }

                @Override
                public boolean handle(Event event) {
                    if (super.handle(event)) {
                        if (((InputEvent)event).getType() == InputEvent.Type.touchDown) {
                            ScrollPane.this.flingTimer = 0.0f;
                        }
                        return true;
                    }
                    if (event instanceof InputEvent && ((InputEvent)event).isTouchFocusCancel()) {
                        ScrollPane.this.cancel();
                    }
                    return false;
                }

                @Override
                public void pan(InputEvent object, float f, float f2, float f3, float f4) {
                    ScrollPane.this.setScrollbarsVisible(true);
                    object = ScrollPane.this;
                    ((ScrollPane)object).amountX -= f3;
                    object = ScrollPane.this;
                    ((ScrollPane)object).amountY += f4;
                    ScrollPane.this.clamp();
                    if (ScrollPane.this.cancelTouchFocus && (ScrollPane.this.scrollX && f3 != 0.0f || ScrollPane.this.scrollY && f4 != 0.0f)) {
                        ScrollPane.this.cancelTouchFocus();
                    }
                }
            };
            this.addListener(this.flickScrollListener);
            this.addListener(new InputListener(){

                @Override
                public boolean scrolled(InputEvent object, float f, float f2, int n) {
                    block4: {
                        block3: {
                            block2: {
                                ScrollPane.this.setScrollbarsVisible(true);
                                if (!ScrollPane.this.scrollY) break block2;
                                object = ScrollPane.this;
                                ((ScrollPane)object).setScrollY(((ScrollPane)object).amountY + ScrollPane.this.getMouseWheelY() * (float)n);
                                break block3;
                            }
                            if (!ScrollPane.this.scrollX) break block4;
                            object = ScrollPane.this;
                            ((ScrollPane)object).setScrollX(((ScrollPane)object).amountX + ScrollPane.this.getMouseWheelX() * (float)n);
                        }
                        return true;
                    }
                    return false;
                }
            });
            return;
        }
        throw new IllegalArgumentException("style cannot be null.");
    }

    public ScrollPane(Actor actor, Skin skin) {
        this(actor, skin.get(ScrollPaneStyle.class));
    }

    public ScrollPane(Actor actor, Skin skin, String string2) {
        this(actor, skin.get(string2, ScrollPaneStyle.class));
    }

    private void updateWidgetPosition() {
        float f = this.widgetAreaBounds.y;
        float f2 = !this.scrollY ? this.maxY : this.maxY - this.visualAmountY;
        float f3 = f - (float)((int)f2);
        f2 = f = this.widgetAreaBounds.x;
        if (this.scrollX) {
            f2 = f - (float)((int)this.visualAmountX);
        }
        float f4 = f3;
        float f5 = f2;
        if (!this.fadeScrollBars) {
            f4 = f3;
            f5 = f2;
            if (this.scrollbarsOnTop) {
                boolean bl = this.scrollX;
                float f6 = 0.0f;
                f = f3;
                if (bl) {
                    f = f3;
                    if (this.hScrollOnBottom) {
                        f = this.style.hScrollKnob != null ? this.style.hScrollKnob.getMinHeight() : 0.0f;
                        f4 = f;
                        if (this.style.hScroll != null) {
                            f4 = Math.max(f, this.style.hScroll.getMinHeight());
                        }
                        f = f3 + f4;
                    }
                }
                f4 = f;
                f5 = f2;
                if (this.scrollY) {
                    f4 = f;
                    f5 = f2;
                    if (!this.vScrollOnRight) {
                        f3 = f6;
                        if (this.style.hScrollKnob != null) {
                            f3 = this.style.hScrollKnob.getMinWidth();
                        }
                        f4 = f3;
                        if (this.style.hScroll != null) {
                            f4 = Math.max(f3, this.style.hScroll.getMinWidth());
                        }
                        f5 = f2 + f4;
                        f4 = f;
                    }
                }
            }
        }
        this.widget.setPosition(f5, f4);
        if (this.widget instanceof Cullable) {
            this.widgetCullingArea.x = this.widgetAreaBounds.x - f5;
            this.widgetCullingArea.y = this.widgetAreaBounds.y - f4;
            this.widgetCullingArea.width = this.widgetAreaBounds.width;
            this.widgetCullingArea.height = this.widgetAreaBounds.height;
            ((Cullable)((Object)this.widget)).setCullingArea(this.widgetCullingArea);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void act(float f) {
        Stage stage;
        boolean bl;
        block34: {
            block39: {
                float f2;
                float f3;
                boolean bl2;
                float f4;
                float f5;
                block38: {
                    block35: {
                        block37: {
                            boolean bl3;
                            block36: {
                                super.act(f);
                                boolean bl4 = this.flickScrollListener.getGestureDetector().isPanning();
                                f5 = this.fadeAlpha;
                                if (f5 > 0.0f && this.fadeScrollBars && !bl4 && !this.touchScrollH && !this.touchScrollV) {
                                    this.fadeDelay -= f;
                                    if (this.fadeDelay <= 0.0f) {
                                        this.fadeAlpha = Math.max(0.0f, f5 - f);
                                    }
                                    bl = true;
                                } else {
                                    bl = false;
                                }
                                if (this.flingTimer > 0.0f) {
                                    this.setScrollbarsVisible(true);
                                    f5 = this.flingTimer / this.flingTime;
                                    this.amountX -= this.velocityX * f5 * f;
                                    this.amountY -= this.velocityY * f5 * f;
                                    this.clamp();
                                    if (this.amountX == -this.overscrollDistance) {
                                        this.velocityX = 0.0f;
                                    }
                                    if (this.amountX >= this.maxX + this.overscrollDistance) {
                                        this.velocityX = 0.0f;
                                    }
                                    if (this.amountY == -this.overscrollDistance) {
                                        this.velocityY = 0.0f;
                                    }
                                    if (this.amountY >= this.maxY + this.overscrollDistance) {
                                        this.velocityY = 0.0f;
                                    }
                                    this.flingTimer -= f;
                                    if (this.flingTimer <= 0.0f) {
                                        this.velocityX = 0.0f;
                                        this.velocityY = 0.0f;
                                    }
                                    bl = true;
                                }
                                if (this.smoothScrolling && this.flingTimer <= 0.0f && !bl4 && (!this.touchScrollH || this.scrollX && this.maxX / (this.hScrollBounds.width - this.hKnobBounds.width) > this.areaWidth * 0.1f) && (!this.touchScrollV || this.scrollY && this.maxY / (this.vScrollBounds.height - this.vKnobBounds.height) > this.areaHeight * 0.1f)) {
                                    f5 = this.visualAmountX;
                                    f4 = this.amountX;
                                    bl3 = bl;
                                    if (f5 != f4) {
                                        if (f5 < f4) {
                                            this.visualScrollX(Math.min(f4, f5 + Math.max(f * 200.0f, (f4 - f5) * 7.0f * f)));
                                        } else {
                                            this.visualScrollX(Math.max(f4, f5 - Math.max(f * 200.0f, (f5 - f4) * 7.0f * f)));
                                        }
                                        bl3 = true;
                                    }
                                    if ((f4 = this.visualAmountY) != (f5 = this.amountY)) {
                                        if (f4 < f5) {
                                            this.visualScrollY(Math.min(f5, f4 + Math.max(200.0f * f, (f5 - f4) * 7.0f * f)));
                                        } else {
                                            this.visualScrollY(Math.max(f5, f4 - Math.max(200.0f * f, (f4 - f5) * 7.0f * f)));
                                        }
                                        bl3 = true;
                                    }
                                } else {
                                    f5 = this.visualAmountX;
                                    f4 = this.amountX;
                                    if (f5 != f4) {
                                        this.visualScrollX(f4);
                                    }
                                    f5 = this.visualAmountY;
                                    f4 = this.amountY;
                                    bl3 = bl;
                                    if (f5 != f4) {
                                        this.visualScrollY(f4);
                                        bl3 = bl;
                                    }
                                }
                                bl = bl3;
                                if (bl4) break block34;
                                bl2 = bl3;
                                if (!this.overscrollX) break block35;
                                bl2 = bl3;
                                if (!this.scrollX) break block35;
                                f5 = this.amountX;
                                if (!(f5 < 0.0f)) break block36;
                                this.setScrollbarsVisible(true);
                                f5 = this.amountX;
                                f4 = this.overscrollSpeedMin;
                                this.amountX = f5 + (f4 + (this.overscrollSpeedMax - f4) * -f5 / this.overscrollDistance) * f;
                                if (this.amountX > 0.0f) {
                                    this.scrollX(0.0f);
                                }
                                break block37;
                            }
                            bl2 = bl3;
                            if (!(f5 > this.maxX)) break block35;
                            this.setScrollbarsVisible(true);
                            f3 = this.amountX;
                            f2 = this.overscrollSpeedMin;
                            f4 = this.overscrollSpeedMax;
                            f5 = this.maxX;
                            this.amountX = f3 - (f2 + (f4 - f2) * -(f5 - f3) / this.overscrollDistance) * f;
                            if (this.amountX < f5) {
                                this.scrollX(f5);
                            }
                        }
                        bl2 = true;
                    }
                    bl = bl2;
                    if (!this.overscrollY) break block34;
                    bl = bl2;
                    if (!this.scrollY) break block34;
                    f5 = this.amountY;
                    if (!(f5 < 0.0f)) break block38;
                    this.setScrollbarsVisible(true);
                    f4 = this.amountY;
                    f5 = this.overscrollSpeedMin;
                    this.amountY = f4 + (f5 + (this.overscrollSpeedMax - f5) * -f4 / this.overscrollDistance) * f;
                    if (this.amountY > 0.0f) {
                        this.scrollY(0.0f);
                    }
                    break block39;
                }
                bl = bl2;
                if (!(f5 > this.maxY)) break block34;
                this.setScrollbarsVisible(true);
                f3 = this.amountY;
                f4 = this.overscrollSpeedMin;
                f2 = this.overscrollSpeedMax;
                f5 = this.maxY;
                this.amountY = f3 - (f4 + (f2 - f4) * -(f5 - f3) / this.overscrollDistance) * f;
                if (this.amountY < f5) {
                    this.scrollY(f5);
                }
            }
            bl = true;
        }
        if (bl && (stage = this.getStage()) != null && stage.getActionsRequestRendering()) {
            Gdx.graphics.requestRendering();
        }
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorAfter(Actor actor, Actor actor2) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorAt(int n, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorBefore(Actor actor, Actor actor2) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    public void cancel() {
        this.draggingPointer = -1;
        this.touchScrollH = false;
        this.touchScrollV = false;
        this.flickScrollListener.getGestureDetector().cancel();
    }

    public void cancelTouchFocus() {
        Stage stage = this.getStage();
        if (stage != null) {
            stage.cancelTouchFocusExcept(this.flickScrollListener, this);
        }
    }

    void clamp() {
        float f;
        float f2;
        if (!this.clamp) {
            return;
        }
        if (this.overscrollX) {
            f2 = this.amountX;
            f = this.overscrollDistance;
            f2 = MathUtils.clamp(f2, -f, this.maxX + f);
        } else {
            f2 = MathUtils.clamp(this.amountX, 0.0f, this.maxX);
        }
        this.scrollX(f2);
        if (this.overscrollY) {
            f = this.amountY;
            f2 = this.overscrollDistance;
            f2 = MathUtils.clamp(f, -f2, this.maxY + f2);
        } else {
            f2 = MathUtils.clamp(this.amountY, 0.0f, this.maxY);
        }
        this.scrollY(f2);
    }

    @Override
    public void draw(Batch batch, float f) {
        float f2;
        if (this.widget == null) {
            return;
        }
        this.validate();
        this.applyTransform(batch, this.computeTransform());
        if (this.scrollX) {
            this.hKnobBounds.x = this.hScrollBounds.x + (float)((int)((this.hScrollBounds.width - this.hKnobBounds.width) * this.getVisualScrollPercentX()));
        }
        if (this.scrollY) {
            this.vKnobBounds.y = this.vScrollBounds.y + (float)((int)((this.vScrollBounds.height - this.vKnobBounds.height) * (1.0f - this.getVisualScrollPercentY())));
        }
        this.updateWidgetPosition();
        Color color2 = this.getColor();
        batch.setColor(color2.r, color2.g, color2.b, color2.a * f);
        if (this.style.background != null) {
            this.style.background.draw(batch, 0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        batch.flush();
        if (this.clipBegin(this.widgetAreaBounds.x, this.widgetAreaBounds.y, this.widgetAreaBounds.width, this.widgetAreaBounds.height)) {
            this.drawChildren(batch, f);
            batch.flush();
            this.clipEnd();
        }
        float f3 = f2 = color2.a * f;
        if (this.fadeScrollBars) {
            f3 = f2 * Interpolation.fade.apply(this.fadeAlpha / this.fadeAlphaSeconds);
        }
        batch.setColor(color2.r, color2.g, color2.b, color2.a * f);
        this.drawScrollBars(batch, color2.r, color2.g, color2.b, f3);
        this.resetTransform(batch);
    }

    @Override
    public void drawDebug(ShapeRenderer shapeRenderer) {
        this.drawDebugBounds(shapeRenderer);
        this.applyTransform(shapeRenderer, this.computeTransform());
        if (this.clipBegin(this.widgetAreaBounds.x, this.widgetAreaBounds.y, this.widgetAreaBounds.width, this.widgetAreaBounds.height)) {
            this.drawDebugChildren(shapeRenderer);
            shapeRenderer.flush();
            this.clipEnd();
        }
        this.resetTransform(shapeRenderer);
    }

    protected void drawScrollBars(Batch batch, float f, float f2, float f3, float f4) {
        if (f4 <= 0.0f) {
            return;
        }
        batch.setColor(f, f2, f3, f4);
        boolean bl = this.scrollX;
        boolean bl2 = true;
        boolean bl3 = bl && this.hKnobBounds.width > 0.0f;
        if (!this.scrollY || !(this.vKnobBounds.height > 0.0f)) {
            bl2 = false;
        }
        if (bl3 && bl2 && this.style.corner != null) {
            this.style.corner.draw(batch, this.hScrollBounds.x + this.hScrollBounds.width, this.hScrollBounds.y, this.vScrollBounds.width, this.vScrollBounds.y);
        }
        if (bl3) {
            if (this.style.hScroll != null) {
                this.style.hScroll.draw(batch, this.hScrollBounds.x, this.hScrollBounds.y, this.hScrollBounds.width, this.hScrollBounds.height);
            }
            if (this.style.hScrollKnob != null) {
                this.style.hScrollKnob.draw(batch, this.hKnobBounds.x, this.hKnobBounds.y, this.hKnobBounds.width, this.hKnobBounds.height);
            }
        }
        if (bl2) {
            if (this.style.vScroll != null) {
                this.style.vScroll.draw(batch, this.vScrollBounds.x, this.vScrollBounds.y, this.vScrollBounds.width, this.vScrollBounds.height);
            }
            if (this.style.vScrollKnob != null) {
                this.style.vScrollKnob.draw(batch, this.vKnobBounds.x, this.vKnobBounds.y, this.vKnobBounds.width, this.vKnobBounds.height);
            }
        }
    }

    public void fling(float f, float f2, float f3) {
        this.flingTimer = f;
        this.velocityX = f2;
        this.velocityY = f3;
    }

    public Actor getActor() {
        return this.widget;
    }

    public boolean getFadeScrollBars() {
        return this.fadeScrollBars;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    protected float getMouseWheelX() {
        float f = this.areaWidth;
        return Math.min(f, Math.max(0.9f * f, this.maxX * 0.1f) / 4.0f);
    }

    protected float getMouseWheelY() {
        float f = this.areaHeight;
        return Math.min(f, Math.max(0.9f * f, this.maxY * 0.1f) / 4.0f);
    }

    public float getOverscrollDistance() {
        return this.overscrollDistance;
    }

    @Override
    public float getPrefHeight() {
        float f;
        Actor actor = this.widget;
        boolean bl = actor instanceof Layout;
        float f2 = 0.0f;
        if (bl) {
            this.validate();
            f = ((Layout)((Object)this.widget)).getPrefHeight();
        } else {
            f = actor != null ? actor.getHeight() : 0.0f;
        }
        float f3 = f;
        if (this.style.background != null) {
            f3 = f + (this.style.background.getTopHeight() + this.style.background.getBottomHeight());
        }
        f = f3;
        if (this.scrollX) {
            f = f2;
            if (this.style.hScrollKnob != null) {
                f = this.style.hScrollKnob.getMinHeight();
            }
            f2 = f;
            if (this.style.hScroll != null) {
                f2 = Math.max(f, this.style.hScroll.getMinHeight());
            }
            f = f3 + f2;
        }
        return f;
    }

    @Override
    public float getPrefWidth() {
        float f;
        Actor actor = this.widget;
        boolean bl = actor instanceof Layout;
        float f2 = 0.0f;
        if (bl) {
            this.validate();
            f = ((Layout)((Object)this.widget)).getPrefWidth();
        } else {
            f = actor != null ? actor.getWidth() : 0.0f;
        }
        float f3 = f;
        if (this.style.background != null) {
            f3 = f + (this.style.background.getLeftWidth() + this.style.background.getRightWidth());
        }
        f = f3;
        if (this.scrollY) {
            f = f2;
            if (this.style.vScrollKnob != null) {
                f = this.style.vScrollKnob.getMinWidth();
            }
            f2 = f;
            if (this.style.vScroll != null) {
                f2 = Math.max(f, this.style.vScroll.getMinWidth());
            }
            f = f3 + f2;
        }
        return f;
    }

    public float getScrollBarHeight() {
        boolean bl = this.scrollX;
        float f = 0.0f;
        if (!bl) {
            return 0.0f;
        }
        if (this.style.hScrollKnob != null) {
            f = this.style.hScrollKnob.getMinHeight();
        }
        float f2 = f;
        if (this.style.hScroll != null) {
            f2 = Math.max(f, this.style.hScroll.getMinHeight());
        }
        return f2;
    }

    public float getScrollBarWidth() {
        boolean bl = this.scrollY;
        float f = 0.0f;
        if (!bl) {
            return 0.0f;
        }
        if (this.style.vScrollKnob != null) {
            f = this.style.vScrollKnob.getMinWidth();
        }
        float f2 = f;
        if (this.style.vScroll != null) {
            f2 = Math.max(f, this.style.vScroll.getMinWidth());
        }
        return f2;
    }

    public float getScrollHeight() {
        return this.areaHeight;
    }

    public float getScrollPercentX() {
        float f = this.maxX;
        if (f == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.amountX / f, 0.0f, 1.0f);
    }

    public float getScrollPercentY() {
        float f = this.maxY;
        if (f == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.amountY / f, 0.0f, 1.0f);
    }

    public float getScrollWidth() {
        return this.areaWidth;
    }

    public float getScrollX() {
        return this.amountX;
    }

    public float getScrollY() {
        return this.amountY;
    }

    public ScrollPaneStyle getStyle() {
        return this.style;
    }

    public boolean getVariableSizeKnobs() {
        return this.variableSizeKnobs;
    }

    public float getVelocityX() {
        return this.velocityX;
    }

    public float getVelocityY() {
        return this.velocityY;
    }

    public float getVisualScrollPercentX() {
        float f = this.maxX;
        if (f == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.visualAmountX / f, 0.0f, 1.0f);
    }

    public float getVisualScrollPercentY() {
        float f = this.maxY;
        if (f == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.visualAmountY / f, 0.0f, 1.0f);
    }

    public float getVisualScrollX() {
        float f = !this.scrollX ? 0.0f : this.visualAmountX;
        return f;
    }

    public float getVisualScrollY() {
        float f = !this.scrollY ? 0.0f : this.visualAmountY;
        return f;
    }

    public Actor getWidget() {
        return this.widget;
    }

    @Override
    public Actor hit(float f, float f2, boolean bl) {
        if (!(f < 0.0f || f >= this.getWidth() || f2 < 0.0f || f2 >= this.getHeight())) {
            if (bl && this.getTouchable() == Touchable.enabled && this.isVisible()) {
                if (this.scrollX && this.touchScrollH && this.hScrollBounds.contains(f, f2)) {
                    return this;
                }
                if (this.scrollY && this.touchScrollV && this.vScrollBounds.contains(f, f2)) {
                    return this;
                }
            }
            return super.hit(f, f2, bl);
        }
        return null;
    }

    public boolean isBottomEdge() {
        boolean bl = !this.scrollY || this.amountY >= this.maxY;
        return bl;
    }

    public boolean isDragging() {
        boolean bl = this.draggingPointer != -1;
        return bl;
    }

    public boolean isFlinging() {
        boolean bl = this.flingTimer > 0.0f;
        return bl;
    }

    public boolean isForceScrollX() {
        return this.forceScrollX;
    }

    public boolean isForceScrollY() {
        return this.forceScrollY;
    }

    public boolean isLeftEdge() {
        boolean bl = !this.scrollX || this.amountX <= 0.0f;
        return bl;
    }

    public boolean isPanning() {
        return this.flickScrollListener.getGestureDetector().isPanning();
    }

    public boolean isRightEdge() {
        boolean bl = !this.scrollX || this.amountX >= this.maxX;
        return bl;
    }

    public boolean isScrollX() {
        return this.scrollX;
    }

    public boolean isScrollY() {
        return this.scrollY;
    }

    public boolean isScrollingDisabledX() {
        return this.disableX;
    }

    public boolean isScrollingDisabledY() {
        return this.disableY;
    }

    public boolean isTopEdge() {
        boolean bl = !this.scrollY || this.amountY <= 0.0f;
        return bl;
    }

    @Override
    public void layout() {
        boolean bl;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        Object object;
        Drawable drawable2;
        Object object2;
        block37: {
            block36: {
                object2 = this.style.background;
                drawable2 = this.style.hScrollKnob;
                object = this.style.vScrollKnob;
                if (object2 != null) {
                    f10 = object2.getLeftWidth();
                    f9 = object2.getRightWidth();
                    f8 = object2.getTopHeight();
                    f7 = object2.getBottomHeight();
                } else {
                    f7 = 0.0f;
                    f10 = 0.0f;
                    f9 = 0.0f;
                    f8 = 0.0f;
                }
                f6 = this.getWidth();
                f5 = this.getHeight();
                f4 = drawable2 != null ? drawable2.getMinHeight() : 0.0f;
                f3 = f4;
                if (this.style.hScroll != null) {
                    f3 = Math.max(f4, this.style.hScroll.getMinHeight());
                }
                f4 = object != null ? object.getMinWidth() : 0.0f;
                f2 = f4;
                if (this.style.vScroll != null) {
                    f2 = Math.max(f4, this.style.vScroll.getMinWidth());
                }
                this.areaWidth = f6 - f10 - f9;
                f = f5 - f8;
                this.areaHeight = f - f7;
                object2 = this.widget;
                if (object2 == null) {
                    return;
                }
                if (object2 instanceof Layout) {
                    object2 = (Layout)object2;
                    f4 = object2.getPrefWidth();
                    f8 = object2.getPrefHeight();
                } else {
                    f4 = ((Actor)object2).getWidth();
                    f8 = this.widget.getHeight();
                }
                bl = this.forceScrollX;
                boolean bl2 = false;
                bl = bl || f4 > this.areaWidth && !this.disableX;
                this.scrollX = bl;
                if (this.forceScrollY) break block36;
                bl = bl2;
                if (!(f8 > this.areaHeight)) break block37;
                bl = bl2;
                if (this.disableY) break block37;
            }
            bl = true;
        }
        this.scrollY = bl;
        bl = this.fadeScrollBars;
        if (!bl) {
            if (this.scrollY) {
                this.areaWidth -= f2;
                if (!this.scrollX && f4 > this.areaWidth && !this.disableX) {
                    this.scrollX = true;
                }
            }
            if (this.scrollX) {
                this.areaHeight -= f3;
                if (!this.scrollY && f8 > this.areaHeight && !this.disableY) {
                    this.scrollY = true;
                    this.areaWidth -= f2;
                }
            }
        }
        this.widgetAreaBounds.set(f10, f7, this.areaWidth, this.areaHeight);
        if (bl) {
            if (this.scrollX && this.scrollY) {
                this.areaHeight -= f3;
                this.areaWidth -= f2;
            }
        } else if (this.scrollbarsOnTop) {
            if (this.scrollX) {
                object2 = this.widgetAreaBounds;
                ((Rectangle)object2).height += f3;
            }
            if (this.scrollY) {
                object2 = this.widgetAreaBounds;
                ((Rectangle)object2).width += f2;
            }
        } else {
            if (this.scrollX && this.hScrollOnBottom) {
                object2 = this.widgetAreaBounds;
                ((Rectangle)object2).y += f3;
            }
            if (this.scrollY && !this.vScrollOnRight) {
                object2 = this.widgetAreaBounds;
                ((Rectangle)object2).x += f2;
            }
        }
        f4 = this.disableX ? this.areaWidth : Math.max(this.areaWidth, f4);
        f8 = this.disableY ? this.areaHeight : Math.max(this.areaHeight, f8);
        this.maxX = f4 - this.areaWidth;
        this.maxY = f8 - this.areaHeight;
        if (bl && this.scrollX && this.scrollY) {
            this.maxY -= f3;
            this.maxX -= f2;
        }
        this.scrollX(MathUtils.clamp(this.amountX, 0.0f, this.maxX));
        this.scrollY(MathUtils.clamp(this.amountY, 0.0f, this.maxY));
        if (this.scrollX) {
            if (drawable2 != null) {
                f3 = this.style.hScroll != null ? this.style.hScroll.getMinHeight() : drawable2.getMinHeight();
                f2 = this.vScrollOnRight ? f10 : (f2 += f10);
                f5 = this.hScrollOnBottom ? f7 : f - f3;
                this.hScrollBounds.set(f2, f5, this.areaWidth, f3);
                this.hKnobBounds.width = this.variableSizeKnobs ? Math.max(drawable2.getMinWidth(), (float)((int)(this.hScrollBounds.width * this.areaWidth / f4))) : drawable2.getMinWidth();
                if (this.hKnobBounds.width > f4) {
                    this.hKnobBounds.width = 0.0f;
                }
                this.hKnobBounds.height = drawable2.getMinHeight();
                this.hKnobBounds.x = this.hScrollBounds.x + (float)((int)((this.hScrollBounds.width - this.hKnobBounds.width) * this.getScrollPercentX()));
                this.hKnobBounds.y = this.hScrollBounds.y;
            } else {
                this.hScrollBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.hKnobBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        if (this.scrollY) {
            if (object != null) {
                f3 = this.style.vScroll != null ? this.style.vScroll.getMinWidth() : object.getMinWidth();
                if (this.hScrollOnBottom) {
                    f7 = f - this.areaHeight;
                }
                f2 = this.vScrollOnRight ? f6 - f9 - f3 : f10;
                this.vScrollBounds.set(f2, f7, f3, this.areaHeight);
                this.vKnobBounds.width = object.getMinWidth();
                this.vKnobBounds.height = this.variableSizeKnobs ? Math.max(object.getMinHeight(), (float)((int)(this.vScrollBounds.height * this.areaHeight / f8))) : object.getMinHeight();
                if (this.vKnobBounds.height > f8) {
                    this.vKnobBounds.height = 0.0f;
                }
                this.vKnobBounds.x = this.vScrollOnRight ? f6 - f9 - object.getMinWidth() : f10;
                this.vKnobBounds.y = this.vScrollBounds.y + (float)((int)((this.vScrollBounds.height - this.vKnobBounds.height) * (1.0f - this.getScrollPercentY())));
            } else {
                this.vScrollBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.vKnobBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        this.updateWidgetPosition();
        object = this.widget;
        if (object instanceof Layout) {
            ((Actor)object).setSize(f4, f8);
            ((Layout)((Object)this.widget)).validate();
        }
    }

    @Override
    public boolean removeActor(Actor actor) {
        if (actor != null) {
            if (actor != this.widget) {
                return false;
            }
            this.setActor(null);
            return true;
        }
        throw new IllegalArgumentException("actor cannot be null.");
    }

    @Override
    public boolean removeActor(Actor actor, boolean bl) {
        if (actor != null) {
            if (actor != this.widget) {
                return false;
            }
            this.widget = null;
            return super.removeActor(actor, bl);
        }
        throw new IllegalArgumentException("actor cannot be null.");
    }

    public void scrollTo(float f, float f2, float f3, float f4) {
        this.scrollTo(f, f2, f3, f4, false, false);
    }

    public void scrollTo(float f, float f2, float f3, float f4, boolean bl, boolean bl2) {
        float f5;
        this.validate();
        float f6 = this.amountX;
        if (bl) {
            f = f - this.areaWidth / 2.0f + f3 / 2.0f;
        } else {
            f5 = f3 + f;
            if (!(f < (f3 = f5 > f6 + (f3 = this.areaWidth) ? f5 - f3 : f6))) {
                f = f3;
            }
        }
        this.scrollX(MathUtils.clamp(f, 0.0f, this.maxX));
        f3 = this.amountY;
        if (bl2) {
            f3 = this.maxY - f2 + this.areaHeight / 2.0f - f4 / 2.0f;
        } else {
            f5 = this.maxY;
            f6 = this.areaHeight;
            f = f3;
            if (f3 > f5 - f2 - f4 + f6) {
                f = f5 - f2 - f4 + f6;
            }
            f4 = this.maxY;
            f3 = f;
            if (f < f4 - f2) {
                f3 = f4 - f2;
            }
        }
        this.scrollY(MathUtils.clamp(f3, 0.0f, this.maxY));
    }

    protected void scrollX(float f) {
        this.amountX = f;
    }

    protected void scrollY(float f) {
        this.amountY = f;
    }

    public void setActor(Actor actor) {
        Actor actor2 = this.widget;
        if (actor2 != this) {
            if (actor2 != null) {
                super.removeActor(actor2);
            }
            if ((actor = (this.widget = actor)) != null) {
                super.addActor(actor);
            }
            return;
        }
        throw new IllegalArgumentException("widget cannot be the ScrollPane.");
    }

    public void setCancelTouchFocus(boolean bl) {
        this.cancelTouchFocus = bl;
    }

    public void setClamp(boolean bl) {
        this.clamp = bl;
    }

    public void setFadeScrollBars(boolean bl) {
        if (this.fadeScrollBars == bl) {
            return;
        }
        this.fadeScrollBars = bl;
        if (!bl) {
            this.fadeAlpha = this.fadeAlphaSeconds;
        }
        this.invalidate();
    }

    public void setFlickScroll(boolean bl) {
        if (this.flickScroll == bl) {
            return;
        }
        this.flickScroll = bl;
        if (bl) {
            this.addListener(this.flickScrollListener);
        } else {
            this.removeListener(this.flickScrollListener);
        }
        this.invalidate();
    }

    public void setFlickScrollTapSquareSize(float f) {
        this.flickScrollListener.getGestureDetector().setTapSquareSize(f);
    }

    public void setFlingTime(float f) {
        this.flingTime = f;
    }

    public void setForceScroll(boolean bl, boolean bl2) {
        this.forceScrollX = bl;
        this.forceScrollY = bl2;
    }

    public void setOverscroll(boolean bl, boolean bl2) {
        this.overscrollX = bl;
        this.overscrollY = bl2;
    }

    public void setScrollBarPositions(boolean bl, boolean bl2) {
        this.hScrollOnBottom = bl;
        this.vScrollOnRight = bl2;
    }

    public void setScrollBarTouch(boolean bl) {
        this.scrollBarTouch = bl;
    }

    public void setScrollPercentX(float f) {
        this.scrollX(this.maxX * MathUtils.clamp(f, 0.0f, 1.0f));
    }

    public void setScrollPercentY(float f) {
        this.scrollY(this.maxY * MathUtils.clamp(f, 0.0f, 1.0f));
    }

    public void setScrollX(float f) {
        this.scrollX(MathUtils.clamp(f, 0.0f, this.maxX));
    }

    public void setScrollY(float f) {
        this.scrollY(MathUtils.clamp(f, 0.0f, this.maxY));
    }

    public void setScrollbarsOnTop(boolean bl) {
        this.scrollbarsOnTop = bl;
        this.invalidate();
    }

    public void setScrollbarsVisible(boolean bl) {
        if (bl) {
            this.fadeAlpha = this.fadeAlphaSeconds;
            this.fadeDelay = this.fadeDelaySeconds;
        } else {
            this.fadeAlpha = 0.0f;
            this.fadeDelay = 0.0f;
        }
    }

    public void setScrollingDisabled(boolean bl, boolean bl2) {
        this.disableX = bl;
        this.disableY = bl2;
        this.invalidate();
    }

    public void setSmoothScrolling(boolean bl) {
        this.smoothScrolling = bl;
    }

    public void setStyle(ScrollPaneStyle scrollPaneStyle) {
        if (scrollPaneStyle != null) {
            this.style = scrollPaneStyle;
            this.invalidateHierarchy();
            return;
        }
        throw new IllegalArgumentException("style cannot be null.");
    }

    public void setVariableSizeKnobs(boolean bl) {
        this.variableSizeKnobs = bl;
    }

    public void setVelocityX(float f) {
        this.velocityX = f;
    }

    public void setVelocityY(float f) {
        this.velocityY = f;
    }

    public void setWidget(Actor actor) {
        this.setActor(actor);
    }

    public void setupFadeScrollBars(float f, float f2) {
        this.fadeAlphaSeconds = f;
        this.fadeDelaySeconds = f2;
    }

    public void setupOverscroll(float f, float f2, float f3) {
        this.overscrollDistance = f;
        this.overscrollSpeedMin = f2;
        this.overscrollSpeedMax = f3;
    }

    public void updateVisualScroll() {
        this.visualAmountX = this.amountX;
        this.visualAmountY = this.amountY;
    }

    protected void visualScrollX(float f) {
        this.visualAmountX = f;
    }

    protected void visualScrollY(float f) {
        this.visualAmountY = f;
    }

    public static class ScrollPaneStyle {
        public Drawable background;
        public Drawable corner;
        public Drawable hScroll;
        public Drawable hScrollKnob;
        public Drawable vScroll;
        public Drawable vScrollKnob;

        public ScrollPaneStyle() {
        }

        public ScrollPaneStyle(ScrollPaneStyle scrollPaneStyle) {
            this.background = scrollPaneStyle.background;
            this.corner = scrollPaneStyle.corner;
            this.hScroll = scrollPaneStyle.hScroll;
            this.hScrollKnob = scrollPaneStyle.hScrollKnob;
            this.vScroll = scrollPaneStyle.vScroll;
            this.vScrollKnob = scrollPaneStyle.vScrollKnob;
        }

        public ScrollPaneStyle(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5, Drawable drawable6) {
            this.background = drawable2;
            this.hScroll = drawable3;
            this.hScrollKnob = drawable4;
            this.vScroll = drawable5;
            this.vScrollKnob = drawable6;
        }
    }
}

