/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Scaling;

public class ImageButton
extends Button {
    private final Image image = new Image();
    private ImageButtonStyle style;

    public ImageButton(ImageButtonStyle imageButtonStyle) {
        super(imageButtonStyle);
        this.image.setScaling(Scaling.fit);
        this.add(this.image);
        this.setStyle(imageButtonStyle);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public ImageButton(Skin skin) {
        this(skin.get(ImageButtonStyle.class));
        this.setSkin(skin);
    }

    public ImageButton(Skin skin, String string2) {
        this(skin.get(string2, ImageButtonStyle.class));
        this.setSkin(skin);
    }

    public ImageButton(Drawable drawable2) {
        this(new ImageButtonStyle(null, null, null, drawable2, null, null));
    }

    public ImageButton(Drawable drawable2, Drawable drawable3) {
        this(new ImageButtonStyle(null, null, null, drawable2, drawable3, null));
    }

    public ImageButton(Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        this(new ImageButtonStyle(null, null, null, drawable2, drawable3, drawable4));
    }

    @Override
    public void draw(Batch batch, float f) {
        this.updateImage();
        super.draw(batch, f);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.getCell(this.image);
    }

    @Override
    public ImageButtonStyle getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Button.ButtonStyle buttonStyle) {
        if (buttonStyle instanceof ImageButtonStyle) {
            super.setStyle(buttonStyle);
            this.style = (ImageButtonStyle)buttonStyle;
            if (this.image != null) {
                this.updateImage();
            }
            return;
        }
        throw new IllegalArgumentException("style must be an ImageButtonStyle.");
    }

    @Override
    public String toString() {
        String string2 = this.getName();
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getClass().getName();
        int n = string3.lastIndexOf(46);
        string2 = string3;
        if (n != -1) {
            string2 = string3.substring(n + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        string3 = string2.indexOf(36) != -1 ? "ImageButton " : "";
        stringBuilder.append(string3);
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        stringBuilder.append(this.image.getDrawable());
        return stringBuilder.toString();
    }

    protected void updateImage() {
        Drawable drawable2 = this.isDisabled() && this.style.imageDisabled != null ? this.style.imageDisabled : (this.isPressed() && this.style.imageDown != null ? this.style.imageDown : (this.isChecked && this.style.imageChecked != null ? (this.style.imageCheckedOver != null && this.isOver() ? this.style.imageCheckedOver : this.style.imageChecked) : (this.isOver() && this.style.imageOver != null ? this.style.imageOver : (this.style.imageUp != null ? this.style.imageUp : null))));
        this.image.setDrawable(drawable2);
    }

    public static class ImageButtonStyle
    extends Button.ButtonStyle {
        public Drawable imageChecked;
        public Drawable imageCheckedOver;
        public Drawable imageDisabled;
        public Drawable imageDown;
        public Drawable imageOver;
        public Drawable imageUp;

        public ImageButtonStyle() {
        }

        public ImageButtonStyle(Button.ButtonStyle buttonStyle) {
            super(buttonStyle);
        }

        public ImageButtonStyle(ImageButtonStyle imageButtonStyle) {
            super(imageButtonStyle);
            this.imageUp = imageButtonStyle.imageUp;
            this.imageDown = imageButtonStyle.imageDown;
            this.imageOver = imageButtonStyle.imageOver;
            this.imageChecked = imageButtonStyle.imageChecked;
            this.imageCheckedOver = imageButtonStyle.imageCheckedOver;
            this.imageDisabled = imageButtonStyle.imageDisabled;
        }

        public ImageButtonStyle(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5, Drawable drawable6, Drawable drawable7) {
            super(drawable2, drawable3, drawable4);
            this.imageUp = drawable5;
            this.imageDown = drawable6;
            this.imageChecked = drawable7;
        }
    }
}

