/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.utils.Array;

public class ButtonGroup<T extends Button> {
    private final Array<T> buttons = new Array();
    private Array<T> checkedButtons = new Array(1);
    private T lastChecked;
    private int maxCheckCount = 1;
    private int minCheckCount;
    private boolean uncheckLast = true;

    public ButtonGroup() {
        this.minCheckCount = 1;
    }

    public ButtonGroup(T ... TArray) {
        this.minCheckCount = 0;
        this.add((T)TArray);
        this.minCheckCount = 1;
    }

    public void add(T t) {
        if (t != null) {
            ((Button)t).buttonGroup = null;
            boolean bl = ((Button)t).isChecked() || this.buttons.size < this.minCheckCount;
            ((Button)t).setChecked(false);
            ((Button)t).buttonGroup = this;
            this.buttons.add(t);
            ((Button)t).setChecked(bl);
            return;
        }
        throw new IllegalArgumentException("button cannot be null.");
    }

    public void add(T ... object) {
        if (object != null) {
            int n = ((T[])object).length;
            for (int i = 0; i < n; ++i) {
                this.add(object[i]);
            }
            return;
        }
        object = new IllegalArgumentException("buttons cannot be null.");
        throw object;
    }

    protected boolean canCheck(T t, boolean bl) {
        if (((Button)t).isChecked == bl) {
            return false;
        }
        if (!bl) {
            if (this.checkedButtons.size <= this.minCheckCount) {
                return false;
            }
            this.checkedButtons.removeValue(t, true);
        } else {
            if (this.maxCheckCount != -1 && this.checkedButtons.size >= this.maxCheckCount) {
                if (this.uncheckLast) {
                    int n = this.minCheckCount;
                    this.minCheckCount = 0;
                    ((Button)this.lastChecked).setChecked(false);
                    this.minCheckCount = n;
                } else {
                    return false;
                }
            }
            this.checkedButtons.add(t);
            this.lastChecked = t;
        }
        return true;
    }

    public void clear() {
        this.buttons.clear();
        this.checkedButtons.clear();
    }

    public Array<T> getAllChecked() {
        return this.checkedButtons;
    }

    public Array<T> getButtons() {
        return this.buttons;
    }

    public T getChecked() {
        if (this.checkedButtons.size > 0) {
            return (T)((Button)this.checkedButtons.get(0));
        }
        return null;
    }

    public int getCheckedIndex() {
        if (this.checkedButtons.size > 0) {
            return this.buttons.indexOf(this.checkedButtons.get(0), true);
        }
        return -1;
    }

    public void remove(T t) {
        if (t != null) {
            ((Button)t).buttonGroup = null;
            this.buttons.removeValue(t, true);
            this.checkedButtons.removeValue(t, true);
            return;
        }
        throw new IllegalArgumentException("button cannot be null.");
    }

    public void remove(T ... object) {
        if (object != null) {
            int n = ((T[])object).length;
            for (int i = 0; i < n; ++i) {
                this.remove(object[i]);
            }
            return;
        }
        object = new IllegalArgumentException("buttons cannot be null.");
        throw object;
    }

    public void setChecked(String object) {
        if (object != null) {
            int n = this.buttons.size;
            for (int i = 0; i < n; ++i) {
                Button button = (Button)this.buttons.get(i);
                if (!(button instanceof TextButton) || !((String)object).contentEquals(((TextButton)button).getText())) continue;
                button.setChecked(true);
                return;
            }
            return;
        }
        object = new IllegalArgumentException("text cannot be null.");
        throw object;
    }

    public void setMaxCheckCount(int n) {
        int n2 = n;
        if (n == 0) {
            n2 = -1;
        }
        this.maxCheckCount = n2;
    }

    public void setMinCheckCount(int n) {
        this.minCheckCount = n;
    }

    public void setUncheckLast(boolean bl) {
        this.uncheckLast = bl;
    }

    public void uncheckAll() {
        int n = this.minCheckCount;
        this.minCheckCount = 0;
        int n2 = this.buttons.size;
        for (int i = 0; i < n2; ++i) {
            ((Button)this.buttons.get(i)).setChecked(false);
        }
        this.minCheckCount = n;
    }
}

