/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;

public class Button
extends Table
implements Disableable {
    ButtonGroup buttonGroup;
    private ClickListener clickListener;
    boolean focused;
    boolean isChecked;
    boolean isDisabled;
    private boolean programmaticChangeEvents = true;
    private ButtonStyle style;

    public Button() {
        this.initialize();
    }

    public Button(Actor actor, ButtonStyle buttonStyle) {
        this.initialize();
        this.add(actor);
        this.setStyle(buttonStyle);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public Button(Actor actor, Skin skin) {
        this(actor, skin.get(ButtonStyle.class));
    }

    public Button(Actor actor, Skin skin, String string2) {
        this(actor, skin.get(string2, ButtonStyle.class));
        this.setSkin(skin);
    }

    public Button(ButtonStyle buttonStyle) {
        this.initialize();
        this.setStyle(buttonStyle);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public Button(Skin skin) {
        super(skin);
        this.initialize();
        this.setStyle(skin.get(ButtonStyle.class));
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public Button(Skin skin, String string2) {
        super(skin);
        this.initialize();
        this.setStyle(skin.get(string2, ButtonStyle.class));
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public Button(Drawable drawable2) {
        this(new ButtonStyle(drawable2, null, null));
    }

    public Button(Drawable drawable2, Drawable drawable3) {
        this(new ButtonStyle(drawable2, drawable3, null));
    }

    public Button(Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        this(new ButtonStyle(drawable2, drawable3, drawable4));
    }

    private void initialize() {
        ClickListener clickListener;
        this.setTouchable(Touchable.enabled);
        this.clickListener = clickListener = new ClickListener(){

            @Override
            public void clicked(InputEvent object, float f, float f2) {
                if (Button.this.isDisabled()) {
                    return;
                }
                object = Button.this;
                ((Button)object).setChecked(((Button)object).isChecked ^ true, true);
            }
        };
        this.addListener(clickListener);
        this.addListener(new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent focusEvent, Actor actor, boolean bl) {
                Button.this.focused = bl;
            }
        });
    }

    @Override
    public void draw(Batch disposable, float f) {
        int n;
        float f2;
        float f3;
        this.validate();
        boolean bl = this.isDisabled();
        boolean bl2 = this.isPressed();
        boolean bl3 = this.isChecked();
        boolean bl4 = this.isOver();
        Object object = bl && this.style.disabled != null ? this.style.disabled : (bl2 && this.style.down != null ? this.style.down : (bl3 && this.style.checked != null ? (this.style.checkedOver != null && bl4 ? this.style.checkedOver : (this.style.checkedFocused != null && this.focused ? this.style.checkedFocused : this.style.checked)) : (bl4 && this.style.over != null ? this.style.over : (this.focused && this.style.focused != null ? this.style.focused : (this.style.up != null ? this.style.up : null)))));
        this.setBackground((Drawable)object);
        if (bl2 && !bl) {
            f3 = this.style.pressedOffsetX;
            f2 = this.style.pressedOffsetY;
        } else if (bl3 && !bl) {
            f3 = this.style.checkedOffsetX;
            f2 = this.style.checkedOffsetY;
        } else {
            f3 = this.style.unpressedOffsetX;
            f2 = this.style.unpressedOffsetY;
        }
        object = this.getChildren();
        int n2 = 0;
        for (n = 0; n < ((Array)object).size; ++n) {
            ((Actor)((Array)object).get(n)).moveBy(f3, f2);
        }
        super.draw((Batch)disposable, f);
        for (n = n2; n < ((Array)object).size; ++n) {
            ((Actor)((Array)object).get(n)).moveBy(-f3, -f2);
        }
        disposable = this.getStage();
        if (disposable != null && ((Stage)disposable).getActionsRequestRendering() && bl2 != this.clickListener.isPressed()) {
            Gdx.graphics.requestRendering();
        }
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getPrefHeight() {
        float f;
        float f2 = f = super.getPrefHeight();
        if (this.style.up != null) {
            f2 = Math.max(f, this.style.up.getMinHeight());
        }
        f = f2;
        if (this.style.down != null) {
            f = Math.max(f2, this.style.down.getMinHeight());
        }
        f2 = f;
        if (this.style.checked != null) {
            f2 = Math.max(f, this.style.checked.getMinHeight());
        }
        return f2;
    }

    @Override
    public float getPrefWidth() {
        float f;
        float f2 = f = super.getPrefWidth();
        if (this.style.up != null) {
            f2 = Math.max(f, this.style.up.getMinWidth());
        }
        f = f2;
        if (this.style.down != null) {
            f = Math.max(f2, this.style.down.getMinWidth());
        }
        f2 = f;
        if (this.style.checked != null) {
            f2 = Math.max(f, this.style.checked.getMinWidth());
        }
        return f2;
    }

    public ButtonStyle getStyle() {
        return this.style;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    public boolean isOver() {
        return this.clickListener.isOver();
    }

    public boolean isPressed() {
        return this.clickListener.isVisualPressed();
    }

    public void setChecked(boolean bl) {
        this.setChecked(bl, this.programmaticChangeEvents);
    }

    void setChecked(boolean bl, boolean bl2) {
        if (this.isChecked == bl) {
            return;
        }
        Object object = this.buttonGroup;
        if (object != null && !((ButtonGroup)object).canCheck(this, bl)) {
            return;
        }
        this.isChecked = bl;
        if (bl2) {
            object = Pools.obtain(ChangeListener.ChangeEvent.class);
            if (this.fire((Event)object)) {
                this.isChecked = bl ^ true;
            }
            Pools.free(object);
        }
    }

    @Override
    public void setDisabled(boolean bl) {
        this.isDisabled = bl;
    }

    public void setProgrammaticChangeEvents(boolean bl) {
        this.programmaticChangeEvents = bl;
    }

    public void setStyle(ButtonStyle object) {
        if (object != null) {
            this.style = object;
            object = this.isPressed() && !this.isDisabled() ? (((ButtonStyle)object).down == null ? ((ButtonStyle)object).up : ((ButtonStyle)object).down) : (this.isDisabled() && ((ButtonStyle)object).disabled != null ? ((ButtonStyle)object).disabled : (this.isChecked && ((ButtonStyle)object).checked != null ? (this.isOver() && ((ButtonStyle)object).checkedOver != null ? ((ButtonStyle)object).checkedOver : (this.focused && ((ButtonStyle)object).checkedFocused != null ? ((ButtonStyle)object).checkedFocused : ((ButtonStyle)object).checked)) : (this.isOver() && ((ButtonStyle)object).over != null ? ((ButtonStyle)object).over : (this.focused && ((ButtonStyle)object).focused != null ? ((ButtonStyle)object).focused : ((ButtonStyle)object).up))));
            this.setBackground((Drawable)object);
            return;
        }
        throw new IllegalArgumentException("style cannot be null.");
    }

    public void toggle() {
        this.setChecked(this.isChecked ^ true);
    }

    public static class ButtonStyle {
        public Drawable checked;
        public Drawable checkedFocused;
        public float checkedOffsetX;
        public float checkedOffsetY;
        public Drawable checkedOver;
        public Drawable disabled;
        public Drawable down;
        public Drawable focused;
        public Drawable over;
        public float pressedOffsetX;
        public float pressedOffsetY;
        public float unpressedOffsetX;
        public float unpressedOffsetY;
        public Drawable up;

        public ButtonStyle() {
        }

        public ButtonStyle(ButtonStyle buttonStyle) {
            this.up = buttonStyle.up;
            this.down = buttonStyle.down;
            this.over = buttonStyle.over;
            this.focused = buttonStyle.focused;
            this.checked = buttonStyle.checked;
            this.checkedOver = buttonStyle.checkedOver;
            this.checkedFocused = buttonStyle.checkedFocused;
            this.disabled = buttonStyle.disabled;
            this.pressedOffsetX = buttonStyle.pressedOffsetX;
            this.pressedOffsetY = buttonStyle.pressedOffsetY;
            this.unpressedOffsetX = buttonStyle.unpressedOffsetX;
            this.unpressedOffsetY = buttonStyle.unpressedOffsetY;
            this.checkedOffsetX = buttonStyle.checkedOffsetX;
            this.checkedOffsetY = buttonStyle.checkedOffsetY;
        }

        public ButtonStyle(Drawable drawable2, Drawable drawable3, Drawable drawable4) {
            this.up = drawable2;
            this.down = drawable3;
            this.checked = drawable4;
        }
    }
}

