/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.Socket;
import com.badlogic.gdx.net.SocketHints;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class NetJavaSocketImpl
implements Socket {
    private java.net.Socket socket;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetJavaSocketImpl(Net.Protocol object, String string2, int n, SocketHints socketHints) {
        try {
            this.socket = object = new java.net.Socket();
            this.applyHints(socketHints);
            object = new InetSocketAddress(string2, n);
            if (socketHints != null) {
                this.socket.connect((SocketAddress)object, socketHints.connectTimeout);
                return;
            }
            this.socket.connect((SocketAddress)object);
            return;
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Error making a socket connection to ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(":");
            ((StringBuilder)object).append(n);
            throw new GdxRuntimeException(((StringBuilder)object).toString(), exception);
        }
    }

    public NetJavaSocketImpl(java.net.Socket socket, SocketHints socketHints) {
        this.socket = socket;
        this.applyHints(socketHints);
    }

    private void applyHints(SocketHints socketHints) {
        if (socketHints != null) {
            try {
                this.socket.setPerformancePreferences(socketHints.performancePrefConnectionTime, socketHints.performancePrefLatency, socketHints.performancePrefBandwidth);
                this.socket.setTrafficClass(socketHints.trafficClass);
                this.socket.setTcpNoDelay(socketHints.tcpNoDelay);
                this.socket.setKeepAlive(socketHints.keepAlive);
                this.socket.setSendBufferSize(socketHints.sendBufferSize);
                this.socket.setReceiveBufferSize(socketHints.receiveBufferSize);
                this.socket.setSoLinger(socketHints.linger, socketHints.lingerDuration);
                this.socket.setSoTimeout(socketHints.socketTimeout);
            }
            catch (Exception exception) {
                throw new GdxRuntimeException("Error setting socket hints.", exception);
            }
        }
    }

    @Override
    public void dispose() {
        java.net.Socket socket = this.socket;
        if (socket != null) {
            try {
                socket.close();
                this.socket = null;
            }
            catch (Exception exception) {
                throw new GdxRuntimeException("Error closing socket.", exception);
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            InputStream inputStream = this.socket.getInputStream();
            return inputStream;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Error getting input stream from socket.", exception);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            OutputStream outputStream = this.socket.getOutputStream();
            return outputStream;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Error getting output stream from socket.", exception);
        }
    }

    @Override
    public String getRemoteAddress() {
        return this.socket.getRemoteSocketAddress().toString();
    }

    @Override
    public boolean isConnected() {
        java.net.Socket socket = this.socket;
        if (socket != null) {
            return socket.isConnected();
        }
        return false;
    }
}

