/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math.collision;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

public class Sphere
implements Serializable {
    private static final float PI_4_3 = 4.1887903f;
    private static final long serialVersionUID = -6487336868908521596L;
    public final Vector3 center;
    public float radius;

    public Sphere(Vector3 vector3, float f) {
        this.center = new Vector3(vector3);
        this.radius = f;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            object = (Sphere)object;
            if (this.radius != ((Sphere)object).radius || !this.center.equals(((Sphere)object).center)) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return (this.center.hashCode() + 71) * 71 + NumberUtils.floatToRawIntBits(this.radius);
    }

    public boolean overlaps(Sphere sphere) {
        float f;
        float f2;
        float f3 = this.center.dst2(sphere.center);
        boolean bl = f3 < ((f2 = this.radius) + (f = sphere.radius)) * (f2 + f);
        return bl;
    }

    public float surfaceArea() {
        float f = this.radius;
        return (float)Math.PI * 4 * f * f;
    }

    public float volume() {
        float f = this.radius;
        return 4.1887903f * f * f * f;
    }
}

