/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

public final class WindowedMean {
    int added_values = 0;
    boolean dirty = true;
    int last_value;
    float mean = 0.0f;
    float[] values;

    public WindowedMean(int n) {
        this.values = new float[n];
    }

    public void addValue(float f) {
        int n = this.added_values;
        if (n < this.values.length) {
            this.added_values = n + 1;
        }
        float[] fArray = this.values;
        n = this.last_value;
        this.last_value = n + 1;
        fArray[n] = f;
        if (this.last_value > fArray.length - 1) {
            this.last_value = 0;
        }
        this.dirty = true;
    }

    public void clear() {
        float[] fArray;
        this.added_values = 0;
        this.last_value = 0;
        for (int i = 0; i < (fArray = this.values).length; ++i) {
            fArray[i] = 0.0f;
        }
        this.dirty = true;
    }

    public float getHighest() {
        float[] fArray;
        float f = Float.MIN_NORMAL;
        for (int i = 0; i < (fArray = this.values).length; ++i) {
            f = Math.max(f, fArray[i]);
        }
        return f;
    }

    public float getLatest() {
        int n;
        float[] fArray = this.values;
        int n2 = n = this.last_value;
        if (n - 1 == -1) {
            n2 = fArray.length;
        }
        return fArray[n2 - 1];
    }

    public float getLowest() {
        float[] fArray;
        float f = Float.MAX_VALUE;
        for (int i = 0; i < (fArray = this.values).length; ++i) {
            f = Math.min(f, fArray[i]);
        }
        return f;
    }

    public float getMean() {
        if (this.hasEnoughData()) {
            if (this.dirty) {
                float[] fArray;
                float f = 0.0f;
                for (int i = 0; i < (fArray = this.values).length; ++i) {
                    f += fArray[i];
                }
                this.mean = f / (float)fArray.length;
                this.dirty = false;
            }
            return this.mean;
        }
        return 0.0f;
    }

    public float getOldest() {
        int n = this.added_values;
        float[] fArray = this.values;
        float f = n < fArray.length ? fArray[0] : fArray[this.last_value];
        return f;
    }

    public int getValueCount() {
        return this.added_values;
    }

    public int getWindowSize() {
        return this.values.length;
    }

    public float[] getWindowValues() {
        float[] fArray = new float[this.added_values];
        boolean bl = this.hasEnoughData();
        if (bl) {
            for (int i = 0; i < fArray.length; ++i) {
                float[] fArray2 = this.values;
                fArray[i] = fArray2[(this.last_value + i) % fArray2.length];
            }
        } else {
            System.arraycopy(this.values, 0, fArray, 0, this.added_values);
        }
        return fArray;
    }

    public boolean hasEnoughData() {
        boolean bl = this.added_values >= this.values.length;
        return bl;
    }

    public float standardDeviation() {
        float[] fArray;
        boolean bl = this.hasEnoughData();
        float f = 0.0f;
        if (!bl) {
            return 0.0f;
        }
        float f2 = this.getMean();
        for (int i = 0; i < (fArray = this.values).length; ++i) {
            f += (fArray[i] - f2) * (fArray[i] - f2);
        }
        return (float)Math.sqrt(f / (float)fArray.length);
    }
}

