/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.Map;
import com.badlogic.gdx.maps.MapGroupLayer;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapLayers;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.objects.EllipseMapObject;
import com.badlogic.gdx.maps.objects.PolygonMapObject;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapImageLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TiledMapTileSets;
import com.badlogic.gdx.maps.tiled.objects.TiledMapTileMapObject;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Base64Coder;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.XmlReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public abstract class BaseTmxMapLoader<P extends Parameters>
extends AsynchronousAssetLoader<TiledMap, P> {
    protected static final int FLAG_FLIP_DIAGONALLY = 0x20000000;
    protected static final int FLAG_FLIP_HORIZONTALLY = Integer.MIN_VALUE;
    protected static final int FLAG_FLIP_VERTICALLY = 0x40000000;
    protected static final int MASK_CLEAR = -536870912;
    protected boolean convertObjectToTileSpace;
    protected boolean flipY = true;
    protected TiledMap map;
    protected int mapHeightInPixels;
    protected int mapTileHeight;
    protected int mapTileWidth;
    protected int mapWidthInPixels;
    protected XmlReader.Element root;
    protected XmlReader xml = new XmlReader();

    public BaseTmxMapLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    private Object castProperty(String string2, String charSequence, String charSequence2) {
        if (charSequence2 == null) {
            return charSequence;
        }
        if (((String)charSequence2).equals("int")) {
            return Integer.valueOf((String)charSequence);
        }
        if (((String)charSequence2).equals("float")) {
            return Float.valueOf((String)charSequence);
        }
        if (((String)charSequence2).equals("bool")) {
            return Boolean.valueOf((String)charSequence);
        }
        if (((String)charSequence2).equals("color")) {
            string2 = ((String)charSequence).substring(3);
            charSequence = ((String)charSequence).substring(1, 3);
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append(string2);
            ((StringBuilder)charSequence2).append((String)charSequence);
            return Color.valueOf(((StringBuilder)charSequence2).toString());
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("Wrong type given for property ");
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(", given : ");
        ((StringBuilder)charSequence).append((String)charSequence2);
        ((StringBuilder)charSequence).append(", supported : string, bool, int, float, color");
        throw new GdxRuntimeException(((StringBuilder)charSequence).toString());
    }

    protected static FileHandle getRelativeFileHandle(FileHandle fileHandle, String object) {
        object = new StringTokenizer((String)object, "\\/");
        fileHandle = fileHandle.parent();
        while (((StringTokenizer)object).hasMoreElements()) {
            String string2 = ((StringTokenizer)object).nextToken();
            if (string2.equals("..")) {
                fileHandle = fileHandle.parent();
                continue;
            }
            fileHandle = fileHandle.child(string2);
        }
        return fileHandle;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] getTileIds(XmlReader.Element var0, int var1_1, int var2_2) {
        var3_3 = var0.getChildByName("data");
        var4_4 = null;
        var5_5 = null;
        var0 = var3_3.getAttribute("encoding", null);
        if (var0 == null) {
            var0 = new GdxRuntimeException("Unsupported encoding (XML) for TMX Layer Data");
            throw var0;
        }
        var6_6 = new int[var1_1 * var2_2];
        var7_7 = var0.equals("csv");
        var8_8 = 0;
        if (var7_7) {
            var0 = var3_3.getText().split(",");
            var1_1 = var8_8;
            while (var1_1 < ((String[])var0).length) {
                var6_6[var1_1] = (int)Long.parseLong(var0[var1_1].trim());
                ++var1_1;
            }
            return var6_6;
        }
        if (!var0.equals("base64")) {
            var9_11 = new StringBuilder();
            var9_11.append("Unrecognised encoding (");
            var9_11.append((String)var0);
            var9_11.append(") for TMX Layer Data");
            throw new GdxRuntimeException(var9_11.toString());
        }
        var0 = var5_5;
        var9_9 /* !! */  = var4_4;
        try {
            block17: {
                block16: {
                    var10_12 = var3_3.getAttribute("compression", null);
                    var0 = var5_5;
                    var9_9 /* !! */  = var4_4;
                    var3_3 = Base64Coder.decode(var3_3.getText());
                    if (var10_12 != null) break block16;
                    var0 = var5_5;
                    var9_9 /* !! */  = var4_4;
                    var0 = var5_5;
                    var9_9 /* !! */  = var4_4;
                    var10_12 = new ByteArrayInputStream((byte[])var3_3);
                    var0 = var10_12;
lbl42:
                    // 3 sources

                    while (true) {
                        var5_5 = var0;
                        var0 = var5_5;
                        var9_9 /* !! */  = var5_5;
                        var4_4 = new byte[4];
                        ** GOTO lbl102
                        break;
                    }
                }
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                if (!var10_12.equals("gzip")) break block17;
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var11_14 = new ByteArrayInputStream((byte[])var3_3);
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var10_12 = new GZIPInputStream((InputStream)var11_14, ((Object)var3_3).length);
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var5_5 = new BufferedInputStream((InputStream)var10_12);
                var0 = var5_5;
                ** GOTO lbl42
            }
            var0 = var5_5;
            var9_9 /* !! */  = var4_4;
            if (var10_12.equals("zlib")) {
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var11_14 = new ByteArrayInputStream((byte[])var3_3);
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var10_12 = new InflaterInputStream(var11_14);
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var5_5 = new BufferedInputStream((InputStream)var10_12);
                var0 = var5_5;
                ** continue;
            }
            ** GOTO lbl135
        }
        catch (IOException var10_13) {
            var0 = var9_9 /* !! */ ;
            var0 = var9_9 /* !! */ ;
            var0 = var9_9 /* !! */ ;
            var4_4 = new StringBuilder();
            var0 = var9_9 /* !! */ ;
            var4_4.append("Error Reading TMX Layer Data - IOException: ");
            var0 = var9_9 /* !! */ ;
            var4_4.append(var10_13.getMessage());
            var0 = var9_9 /* !! */ ;
            var5_5 = new GdxRuntimeException(var4_4.toString());
            var0 = var9_9 /* !! */ ;
            throw var5_5;
lbl102:
            // 2 sources

            for (var8_8 = 0; var8_8 < var2_2; ++var8_8) {
                for (var12_15 = 0; var12_15 < var1_1; ++var12_15) {
                    var0 = var5_5;
                    var9_9 /* !! */  = var5_5;
                    var13_16 = var5_5.read((byte[])var4_4);
                    while (true) {
                        var0 = var5_5;
                        var9_9 /* !! */  = var5_5;
                        if (var13_16 >= ((Object)var4_4).length) break;
                        var0 = var5_5;
                        var9_9 /* !! */  = var5_5;
                        var14_17 = var5_5.read((byte[])var4_4, var13_16, ((Object)var4_4).length - var13_16);
                        if (var14_17 == -1) break;
                        var13_16 += var14_17;
                    }
                    var0 = var5_5;
                    var9_9 /* !! */  = var5_5;
                    if (var13_16 == ((Object)var4_4).length) {
                        var0 = var5_5;
                        var9_9 /* !! */  = var5_5;
                        var6_6[var8_8 * var1_1 + var12_15] = BaseTmxMapLoader.unsignedByteToInt((byte)var4_4[0]) | BaseTmxMapLoader.unsignedByteToInt((byte)var4_4[1]) << 8 | BaseTmxMapLoader.unsignedByteToInt((byte)var4_4[2]) << 16 | BaseTmxMapLoader.unsignedByteToInt((byte)var4_4[3]) << 24;
                        continue;
                    }
                    var0 = var5_5;
                    var9_9 /* !! */  = var5_5;
                    var0 = var5_5;
                    var9_9 /* !! */  = var5_5;
                    var4_4 = new GdxRuntimeException("Error Reading TMX Layer Data: Premature end of tile data");
                    var0 = var5_5;
                    var9_9 /* !! */  = var5_5;
                    throw var4_4;
                }
            }
            StreamUtils.closeQuietly((Closeable)var5_5);
            return var6_6;
lbl135:
            // 1 sources

            var0 = var5_5;
            var9_9 /* !! */  = var4_4;
            {
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var6_6 = new StringBuilder;
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var6_6();
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var6_6.append("Unrecognised compression (");
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var6_6.append((String)var10_12);
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var6_6.append(") for TMX Layer Data");
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                var3_3 = new GdxRuntimeException(var6_6.toString());
                var0 = var5_5;
                var9_9 /* !! */  = var4_4;
                throw var3_3;
            }
            catch (Throwable var9_10) {}
        }
        StreamUtils.closeQuietly((Closeable)var0);
        throw var9_10;
    }

    protected static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    protected void addAnimatedTile(TiledMapTileSet tiledMapTileSet, TiledMapTile tiledMapTile, XmlReader.Element object, int n) {
        XmlReader.Element element2 = ((XmlReader.Element)object).getChildByName("animation");
        if (element2 != null) {
            object = new Array();
            IntArray intArray = new IntArray();
            for (XmlReader.Element element2 : element2.getChildrenByName("frame")) {
                ((Array)object).add((StaticTiledMapTile)tiledMapTileSet.getTile(element2.getIntAttribute("tileid") + n));
                intArray.add(element2.getIntAttribute("duration"));
            }
            object = new AnimatedTiledMapTile(intArray, (Array<StaticTiledMapTile>)object);
            ((AnimatedTiledMapTile)object).setId(tiledMapTile.getId());
            tiledMapTileSet.putTile(tiledMapTile.getId(), (TiledMapTile)object);
        }
    }

    protected void addStaticTiledMapTile(TiledMapTileSet tiledMapTileSet, TextureRegion object, int n, float f, float f2) {
        object = new StaticTiledMapTile((TextureRegion)object);
        object.setId(n);
        object.setOffsetX(f);
        f = f2;
        if (this.flipY) {
            f = -f2;
        }
        object.setOffsetY(f);
        tiledMapTileSet.putTile(n, (TiledMapTile)object);
    }

    protected abstract void addStaticTiles(FileHandle var1, ImageResolver var2, TiledMapTileSet var3, XmlReader.Element var4, Array<XmlReader.Element> var5, String var6, int var7, int var8, int var9, int var10, int var11, String var12, int var13, int var14, String var15, int var16, int var17, FileHandle var18);

    protected void addTileObjectGroup(TiledMapTile tiledMapTile, XmlReader.Element object) {
        if ((object = ((XmlReader.Element)object).getChildByName("objectgroup")) != null) {
            for (XmlReader.Element element : ((XmlReader.Element)object).getChildrenByName("object")) {
                this.loadObject(this.map, tiledMapTile, element);
            }
        }
    }

    protected void addTileProperties(TiledMapTile tiledMapTile, XmlReader.Element element) {
        String string2 = element.getAttribute("terrain", null);
        if (string2 != null) {
            tiledMapTile.getProperties().put("terrain", string2);
        }
        if ((string2 = element.getAttribute("probability", null)) != null) {
            tiledMapTile.getProperties().put("probability", string2);
        }
        if ((element = element.getChildByName("properties")) != null) {
            this.loadProperties(tiledMapTile.getProperties(), element);
        }
    }

    protected TiledMapTileLayer.Cell createTileLayerCell(boolean bl, boolean bl2, boolean bl3) {
        TiledMapTileLayer.Cell cell = new TiledMapTileLayer.Cell();
        if (bl3) {
            if (bl && bl2) {
                cell.setFlipHorizontally(true);
                cell.setRotation(3);
            } else if (bl) {
                cell.setRotation(3);
            } else if (bl2) {
                cell.setRotation(1);
            } else {
                cell.setFlipVertically(true);
                cell.setRotation(3);
            }
        } else {
            cell.setFlipHorizontally(bl);
            cell.setFlipVertically(bl2);
        }
        return cell;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String object, FileHandle fileHandle, P p) {
        this.root = this.xml.parse(fileHandle);
        object = new TextureLoader.TextureParameter();
        if (p != null) {
            ((TextureLoader.TextureParameter)object).genMipMaps = ((Parameters)p).generateMipMaps;
            ((TextureLoader.TextureParameter)object).minFilter = ((Parameters)p).textureMinFilter;
            ((TextureLoader.TextureParameter)object).magFilter = ((Parameters)p).textureMagFilter;
        }
        return this.getDependencyAssetDescriptors(fileHandle, (TextureLoader.TextureParameter)object);
    }

    protected abstract Array<AssetDescriptor> getDependencyAssetDescriptors(FileHandle var1, TextureLoader.TextureParameter var2);

    protected void loadBasicLayerInfo(MapLayer mapLayer, XmlReader.Element element) {
        String string2 = element.getAttribute("name", null);
        float f = Float.parseFloat(element.getAttribute("opacity", "1.0"));
        boolean bl = true;
        if (element.getIntAttribute("visible", 1) != 1) {
            bl = false;
        }
        float f2 = element.getFloatAttribute("offsetx", 0.0f);
        float f3 = element.getFloatAttribute("offsety", 0.0f);
        mapLayer.setName(string2);
        mapLayer.setOpacity(f);
        mapLayer.setVisible(bl);
        mapLayer.setOffsetX(f2);
        mapLayer.setOffsetY(f3);
    }

    protected void loadImageLayer(TiledMap object, MapLayers mapLayers, XmlReader.Element element, FileHandle fileHandle, ImageResolver imageResolver) {
        if (element.getName().equals("imagelayer")) {
            float f = element.hasAttribute("offsetx") ? Float.parseFloat(element.getAttribute("offsetx", "0")) : Float.parseFloat(element.getAttribute("x", "0"));
            float f2 = element.hasAttribute("offsety") ? Float.parseFloat(element.getAttribute("offsety", "0")) : Float.parseFloat(element.getAttribute("y", "0"));
            float f3 = f2;
            if (this.flipY) {
                f3 = (float)this.mapHeightInPixels - f2;
            }
            object = null;
            XmlReader.Element element2 = element.getChildByName("image");
            f2 = f3;
            if (element2 != null) {
                object = imageResolver.getImage(BaseTmxMapLoader.getRelativeFileHandle(fileHandle, element2.getAttribute("source")).path());
                f2 = f3 - (float)((TextureRegion)object).getRegionHeight();
            }
            object = new TiledMapImageLayer((TextureRegion)object, f, f2);
            this.loadBasicLayerInfo((MapLayer)object, element);
            element = element.getChildByName("properties");
            if (element != null) {
                this.loadProperties(((MapLayer)object).getProperties(), element);
            }
            mapLayers.add((MapLayer)object);
        }
    }

    protected void loadLayer(TiledMap tiledMap, MapLayers mapLayers, XmlReader.Element element, FileHandle fileHandle, ImageResolver imageResolver) {
        String string2 = element.getName();
        if (string2.equals("group")) {
            this.loadLayerGroup(tiledMap, mapLayers, element, fileHandle, imageResolver);
        } else if (string2.equals("layer")) {
            this.loadTileLayer(tiledMap, mapLayers, element);
        } else if (string2.equals("objectgroup")) {
            this.loadObjectGroup(tiledMap, mapLayers, element);
        } else if (string2.equals("imagelayer")) {
            this.loadImageLayer(tiledMap, mapLayers, element, fileHandle, imageResolver);
        }
    }

    protected void loadLayerGroup(TiledMap object, MapLayers mapLayers, XmlReader.Element element, FileHandle fileHandle, ImageResolver imageResolver) {
        if (element.getName().equals("group")) {
            MapGroupLayer mapGroupLayer = new MapGroupLayer();
            this.loadBasicLayerInfo(mapGroupLayer, element);
            XmlReader.Element element2 = element.getChildByName("properties");
            if (element2 != null) {
                this.loadProperties(mapGroupLayer.getProperties(), element2);
            }
            int n = element.getChildCount();
            for (int i = 0; i < n; ++i) {
                element2 = element.getChild(i);
                this.loadLayer((TiledMap)object, mapGroupLayer.getLayers(), element2, fileHandle, imageResolver);
            }
            object = mapGroupLayer.getLayers().iterator();
            while (object.hasNext()) {
                ((MapLayer)object.next()).setParent(mapGroupLayer);
            }
            mapLayers.add(mapGroupLayer);
        }
    }

    protected void loadObject(TiledMap tiledMap, MapLayer mapLayer, XmlReader.Element element) {
        this.loadObject(tiledMap, mapLayer.getObjects(), element, this.mapHeightInPixels);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void loadObject(TiledMap var1_1, MapObjects var2_2, XmlReader.Element var3_3, float var4_4) {
        block20: {
            if (!var3_3.getName().equals("object")) break block20;
            var5_5 = this.convertObjectToTileSpace;
            var6_6 = 1.0f;
            var7_7 = var5_5 != false ? 1.0f / (float)this.mapTileWidth : 1.0f;
            if (this.convertObjectToTileSpace) {
                var6_6 = 1.0f / (float)this.mapTileHeight;
            }
            var8_8 = var3_3.getFloatAttribute("x", 0.0f) * var7_7;
            var5_5 = this.flipY;
            var9_9 = "y";
            var4_4 = var5_5 ? (var4_4 -= var3_3.getFloatAttribute("y", 0.0f)) : var3_3.getFloatAttribute("y", 0.0f);
            var4_4 *= var6_6;
            var10_10 = var3_3.getFloatAttribute("width", 0.0f) * var7_7;
            var11_11 = var3_3.getFloatAttribute("height", 0.0f) * var6_6;
            if (var3_3.getChildCount() <= 0) ** GOTO lbl-1000
            var12_12 /* !! */  = var3_3.getChildByName("polygon");
            if (var12_12 /* !! */  != null) {
                var12_12 /* !! */  = var12_12 /* !! */ .getAttribute("points").split(" ");
                var13_13 = new float[var12_12 /* !! */ .length * 2];
                for (var14_15 = 0; var14_15 < var12_12 /* !! */ .length; ++var14_15) {
                    var15_16 = var12_12 /* !! */ [var14_15].split(",");
                    var16_18 = var14_15 * 2;
                    var13_13[var16_18] = Float.parseFloat(var15_16[0]) * var7_7;
                    var17_20 = Float.parseFloat(var15_16[1]);
                    var18_21 = this.flipY != false ? -1 : 1;
                    var13_13[var16_18 + 1] = var17_20 * var6_6 * (float)var18_21;
                }
                var12_12 /* !! */  = var9_9;
                var9_9 = new Polygon(var13_13);
                var9_9.setPosition(var8_8, var4_4);
                var9_9 = new PolygonMapObject((Polygon)var9_9);
            } else {
                var12_12 /* !! */  = "y";
                var9_9 = var3_3.getChildByName("polyline");
                if (var9_9 != null) {
                    var9_9 = var9_9.getAttribute("points").split(" ");
                    var13_14 = new float[((String[])var9_9).length * 2];
                    for (var14_15 = 0; var14_15 < ((Object)var9_9).length; ++var14_15) {
                        var15_17 = var9_9[var14_15].split(",");
                        var16_19 = var14_15 * 2;
                        var13_14[var16_19] = Float.parseFloat(var15_17[0]) * var7_7;
                        var17_20 = Float.parseFloat(var15_17[1]);
                        var18_22 = this.flipY != false ? -1 : 1;
                        var13_14[var16_19 + 1] = var17_20 * var6_6 * (float)var18_22;
                    }
                    var9_9 = new Polyline(var13_14);
                    var9_9.setPosition(var8_8, var4_4);
                    var9_9 = new PolylineMapObject((Polyline)var9_9);
                } else if (var3_3.getChildByName("ellipse") != null) {
                    var17_20 = this.flipY != false ? var4_4 - var11_11 : var4_4;
                    var9_9 = new EllipseMapObject(var8_8, var17_20, var10_10, var11_11);
                } else lbl-1000:
                // 2 sources

                {
                    var12_12 /* !! */  = "y";
                    var9_9 = null;
                }
            }
            if (var9_9 == null) {
                var9_9 = var3_3.getAttribute("gid", null);
                if (var9_9 != null) {
                    var14_15 = (int)Long.parseLong((String)var9_9);
                    var5_5 = (-2147483648 & var14_15) != 0;
                    var19_23 = (0x40000000 & var14_15) != 0;
                    var9_9 = new TiledMapTileMapObject(var1_1.getTileSets().getTile(var14_15 & 0x1FFFFFFF), var5_5, var19_23);
                    var1_1 = var9_9.getTextureRegion();
                    var9_9.getProperties().put("gid", var14_15);
                    var9_9.setX(var8_8);
                    var17_20 = this.flipY != false ? var4_4 : var4_4 - var11_11;
                    var9_9.setY(var17_20);
                    var17_20 = var3_3.getFloatAttribute("width", var1_1.getRegionWidth());
                    var20_24 = var3_3.getFloatAttribute("height", var1_1.getRegionHeight());
                    var9_9.setScaleX(var7_7 * (var17_20 / (float)var1_1.getRegionWidth()));
                    var9_9.setScaleY(var6_6 * (var20_24 / (float)var1_1.getRegionHeight()));
                    var9_9.setRotation(var3_3.getFloatAttribute("rotation", 0.0f));
                } else {
                    var7_7 = this.flipY != false ? var4_4 - var11_11 : var4_4;
                    var9_9 = new RectangleMapObject(var8_8, var7_7, var10_10, var11_11);
                }
            }
            var9_9.setName(var3_3.getAttribute("name", null));
            var1_1 = var3_3.getAttribute("rotation", null);
            if (var1_1 != null) {
                var9_9.getProperties().put("rotation", Float.valueOf(Float.parseFloat((String)var1_1)));
            }
            if ((var1_1 = var3_3.getAttribute("type", null)) != null) {
                var9_9.getProperties().put("type", var1_1);
            }
            var5_5 = false;
            var14_15 = var3_3.getIntAttribute("id", 0);
            if (var14_15 != 0) {
                var9_9.getProperties().put("id", var14_15);
            }
            var9_9.getProperties().put("x", Float.valueOf(var8_8));
            if (var9_9 instanceof TiledMapTileMapObject) {
                var9_9.getProperties().put((String)var12_12 /* !! */ , Float.valueOf(var4_4));
            } else {
                var1_1 = var9_9.getProperties();
                var7_7 = var4_4;
                if (this.flipY) {
                    var7_7 = var4_4 - var11_11;
                }
                var1_1.put((String)var12_12 /* !! */ , Float.valueOf(var7_7));
            }
            var9_9.getProperties().put("width", Float.valueOf(var10_10));
            var9_9.getProperties().put("height", Float.valueOf(var11_11));
            if (var3_3.getIntAttribute("visible", 1) == 1) {
                var5_5 = true;
            }
            var9_9.setVisible(var5_5);
            var1_1 = var3_3.getChildByName("properties");
            if (var1_1 != null) {
                this.loadProperties(var9_9.getProperties(), (XmlReader.Element)var1_1);
            }
            var2_2.add((MapObject)var9_9);
        }
    }

    protected void loadObject(TiledMap tiledMap, TiledMapTile tiledMapTile, XmlReader.Element element) {
        this.loadObject(tiledMap, tiledMapTile.getObjects(), element, tiledMapTile.getTextureRegion().getRegionHeight());
    }

    protected void loadObjectGroup(TiledMap tiledMap, MapLayers mapLayers, XmlReader.Element object) {
        if (((XmlReader.Element)object).getName().equals("objectgroup")) {
            MapLayer mapLayer = new MapLayer();
            this.loadBasicLayerInfo(mapLayer, (XmlReader.Element)object);
            XmlReader.Element element = ((XmlReader.Element)object).getChildByName("properties");
            if (element != null) {
                this.loadProperties(mapLayer.getProperties(), element);
            }
            object = ((XmlReader.Element)object).getChildrenByName("object").iterator();
            while (object.hasNext()) {
                this.loadObject(tiledMap, mapLayer, (XmlReader.Element)object.next());
            }
            mapLayers.add(mapLayer);
        }
    }

    protected void loadProperties(MapProperties mapProperties, XmlReader.Element object) {
        if (object == null) {
            return;
        }
        if (((XmlReader.Element)object).getName().equals("properties")) {
            for (XmlReader.Element element : ((XmlReader.Element)object).getChildrenByName("property")) {
                String string2 = element.getAttribute("name", null);
                String string3 = element.getAttribute("value", null);
                String string4 = element.getAttribute("type", null);
                object = string3;
                if (string3 == null) {
                    object = element.getText();
                }
                mapProperties.put(string2, this.castProperty(string2, (String)object, string4));
            }
        }
    }

    protected void loadTileLayer(TiledMap object, MapLayers mapLayers, XmlReader.Element element) {
        if (element.getName().equals("layer")) {
            int n = element.getIntAttribute("width", 0);
            int n2 = element.getIntAttribute("height", 0);
            TiledMapTileLayer tiledMapTileLayer = new TiledMapTileLayer(n, n2, ((Map)object).getProperties().get("tilewidth", Integer.class), ((Map)object).getProperties().get("tileheight", Integer.class));
            this.loadBasicLayerInfo(tiledMapTileLayer, element);
            int[] nArray = BaseTmxMapLoader.getTileIds(element, n, n2);
            TiledMapTileSets tiledMapTileSets = ((TiledMap)object).getTileSets();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n3 = nArray[i * n + j];
                    boolean bl = true;
                    boolean bl2 = (Integer.MIN_VALUE & n3) != 0;
                    boolean bl3 = (0x40000000 & n3) != 0;
                    if ((0x20000000 & n3) == 0) {
                        bl = false;
                    }
                    TiledMapTile tiledMapTile = tiledMapTileSets.getTile(n3 & 0x1FFFFFFF);
                    if (tiledMapTile == null) continue;
                    object = this.createTileLayerCell(bl2, bl3, bl);
                    ((TiledMapTileLayer.Cell)object).setTile(tiledMapTile);
                    n3 = this.flipY ? n2 - 1 - i : i;
                    tiledMapTileLayer.setCell(j, n3, (TiledMapTileLayer.Cell)object);
                }
            }
            object = element.getChildByName("properties");
            if (object != null) {
                this.loadProperties(tiledMapTileLayer.getProperties(), (XmlReader.Element)object);
            }
            mapLayers.add(tiledMapTileLayer);
        }
    }

    protected void loadTileSet(XmlReader.Element iterator, FileHandle object, ImageResolver object2) {
        block10: {
            int n;
            int n2;
            int n3;
            int n4;
            Object object3;
            Object object4;
            Object object5;
            String string2;
            Object object6;
            block12: {
                block11: {
                    block9: {
                        if (!((XmlReader.Element)((Object)iterator)).getName().equals("tileset")) break block10;
                        object6 = "";
                        string2 = ((XmlReader.Element)((Object)iterator)).getAttribute("source", null);
                        if (string2 == null) break block11;
                        object5 = BaseTmxMapLoader.getRelativeFileHandle((FileHandle)object, string2);
                        try {
                            object4 = this.xml.parse((FileHandle)object5);
                            object3 = ((XmlReader.Element)object4).getChildByName("image");
                            if (object3 == null) break block9;
                        }
                        catch (SerializationException serializationException) {
                            throw new GdxRuntimeException("Error parsing external tileset.");
                        }
                        iterator = ((XmlReader.Element)object3).getAttribute("source");
                        n4 = ((XmlReader.Element)object3).getIntAttribute("width", 0);
                        n3 = ((XmlReader.Element)object3).getIntAttribute("height", 0);
                        object6 = BaseTmxMapLoader.getRelativeFileHandle((FileHandle)object5, (String)((Object)iterator));
                    }
                    object5 = null;
                    n4 = 0;
                    n3 = 0;
                    iterator = object6;
                    object6 = object5;
                    object5 = object6;
                    object6 = iterator;
                    iterator = object4;
                    break block12;
                }
                object5 = ((XmlReader.Element)((Object)iterator)).getChildByName("image");
                if (object5 != null) {
                    object6 = ((XmlReader.Element)object5).getAttribute("source");
                    n4 = ((XmlReader.Element)object5).getIntAttribute("width", 0);
                    n3 = ((XmlReader.Element)object5).getIntAttribute("height", 0);
                    object5 = BaseTmxMapLoader.getRelativeFileHandle((FileHandle)object, (String)object6);
                } else {
                    object6 = "";
                    object5 = null;
                    n3 = 0;
                    n4 = 0;
                }
            }
            String string3 = ((XmlReader.Element)((Object)iterator)).get("name", null);
            int n5 = ((XmlReader.Element)((Object)iterator)).getIntAttribute("firstgid", 1);
            int n6 = ((XmlReader.Element)((Object)iterator)).getIntAttribute("tilewidth", 0);
            int n7 = ((XmlReader.Element)((Object)iterator)).getIntAttribute("tileheight", 0);
            int n8 = ((XmlReader.Element)((Object)iterator)).getIntAttribute("spacing", 0);
            int n9 = ((XmlReader.Element)((Object)iterator)).getIntAttribute("margin", 0);
            object4 = ((XmlReader.Element)((Object)iterator)).getChildByName("tileoffset");
            if (object4 != null) {
                n2 = ((XmlReader.Element)object4).getIntAttribute("x", 0);
                n = ((XmlReader.Element)object4).getIntAttribute("y", 0);
            } else {
                n2 = 0;
                n = 0;
            }
            object3 = new TiledMapTileSet();
            ((TiledMapTileSet)object3).setName(string3);
            object4 = ((TiledMapTileSet)object3).getProperties();
            Object object7 = ((XmlReader.Element)((Object)iterator)).getChildByName("properties");
            if (object7 != null) {
                this.loadProperties((MapProperties)object4, (XmlReader.Element)object7);
            }
            ((MapProperties)object4).put("firstgid", n5);
            object7 = ((XmlReader.Element)((Object)iterator)).getChildrenByName("tile");
            object4 = object3;
            int n10 = n5;
            this.addStaticTiles((FileHandle)object, (ImageResolver)object2, (TiledMapTileSet)object3, (XmlReader.Element)((Object)iterator), (Array<XmlReader.Element>)object7, string3, n5, n6, n7, n8, n9, string2, n2, n, (String)object6, n4, n3, (FileHandle)object5);
            iterator = ((Array)object7).iterator();
            while (iterator.hasNext()) {
                object = (XmlReader.Element)iterator.next();
                object2 = ((TiledMapTileSet)object4).getTile(n10 + ((XmlReader.Element)object).getIntAttribute("id", 0));
                if (object2 == null) continue;
                this.addTileProperties((TiledMapTile)object2, (XmlReader.Element)object);
                this.addTileObjectGroup((TiledMapTile)object2, (XmlReader.Element)object);
                this.addAnimatedTile((TiledMapTileSet)object4, (TiledMapTile)object2, (XmlReader.Element)object, n10);
            }
            this.map.getTileSets().addTileSet((TiledMapTileSet)object4);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected TiledMap loadTiledMap(FileHandle fileHandle, P object3, ImageResolver imageResolver) {
        void var3_9;
        XmlReader.Element element;
        this.map = new TiledMap();
        if (object3 != null) {
            this.convertObjectToTileSpace = ((Parameters)object3).convertObjectToTileSpace;
            this.flipY = ((Parameters)object3).flipY;
        } else {
            this.convertObjectToTileSpace = false;
            this.flipY = true;
        }
        String string2 = this.root.getAttribute("orientation", null);
        int n = this.root.getIntAttribute("width", 0);
        int n2 = this.root.getIntAttribute("height", 0);
        int n3 = this.root.getIntAttribute("tilewidth", 0);
        int n4 = this.root.getIntAttribute("tileheight", 0);
        int n5 = this.root.getIntAttribute("hexsidelength", 0);
        Object object = this.root.getAttribute("staggeraxis", null);
        String string3 = this.root.getAttribute("staggerindex", null);
        String string4 = this.root.getAttribute("backgroundcolor", null);
        MapProperties mapProperties = this.map.getProperties();
        if (string2 != null) {
            mapProperties.put("orientation", string2);
        }
        mapProperties.put("width", n);
        mapProperties.put("height", n2);
        mapProperties.put("tilewidth", n3);
        mapProperties.put("tileheight", n4);
        mapProperties.put("hexsidelength", n5);
        if (object != null) {
            mapProperties.put("staggeraxis", object);
        }
        if (string3 != null) {
            mapProperties.put("staggerindex", string3);
        }
        if (string4 != null) {
            mapProperties.put("backgroundcolor", string4);
        }
        this.mapTileWidth = n3;
        this.mapTileHeight = n4;
        this.mapWidthInPixels = n * n3;
        this.mapHeightInPixels = n2 * n4;
        if (string2 != null && "staggered".equals(string2) && n2 > 1) {
            this.mapWidthInPixels += n3 / 2;
            this.mapHeightInPixels = this.mapHeightInPixels / 2 + n4 / 2;
        }
        if ((element = this.root.getChildByName("properties")) != null) {
            this.loadProperties(this.map.getProperties(), element);
        }
        for (XmlReader.Element element2 : this.root.getChildrenByName("tileset")) {
            this.loadTileSet(element2, fileHandle, (ImageResolver)var3_9);
            this.root.removeChild(element2);
        }
        n = this.root.getChildCount();
        for (n5 = 0; n5 < n; ++n5) {
            XmlReader.Element element3 = this.root.getChild(n5);
            object = this.map;
            this.loadLayer((TiledMap)object, ((Map)object).getLayers(), element3, fileHandle, (ImageResolver)var3_9);
        }
        return this.map;
    }

    public static class Parameters
    extends AssetLoaderParameters<TiledMap> {
        public boolean convertObjectToTileSpace = false;
        public boolean flipY = true;
        public boolean generateMipMaps = false;
        public Texture.TextureFilter textureMagFilter;
        public Texture.TextureFilter textureMinFilter = Texture.TextureFilter.Nearest;

        public Parameters() {
            this.textureMagFilter = Texture.TextureFilter.Nearest;
        }
    }
}

