/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps;

import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import java.util.Iterator;

public class MapLayers
implements Iterable<MapLayer> {
    private Array<MapLayer> layers = new Array();

    public void add(MapLayer mapLayer) {
        this.layers.add(mapLayer);
    }

    public MapLayer get(int n) {
        return this.layers.get(n);
    }

    public MapLayer get(String string2) {
        int n = this.layers.size;
        for (int i = 0; i < n; ++i) {
            MapLayer mapLayer = this.layers.get(i);
            if (!string2.equals(mapLayer.getName())) continue;
            return mapLayer;
        }
        return null;
    }

    public <T extends MapLayer> Array<T> getByType(Class<T> clazz) {
        return this.getByType(clazz, new Array());
    }

    public <T extends MapLayer> Array<T> getByType(Class<T> clazz, Array<T> array) {
        array.clear();
        int n = this.layers.size;
        for (int i = 0; i < n; ++i) {
            MapLayer mapLayer = this.layers.get(i);
            if (!ClassReflection.isInstance(clazz, mapLayer)) continue;
            array.add(mapLayer);
        }
        return array;
    }

    public int getCount() {
        return this.layers.size;
    }

    public int getIndex(MapLayer mapLayer) {
        return this.layers.indexOf(mapLayer, true);
    }

    public int getIndex(String string2) {
        return this.getIndex(this.get(string2));
    }

    @Override
    public Iterator<MapLayer> iterator() {
        return this.layers.iterator();
    }

    public void remove(int n) {
        this.layers.removeIndex(n);
    }

    public void remove(MapLayer mapLayer) {
        this.layers.removeValue(mapLayer, true);
    }

    public int size() {
        return this.layers.size;
    }
}

