/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.input;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import java.io.DataOutputStream;
import java.net.Socket;

public class RemoteSender
implements InputProcessor {
    public static final int ACCEL = 6;
    public static final int COMPASS = 7;
    public static final int GYRO = 9;
    public static final int KEY_DOWN = 0;
    public static final int KEY_TYPED = 2;
    public static final int KEY_UP = 1;
    public static final int SIZE = 8;
    public static final int TOUCH_DOWN = 3;
    public static final int TOUCH_DRAGGED = 5;
    public static final int TOUCH_UP = 4;
    private boolean connected = false;
    private DataOutputStream out;

    public RemoteSender(String string2, int n) {
        try {
            DataOutputStream dataOutputStream;
            Socket socket = new Socket(string2, n);
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(3000);
            this.out = dataOutputStream = new DataOutputStream(socket.getOutputStream());
            this.out.writeBoolean(Gdx.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen));
            this.connected = true;
            Gdx.input.setInputProcessor(this);
        }
        catch (Exception exception) {
            Application application = Gdx.app;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("couldn't connect to ");
            stringBuilder.append(string2);
            stringBuilder.append(":");
            stringBuilder.append(n);
            application.log("RemoteSender", stringBuilder.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnected() {
        synchronized (this) {
            return this.connected;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean keyDown(int n) {
        // MONITORENTER : this
        if (!this.connected) {
            // MONITOREXIT : this
            return false;
        }
        // MONITOREXIT : this
        try {
            this.out.writeInt(0);
            this.out.writeInt(n);
            return false;
        }
        catch (Throwable throwable) {
            // MONITORENTER : this
            this.connected = false;
            // MONITOREXIT : this
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean keyTyped(char c) {
        // MONITORENTER : this
        if (!this.connected) {
            // MONITOREXIT : this
            return false;
        }
        // MONITOREXIT : this
        try {
            this.out.writeInt(2);
            this.out.writeChar(c);
            return false;
        }
        catch (Throwable throwable) {
            // MONITORENTER : this
            this.connected = false;
            // MONITOREXIT : this
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean keyUp(int n) {
        // MONITORENTER : this
        if (!this.connected) {
            // MONITOREXIT : this
            return false;
        }
        // MONITOREXIT : this
        try {
            this.out.writeInt(1);
            this.out.writeInt(n);
            return false;
        }
        catch (Throwable throwable) {
            // MONITORENTER : this
            this.connected = false;
            // MONITOREXIT : this
        }
        return false;
    }

    @Override
    public boolean mouseMoved(int n, int n2) {
        return false;
    }

    @Override
    public boolean scrolled(int n) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendUpdate() {
        synchronized (this) {
            if (!this.connected) {
                return;
            }
        }
        try {
            this.out.writeInt(6);
            this.out.writeFloat(Gdx.input.getAccelerometerX());
            this.out.writeFloat(Gdx.input.getAccelerometerY());
            this.out.writeFloat(Gdx.input.getAccelerometerZ());
            this.out.writeInt(7);
            this.out.writeFloat(Gdx.input.getAzimuth());
            this.out.writeFloat(Gdx.input.getPitch());
            this.out.writeFloat(Gdx.input.getRoll());
            this.out.writeInt(8);
            this.out.writeFloat(Gdx.graphics.getWidth());
            this.out.writeFloat(Gdx.graphics.getHeight());
            this.out.writeInt(9);
            this.out.writeFloat(Gdx.input.getGyroscopeX());
            this.out.writeFloat(Gdx.input.getGyroscopeY());
            this.out.writeFloat(Gdx.input.getGyroscopeZ());
            return;
        }
        catch (Throwable throwable) {
            this.out = null;
            this.connected = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean touchDown(int n, int n2, int n3, int n4) {
        // MONITORENTER : this
        if (!this.connected) {
            // MONITOREXIT : this
            return false;
        }
        // MONITOREXIT : this
        try {
            this.out.writeInt(3);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            return false;
        }
        catch (Throwable throwable) {
            // MONITORENTER : this
            this.connected = false;
            // MONITOREXIT : this
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean touchDragged(int n, int n2, int n3) {
        // MONITORENTER : this
        if (!this.connected) {
            // MONITOREXIT : this
            return false;
        }
        // MONITOREXIT : this
        try {
            this.out.writeInt(5);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            return false;
        }
        catch (Throwable throwable) {
            // MONITORENTER : this
            this.connected = false;
            // MONITOREXIT : this
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean touchUp(int n, int n2, int n3, int n4) {
        // MONITORENTER : this
        if (!this.connected) {
            // MONITOREXIT : this
            return false;
        }
        // MONITOREXIT : this
        try {
            this.out.writeInt(4);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            return false;
        }
        catch (Throwable throwable) {
            // MONITORENTER : this
            this.connected = false;
            // MONITOREXIT : this
        }
        return false;
    }
}

