/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.TimeUtils;
import com.badlogic.gdx.utils.Timer;

public class GestureDetector
extends InputAdapter {
    private long gestureStartTime;
    private boolean inTapRectangle;
    private final Vector2 initialPointer1;
    private final Vector2 initialPointer2;
    private int lastTapButton;
    private int lastTapPointer;
    private long lastTapTime;
    private float lastTapX;
    private float lastTapY;
    final GestureListener listener;
    boolean longPressFired;
    private float longPressSeconds;
    private final Timer.Task longPressTask;
    private long maxFlingDelay;
    private boolean panning;
    private boolean pinching;
    Vector2 pointer1;
    private final Vector2 pointer2;
    private int tapCount;
    private long tapCountInterval;
    private float tapRectangleCenterX;
    private float tapRectangleCenterY;
    private float tapRectangleHeight;
    private float tapRectangleWidth;
    private final VelocityTracker tracker = new VelocityTracker();

    public GestureDetector(float f, float f2, float f3, float f4, float f5, GestureListener gestureListener) {
        this.pointer1 = new Vector2();
        this.pointer2 = new Vector2();
        this.initialPointer1 = new Vector2();
        this.initialPointer2 = new Vector2();
        this.longPressTask = new Timer.Task(){

            @Override
            public void run() {
                if (!GestureDetector.this.longPressFired) {
                    GestureDetector gestureDetector = GestureDetector.this;
                    gestureDetector.longPressFired = gestureDetector.listener.longPress(GestureDetector.this.pointer1.x, GestureDetector.this.pointer1.y);
                }
            }
        };
        if (gestureListener != null) {
            this.tapRectangleWidth = f;
            this.tapRectangleHeight = f2;
            this.tapCountInterval = (long)(f3 * 1.0E9f);
            this.longPressSeconds = f4;
            this.maxFlingDelay = (long)(f5 * 1.0E9f);
            this.listener = gestureListener;
            return;
        }
        throw new IllegalArgumentException("listener cannot be null.");
    }

    public GestureDetector(float f, float f2, float f3, float f4, GestureListener gestureListener) {
        this(f, f, f2, f3, f4, gestureListener);
    }

    public GestureDetector(GestureListener gestureListener) {
        this(20.0f, 0.4f, 1.1f, 0.15f, gestureListener);
    }

    private boolean isWithinTapRectangle(float f, float f2, float f3, float f4) {
        boolean bl = Math.abs(f - f3) < this.tapRectangleWidth && Math.abs(f2 - f4) < this.tapRectangleHeight;
        return bl;
    }

    public void cancel() {
        this.longPressTask.cancel();
        this.longPressFired = true;
    }

    public void invalidateTapSquare() {
        this.inTapRectangle = false;
    }

    public boolean isLongPressed() {
        return this.isLongPressed(this.longPressSeconds);
    }

    public boolean isLongPressed(float f) {
        long l = this.gestureStartTime;
        boolean bl = false;
        if (l == 0L) {
            return false;
        }
        if (TimeUtils.nanoTime() - this.gestureStartTime > (long)(f * 1.0E9f)) {
            bl = true;
        }
        return bl;
    }

    public boolean isPanning() {
        return this.panning;
    }

    public void reset() {
        this.gestureStartTime = 0L;
        this.panning = false;
        this.inTapRectangle = false;
        this.tracker.lastTime = 0L;
    }

    public void setLongPressSeconds(float f) {
        this.longPressSeconds = f;
    }

    public void setMaxFlingDelay(long l) {
        this.maxFlingDelay = l;
    }

    public void setTapCountInterval(float f) {
        this.tapCountInterval = (long)(f * 1.0E9f);
    }

    public void setTapRectangleSize(float f, float f2) {
        this.tapRectangleWidth = f;
        this.tapRectangleHeight = f2;
    }

    public void setTapSquareSize(float f) {
        this.setTapRectangleSize(f, f);
    }

    public boolean touchDown(float f, float f2, int n, int n2) {
        if (n > 1) {
            return false;
        }
        if (n == 0) {
            this.pointer1.set(f, f2);
            this.gestureStartTime = Gdx.input.getCurrentEventTime();
            this.tracker.start(f, f2, this.gestureStartTime);
            if (Gdx.input.isTouched(1)) {
                this.inTapRectangle = false;
                this.pinching = true;
                this.initialPointer1.set(this.pointer1);
                this.initialPointer2.set(this.pointer2);
                this.longPressTask.cancel();
            } else {
                this.inTapRectangle = true;
                this.pinching = false;
                this.longPressFired = false;
                this.tapRectangleCenterX = f;
                this.tapRectangleCenterY = f2;
                if (!this.longPressTask.isScheduled()) {
                    Timer.schedule(this.longPressTask, this.longPressSeconds);
                }
            }
        } else {
            this.pointer2.set(f, f2);
            this.inTapRectangle = false;
            this.pinching = true;
            this.initialPointer1.set(this.pointer1);
            this.initialPointer2.set(this.pointer2);
            this.longPressTask.cancel();
        }
        return this.listener.touchDown(f, f2, n, n2);
    }

    @Override
    public boolean touchDown(int n, int n2, int n3, int n4) {
        return this.touchDown((float)n, (float)n2, n3, n4);
    }

    public boolean touchDragged(float f, float f2, int n) {
        boolean bl = true;
        if (n > 1) {
            return false;
        }
        if (this.longPressFired) {
            return false;
        }
        if (n == 0) {
            this.pointer1.set(f, f2);
        } else {
            this.pointer2.set(f, f2);
        }
        if (this.pinching) {
            GestureListener gestureListener = this.listener;
            if (gestureListener != null) {
                boolean bl2 = gestureListener.pinch(this.initialPointer1, this.initialPointer2, this.pointer1, this.pointer2);
                boolean bl3 = bl;
                if (!this.listener.zoom(this.initialPointer1.dst(this.initialPointer2), this.pointer1.dst(this.pointer2))) {
                    bl3 = bl2 ? bl : false;
                }
                return bl3;
            }
            return false;
        }
        this.tracker.update(f, f2, Gdx.input.getCurrentEventTime());
        if (this.inTapRectangle && !this.isWithinTapRectangle(f, f2, this.tapRectangleCenterX, this.tapRectangleCenterY)) {
            this.longPressTask.cancel();
            this.inTapRectangle = false;
        }
        if (!this.inTapRectangle) {
            this.panning = true;
            return this.listener.pan(f, f2, this.tracker.deltaX, this.tracker.deltaY);
        }
        return false;
    }

    @Override
    public boolean touchDragged(int n, int n2, int n3) {
        return this.touchDragged((float)n, (float)n2, n3);
    }

    public boolean touchUp(float f, float f2, int n, int n2) {
        if (n > 1) {
            return false;
        }
        if (this.inTapRectangle && !this.isWithinTapRectangle(f, f2, this.tapRectangleCenterX, this.tapRectangleCenterY)) {
            this.inTapRectangle = false;
        }
        boolean bl = this.panning;
        this.panning = false;
        this.longPressTask.cancel();
        if (this.longPressFired) {
            return false;
        }
        if (this.inTapRectangle) {
            if (this.lastTapButton != n2 || this.lastTapPointer != n || TimeUtils.nanoTime() - this.lastTapTime > this.tapCountInterval || !this.isWithinTapRectangle(f, f2, this.lastTapX, this.lastTapY)) {
                this.tapCount = 0;
            }
            ++this.tapCount;
            this.lastTapTime = TimeUtils.nanoTime();
            this.lastTapX = f;
            this.lastTapY = f2;
            this.lastTapButton = n2;
            this.lastTapPointer = n;
            this.gestureStartTime = 0L;
            return this.listener.tap(f, f2, this.tapCount, n2);
        }
        if (this.pinching) {
            this.pinching = false;
            this.listener.pinchStop();
            this.panning = true;
            if (n == 0) {
                this.tracker.start(this.pointer2.x, this.pointer2.y, Gdx.input.getCurrentEventTime());
            } else {
                this.tracker.start(this.pointer1.x, this.pointer1.y, Gdx.input.getCurrentEventTime());
            }
            return false;
        }
        bl = bl && !this.panning ? this.listener.panStop(f, f2, n, n2) : false;
        this.gestureStartTime = 0L;
        long l = Gdx.input.getCurrentEventTime();
        boolean bl2 = bl;
        if (l - this.tracker.lastTime < this.maxFlingDelay) {
            this.tracker.update(f, f2, l);
            bl2 = this.listener.fling(this.tracker.getVelocityX(), this.tracker.getVelocityY(), n2) || bl;
        }
        return bl2;
    }

    @Override
    public boolean touchUp(int n, int n2, int n3, int n4) {
        return this.touchUp((float)n, (float)n2, n3, n4);
    }

    public static class GestureAdapter
    implements GestureListener {
        @Override
        public boolean fling(float f, float f2, int n) {
            return false;
        }

        @Override
        public boolean longPress(float f, float f2) {
            return false;
        }

        @Override
        public boolean pan(float f, float f2, float f3, float f4) {
            return false;
        }

        @Override
        public boolean panStop(float f, float f2, int n, int n2) {
            return false;
        }

        @Override
        public boolean pinch(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
            return false;
        }

        @Override
        public void pinchStop() {
        }

        @Override
        public boolean tap(float f, float f2, int n, int n2) {
            return false;
        }

        @Override
        public boolean touchDown(float f, float f2, int n, int n2) {
            return false;
        }

        @Override
        public boolean zoom(float f, float f2) {
            return false;
        }
    }

    public static interface GestureListener {
        public boolean fling(float var1, float var2, int var3);

        public boolean longPress(float var1, float var2);

        public boolean pan(float var1, float var2, float var3, float var4);

        public boolean panStop(float var1, float var2, int var3, int var4);

        public boolean pinch(Vector2 var1, Vector2 var2, Vector2 var3, Vector2 var4);

        public void pinchStop();

        public boolean tap(float var1, float var2, int var3, int var4);

        public boolean touchDown(float var1, float var2, int var3, int var4);

        public boolean zoom(float var1, float var2);
    }

    static class VelocityTracker {
        float deltaX;
        float deltaY;
        long lastTime;
        float lastX;
        float lastY;
        long[] meanTime;
        float[] meanX;
        float[] meanY;
        int numSamples;
        int sampleSize;

        VelocityTracker() {
            int n = this.sampleSize = 10;
            this.meanX = new float[n];
            this.meanY = new float[n];
            this.meanTime = new long[n];
        }

        private float getAverage(float[] fArray, int n) {
            int n2 = Math.min(this.sampleSize, n);
            float f = 0.0f;
            for (n = 0; n < n2; ++n) {
                f += fArray[n];
            }
            return f / (float)n2;
        }

        private long getAverage(long[] lArray, int n) {
            int n2 = Math.min(this.sampleSize, n);
            long l = 0L;
            for (n = 0; n < n2; ++n) {
                l += lArray[n];
            }
            if (n2 == 0) {
                return 0L;
            }
            return l / (long)n2;
        }

        private float getSum(float[] fArray, int n) {
            int n2 = Math.min(this.sampleSize, n);
            float f = 0.0f;
            for (n = 0; n < n2; ++n) {
                f += fArray[n];
            }
            if (n2 == 0) {
                return 0.0f;
            }
            return f;
        }

        public float getVelocityX() {
            float f = this.getAverage(this.meanX, this.numSamples);
            float f2 = (float)this.getAverage(this.meanTime, this.numSamples) / 1.0E9f;
            if (f2 == 0.0f) {
                return 0.0f;
            }
            return f / f2;
        }

        public float getVelocityY() {
            float f = this.getAverage(this.meanY, this.numSamples);
            float f2 = (float)this.getAverage(this.meanTime, this.numSamples) / 1.0E9f;
            if (f2 == 0.0f) {
                return 0.0f;
            }
            return f / f2;
        }

        public void start(float f, float f2, long l) {
            this.lastX = f;
            this.lastY = f2;
            this.deltaX = 0.0f;
            this.deltaY = 0.0f;
            this.numSamples = 0;
            for (int i = 0; i < this.sampleSize; ++i) {
                this.meanX[i] = 0.0f;
                this.meanY[i] = 0.0f;
                this.meanTime[i] = 0L;
            }
            this.lastTime = l;
        }

        public void update(float f, float f2, long l) {
            this.deltaX = f - this.lastX;
            this.deltaY = f2 - this.lastY;
            this.lastX = f;
            this.lastY = f2;
            long l2 = this.lastTime;
            this.lastTime = l;
            int n = this.numSamples;
            int n2 = n % this.sampleSize;
            this.meanX[n2] = this.deltaX;
            this.meanY[n2] = this.deltaY;
            this.meanTime[n2] = l - l2;
            this.numSamples = n + 1;
        }
    }
}

