/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GLVersion {
    private final String TAG;
    private int majorVersion;
    private int minorVersion;
    private int releaseVersion;
    private final String rendererString;
    private final Type type;
    private final String vendorString;

    public GLVersion(Application.ApplicationType applicationType, String string2, String string3, String string4) {
        this.TAG = "GLVersion";
        this.type = applicationType == Application.ApplicationType.Android ? Type.GLES : (applicationType == Application.ApplicationType.iOS ? Type.GLES : (applicationType == Application.ApplicationType.Desktop ? Type.OpenGL : (applicationType == Application.ApplicationType.Applet ? Type.OpenGL : (applicationType == Application.ApplicationType.WebGL ? Type.WebGL : Type.NONE))));
        if (this.type == Type.GLES) {
            this.extractVersion("OpenGL ES (\\d(\\.\\d){0,2})", string2);
        } else if (this.type == Type.WebGL) {
            this.extractVersion("WebGL (\\d(\\.\\d){0,2})", string2);
        } else if (this.type == Type.OpenGL) {
            this.extractVersion("(\\d(\\.\\d){0,2})", string2);
        } else {
            this.majorVersion = -1;
            this.minorVersion = -1;
            this.releaseVersion = -1;
            string4 = string3 = "";
        }
        this.vendorString = string3;
        this.rendererString = string4;
    }

    private void extractVersion(String object, String string2) {
        object = Pattern.compile((String)object).matcher(string2);
        boolean bl = ((Matcher)object).find();
        int n = 0;
        if (bl) {
            object = ((Matcher)object).group(1).split("\\.");
            this.majorVersion = this.parseInt((String)object[0], 2);
            int n2 = ((Object)object).length < 2 ? 0 : this.parseInt((String)object[1], 0);
            this.minorVersion = n2;
            n2 = ((Object)object).length < 3 ? n : this.parseInt((String)object[2], 0);
            this.releaseVersion = n2;
        } else {
            Application application = Gdx.app;
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid version string: ");
            ((StringBuilder)object).append(string2);
            application.log("GLVersion", ((StringBuilder)object).toString());
            this.majorVersion = 2;
            this.minorVersion = 0;
            this.releaseVersion = 0;
        }
    }

    private int parseInt(String string2, int n) {
        try {
            int n2 = Integer.parseInt(string2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            Application application = Gdx.app;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error parsing number: ");
            stringBuilder.append(string2);
            stringBuilder.append(", assuming: ");
            stringBuilder.append(n);
            application.error("LibGDX GL", stringBuilder.toString());
            return n;
        }
    }

    public String getDebugVersionString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Type: ");
        stringBuilder.append((Object)this.type);
        stringBuilder.append("\nVersion: ");
        stringBuilder.append(this.majorVersion);
        stringBuilder.append(":");
        stringBuilder.append(this.minorVersion);
        stringBuilder.append(":");
        stringBuilder.append(this.releaseVersion);
        stringBuilder.append("\nVendor: ");
        stringBuilder.append(this.vendorString);
        stringBuilder.append("\nRenderer: ");
        stringBuilder.append(this.rendererString);
        return stringBuilder.toString();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getRendererString() {
        return this.rendererString;
    }

    public Type getType() {
        return this.type;
    }

    public String getVendorString() {
        return this.vendorString;
    }

    public boolean isVersionEqualToOrHigher(int n, int n2) {
        int n3 = this.majorVersion;
        boolean bl = n3 > n || n3 == n && this.minorVersion >= n2;
        return bl;
    }

    public static enum Type {
        OpenGL,
        GLES,
        WebGL,
        NONE;

    }
}

