/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.FloatFrameBuffer;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.FrameBufferCubemap;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class GLFrameBuffer<T extends GLTexture>
implements Disposable {
    protected static final int GL_DEPTH24_STENCIL8_OES = 35056;
    protected static final Map<Application, Array<GLFrameBuffer>> buffers = new HashMap<Application, Array<GLFrameBuffer>>();
    protected static int defaultFramebufferHandle;
    protected static boolean defaultFramebufferHandleInitialized;
    protected GLFrameBufferBuilder<? extends GLFrameBuffer<T>> bufferBuilder;
    protected int depthStencilPackedBufferHandle;
    protected int depthbufferHandle;
    protected int framebufferHandle;
    protected boolean hasDepthStencilPackedBuffer;
    protected boolean isMRT;
    protected int stencilbufferHandle;
    protected Array<T> textureAttachments = new Array();

    static {
        defaultFramebufferHandleInitialized = false;
    }

    GLFrameBuffer() {
    }

    protected GLFrameBuffer(GLFrameBufferBuilder<? extends GLFrameBuffer<T>> gLFrameBufferBuilder) {
        this.bufferBuilder = gLFrameBufferBuilder;
        this.build();
    }

    private static void addManagedFrameBuffer(Application application, GLFrameBuffer gLFrameBuffer) {
        Array<GLFrameBuffer> array;
        Array array2 = array = buffers.get(application);
        if (array == null) {
            array2 = new Array();
        }
        array2.add(gLFrameBuffer);
        buffers.put(application, array2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkValidBuilder() {
        if (Gdx.graphics.isGL30Available()) return;
        if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer) throw new GdxRuntimeException("Packed Stencil/Render render buffers are not available on GLES 2.0");
        if (this.bufferBuilder.textureAttachmentSpecs.size > 1) throw new GdxRuntimeException("Multiple render targets not available on GLES 2.0");
        for (FrameBufferTextureAttachmentSpec frameBufferTextureAttachmentSpec : this.bufferBuilder.textureAttachmentSpecs) {
            if (frameBufferTextureAttachmentSpec.isDepth) throw new GdxRuntimeException("Depth texture FrameBuffer Attachment not available on GLES 2.0");
            if (frameBufferTextureAttachmentSpec.isStencil) throw new GdxRuntimeException("Stencil texture FrameBuffer Attachment not available on GLES 2.0");
            if (!frameBufferTextureAttachmentSpec.isFloat || Gdx.graphics.supportsExtension("OES_texture_float")) continue;
            throw new GdxRuntimeException("Float texture FrameBuffer Attachment not available on GLES 2.0");
        }
    }

    public static void clearAllFrameBuffers(Application application) {
        buffers.remove(application);
    }

    public static String getManagedStatus() {
        return GLFrameBuffer.getManagedStatus(new StringBuilder()).toString();
    }

    public static StringBuilder getManagedStatus(StringBuilder stringBuilder) {
        stringBuilder.append("Managed buffers/app: { ");
        for (Application application : buffers.keySet()) {
            stringBuilder.append(GLFrameBuffer.buffers.get((Object)application).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    public static void invalidateAllFrameBuffers(Application object) {
        if (Gdx.gl20 == null) {
            return;
        }
        if ((object = buffers.get(object)) == null) {
            return;
        }
        for (int i = 0; i < ((Array)object).size; ++i) {
            ((GLFrameBuffer)((Array)object).get(i)).build();
        }
    }

    public static void unbind() {
        Gdx.gl20.glBindFramebuffer(36160, defaultFramebufferHandle);
    }

    protected abstract void attachFrameBufferColorTexture(T var1);

    public void begin() {
        this.bind();
        this.setFrameBufferViewport();
    }

    public void bind() {
        Gdx.gl20.glBindFramebuffer(36160, this.framebufferHandle);
    }

    protected void build() {
        int n;
        Iterator<T> iterator;
        Object object;
        block34: {
            int n2;
            int n3;
            block35: {
                int n4;
                object = Gdx.gl20;
                this.checkValidBuilder();
                if (!defaultFramebufferHandleInitialized) {
                    defaultFramebufferHandleInitialized = true;
                    if (Gdx.app.getType() == Application.ApplicationType.iOS) {
                        iterator = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
                        object.glGetIntegerv(36006, (IntBuffer)((Object)iterator));
                        defaultFramebufferHandle = ((IntBuffer)((Object)iterator)).get(0);
                    } else {
                        defaultFramebufferHandle = 0;
                    }
                }
                this.framebufferHandle = object.glGenFramebuffer();
                object.glBindFramebuffer(36160, this.framebufferHandle);
                n3 = this.bufferBuilder.width;
                n2 = this.bufferBuilder.height;
                if (this.bufferBuilder.hasDepthRenderBuffer) {
                    this.depthbufferHandle = object.glGenRenderbuffer();
                    object.glBindRenderbuffer(36161, this.depthbufferHandle);
                    object.glRenderbufferStorage(36161, this.bufferBuilder.depthRenderBufferSpec.internalFormat, n3, n2);
                }
                if (this.bufferBuilder.hasStencilRenderBuffer) {
                    this.stencilbufferHandle = object.glGenRenderbuffer();
                    object.glBindRenderbuffer(36161, this.stencilbufferHandle);
                    object.glRenderbufferStorage(36161, this.bufferBuilder.stencilRenderBufferSpec.internalFormat, n3, n2);
                }
                if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer) {
                    this.depthStencilPackedBufferHandle = object.glGenRenderbuffer();
                    object.glBindRenderbuffer(36161, this.depthStencilPackedBufferHandle);
                    object.glRenderbufferStorage(36161, this.bufferBuilder.packedStencilDepthRenderBufferSpec.internalFormat, n3, n2);
                }
                boolean bl = this.bufferBuilder.textureAttachmentSpecs.size > 1;
                this.isMRT = bl;
                if (this.isMRT) {
                    Iterator<FrameBufferTextureAttachmentSpec> iterator2 = this.bufferBuilder.textureAttachmentSpecs.iterator();
                    n = 0;
                    while (iterator2.hasNext()) {
                        FrameBufferTextureAttachmentSpec frameBufferTextureAttachmentSpec = iterator2.next();
                        iterator = this.createTexture(frameBufferTextureAttachmentSpec);
                        this.textureAttachments.add((IntBuffer)((Object)iterator));
                        if (frameBufferTextureAttachmentSpec.isColorTexture()) {
                            object.glFramebufferTexture2D(36160, n + 36064, 3553, ((GLTexture)((Object)iterator)).getTextureObjectHandle(), 0);
                            ++n;
                            continue;
                        }
                        if (frameBufferTextureAttachmentSpec.isDepth) {
                            object.glFramebufferTexture2D(36160, 36096, 3553, ((GLTexture)((Object)iterator)).getTextureObjectHandle(), 0);
                            continue;
                        }
                        if (!frameBufferTextureAttachmentSpec.isStencil) continue;
                        object.glFramebufferTexture2D(36160, 36128, 3553, ((GLTexture)((Object)iterator)).getTextureObjectHandle(), 0);
                    }
                } else {
                    iterator = this.createTexture(this.bufferBuilder.textureAttachmentSpecs.first());
                    this.textureAttachments.add((IntBuffer)((Object)iterator));
                    object.glBindTexture(((GLTexture)((Object)iterator)).glTarget, ((GLTexture)((Object)iterator)).getTextureObjectHandle());
                    n = 0;
                }
                if (this.isMRT) {
                    iterator = BufferUtils.newIntBuffer(n);
                    for (n4 = 0; n4 < n; ++n4) {
                        ((IntBuffer)((Object)iterator)).put(n4 + 36064);
                    }
                    ((IntBuffer)((Object)iterator)).position(0);
                    Gdx.gl30.glDrawBuffers(n, (IntBuffer)((Object)iterator));
                } else {
                    this.attachFrameBufferColorTexture((GLTexture)this.textureAttachments.first());
                }
                if (this.bufferBuilder.hasDepthRenderBuffer) {
                    object.glFramebufferRenderbuffer(36160, 36096, 36161, this.depthbufferHandle);
                }
                if (this.bufferBuilder.hasStencilRenderBuffer) {
                    object.glFramebufferRenderbuffer(36160, 36128, 36161, this.stencilbufferHandle);
                }
                if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer) {
                    object.glFramebufferRenderbuffer(36160, 33306, 36161, this.depthStencilPackedBufferHandle);
                }
                object.glBindRenderbuffer(36161, 0);
                iterator = this.textureAttachments.iterator();
                while (iterator.hasNext()) {
                    object.glBindTexture(((GLTexture)iterator.next()).glTarget, 0);
                }
                n = n4 = object.glCheckFramebufferStatus(36160);
                if (n4 != 36061) break block34;
                n = n4;
                if (!this.bufferBuilder.hasDepthRenderBuffer) break block34;
                n = n4;
                if (!this.bufferBuilder.hasStencilRenderBuffer) break block34;
                if (Gdx.graphics.supportsExtension("GL_OES_packed_depth_stencil")) break block35;
                n = n4;
                if (!Gdx.graphics.supportsExtension("GL_EXT_packed_depth_stencil")) break block34;
            }
            if (this.bufferBuilder.hasDepthRenderBuffer) {
                object.glDeleteRenderbuffer(this.depthbufferHandle);
                this.depthbufferHandle = 0;
            }
            if (this.bufferBuilder.hasStencilRenderBuffer) {
                object.glDeleteRenderbuffer(this.stencilbufferHandle);
                this.stencilbufferHandle = 0;
            }
            if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer) {
                object.glDeleteRenderbuffer(this.depthStencilPackedBufferHandle);
                this.depthStencilPackedBufferHandle = 0;
            }
            this.depthStencilPackedBufferHandle = object.glGenRenderbuffer();
            this.hasDepthStencilPackedBuffer = true;
            object.glBindRenderbuffer(36161, this.depthStencilPackedBufferHandle);
            object.glRenderbufferStorage(36161, 35056, n3, n2);
            object.glBindRenderbuffer(36161, 0);
            object.glFramebufferRenderbuffer(36160, 36096, 36161, this.depthStencilPackedBufferHandle);
            object.glFramebufferRenderbuffer(36160, 36128, 36161, this.depthStencilPackedBufferHandle);
            n = object.glCheckFramebufferStatus(36160);
        }
        object.glBindFramebuffer(36160, defaultFramebufferHandle);
        if (n != 36053) {
            iterator = this.textureAttachments.iterator();
            while (iterator.hasNext()) {
                this.disposeColorTexture((GLTexture)iterator.next());
            }
            if (this.hasDepthStencilPackedBuffer) {
                object.glDeleteBuffer(this.depthStencilPackedBufferHandle);
            } else {
                if (this.bufferBuilder.hasDepthRenderBuffer) {
                    object.glDeleteRenderbuffer(this.depthbufferHandle);
                }
                if (this.bufferBuilder.hasStencilRenderBuffer) {
                    object.glDeleteRenderbuffer(this.stencilbufferHandle);
                }
            }
            object.glDeleteFramebuffer(this.framebufferHandle);
            if (n != 36054) {
                if (n != 36057) {
                    if (n != 36055) {
                        if (n == 36061) {
                            throw new IllegalStateException("Frame buffer couldn't be constructed: unsupported combination of formats");
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Frame buffer couldn't be constructed: unknown error ");
                        ((StringBuilder)object).append(n);
                        throw new IllegalStateException(((StringBuilder)object).toString());
                    }
                    throw new IllegalStateException("Frame buffer couldn't be constructed: missing attachment");
                }
                throw new IllegalStateException("Frame buffer couldn't be constructed: incomplete dimensions");
            }
            throw new IllegalStateException("Frame buffer couldn't be constructed: incomplete attachment");
        }
        GLFrameBuffer.addManagedFrameBuffer(Gdx.app, this);
    }

    protected abstract T createTexture(FrameBufferTextureAttachmentSpec var1);

    @Override
    public void dispose() {
        GL20 gL20 = Gdx.gl20;
        Iterator<T> iterator = this.textureAttachments.iterator();
        while (iterator.hasNext()) {
            this.disposeColorTexture((GLTexture)iterator.next());
        }
        if (this.hasDepthStencilPackedBuffer) {
            gL20.glDeleteRenderbuffer(this.depthStencilPackedBufferHandle);
        } else {
            if (this.bufferBuilder.hasDepthRenderBuffer) {
                gL20.glDeleteRenderbuffer(this.depthbufferHandle);
            }
            if (this.bufferBuilder.hasStencilRenderBuffer) {
                gL20.glDeleteRenderbuffer(this.stencilbufferHandle);
            }
        }
        gL20.glDeleteFramebuffer(this.framebufferHandle);
        if (buffers.get(Gdx.app) != null) {
            buffers.get(Gdx.app).removeValue(this, true);
        }
    }

    protected abstract void disposeColorTexture(T var1);

    public void end() {
        this.end(0, 0, Gdx.graphics.getBackBufferWidth(), Gdx.graphics.getBackBufferHeight());
    }

    public void end(int n, int n2, int n3, int n4) {
        GLFrameBuffer.unbind();
        Gdx.gl20.glViewport(n, n2, n3, n4);
    }

    public T getColorBufferTexture() {
        return (T)((GLTexture)this.textureAttachments.first());
    }

    public int getDepthBufferHandle() {
        return this.depthbufferHandle;
    }

    protected int getDepthStencilPackedBuffer() {
        return this.depthStencilPackedBufferHandle;
    }

    public int getFramebufferHandle() {
        return this.framebufferHandle;
    }

    public int getHeight() {
        return this.bufferBuilder.height;
    }

    public int getStencilBufferHandle() {
        return this.stencilbufferHandle;
    }

    public Array<T> getTextureAttachments() {
        return this.textureAttachments;
    }

    public int getWidth() {
        return this.bufferBuilder.width;
    }

    protected void setFrameBufferViewport() {
        Gdx.gl20.glViewport(0, 0, this.bufferBuilder.width, this.bufferBuilder.height);
    }

    public static class FloatFrameBufferBuilder
    extends GLFrameBufferBuilder<FloatFrameBuffer> {
        public FloatFrameBufferBuilder(int n, int n2) {
            super(n, n2);
        }

        @Override
        public FloatFrameBuffer build() {
            return new FloatFrameBuffer(this);
        }
    }

    public static class FrameBufferBuilder
    extends GLFrameBufferBuilder<FrameBuffer> {
        public FrameBufferBuilder(int n, int n2) {
            super(n, n2);
        }

        @Override
        public FrameBuffer build() {
            return new FrameBuffer(this);
        }
    }

    public static class FrameBufferCubemapBuilder
    extends GLFrameBufferBuilder<FrameBufferCubemap> {
        public FrameBufferCubemapBuilder(int n, int n2) {
            super(n, n2);
        }

        @Override
        public FrameBufferCubemap build() {
            return new FrameBufferCubemap(this);
        }
    }

    protected static class FrameBufferRenderBufferAttachmentSpec {
        int internalFormat;

        public FrameBufferRenderBufferAttachmentSpec(int n) {
            this.internalFormat = n;
        }
    }

    protected static class FrameBufferTextureAttachmentSpec {
        int format;
        int internalFormat;
        boolean isDepth;
        boolean isFloat;
        boolean isGpuOnly;
        boolean isStencil;
        int type;

        public FrameBufferTextureAttachmentSpec(int n, int n2, int n3) {
            this.internalFormat = n;
            this.format = n2;
            this.type = n3;
        }

        public boolean isColorTexture() {
            boolean bl = !this.isDepth && !this.isStencil;
            return bl;
        }
    }

    protected static abstract class GLFrameBufferBuilder<U extends GLFrameBuffer<? extends GLTexture>> {
        protected FrameBufferRenderBufferAttachmentSpec depthRenderBufferSpec;
        protected boolean hasDepthRenderBuffer;
        protected boolean hasPackedStencilDepthRenderBuffer;
        protected boolean hasStencilRenderBuffer;
        protected int height;
        protected FrameBufferRenderBufferAttachmentSpec packedStencilDepthRenderBufferSpec;
        protected FrameBufferRenderBufferAttachmentSpec stencilRenderBufferSpec;
        protected Array<FrameBufferTextureAttachmentSpec> textureAttachmentSpecs = new Array();
        protected int width;

        public GLFrameBufferBuilder(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public GLFrameBufferBuilder<U> addBasicColorTextureAttachment(Pixmap.Format format) {
            int n = Pixmap.Format.toGlFormat(format);
            return this.addColorTextureAttachment(n, n, Pixmap.Format.toGlType(format));
        }

        public GLFrameBufferBuilder<U> addBasicDepthRenderBuffer() {
            return this.addDepthRenderBuffer(33189);
        }

        public GLFrameBufferBuilder<U> addBasicStencilDepthPackedRenderBuffer() {
            return this.addStencilDepthPackedRenderBuffer(35056);
        }

        public GLFrameBufferBuilder<U> addBasicStencilRenderBuffer() {
            return this.addStencilRenderBuffer(36168);
        }

        public GLFrameBufferBuilder<U> addColorTextureAttachment(int n, int n2, int n3) {
            this.textureAttachmentSpecs.add(new FrameBufferTextureAttachmentSpec(n, n2, n3));
            return this;
        }

        public GLFrameBufferBuilder<U> addDepthRenderBuffer(int n) {
            this.depthRenderBufferSpec = new FrameBufferRenderBufferAttachmentSpec(n);
            this.hasDepthRenderBuffer = true;
            return this;
        }

        public GLFrameBufferBuilder<U> addDepthTextureAttachment(int n, int n2) {
            FrameBufferTextureAttachmentSpec frameBufferTextureAttachmentSpec = new FrameBufferTextureAttachmentSpec(n, 6402, n2);
            frameBufferTextureAttachmentSpec.isDepth = true;
            this.textureAttachmentSpecs.add(frameBufferTextureAttachmentSpec);
            return this;
        }

        public GLFrameBufferBuilder<U> addFloatAttachment(int n, int n2, int n3, boolean bl) {
            FrameBufferTextureAttachmentSpec frameBufferTextureAttachmentSpec = new FrameBufferTextureAttachmentSpec(n, n2, n3);
            frameBufferTextureAttachmentSpec.isFloat = true;
            frameBufferTextureAttachmentSpec.isGpuOnly = bl;
            this.textureAttachmentSpecs.add(frameBufferTextureAttachmentSpec);
            return this;
        }

        public GLFrameBufferBuilder<U> addStencilDepthPackedRenderBuffer(int n) {
            this.packedStencilDepthRenderBufferSpec = new FrameBufferRenderBufferAttachmentSpec(n);
            this.hasPackedStencilDepthRenderBuffer = true;
            return this;
        }

        public GLFrameBufferBuilder<U> addStencilRenderBuffer(int n) {
            this.stencilRenderBufferSpec = new FrameBufferRenderBufferAttachmentSpec(n);
            this.hasStencilRenderBuffer = true;
            return this;
        }

        public GLFrameBufferBuilder<U> addStencilTextureAttachment(int n, int n2) {
            FrameBufferTextureAttachmentSpec frameBufferTextureAttachmentSpec = new FrameBufferTextureAttachmentSpec(n, 36128, n2);
            frameBufferTextureAttachmentSpec.isStencil = true;
            this.textureAttachmentSpecs.add(frameBufferTextureAttachmentSpec);
            return this;
        }

        public abstract U build();
    }
}

