/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Texture;

public interface TextureProvider {
    public Texture load(String var1);

    public static class AssetTextureProvider
    implements TextureProvider {
        public final AssetManager assetManager;

        public AssetTextureProvider(AssetManager assetManager) {
            this.assetManager = assetManager;
        }

        @Override
        public Texture load(String string2) {
            return this.assetManager.get(string2, Texture.class);
        }
    }

    public static class FileTextureProvider
    implements TextureProvider {
        private Texture.TextureFilter magFilter;
        private Texture.TextureFilter minFilter;
        private Texture.TextureWrap uWrap;
        private boolean useMipMaps;
        private Texture.TextureWrap vWrap;

        public FileTextureProvider() {
            Enum enum_ = Texture.TextureFilter.Linear;
            this.magFilter = enum_;
            this.minFilter = enum_;
            this.vWrap = enum_ = Texture.TextureWrap.Repeat;
            this.uWrap = enum_;
            this.useMipMaps = false;
        }

        public FileTextureProvider(Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2, Texture.TextureWrap textureWrap, Texture.TextureWrap textureWrap2, boolean bl) {
            this.minFilter = textureFilter;
            this.magFilter = textureFilter2;
            this.uWrap = textureWrap;
            this.vWrap = textureWrap2;
            this.useMipMaps = bl;
        }

        @Override
        public Texture load(String object) {
            object = new Texture(Gdx.files.internal((String)object), this.useMipMaps);
            ((GLTexture)object).setFilter(this.minFilter, this.magFilter);
            ((GLTexture)object).setWrap(this.uWrap, this.vWrap);
            return object;
        }
    }
}

