/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.FloatAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;

public class DepthShader
extends DefaultShader {
    private static String defaultFragmentShader;
    private static String defaultVertexShader;
    private static final Attributes tmpAttributes;
    private final FloatAttribute alphaTestAttribute;
    public final int numBones;
    public final int weights;

    static {
        tmpAttributes = new Attributes();
    }

    public DepthShader(Renderable renderable) {
        this(renderable, new Config());
    }

    public DepthShader(Renderable renderable, Config config) {
        this(renderable, config, DepthShader.createPrefix(renderable, config));
    }

    public DepthShader(Renderable renderable, Config config, ShaderProgram object) {
        super(renderable, (DefaultShader.Config)config, (ShaderProgram)object);
        DepthShader.combineAttributes(renderable);
        object = renderable.bones;
        int n = object == null ? 0 : config.numBones;
        this.numBones = n;
        int n2 = renderable.meshPart.mesh.getVertexAttributes().size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            object = renderable.meshPart.mesh.getVertexAttributes().get(i);
            n = n3;
            if (object.usage == 64) {
                n = n3 | 1 << object.unit;
            }
            n3 = n;
        }
        this.weights = n3;
        this.alphaTestAttribute = new FloatAttribute(FloatAttribute.AlphaTest, config.defaultAlphaTest);
    }

    public DepthShader(Renderable renderable, Config config, String string2) {
        String string3 = config.vertexShader != null ? config.vertexShader : DepthShader.getDefaultVertexShader();
        String string4 = config.fragmentShader != null ? config.fragmentShader : DepthShader.getDefaultFragmentShader();
        this(renderable, config, string2, string3, string4);
    }

    public DepthShader(Renderable renderable, Config config, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(string3);
        string3 = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(string4);
        this(renderable, config, new ShaderProgram(string3, stringBuilder.toString()));
    }

    private static final Attributes combineAttributes(Renderable renderable) {
        tmpAttributes.clear();
        if (renderable.environment != null) {
            tmpAttributes.set(renderable.environment);
        }
        if (renderable.material != null) {
            tmpAttributes.set(renderable.material);
        }
        return tmpAttributes;
    }

    public static String createPrefix(Renderable object, Config config) {
        String string2 = DefaultShader.createPrefix((Renderable)object, config);
        object = string2;
        if (!config.depthBufferOnly) {
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append("#define PackedDepthFlag\n");
            object = ((StringBuilder)object).toString();
        }
        return object;
    }

    public static final String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/depth.fragment.glsl").readString();
        }
        return defaultFragmentShader;
    }

    public static final String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/depth.vertex.glsl").readString();
        }
        return defaultVertexShader;
    }

    @Override
    public void begin(Camera camera, RenderContext renderContext) {
        super.begin(camera, renderContext);
    }

    @Override
    public boolean canRender(Renderable renderable) {
        int n;
        int n2;
        Object object = DepthShader.combineAttributes(renderable);
        boolean bl = ((Attributes)object).has(BlendingAttribute.Type);
        boolean bl2 = true;
        if (bl) {
            if ((this.attributesMask & BlendingAttribute.Type) != BlendingAttribute.Type) {
                return false;
            }
            boolean bl3 = ((Attributes)object).has(TextureAttribute.Diffuse);
            if (bl3 != (bl = (this.attributesMask & TextureAttribute.Diffuse) == TextureAttribute.Diffuse)) {
                return false;
            }
        }
        if ((n2 = (renderable.meshPart.mesh.getVertexAttributes().getMask() & 0x40L) == 64L ? 1 : 0) != (n = this.numBones > 0 ? 1 : 0)) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        int n3 = renderable.meshPart.mesh.getVertexAttributes().size();
        n2 = 0;
        for (int i = 0; i < n3; ++i) {
            object = renderable.meshPart.mesh.getVertexAttributes().get(i);
            n = n2;
            if (((VertexAttribute)object).usage == 64) {
                n = n2 | 1 << ((VertexAttribute)object).unit;
            }
            n2 = n;
        }
        bl = n2 == this.weights ? bl2 : false;
        return bl;
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public void render(Renderable renderable, Attributes attributes) {
        if (attributes.has(BlendingAttribute.Type)) {
            BlendingAttribute blendingAttribute = (BlendingAttribute)attributes.get(BlendingAttribute.Type);
            attributes.remove(BlendingAttribute.Type);
            boolean bl = attributes.has(FloatAttribute.AlphaTest);
            if (!bl) {
                attributes.set((Attribute)this.alphaTestAttribute);
            }
            if (blendingAttribute.opacity >= ((FloatAttribute)attributes.get((long)FloatAttribute.AlphaTest)).value) {
                super.render(renderable, attributes);
            }
            if (!bl) {
                attributes.remove(FloatAttribute.AlphaTest);
            }
            attributes.set((Attribute)blendingAttribute);
        } else {
            super.render(renderable, attributes);
        }
    }

    public static class Config
    extends DefaultShader.Config {
        public float defaultAlphaTest = 0.5f;
        public boolean depthBufferOnly = false;

        public Config() {
            this.defaultCullFace = 1028;
        }

        public Config(String string2, String string3) {
            super(string2, string3);
        }
    }
}

