/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.values;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.particles.values.MeshSpawnShapeValue;
import com.badlogic.gdx.graphics.g3d.particles.values.SpawnShapeValue;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;

public final class UnweightedMeshSpawnShapeValue
extends MeshSpawnShapeValue {
    private short[] indices;
    private int positionOffset;
    private int triangleCount;
    private int vertexCount;
    private int vertexSize;
    private float[] vertices;

    public UnweightedMeshSpawnShapeValue() {
    }

    public UnweightedMeshSpawnShapeValue(UnweightedMeshSpawnShapeValue unweightedMeshSpawnShapeValue) {
        super(unweightedMeshSpawnShapeValue);
        this.load(unweightedMeshSpawnShapeValue);
    }

    @Override
    public SpawnShapeValue copy() {
        return new UnweightedMeshSpawnShapeValue(this);
    }

    @Override
    public void setMesh(Mesh mesh, Model model) {
        super.setMesh(mesh, model);
        this.vertexSize = mesh.getVertexSize() / 4;
        this.positionOffset = mesh.getVertexAttribute((int)1).offset / 4;
        int n = mesh.getNumIndices();
        if (n > 0) {
            this.indices = new short[n];
            mesh.getIndices(this.indices);
            this.triangleCount = this.indices.length / 3;
        } else {
            this.indices = null;
        }
        this.vertexCount = mesh.getNumVertices();
        this.vertices = new float[this.vertexCount * this.vertexSize];
        mesh.getVertices(this.vertices);
    }

    @Override
    public void spawnAux(Vector3 vector3, float f) {
        if (this.indices == null) {
            int n = MathUtils.random(this.vertexCount - 3);
            int n2 = this.vertexSize;
            int n3 = n * n2 + this.positionOffset;
            n = n3 + n2;
            float[] fArray = this.vertices;
            MeshSpawnShapeValue.Triangle.pick(fArray[n3], fArray[n3 + 1], fArray[n3 + 2], fArray[n], fArray[n + 1], fArray[n + 2], fArray[n2 += n], fArray[n2 + 1], fArray[n2 + 2], vector3);
        } else {
            int n = MathUtils.random(this.triangleCount - 1) * 3;
            Object[] objectArray = this.indices;
            int n4 = objectArray[n];
            int n5 = this.vertexSize;
            int n6 = this.positionOffset;
            n4 = n4 * n5 + n6;
            int n7 = objectArray[n + 1] * n5 + n6;
            n = objectArray[n + 2] * n5 + n6;
            objectArray = this.vertices;
            MeshSpawnShapeValue.Triangle.pick(objectArray[n4], objectArray[n4 + 1], objectArray[n4 + 2], objectArray[n7], objectArray[n7 + 1], objectArray[n7 + 2], objectArray[n], objectArray[n + 1], objectArray[n + 2], vector3);
        }
    }
}

