/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.graphics.g3d.particles.values.ScaledNumericValue;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public abstract class SimpleInfluencer
extends Influencer {
    ParallelArray.FloatChannel interpolationChannel;
    ParallelArray.FloatChannel lifeChannel;
    public ScaledNumericValue value = new ScaledNumericValue();
    ParallelArray.FloatChannel valueChannel;
    ParallelArray.ChannelDescriptor valueChannelDescriptor;

    public SimpleInfluencer() {
        this.value.setHigh(1.0f);
    }

    public SimpleInfluencer(SimpleInfluencer simpleInfluencer) {
        this();
        this.set(simpleInfluencer);
    }

    private void set(SimpleInfluencer simpleInfluencer) {
        this.value.load(simpleInfluencer.value);
        this.valueChannelDescriptor = simpleInfluencer.valueChannelDescriptor;
    }

    @Override
    public void activateParticles(int n, int n2) {
        if (!this.value.isRelative()) {
            int n3 = this.valueChannel.strideSize * n;
            int n4 = n * this.interpolationChannel.strideSize;
            int n5 = this.valueChannel.strideSize;
            n = n3;
            while (n < n2 * n5 + n3) {
                float f = this.value.newLowValue();
                float f2 = this.value.newHighValue() - f;
                this.interpolationChannel.data[n4 + 0] = f;
                this.interpolationChannel.data[n4 + 1] = f2;
                this.valueChannel.data[n] = f + f2 * this.value.getScale(0.0f);
                n += this.valueChannel.strideSize;
                n4 += this.interpolationChannel.strideSize;
            }
        } else {
            int n6 = this.valueChannel.strideSize * n;
            int n7 = n * this.interpolationChannel.strideSize;
            int n8 = this.valueChannel.strideSize;
            n = n6;
            while (n < n2 * n8 + n6) {
                float f = this.value.newLowValue();
                float f3 = this.value.newHighValue();
                this.interpolationChannel.data[n7 + 0] = f;
                this.interpolationChannel.data[n7 + 1] = f3;
                this.valueChannel.data[n] = f + f3 * this.value.getScale(0.0f);
                n += this.valueChannel.strideSize;
                n7 += this.interpolationChannel.strideSize;
            }
        }
    }

    @Override
    public void allocateChannels() {
        this.valueChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(this.valueChannelDescriptor);
        ParticleChannels.Interpolation.id = this.controller.particleChannels.newId();
        this.interpolationChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Interpolation);
        this.lifeChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Life);
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        this.value = json.readValue("value", ScaledNumericValue.class, jsonValue);
    }

    @Override
    public void update() {
        int n = this.controller.particles.size;
        int n2 = this.valueChannel.strideSize;
        int n3 = 0;
        int n4 = 0;
        int n5 = 2;
        while (n3 < n * n2 + 0) {
            this.valueChannel.data[n3] = this.interpolationChannel.data[n4 + 0] + this.interpolationChannel.data[n4 + 1] * this.value.getScale(this.lifeChannel.data[n5]);
            n3 += this.valueChannel.strideSize;
            n4 += this.interpolationChannel.strideSize;
            n5 += this.lifeChannel.strideSize;
        }
    }

    @Override
    public void write(Json json) {
        json.writeValue("value", this.value);
    }
}

