/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.batches;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DepthTestAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.batches.BufferedParticleBatch;
import com.badlogic.gdx.graphics.g3d.particles.renderers.PointSpriteControllerRenderData;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.Iterator;

public class PointSpriteParticleBatch
extends BufferedParticleBatch<PointSpriteControllerRenderData> {
    protected static final VertexAttributes CPU_ATTRIBUTES;
    protected static final int CPU_COLOR_OFFSET;
    protected static final int CPU_POSITION_OFFSET;
    protected static final int CPU_REGION_OFFSET;
    protected static final int CPU_SIZE_AND_ROTATION_OFFSET;
    protected static final int CPU_VERTEX_SIZE;
    protected static final Vector3 TMP_V1;
    private static boolean pointSpritesEnabled = false;
    protected static final int sizeAndRotationUsage = 512;
    Renderable renderable;
    private float[] vertices;

    static {
        TMP_V1 = new Vector3();
        CPU_ATTRIBUTES = new VertexAttributes(new VertexAttribute(1, 3, "a_position"), new VertexAttribute(2, 4, "a_color"), new VertexAttribute(16, 4, "a_region"), new VertexAttribute(512, 3, "a_sizeAndRotation"));
        CPU_VERTEX_SIZE = (short)(PointSpriteParticleBatch.CPU_ATTRIBUTES.vertexSize / 4);
        CPU_POSITION_OFFSET = (short)(PointSpriteParticleBatch.CPU_ATTRIBUTES.findByUsage((int)1).offset / 4);
        CPU_COLOR_OFFSET = (short)(PointSpriteParticleBatch.CPU_ATTRIBUTES.findByUsage((int)2).offset / 4);
        CPU_REGION_OFFSET = (short)(PointSpriteParticleBatch.CPU_ATTRIBUTES.findByUsage((int)16).offset / 4);
        CPU_SIZE_AND_ROTATION_OFFSET = (short)(PointSpriteParticleBatch.CPU_ATTRIBUTES.findByUsage((int)512).offset / 4);
    }

    public PointSpriteParticleBatch() {
        this(1000);
    }

    public PointSpriteParticleBatch(int n) {
        this(n, new ParticleShader.Config(ParticleShader.ParticleType.Point));
    }

    public PointSpriteParticleBatch(int n, ParticleShader.Config config) {
        super(PointSpriteControllerRenderData.class);
        if (!pointSpritesEnabled) {
            PointSpriteParticleBatch.enablePointSprites();
        }
        this.allocRenderable();
        this.ensureCapacity(n);
        Renderable renderable = this.renderable;
        renderable.shader = new ParticleShader(renderable, config);
        this.renderable.shader.init();
    }

    private static void enablePointSprites() {
        Gdx.gl.glEnable(34370);
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            Gdx.gl.glEnable(34913);
        }
        pointSpritesEnabled = true;
    }

    @Override
    protected void allocParticlesData(int n) {
        this.vertices = new float[CPU_VERTEX_SIZE * n];
        if (this.renderable.meshPart.mesh != null) {
            this.renderable.meshPart.mesh.dispose();
        }
        this.renderable.meshPart.mesh = new Mesh(false, n, 0, CPU_ATTRIBUTES);
    }

    protected void allocRenderable() {
        this.renderable = new Renderable();
        this.renderable.meshPart.primitiveType = 0;
        this.renderable.meshPart.offset = 0;
        this.renderable.material = new Material(new BlendingAttribute(1, 771, 1.0f), new DepthTestAttribute(515, false), TextureAttribute.createDiffuse((Texture)null));
    }

    @Override
    protected void flush(int[] nArray) {
        Iterator iterator = this.renderData.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PointSpriteControllerRenderData pointSpriteControllerRenderData = (PointSpriteControllerRenderData)iterator.next();
            ParallelArray.FloatChannel floatChannel = pointSpriteControllerRenderData.scaleChannel;
            ParallelArray.FloatChannel floatChannel2 = pointSpriteControllerRenderData.regionChannel;
            ParallelArray.FloatChannel floatChannel3 = pointSpriteControllerRenderData.positionChannel;
            ParallelArray.FloatChannel floatChannel4 = pointSpriteControllerRenderData.colorChannel;
            ParallelArray.FloatChannel floatChannel5 = pointSpriteControllerRenderData.rotationChannel;
            int n2 = 0;
            while (n2 < pointSpriteControllerRenderData.controller.particles.size) {
                int n3 = nArray[n] * CPU_VERTEX_SIZE;
                int n4 = floatChannel2.strideSize * n2;
                int n5 = floatChannel3.strideSize * n2;
                int n6 = floatChannel4.strideSize * n2;
                int n7 = floatChannel5.strideSize * n2;
                this.vertices[n3 + PointSpriteParticleBatch.CPU_POSITION_OFFSET] = floatChannel3.data[n5 + 0];
                this.vertices[PointSpriteParticleBatch.CPU_POSITION_OFFSET + n3 + 1] = floatChannel3.data[n5 + 1];
                this.vertices[PointSpriteParticleBatch.CPU_POSITION_OFFSET + n3 + 2] = floatChannel3.data[n5 + 2];
                this.vertices[PointSpriteParticleBatch.CPU_COLOR_OFFSET + n3] = floatChannel4.data[n6 + 0];
                this.vertices[PointSpriteParticleBatch.CPU_COLOR_OFFSET + n3 + 1] = floatChannel4.data[n6 + 1];
                this.vertices[PointSpriteParticleBatch.CPU_COLOR_OFFSET + n3 + 2] = floatChannel4.data[n6 + 2];
                this.vertices[PointSpriteParticleBatch.CPU_COLOR_OFFSET + n3 + 3] = floatChannel4.data[n6 + 3];
                this.vertices[PointSpriteParticleBatch.CPU_SIZE_AND_ROTATION_OFFSET + n3] = floatChannel.data[floatChannel.strideSize * n2];
                this.vertices[PointSpriteParticleBatch.CPU_SIZE_AND_ROTATION_OFFSET + n3 + 1] = floatChannel5.data[n7 + 0];
                this.vertices[PointSpriteParticleBatch.CPU_SIZE_AND_ROTATION_OFFSET + n3 + 2] = floatChannel5.data[n7 + 1];
                this.vertices[PointSpriteParticleBatch.CPU_REGION_OFFSET + n3] = floatChannel2.data[n4 + 0];
                this.vertices[PointSpriteParticleBatch.CPU_REGION_OFFSET + n3 + 1] = floatChannel2.data[n4 + 1];
                this.vertices[PointSpriteParticleBatch.CPU_REGION_OFFSET + n3 + 2] = floatChannel2.data[n4 + 2];
                this.vertices[n3 + PointSpriteParticleBatch.CPU_REGION_OFFSET + 3] = floatChannel2.data[n4 + 3];
                ++n2;
                ++n;
            }
        }
        this.renderable.meshPart.size = this.bufferedParticlesCount;
        this.renderable.meshPart.mesh.setVertices(this.vertices, 0, this.bufferedParticlesCount * CPU_VERTEX_SIZE);
        this.renderable.meshPart.update();
    }

    @Override
    public void getRenderables(Array<Renderable> array, Pool<Renderable> pool) {
        if (this.bufferedParticlesCount > 0) {
            array.add(pool.obtain().set(this.renderable));
        }
    }

    public Texture getTexture() {
        return (Texture)((TextureAttribute)this.renderable.material.get((long)TextureAttribute.Diffuse)).textureDescription.texture;
    }

    @Override
    public void load(AssetManager assetManager, ResourceData serializable) {
        if ((serializable = ((ResourceData)serializable).getSaveData("pointSpriteBatch")) != null) {
            this.setTexture((Texture)assetManager.get(((ResourceData.SaveData)serializable).loadAsset()));
        }
    }

    @Override
    public void save(AssetManager assetManager, ResourceData resourceData) {
        resourceData.createSaveData("pointSpriteBatch").saveAsset(assetManager.getAssetFileName(this.getTexture()), Texture.class);
    }

    public void setTexture(Texture texture) {
        ((TextureAttribute)this.renderable.material.get((long)TextureAttribute.Diffuse)).textureDescription.texture = texture;
    }
}

