/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import java.util.Iterator;

public class ParallelArray {
    Array<Channel> arrays = new Array(false, 2, Channel.class);
    public int capacity;
    public int size;

    public ParallelArray(int n) {
        this.capacity = n;
        this.size = 0;
    }

    private <T extends Channel> T allocateChannel(ChannelDescriptor channelDescriptor) {
        if (channelDescriptor.type == Float.TYPE) {
            return (T)new FloatChannel(channelDescriptor.id, channelDescriptor.count, this.capacity);
        }
        if (channelDescriptor.type == Integer.TYPE) {
            return (T)new IntChannel(channelDescriptor.id, channelDescriptor.count, this.capacity);
        }
        return (T)new ObjectChannel(channelDescriptor.id, channelDescriptor.count, this.capacity, channelDescriptor.type);
    }

    private int findIndex(int n) {
        for (int i = 0; i < this.arrays.size; ++i) {
            if (((Channel[])this.arrays.items)[i].id != n) continue;
            return i;
        }
        return -1;
    }

    public <T extends Channel> T addChannel(ChannelDescriptor channelDescriptor) {
        return this.addChannel(channelDescriptor, null);
    }

    public <T extends Channel> T addChannel(ChannelDescriptor channelDescriptor, ChannelInitializer<T> channelInitializer) {
        T t;
        T t2 = t = this.getChannel(channelDescriptor);
        if (t == null) {
            t2 = this.allocateChannel(channelDescriptor);
            if (channelInitializer != null) {
                channelInitializer.init(t2);
            }
            this.arrays.add((Channel)t2);
        }
        return t2;
    }

    public void addElement(Object ... objectArray) {
        if (this.size != this.capacity) {
            int n = 0;
            for (Channel channel : this.arrays) {
                channel.add(n, objectArray);
                n += channel.strideSize;
            }
            ++this.size;
            return;
        }
        objectArray = new GdxRuntimeException("Capacity reached, cannot add other elements");
        throw objectArray;
    }

    public void clear() {
        this.arrays.clear();
        this.size = 0;
    }

    public <T extends Channel> T getChannel(ChannelDescriptor channelDescriptor) {
        for (Channel channel : this.arrays) {
            if (channel.id != channelDescriptor.id) continue;
            return (T)channel;
        }
        return null;
    }

    public <T> void removeArray(int n) {
        this.arrays.removeIndex(this.findIndex(n));
    }

    public void removeElement(int n) {
        int n2 = this.size - 1;
        Iterator<Channel> iterator = this.arrays.iterator();
        while (iterator.hasNext()) {
            iterator.next().swap(n, n2);
        }
        this.size = n2;
    }

    public void setCapacity(int n) {
        if (this.capacity != n) {
            Iterator<Channel> iterator = this.arrays.iterator();
            while (iterator.hasNext()) {
                iterator.next().setCapacity(n);
            }
            this.capacity = n;
        }
    }

    public abstract class Channel {
        public Object data;
        public int id;
        public int strideSize;

        public Channel(int n, Object object, int n2) {
            this.id = n;
            this.strideSize = n2;
            this.data = object;
        }

        public abstract void add(int var1, Object ... var2);

        protected abstract void setCapacity(int var1);

        public abstract void swap(int var1, int var2);
    }

    public static class ChannelDescriptor {
        public int count;
        public int id;
        public Class<?> type;

        public ChannelDescriptor(int n, Class<?> clazz, int n2) {
            this.id = n;
            this.type = clazz;
            this.count = n2;
        }
    }

    public static interface ChannelInitializer<T extends Channel> {
        public void init(T var1);
    }

    public class FloatChannel
    extends Channel {
        public float[] data;

        public FloatChannel(int n, int n2, int n3) {
            super(n, new float[n3 * n2], n2);
            this.data = (float[])((Channel)this).data;
        }

        @Override
        public void add(int n, Object ... objectArray) {
            int n2 = this.strideSize * ParallelArray.this.size;
            int n3 = this.strideSize;
            int n4 = 0;
            n = n2;
            while (n < n3 + n2) {
                this.data[n] = ((Float)objectArray[n4]).floatValue();
                ++n;
                ++n4;
            }
        }

        @Override
        public void setCapacity(int n) {
            float[] fArray = new float[this.strideSize * n];
            float[] fArray2 = this.data;
            System.arraycopy(fArray2, 0, fArray, 0, Math.min(fArray2.length, fArray.length));
            this.data = fArray;
            ((Channel)this).data = fArray;
        }

        @Override
        public void swap(int n, int n2) {
            int n3 = this.strideSize * n;
            n2 = this.strideSize * n2;
            int n4 = this.strideSize;
            n = n3;
            while (n < n4 + n3) {
                float[] fArray = this.data;
                float f = fArray[n];
                fArray[n] = fArray[n2];
                fArray[n2] = f;
                ++n;
                ++n2;
            }
        }
    }

    public class IntChannel
    extends Channel {
        public int[] data;

        public IntChannel(int n, int n2, int n3) {
            super(n, new int[n3 * n2], n2);
            this.data = (int[])((Channel)this).data;
        }

        @Override
        public void add(int n, Object ... objectArray) {
            int n2 = this.strideSize * ParallelArray.this.size;
            int n3 = this.strideSize;
            int n4 = 0;
            n = n2;
            while (n < n3 + n2) {
                this.data[n] = (Integer)objectArray[n4];
                ++n;
                ++n4;
            }
        }

        @Override
        public void setCapacity(int n) {
            int[] nArray = new int[this.strideSize * n];
            int[] nArray2 = this.data;
            System.arraycopy(nArray2, 0, nArray, 0, Math.min(nArray2.length, nArray.length));
            this.data = nArray;
            ((Channel)this).data = nArray;
        }

        @Override
        public void swap(int n, int n2) {
            int n3 = this.strideSize * n;
            n2 = this.strideSize * n2;
            int n4 = this.strideSize;
            n = n3;
            while (n < n4 + n3) {
                int[] nArray = this.data;
                int n5 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n5;
                ++n;
                ++n2;
            }
        }
    }

    public class ObjectChannel<T>
    extends Channel {
        Class<T> componentType;
        public T[] data;

        public ObjectChannel(int n, int n2, int n3, Class<T> clazz) {
            super(n, ArrayReflection.newInstance(clazz, n3 * n2), n2);
            this.componentType = clazz;
            this.data = (Object[])((Channel)this).data;
        }

        @Override
        public void add(int n, Object ... objectArray) {
            int n2 = this.strideSize * ParallelArray.this.size;
            int n3 = this.strideSize;
            int n4 = 0;
            n = n2;
            while (n < n3 + n2) {
                this.data[n] = objectArray[n4];
                ++n;
                ++n4;
            }
        }

        @Override
        public void setCapacity(int n) {
            Object[] objectArray = (Object[])ArrayReflection.newInstance(this.componentType, this.strideSize * n);
            T[] TArray = this.data;
            System.arraycopy(TArray, 0, objectArray, 0, Math.min(TArray.length, objectArray.length));
            this.data = objectArray;
            ((Channel)this).data = objectArray;
        }

        @Override
        public void swap(int n, int n2) {
            int n3 = this.strideSize * n;
            n2 = this.strideSize * n2;
            int n4 = this.strideSize;
            n = n3;
            while (n < n4 + n3) {
                T[] TArray = this.data;
                T t = TArray[n];
                TArray[n] = TArray[n2];
                TArray[n2] = t;
                ++n;
                ++n2;
            }
        }
    }
}

