/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.attributes;

import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class CubemapAttribute
extends Attribute {
    public static final long EnvironmentMap;
    public static final String EnvironmentMapAlias = "environmentCubemap";
    protected static long Mask;
    public final TextureDescriptor<Cubemap> textureDescription;

    static {
        Mask = EnvironmentMap = CubemapAttribute.register(EnvironmentMapAlias);
    }

    public CubemapAttribute(long l) {
        super(l);
        if (CubemapAttribute.is(l)) {
            this.textureDescription = new TextureDescriptor();
            return;
        }
        throw new GdxRuntimeException("Invalid type specified");
    }

    public CubemapAttribute(long l, Cubemap cubemap) {
        this(l);
        this.textureDescription.texture = cubemap;
    }

    public <T extends Cubemap> CubemapAttribute(long l, TextureDescriptor<T> textureDescriptor) {
        this(l);
        this.textureDescription.set(textureDescriptor);
    }

    public CubemapAttribute(CubemapAttribute cubemapAttribute) {
        this(cubemapAttribute.type, cubemapAttribute.textureDescription);
    }

    public static final boolean is(long l) {
        boolean bl = (l & Mask) != 0L;
        return bl;
    }

    @Override
    public int compareTo(Attribute attribute) {
        if (this.type != attribute.type) {
            return (int)(this.type - attribute.type);
        }
        return this.textureDescription.compareTo(((CubemapAttribute)attribute).textureDescription);
    }

    @Override
    public Attribute copy() {
        return new CubemapAttribute(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 967 + this.textureDescription.hashCode();
    }
}

