/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.attributes;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class ColorAttribute
extends Attribute {
    public static final long Ambient;
    public static final String AmbientAlias = "ambientColor";
    public static final long AmbientLight;
    public static final String AmbientLightAlias = "ambientLightColor";
    public static final long Diffuse;
    public static final String DiffuseAlias = "diffuseColor";
    public static final long Emissive;
    public static final String EmissiveAlias = "emissiveColor";
    public static final long Fog;
    public static final String FogAlias = "fogColor";
    protected static long Mask = 0L;
    public static final long Reflection;
    public static final String ReflectionAlias = "reflectionColor";
    public static final long Specular;
    public static final String SpecularAlias = "specularColor";
    public final Color color = new Color();

    static {
        Diffuse = ColorAttribute.register(DiffuseAlias);
        Specular = ColorAttribute.register(SpecularAlias);
        Ambient = ColorAttribute.register(AmbientAlias);
        Emissive = ColorAttribute.register(EmissiveAlias);
        Reflection = ColorAttribute.register(ReflectionAlias);
        AmbientLight = ColorAttribute.register(AmbientLightAlias);
        Fog = ColorAttribute.register(FogAlias);
        Mask = Ambient | Diffuse | Specular | Emissive | Reflection | AmbientLight | Fog;
    }

    public ColorAttribute(long l) {
        super(l);
        if (ColorAttribute.is(l)) {
            return;
        }
        throw new GdxRuntimeException("Invalid type specified");
    }

    public ColorAttribute(long l, float f, float f2, float f3, float f4) {
        this(l);
        this.color.set(f, f2, f3, f4);
    }

    public ColorAttribute(long l, Color color2) {
        this(l);
        if (color2 != null) {
            this.color.set(color2);
        }
    }

    public ColorAttribute(ColorAttribute colorAttribute) {
        this(colorAttribute.type, colorAttribute.color);
    }

    public static final ColorAttribute createAmbient(float f, float f2, float f3, float f4) {
        return new ColorAttribute(Ambient, f, f2, f3, f4);
    }

    public static final ColorAttribute createAmbient(Color color2) {
        return new ColorAttribute(Ambient, color2);
    }

    public static final ColorAttribute createDiffuse(float f, float f2, float f3, float f4) {
        return new ColorAttribute(Diffuse, f, f2, f3, f4);
    }

    public static final ColorAttribute createDiffuse(Color color2) {
        return new ColorAttribute(Diffuse, color2);
    }

    public static final ColorAttribute createReflection(float f, float f2, float f3, float f4) {
        return new ColorAttribute(Reflection, f, f2, f3, f4);
    }

    public static final ColorAttribute createReflection(Color color2) {
        return new ColorAttribute(Reflection, color2);
    }

    public static final ColorAttribute createSpecular(float f, float f2, float f3, float f4) {
        return new ColorAttribute(Specular, f, f2, f3, f4);
    }

    public static final ColorAttribute createSpecular(Color color2) {
        return new ColorAttribute(Specular, color2);
    }

    public static final boolean is(long l) {
        boolean bl = (l & Mask) != 0L;
        return bl;
    }

    @Override
    public int compareTo(Attribute attribute) {
        if (this.type != attribute.type) {
            return (int)(this.type - attribute.type);
        }
        return ((ColorAttribute)attribute).color.toIntBits() - this.color.toIntBits();
    }

    @Override
    public Attribute copy() {
        return new ColorAttribute(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 953 + this.color.toIntBits();
    }
}

