/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.utils.Array;
import java.util.Comparator;
import java.util.Iterator;

public class Attributes
implements Iterable<Attribute>,
Comparator<Attribute>,
Comparable<Attributes> {
    protected final Array<Attribute> attributes = new Array();
    protected long mask;
    protected boolean sorted = true;

    private final void disable(long l) {
        this.mask = (l ^ 0xFFFFFFFFFFFFFFFFL) & this.mask;
    }

    private final void enable(long l) {
        this.mask = l | this.mask;
    }

    public int attributesHash() {
        this.sort();
        int n = this.attributes.size;
        long l = this.mask + 71L;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            long l2 = this.mask;
            long l3 = this.attributes.get(i).hashCode();
            n2 = n2 * 7 & 0xFFFF;
            l += l2 * l3 * (long)n2;
        }
        return (int)(l ^ l >> 32);
    }

    public void clear() {
        this.mask = 0L;
        this.attributes.clear();
    }

    @Override
    public final int compare(Attribute attribute, Attribute attribute2) {
        return (int)(attribute.type - attribute2.type);
    }

    @Override
    public int compareTo(Attributes attributes) {
        int n = 0;
        if (attributes == this) {
            return 0;
        }
        long l = this.mask;
        long l2 = attributes.mask;
        int n2 = -1;
        if (l != l2) {
            if (l >= l2) {
                n2 = 1;
            }
            return n2;
        }
        this.sort();
        attributes.sort();
        for (n2 = 0; n2 < this.attributes.size; ++n2) {
            int n3 = this.attributes.get(n2).compareTo(attributes.attributes.get(n2));
            if (n3 == 0) continue;
            if (n3 < 0) {
                n2 = -1;
            } else {
                n2 = n;
                if (n3 > 0) {
                    n2 = 1;
                }
            }
            return n2;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Attributes)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.same((Attributes)object, true);
    }

    public final Attribute get(long l) {
        if (this.has(l)) {
            for (int i = 0; i < this.attributes.size; ++i) {
                if (this.attributes.get((int)i).type != l) continue;
                return this.attributes.get(i);
            }
        }
        return null;
    }

    public final <T extends Attribute> T get(Class<T> clazz, long l) {
        return (T)this.get(l);
    }

    public final Array<Attribute> get(Array<Attribute> array, long l) {
        for (int i = 0; i < this.attributes.size; ++i) {
            if ((this.attributes.get((int)i).type & l) == 0L) continue;
            array.add(this.attributes.get(i));
        }
        return array;
    }

    public final long getMask() {
        return this.mask;
    }

    public final boolean has(long l) {
        boolean bl = l != 0L && (this.mask & l) == l;
        return bl;
    }

    public int hashCode() {
        return this.attributesHash();
    }

    protected int indexOf(long l) {
        if (this.has(l)) {
            for (int i = 0; i < this.attributes.size; ++i) {
                if (this.attributes.get((int)i).type != l) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final Iterator<Attribute> iterator() {
        return this.attributes.iterator();
    }

    public final void remove(long l) {
        for (int i = this.attributes.size - 1; i >= 0; --i) {
            long l2 = this.attributes.get((int)i).type;
            if ((l & l2) != l2) continue;
            this.attributes.removeIndex(i);
            this.disable(l2);
            this.sorted = false;
        }
        this.sort();
    }

    public final boolean same(Attributes attributes) {
        return this.same(attributes, false);
    }

    public final boolean same(Attributes attributes, boolean bl) {
        if (attributes == this) {
            return true;
        }
        if (attributes != null && this.mask == attributes.mask) {
            if (!bl) {
                return true;
            }
            this.sort();
            attributes.sort();
            for (int i = 0; i < this.attributes.size; ++i) {
                if (this.attributes.get(i).equals(attributes.attributes.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final void set(Attribute attribute) {
        int n = this.indexOf(attribute.type);
        if (n < 0) {
            this.enable(attribute.type);
            this.attributes.add(attribute);
            this.sorted = false;
        } else {
            this.attributes.set(n, attribute);
        }
        this.sort();
    }

    public final void set(Attribute attribute, Attribute attribute2) {
        this.set(attribute);
        this.set(attribute2);
    }

    public final void set(Attribute attribute, Attribute attribute2, Attribute attribute3) {
        this.set(attribute);
        this.set(attribute2);
        this.set(attribute3);
    }

    public final void set(Attribute attribute, Attribute attribute2, Attribute attribute3, Attribute attribute4) {
        this.set(attribute);
        this.set(attribute2);
        this.set(attribute3);
        this.set(attribute4);
    }

    public final void set(Iterable<Attribute> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.set((Attribute)object.next());
        }
    }

    public final void set(Attribute ... attributeArray) {
        int n = attributeArray.length;
        for (int i = 0; i < n; ++i) {
            this.set(attributeArray[i]);
        }
    }

    public int size() {
        return this.attributes.size;
    }

    public final void sort() {
        if (!this.sorted) {
            this.attributes.sort(this);
            this.sorted = true;
        }
    }
}

