/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Iterator;

public class ParticleEffect
implements Disposable {
    private BoundingBox bounds;
    private final Array<ParticleEmitter> emitters;
    protected float motionScale = 1.0f;
    private boolean ownsTexture;
    protected float xSizeScale = 1.0f;
    protected float ySizeScale = 1.0f;

    public ParticleEffect() {
        this.emitters = new Array(8);
    }

    public ParticleEffect(ParticleEffect particleEffect) {
        this.emitters = new Array(true, particleEffect.emitters.size);
        int n = particleEffect.emitters.size;
        for (int i = 0; i < n; ++i) {
            this.emitters.add(this.newEmitter(particleEffect.emitters.get(i)));
        }
    }

    public void allowCompletion() {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            this.emitters.get(i).allowCompletion();
        }
    }

    @Override
    public void dispose() {
        if (!this.ownsTexture) {
            return;
        }
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            Iterator<Sprite> iterator = this.emitters.get(i).getSprites().iterator();
            while (iterator.hasNext()) {
                iterator.next().getTexture().dispose();
            }
        }
    }

    public void draw(Batch batch) {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            this.emitters.get(i).draw(batch);
        }
    }

    public void draw(Batch batch, float f) {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            this.emitters.get(i).draw(batch, f);
        }
    }

    public ParticleEmitter findEmitter(String string2) {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            ParticleEmitter particleEmitter = this.emitters.get(i);
            if (!particleEmitter.getName().equals(string2)) continue;
            return particleEmitter;
        }
        return null;
    }

    public void flipY() {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            this.emitters.get(i).flipY();
        }
    }

    public BoundingBox getBoundingBox() {
        if (this.bounds == null) {
            this.bounds = new BoundingBox();
        }
        BoundingBox boundingBox = this.bounds;
        boundingBox.inf();
        Iterator<ParticleEmitter> iterator = this.emitters.iterator();
        while (iterator.hasNext()) {
            boundingBox.ext(iterator.next().getBoundingBox());
        }
        return boundingBox;
    }

    public Array<ParticleEmitter> getEmitters() {
        return this.emitters;
    }

    public boolean isComplete() {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            if (this.emitters.get(i).isComplete()) continue;
            return false;
        }
        return true;
    }

    public void load(FileHandle fileHandle, FileHandle fileHandle2) {
        this.loadEmitters(fileHandle);
        this.loadEmitterImages(fileHandle2);
    }

    public void load(FileHandle fileHandle, TextureAtlas textureAtlas) {
        this.load(fileHandle, textureAtlas, null);
    }

    public void load(FileHandle fileHandle, TextureAtlas textureAtlas, String string2) {
        this.loadEmitters(fileHandle);
        this.loadEmitterImages(textureAtlas, string2);
    }

    public void loadEmitterImages(FileHandle fileHandle) {
        this.ownsTexture = true;
        ObjectMap<String, Sprite> objectMap = new ObjectMap<String, Sprite>(this.emitters.size);
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            ParticleEmitter particleEmitter = this.emitters.get(i);
            if (particleEmitter.getImagePaths().size == 0) continue;
            Array<Sprite> array = new Array<Sprite>();
            Iterator<String> iterator = particleEmitter.getImagePaths().iterator();
            while (iterator.hasNext()) {
                Sprite sprite;
                String string2 = new File(iterator.next().replace('\\', '/')).getName();
                Sprite sprite2 = sprite = (Sprite)objectMap.get(string2);
                if (sprite == null) {
                    sprite2 = new Sprite(this.loadTexture(fileHandle.child(string2)));
                    objectMap.put(string2, sprite2);
                }
                array.add(sprite2);
            }
            particleEmitter.setSprites(array);
        }
    }

    public void loadEmitterImages(TextureAtlas textureAtlas) {
        this.loadEmitterImages(textureAtlas, null);
    }

    public void loadEmitterImages(TextureAtlas object, String string2) {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            ParticleEmitter particleEmitter = this.emitters.get(i);
            if (particleEmitter.getImagePaths().size == 0) continue;
            Array<Sprite> array = new Array<Sprite>();
            Iterator<String> iterator = particleEmitter.getImagePaths().iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = new File(iterator.next().replace('\\', '/')).getName();
                int n2 = ((String)charSequence).lastIndexOf(46);
                Object object2 = charSequence;
                if (n2 != -1) {
                    object2 = ((String)charSequence).substring(0, n2);
                }
                charSequence = object2;
                if (string2 != null) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append(string2);
                    ((StringBuilder)charSequence).append((String)object2);
                    charSequence = ((StringBuilder)charSequence).toString();
                }
                if ((object2 = ((TextureAtlas)object).createSprite((String)charSequence)) != null) {
                    array.add((Sprite)object2);
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("SpriteSheet missing image: ");
                ((StringBuilder)object).append((String)charSequence);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            particleEmitter.setSprites(array);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadEmitters(FileHandle fileHandle) {
        void var1_4;
        Object object;
        block8: {
            BufferedReader bufferedReader;
            GdxRuntimeException gdxRuntimeException;
            Object object2;
            block9: {
                object2 = fileHandle.read();
                this.emitters.clear();
                gdxRuntimeException = null;
                BufferedReader bufferedReader2 = null;
                object = bufferedReader2;
                try {
                    object = bufferedReader2;
                    object = bufferedReader2;
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object2);
                    object = bufferedReader2;
                    bufferedReader = new BufferedReader(inputStreamReader, 512);
                }
                catch (Throwable throwable) {
                    break block8;
                }
                catch (IOException iOException) {
                    bufferedReader = gdxRuntimeException;
                    break block9;
                }
                try {
                    do {
                        object = this.newEmitter(bufferedReader);
                        this.emitters.add((ParticleEmitter)object);
                    } while ((object = bufferedReader.readLine()) != null);
                }
                catch (Throwable throwable) {
                    object = bufferedReader;
                    break block8;
                }
                catch (IOException iOException) {
                    break block9;
                }
                StreamUtils.closeQuietly(bufferedReader);
                return;
            }
            object = bufferedReader;
            {
                void var4_10;
                object = bufferedReader;
                object = bufferedReader;
                object2 = new StringBuilder();
                object = bufferedReader;
                ((StringBuilder)object2).append("Error loading effect: ");
                object = bufferedReader;
                ((StringBuilder)object2).append(fileHandle);
                object = bufferedReader;
                gdxRuntimeException = new GdxRuntimeException(((StringBuilder)object2).toString(), (Throwable)var4_10);
                object = bufferedReader;
                throw gdxRuntimeException;
            }
        }
        StreamUtils.closeQuietly(object);
        throw var1_4;
    }

    protected Texture loadTexture(FileHandle fileHandle) {
        return new Texture(fileHandle, false);
    }

    protected ParticleEmitter newEmitter(ParticleEmitter particleEmitter) {
        return new ParticleEmitter(particleEmitter);
    }

    protected ParticleEmitter newEmitter(BufferedReader bufferedReader) throws IOException {
        return new ParticleEmitter(bufferedReader);
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            this.emitters.get(i).reset();
        }
        if (bl && (this.xSizeScale != 1.0f || this.ySizeScale != 1.0f || this.motionScale != 1.0f)) {
            this.scaleEffect(1.0f / this.xSizeScale, 1.0f / this.ySizeScale, 1.0f / this.motionScale);
            this.motionScale = 1.0f;
            this.ySizeScale = 1.0f;
            this.xSizeScale = 1.0f;
        }
    }

    public void save(Writer writer) throws IOException {
        int n = this.emitters.size;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            ParticleEmitter particleEmitter = this.emitters.get(n2);
            if (n3 > 0) {
                writer.write("\n");
            }
            particleEmitter.save(writer);
            ++n2;
            ++n3;
        }
    }

    public void scaleEffect(float f) {
        this.scaleEffect(f, f, f);
    }

    public void scaleEffect(float f, float f2) {
        this.scaleEffect(f, f, f2);
    }

    public void scaleEffect(float f, float f2, float f3) {
        this.xSizeScale *= f;
        this.ySizeScale *= f2;
        this.motionScale *= f3;
        for (ParticleEmitter particleEmitter : this.emitters) {
            particleEmitter.scaleSize(f, f2);
            particleEmitter.scaleMotion(f3);
        }
    }

    public void setDuration(int n) {
        int n2 = this.emitters.size;
        for (int i = 0; i < n2; ++i) {
            ParticleEmitter particleEmitter = this.emitters.get(i);
            particleEmitter.setContinuous(false);
            particleEmitter.duration = n;
            particleEmitter.durationTimer = 0.0f;
        }
    }

    public void setEmittersCleanUpBlendFunction(boolean bl) {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            this.emitters.get(i).setCleansUpBlendFunction(bl);
        }
    }

    public void setFlip(boolean bl, boolean bl2) {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            this.emitters.get(i).setFlip(bl, bl2);
        }
    }

    public void setPosition(float f, float f2) {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            this.emitters.get(i).setPosition(f, f2);
        }
    }

    public void start() {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            this.emitters.get(i).start();
        }
    }

    public void update(float f) {
        int n = this.emitters.size;
        for (int i = 0; i < n; ++i) {
            this.emitters.get(i).update(f);
        }
    }
}

