/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.glutils.ETC1TextureData;
import com.badlogic.gdx.graphics.glutils.FileTextureData;
import com.badlogic.gdx.graphics.glutils.KTXTextureData;

public interface TextureData {
    public void consumeCustomData(int var1);

    public Pixmap consumePixmap();

    public boolean disposePixmap();

    public Pixmap.Format getFormat();

    public int getHeight();

    public TextureDataType getType();

    public int getWidth();

    public boolean isManaged();

    public boolean isPrepared();

    public void prepare();

    public boolean useMipMaps();

    public static class Factory {
        public static TextureData loadFromFile(FileHandle fileHandle, Pixmap.Format format, boolean bl) {
            if (fileHandle == null) {
                return null;
            }
            if (fileHandle.name().endsWith(".cim")) {
                return new FileTextureData(fileHandle, PixmapIO.readCIM(fileHandle), format, bl);
            }
            if (fileHandle.name().endsWith(".etc1")) {
                return new ETC1TextureData(fileHandle, bl);
            }
            if (!fileHandle.name().endsWith(".ktx") && !fileHandle.name().endsWith(".zktx")) {
                return new FileTextureData(fileHandle, new Pixmap(fileHandle), format, bl);
            }
            return new KTXTextureData(fileHandle, bl);
        }

        public static TextureData loadFromFile(FileHandle fileHandle, boolean bl) {
            return Factory.loadFromFile(fileHandle, null, bl);
        }
    }

    public static enum TextureDataType {
        Pixmap,
        Custom;

    }
}

