/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.MipMapGenerator;
import com.badlogic.gdx.utils.Disposable;

public abstract class GLTexture
implements Disposable {
    protected int glHandle;
    public final int glTarget;
    protected Texture.TextureFilter magFilter;
    protected Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
    protected Texture.TextureWrap uWrap;
    protected Texture.TextureWrap vWrap;

    public GLTexture(int n) {
        this(n, Gdx.gl.glGenTexture());
    }

    public GLTexture(int n, int n2) {
        this.magFilter = Texture.TextureFilter.Nearest;
        this.uWrap = Texture.TextureWrap.ClampToEdge;
        this.vWrap = Texture.TextureWrap.ClampToEdge;
        this.glTarget = n;
        this.glHandle = n2;
    }

    protected static void uploadImageData(int n, TextureData textureData) {
        GLTexture.uploadImageData(n, textureData, 0);
    }

    public static void uploadImageData(int n, TextureData textureData, int n2) {
        if (textureData == null) {
            return;
        }
        if (!textureData.isPrepared()) {
            textureData.prepare();
        }
        if (textureData.getType() == TextureData.TextureDataType.Custom) {
            textureData.consumeCustomData(n);
            return;
        }
        Pixmap pixmap = textureData.consumePixmap();
        boolean bl = textureData.disposePixmap();
        Pixmap pixmap2 = pixmap;
        if (textureData.getFormat() != pixmap.getFormat()) {
            pixmap2 = new Pixmap(pixmap.getWidth(), pixmap.getHeight(), textureData.getFormat());
            pixmap2.setBlending(Pixmap.Blending.None);
            pixmap2.drawPixmap(pixmap, 0, 0, 0, 0, pixmap.getWidth(), pixmap.getHeight());
            if (textureData.disposePixmap()) {
                pixmap.dispose();
            }
            bl = true;
        }
        Gdx.gl.glPixelStorei(3317, 1);
        if (textureData.useMipMaps()) {
            MipMapGenerator.generateMipMap(n, pixmap2, pixmap2.getWidth(), pixmap2.getHeight());
        } else {
            Gdx.gl.glTexImage2D(n, n2, pixmap2.getGLInternalFormat(), pixmap2.getWidth(), pixmap2.getHeight(), 0, pixmap2.getGLFormat(), pixmap2.getGLType(), pixmap2.getPixels());
        }
        if (bl) {
            pixmap2.dispose();
        }
    }

    public void bind() {
        Gdx.gl.glBindTexture(this.glTarget, this.glHandle);
    }

    public void bind(int n) {
        Gdx.gl.glActiveTexture(n + 33984);
        Gdx.gl.glBindTexture(this.glTarget, this.glHandle);
    }

    protected void delete() {
        if (this.glHandle != 0) {
            Gdx.gl.glDeleteTexture(this.glHandle);
            this.glHandle = 0;
        }
    }

    @Override
    public void dispose() {
        this.delete();
    }

    public abstract int getDepth();

    public abstract int getHeight();

    public Texture.TextureFilter getMagFilter() {
        return this.magFilter;
    }

    public Texture.TextureFilter getMinFilter() {
        return this.minFilter;
    }

    public int getTextureObjectHandle() {
        return this.glHandle;
    }

    public Texture.TextureWrap getUWrap() {
        return this.uWrap;
    }

    public Texture.TextureWrap getVWrap() {
        return this.vWrap;
    }

    public abstract int getWidth();

    public abstract boolean isManaged();

    protected abstract void reload();

    public void setFilter(Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2) {
        this.minFilter = textureFilter;
        this.magFilter = textureFilter2;
        this.bind();
        Gdx.gl.glTexParameteri(this.glTarget, 10241, textureFilter.getGLEnum());
        Gdx.gl.glTexParameteri(this.glTarget, 10240, textureFilter2.getGLEnum());
    }

    public void setWrap(Texture.TextureWrap textureWrap, Texture.TextureWrap textureWrap2) {
        this.uWrap = textureWrap;
        this.vWrap = textureWrap2;
        this.bind();
        Gdx.gl.glTexParameteri(this.glTarget, 10242, textureWrap.getGLEnum());
        Gdx.gl.glTexParameteri(this.glTarget, 10243, textureWrap2.getGLEnum());
    }

    public void unsafeSetFilter(Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2) {
        this.unsafeSetFilter(textureFilter, textureFilter2, false);
    }

    public void unsafeSetFilter(Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2, boolean bl) {
        if (textureFilter != null && (bl || this.minFilter != textureFilter)) {
            Gdx.gl.glTexParameteri(this.glTarget, 10241, textureFilter.getGLEnum());
            this.minFilter = textureFilter;
        }
        if (textureFilter2 != null && (bl || this.magFilter != textureFilter2)) {
            Gdx.gl.glTexParameteri(this.glTarget, 10240, textureFilter2.getGLEnum());
            this.magFilter = textureFilter2;
        }
    }

    public void unsafeSetWrap(Texture.TextureWrap textureWrap, Texture.TextureWrap textureWrap2) {
        this.unsafeSetWrap(textureWrap, textureWrap2, false);
    }

    public void unsafeSetWrap(Texture.TextureWrap textureWrap, Texture.TextureWrap textureWrap2, boolean bl) {
        if (textureWrap != null && (bl || this.uWrap != textureWrap)) {
            Gdx.gl.glTexParameteri(this.glTarget, 10242, textureWrap.getGLEnum());
            this.uWrap = textureWrap;
        }
        if (textureWrap2 != null && (bl || this.vWrap != textureWrap2)) {
            Gdx.gl.glTexParameteri(this.glTarget, 10243, textureWrap2.getGLEnum());
            this.vWrap = textureWrap2;
        }
    }
}

