/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Handler;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidGraphics;
import com.badlogic.gdx.backends.android.AndroidMultiTouchHandler;
import com.badlogic.gdx.backends.android.AndroidOnscreenKeyboard;
import com.badlogic.gdx.backends.android.AndroidTouchHandler;
import com.badlogic.gdx.utils.IntSet;
import com.badlogic.gdx.utils.Pool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AndroidInput
implements View.OnKeyListener,
View.OnTouchListener,
Input {
    public static final int NUM_TOUCHES = 20;
    public static final int SUPPORTED_KEYS = 260;
    final float[] R;
    public boolean accelerometerAvailable;
    private SensorEventListener accelerometerListener;
    protected final float[] accelerometerValues;
    final Application app;
    private float azimuth;
    int[] button;
    private boolean compassAvailable;
    private SensorEventListener compassListener;
    private final AndroidApplicationConfiguration config;
    final Context context;
    private long currentEventTimeStamp;
    int[] deltaX;
    int[] deltaY;
    public boolean gyroscopeAvailable;
    private SensorEventListener gyroscopeListener;
    protected final float[] gyroscopeValues;
    private Handler handle;
    final boolean hasMultitouch;
    private float inclination;
    private boolean[] justPressedButtons;
    private boolean[] justPressedKeys;
    private boolean justTouched;
    private int keyCount;
    ArrayList<KeyEvent> keyEvents;
    private boolean keyJustPressed;
    ArrayList<View.OnKeyListener> keyListeners;
    boolean keyboardAvailable;
    private boolean[] keys;
    private IntSet keysToCatch;
    protected final float[] magneticFieldValues;
    private SensorManager manager;
    protected final Input.Orientation nativeOrientation;
    private final AndroidOnscreenKeyboard onscreenKeyboard;
    final float[] orientation;
    private float pitch;
    float[] pressure;
    private InputProcessor processor;
    int[] realId;
    boolean requestFocus;
    private float roll;
    private boolean rotationVectorAvailable;
    private SensorEventListener rotationVectorListener;
    protected final float[] rotationVectorValues;
    private int sleepTime;
    private String text;
    private Input.TextInputListener textListener;
    ArrayList<TouchEvent> touchEvents;
    protected final AndroidTouchHandler touchHandler;
    int[] touchX;
    int[] touchY;
    boolean[] touched;
    Pool<KeyEvent> usedKeyEvents = new Pool<KeyEvent>(16, 1000){

        @Override
        protected KeyEvent newObject() {
            return new KeyEvent();
        }
    };
    Pool<TouchEvent> usedTouchEvents = new Pool<TouchEvent>(16, 1000){

        @Override
        protected TouchEvent newObject() {
            return new TouchEvent();
        }
    };
    protected final Vibrator vibrator;

    public AndroidInput(Application object, Context context, Object object2, AndroidApplicationConfiguration androidApplicationConfiguration) {
        this.keyListeners = new ArrayList();
        this.keyEvents = new ArrayList();
        this.touchEvents = new ArrayList();
        this.touchX = new int[20];
        this.touchY = new int[20];
        this.deltaX = new int[20];
        this.deltaY = new int[20];
        this.touched = new boolean[20];
        this.button = new int[20];
        this.realId = new int[20];
        this.pressure = new float[20];
        int n = 0;
        this.keyCount = 0;
        this.keys = new boolean[260];
        this.keyJustPressed = false;
        this.justPressedKeys = new boolean[260];
        this.justPressedButtons = new boolean[20];
        this.accelerometerAvailable = false;
        this.accelerometerValues = new float[3];
        this.gyroscopeAvailable = false;
        this.gyroscopeValues = new float[3];
        this.text = null;
        this.textListener = null;
        this.sleepTime = 0;
        this.keysToCatch = new IntSet();
        this.compassAvailable = false;
        this.rotationVectorAvailable = false;
        this.magneticFieldValues = new float[3];
        this.rotationVectorValues = new float[3];
        this.azimuth = 0.0f;
        this.pitch = 0.0f;
        this.roll = 0.0f;
        this.inclination = 0.0f;
        this.justTouched = false;
        this.currentEventTimeStamp = 0L;
        this.requestFocus = true;
        this.R = new float[9];
        this.orientation = new float[3];
        if (object2 instanceof View) {
            object2 = (View)object2;
            object2.setOnKeyListener((View.OnKeyListener)this);
            object2.setOnTouchListener((View.OnTouchListener)this);
            object2.setFocusable(true);
            object2.setFocusableInTouchMode(true);
            object2.requestFocus();
        }
        this.config = androidApplicationConfiguration;
        this.onscreenKeyboard = new AndroidOnscreenKeyboard(context, new Handler(), this);
        while (n < ((Object)(object2 = (Object)this.realId)).length) {
            object2[n] = -1;
            ++n;
        }
        this.handle = new Handler();
        this.app = object;
        this.context = context;
        this.sleepTime = androidApplicationConfiguration.touchSleepTime;
        this.touchHandler = new AndroidMultiTouchHandler();
        this.hasMultitouch = this.touchHandler.supportsMultitouch(context);
        this.vibrator = (Vibrator)context.getSystemService("vibrator");
        n = this.getRotation();
        object = this.app.getGraphics().getDisplayMode();
        this.nativeOrientation = (n != 0 && n != 180 || ((Graphics.DisplayMode)object).width < ((Graphics.DisplayMode)object).height) && (n != 90 && n != 270 || ((Graphics.DisplayMode)object).width > ((Graphics.DisplayMode)object).height) ? Input.Orientation.Portrait : Input.Orientation.Landscape;
        this.keysToCatch.add(255);
    }

    private int[] resize(int[] nArray) {
        int[] nArray2 = new int[nArray.length + 2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private boolean[] resize(boolean[] blArray) {
        boolean[] blArray2 = new boolean[blArray.length + 2];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        return blArray2;
    }

    private void updateOrientation() {
        if (this.rotationVectorAvailable) {
            SensorManager.getRotationMatrixFromVector((float[])this.R, (float[])this.rotationVectorValues);
        } else if (!SensorManager.getRotationMatrix((float[])this.R, null, (float[])this.accelerometerValues, (float[])this.magneticFieldValues)) {
            return;
        }
        SensorManager.getOrientation((float[])this.R, (float[])this.orientation);
        this.azimuth = (float)Math.toDegrees(this.orientation[0]);
        this.pitch = (float)Math.toDegrees(this.orientation[1]);
        this.roll = (float)Math.toDegrees(this.orientation[2]);
    }

    public void addKeyListener(View.OnKeyListener onKeyListener) {
        this.keyListeners.add(onKeyListener);
    }

    @Override
    public void cancelVibrate() {
        this.vibrator.cancel();
    }

    @Override
    public float getAccelerometerX() {
        return this.accelerometerValues[0];
    }

    @Override
    public float getAccelerometerY() {
        return this.accelerometerValues[1];
    }

    @Override
    public float getAccelerometerZ() {
        return this.accelerometerValues[2];
    }

    @Override
    public float getAzimuth() {
        if (!this.compassAvailable && !this.rotationVectorAvailable) {
            return 0.0f;
        }
        this.updateOrientation();
        return this.azimuth;
    }

    @Override
    public long getCurrentEventTime() {
        return this.currentEventTimeStamp;
    }

    @Override
    public int getDeltaX() {
        return this.deltaX[0];
    }

    @Override
    public int getDeltaX(int n) {
        return this.deltaX[n];
    }

    @Override
    public int getDeltaY() {
        return this.deltaY[0];
    }

    @Override
    public int getDeltaY(int n) {
        return this.deltaY[n];
    }

    public int getFreePointerIndex() {
        int n = this.realId.length;
        for (int i = 0; i < n; ++i) {
            if (this.realId[i] != -1) continue;
            return i;
        }
        this.realId = this.resize(this.realId);
        this.touchX = this.resize(this.touchX);
        this.touchY = this.resize(this.touchY);
        this.deltaX = this.resize(this.deltaX);
        this.deltaY = this.resize(this.deltaY);
        this.touched = this.resize(this.touched);
        this.button = this.resize(this.button);
        return n;
    }

    @Override
    public float getGyroscopeX() {
        return this.gyroscopeValues[0];
    }

    @Override
    public float getGyroscopeY() {
        return this.gyroscopeValues[1];
    }

    @Override
    public float getGyroscopeZ() {
        return this.gyroscopeValues[2];
    }

    @Override
    public InputProcessor getInputProcessor() {
        return this.processor;
    }

    @Override
    public int getMaxPointers() {
        return 20;
    }

    @Override
    public Input.Orientation getNativeOrientation() {
        return this.nativeOrientation;
    }

    @Override
    public float getPitch() {
        if (!this.compassAvailable && !this.rotationVectorAvailable) {
            return 0.0f;
        }
        this.updateOrientation();
        return this.pitch;
    }

    @Override
    public float getPressure() {
        return this.getPressure(0);
    }

    @Override
    public float getPressure(int n) {
        return this.pressure[n];
    }

    @Override
    public float getRoll() {
        if (!this.compassAvailable && !this.rotationVectorAvailable) {
            return 0.0f;
        }
        this.updateOrientation();
        return this.roll;
    }

    @Override
    public int getRotation() {
        Context context = this.context;
        int n = context instanceof Activity ? ((Activity)context).getWindowManager().getDefaultDisplay().getRotation() : ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation();
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        return 0;
                    }
                    return 270;
                }
                return 180;
            }
            return 90;
        }
        return 0;
    }

    @Override
    public void getRotationMatrix(float[] fArray) {
        if (this.rotationVectorAvailable) {
            SensorManager.getRotationMatrixFromVector((float[])fArray, (float[])this.rotationVectorValues);
        } else {
            SensorManager.getRotationMatrix((float[])fArray, null, (float[])this.accelerometerValues, (float[])this.magneticFieldValues);
        }
    }

    @Override
    public void getTextInput(final Input.TextInputListener textInputListener, final String string2, final String string3, final String string4) {
        this.handle.post(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder(AndroidInput.this.context);
                builder.setTitle((CharSequence)string2);
                final EditText editText = new EditText(AndroidInput.this.context);
                editText.setHint((CharSequence)string4);
                editText.setText((CharSequence)string3);
                editText.setSingleLine();
                builder.setView((View)editText);
                builder.setPositiveButton((CharSequence)AndroidInput.this.context.getString(17039370), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                textInputListener.input(editText.getText().toString());
                            }
                        });
                    }
                });
                builder.setNegativeButton((CharSequence)AndroidInput.this.context.getString(0x1040000), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                textInputListener.canceled();
                            }
                        });
                    }
                });
                builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialogInterface) {
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                textInputListener.canceled();
                            }
                        });
                    }
                });
                builder.show();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getX() {
        synchronized (this) {
            return this.touchX[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getX(int n) {
        synchronized (this) {
            return this.touchX[n];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getY() {
        synchronized (this) {
            return this.touchY[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getY(int n) {
        synchronized (this) {
            return this.touchY[n];
        }
    }

    @Override
    public boolean isButtonJustPressed(int n) {
        if (n >= 0 && n <= 20) {
            return this.justPressedButtons[n];
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isButtonPressed(int n) {
        synchronized (this) {
            boolean bl = this.hasMultitouch;
            boolean bl2 = true;
            if (bl) {
                for (int i = 0; i < 20; ++i) {
                    if (!this.touched[i] || this.button[i] != n) continue;
                    return true;
                }
            }
            if (!this.touched[0]) return false;
            if (this.button[0] != n) return false;
            return bl2;
        }
    }

    @Override
    public boolean isCatchBackKey() {
        return this.keysToCatch.contains(4);
    }

    @Override
    public boolean isCatchKey(int n) {
        return this.keysToCatch.contains(this.keyCount);
    }

    @Override
    public boolean isCatchMenuKey() {
        return this.keysToCatch.contains(82);
    }

    @Override
    public boolean isCursorCatched() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isKeyJustPressed(int n) {
        synchronized (this) {
            Throwable throwable2;
            if (n == -1) {
                try {
                    return this.keyJustPressed;
                }
                catch (Throwable throwable2) {
                }
            } else {
                if (n < 0) return false;
                if (n >= 260) return false;
                return this.justPressedKeys[n];
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isKeyPressed(int n) {
        synchronized (this) {
            boolean bl = false;
            if (n == -1) {
                try {
                    n = this.keyCount;
                    if (n <= 0) return bl;
                    return true;
                }
                catch (Throwable throwable) {}
                throw throwable;
            }
            if (n < 0) return false;
            if (n < 260) return this.keys[n];
            return false;
        }
    }

    @Override
    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        if (peripheral == Input.Peripheral.Accelerometer) {
            return this.accelerometerAvailable;
        }
        if (peripheral == Input.Peripheral.Gyroscope) {
            return this.gyroscopeAvailable;
        }
        if (peripheral == Input.Peripheral.Compass) {
            return this.compassAvailable;
        }
        if (peripheral == Input.Peripheral.HardwareKeyboard) {
            return this.keyboardAvailable;
        }
        Input.Peripheral peripheral2 = Input.Peripheral.OnscreenKeyboard;
        boolean bl = true;
        boolean bl2 = true;
        if (peripheral == peripheral2) {
            return true;
        }
        if (peripheral == Input.Peripheral.Vibrator) {
            if (Build.VERSION.SDK_INT >= 11) {
                peripheral = this.vibrator;
                if (peripheral == null || !peripheral.hasVibrator()) {
                    bl2 = false;
                }
                return bl2;
            }
            bl2 = this.vibrator != null ? bl : false;
            return bl2;
        }
        if (peripheral == Input.Peripheral.MultitouchScreen) {
            return this.hasMultitouch;
        }
        if (peripheral == Input.Peripheral.RotationVector) {
            return this.rotationVectorAvailable;
        }
        return peripheral == Input.Peripheral.Pressure;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isTouched() {
        synchronized (this) {
            if (!this.hasMultitouch) return this.touched[0];
            int n = 0;
            while (n < 20) {
                if (this.touched[n]) {
                    return true;
                }
                ++n;
            }
            return this.touched[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isTouched(int n) {
        synchronized (this) {
            return this.touched[n];
        }
    }

    @Override
    public boolean justTouched() {
        return this.justTouched;
    }

    public int lookUpPointerIndex(int n) {
        Object object;
        int n2;
        int n3 = this.realId.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.realId[n2] != n) continue;
            return n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = n4; n2 < n3; ++n2) {
            object = new StringBuilder();
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(":");
            ((StringBuilder)object).append(this.realId[n2]);
            ((StringBuilder)object).append(" ");
            stringBuilder.append(((StringBuilder)object).toString());
        }
        object = Gdx.app;
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("Pointer ID lookup failed: ");
        stringBuilder2.append(n);
        stringBuilder2.append(", ");
        stringBuilder2.append(stringBuilder.toString());
        object.log("AndroidInput", stringBuilder2.toString());
        return -1;
    }

    public void onDrop(int n, int n2) {
        this.postTap(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onKey(View object, int n, android.view.KeyEvent object2) {
        int n2;
        int n3 = this.keyListeners.size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.keyListeners.get(n2).onKey(object, n, (android.view.KeyEvent)object2)) continue;
            return true;
        }
        if (object2.getAction() == 0 && object2.getRepeatCount() > 0) {
            return this.keysToCatch.contains(n);
        }
        synchronized (this) {
            block20: {
                block22: {
                    block21: {
                        if (object2.getKeyCode() == 0 && object2.getAction() == 2) {
                            object2 = object2.getCharacters();
                            for (n = 0; n < ((String)object2).length(); ++n) {
                                object = this.usedKeyEvents.obtain();
                                object.timeStamp = System.nanoTime();
                                object.keyCode = 0;
                                object.keyChar = ((String)object2).charAt(n);
                                object.type = 2;
                                this.keyEvents.add((KeyEvent)object);
                            }
                            return false;
                        }
                        n3 = (char)object2.getUnicodeChar();
                        if (n == 67) {
                            n3 = 8;
                        }
                        if (object2.getKeyCode() < 0 || object2.getKeyCode() >= 260) break block20;
                        n2 = object2.getAction();
                        if (n2 == 0) break block21;
                        if (n2 == 1) {
                            long l = System.nanoTime();
                            object = this.usedKeyEvents.obtain();
                            object.timeStamp = l;
                            object.keyChar = (char)0;
                            object.keyCode = object2.getKeyCode();
                            object.type = 1;
                            n2 = n;
                            if (n == 4) {
                                n2 = n;
                                if (object2.isAltPressed()) {
                                    object.keyCode = 255;
                                    n2 = 255;
                                }
                            }
                            this.keyEvents.add((KeyEvent)object);
                            object = this.usedKeyEvents.obtain();
                            object.timeStamp = l;
                            object.keyChar = (char)n3;
                            object.keyCode = 0;
                            object.type = 2;
                            this.keyEvents.add((KeyEvent)object);
                            if (n2 == 255) {
                                n = n2;
                                if (this.keys[255]) {
                                    --this.keyCount;
                                    this.keys[255] = false;
                                    n = n2;
                                }
                                break block22;
                            } else {
                                n = n2;
                                if (this.keys[object2.getKeyCode()]) {
                                    --this.keyCount;
                                    this.keys[object2.getKeyCode()] = false;
                                    n = n2;
                                }
                            }
                        }
                        break block22;
                    }
                    object = this.usedKeyEvents.obtain();
                    object.timeStamp = System.nanoTime();
                    object.keyChar = (char)0;
                    object.keyCode = object2.getKeyCode();
                    object.type = 0;
                    n2 = n;
                    if (n == 4) {
                        n2 = n;
                        if (object2.isAltPressed()) {
                            object.keyCode = 255;
                            n2 = 255;
                        }
                    }
                    this.keyEvents.add((KeyEvent)object);
                    n = n2;
                    if (!this.keys[object.keyCode]) {
                        ++this.keyCount;
                        this.keys[object.keyCode] = true;
                        n = n2;
                    }
                }
                this.app.getGraphics().requestRendering();
                return this.keysToCatch.contains(n);
            }
            return false;
        }
    }

    public void onPause() {
        this.unregisterSensorListeners();
        Arrays.fill(this.realId, -1);
        Arrays.fill(this.touched, false);
    }

    public void onResume() {
        this.registerSensorListeners();
    }

    public void onTap(int n, int n2) {
        this.postTap(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.requestFocus && view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
            this.requestFocus = false;
        }
        this.touchHandler.onTouch(motionEvent, this);
        int n = this.sleepTime;
        if (n == 0) return true;
        long l = n;
        try {
            Thread.sleep(l);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void postTap(int n, int n2) {
        synchronized (this) {
            TouchEvent touchEvent = this.usedTouchEvents.obtain();
            touchEvent.timeStamp = System.nanoTime();
            touchEvent.pointer = 0;
            touchEvent.x = n;
            touchEvent.y = n2;
            touchEvent.type = 0;
            this.touchEvents.add(touchEvent);
            touchEvent = this.usedTouchEvents.obtain();
            touchEvent.timeStamp = System.nanoTime();
            touchEvent.pointer = 0;
            touchEvent.x = n;
            touchEvent.y = n2;
            touchEvent.type = 1;
            this.touchEvents.add(touchEvent);
        }
        Gdx.app.getGraphics().requestRendering();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processEvents() {
        synchronized (this) {
            block28: {
                int n;
                block27: {
                    int n2;
                    Object object;
                    block26: {
                        int n3;
                        Object object2;
                        if (this.justTouched) {
                            this.justTouched = false;
                            for (n = 0; n < this.justPressedButtons.length; ++n) {
                                this.justPressedButtons[n] = false;
                            }
                        }
                        if (this.keyJustPressed) {
                            this.keyJustPressed = false;
                            for (n = 0; n < this.justPressedKeys.length; ++n) {
                                this.justPressedKeys[n] = false;
                            }
                        }
                        if (this.processor == null) break block26;
                        object = this.processor;
                        n2 = this.keyEvents.size();
                        for (n = 0; n < n2; ++n) {
                            block30: {
                                block29: {
                                    object2 = this.keyEvents.get(n);
                                    this.currentEventTimeStamp = ((KeyEvent)object2).timeStamp;
                                    n3 = ((KeyEvent)object2).type;
                                    if (n3 == 0) break block29;
                                    if (n3 != 1) {
                                        if (n3 == 2) {
                                            object.keyTyped(((KeyEvent)object2).keyChar);
                                        }
                                        break block30;
                                    } else {
                                        object.keyUp(((KeyEvent)object2).keyCode);
                                    }
                                    break block30;
                                }
                                object.keyDown(((KeyEvent)object2).keyCode);
                                this.keyJustPressed = true;
                                this.justPressedKeys[((KeyEvent)object2).keyCode] = true;
                            }
                            this.usedKeyEvents.free((KeyEvent)object2);
                        }
                        n2 = this.touchEvents.size();
                        for (n = 0; n < n2; ++n) {
                            block34: {
                                block31: {
                                    block32: {
                                        block33: {
                                            object2 = this.touchEvents.get(n);
                                            this.currentEventTimeStamp = ((TouchEvent)object2).timeStamp;
                                            n3 = ((TouchEvent)object2).type;
                                            if (n3 == 0) break block31;
                                            if (n3 == 1) break block32;
                                            if (n3 == 2) break block33;
                                            if (n3 != 3) {
                                                if (n3 == 4) {
                                                    object.mouseMoved(((TouchEvent)object2).x, ((TouchEvent)object2).y);
                                                }
                                                break block34;
                                            } else {
                                                object.scrolled(((TouchEvent)object2).scrollAmount);
                                            }
                                            break block34;
                                        }
                                        object.touchDragged(((TouchEvent)object2).x, ((TouchEvent)object2).y, ((TouchEvent)object2).pointer);
                                        break block34;
                                    }
                                    object.touchUp(((TouchEvent)object2).x, ((TouchEvent)object2).y, ((TouchEvent)object2).pointer, ((TouchEvent)object2).button);
                                    break block34;
                                }
                                object.touchDown(((TouchEvent)object2).x, ((TouchEvent)object2).y, ((TouchEvent)object2).pointer, ((TouchEvent)object2).button);
                                this.justTouched = true;
                                this.justPressedButtons[((TouchEvent)object2).button] = true;
                            }
                            this.usedTouchEvents.free((TouchEvent)object2);
                        }
                        break block27;
                    }
                    n2 = this.touchEvents.size();
                    for (n = 0; n < n2; ++n) {
                        object = this.touchEvents.get(n);
                        if (((TouchEvent)object).type == 0) {
                            this.justTouched = true;
                        }
                        this.usedTouchEvents.free((TouchEvent)object);
                    }
                    n2 = this.keyEvents.size();
                    for (n = 0; n < n2; ++n) {
                        this.usedKeyEvents.free(this.keyEvents.get(n));
                    }
                }
                if (!this.touchEvents.isEmpty()) break block28;
                for (n = 0; n < this.deltaX.length; ++n) {
                    this.deltaX[0] = 0;
                    this.deltaY[0] = 0;
                }
            }
            this.keyEvents.clear();
            this.touchEvents.clear();
            return;
        }
    }

    void registerSensorListeners() {
        Object object;
        if (this.config.useAccelerometer) {
            this.manager = (SensorManager)this.context.getSystemService("sensor");
            if (this.manager.getSensorList(1).isEmpty()) {
                this.accelerometerAvailable = false;
            } else {
                object = (Sensor)this.manager.getSensorList(1).get(0);
                this.accelerometerListener = new SensorListener();
                this.accelerometerAvailable = this.manager.registerListener(this.accelerometerListener, (Sensor)object, this.config.sensorDelay);
            }
        } else {
            this.accelerometerAvailable = false;
        }
        if (this.config.useGyroscope) {
            this.manager = (SensorManager)this.context.getSystemService("sensor");
            if (this.manager.getSensorList(4).isEmpty()) {
                this.gyroscopeAvailable = false;
            } else {
                object = (Sensor)this.manager.getSensorList(4).get(0);
                this.gyroscopeListener = new SensorListener();
                this.gyroscopeAvailable = this.manager.registerListener(this.gyroscopeListener, (Sensor)object, this.config.sensorDelay);
            }
        } else {
            this.gyroscopeAvailable = false;
        }
        this.rotationVectorAvailable = false;
        if (this.config.useRotationVectorSensor) {
            List list;
            if (this.manager == null) {
                this.manager = (SensorManager)this.context.getSystemService("sensor");
            }
            if (!(list = this.manager.getSensorList(11)).isEmpty()) {
                this.rotationVectorListener = new SensorListener();
                object = list.iterator();
                while (object.hasNext()) {
                    Sensor sensor = (Sensor)object.next();
                    if (!sensor.getVendor().equals("Google Inc.") || sensor.getVersion() != 3) continue;
                    this.rotationVectorAvailable = this.manager.registerListener(this.rotationVectorListener, sensor, this.config.sensorDelay);
                    break;
                }
                if (!this.rotationVectorAvailable) {
                    this.rotationVectorAvailable = this.manager.registerListener(this.rotationVectorListener, (Sensor)list.get(0), this.config.sensorDelay);
                }
            }
        }
        if (this.config.useCompass && !this.rotationVectorAvailable) {
            if (this.manager == null) {
                this.manager = (SensorManager)this.context.getSystemService("sensor");
            }
            if ((object = this.manager.getDefaultSensor(2)) != null) {
                this.compassAvailable = this.accelerometerAvailable;
                if (this.compassAvailable) {
                    this.compassListener = new SensorListener();
                    this.compassAvailable = this.manager.registerListener(this.compassListener, (Sensor)object, this.config.sensorDelay);
                }
            } else {
                this.compassAvailable = false;
            }
        } else {
            this.compassAvailable = false;
        }
        Gdx.app.log("AndroidInput", "sensor listener setup");
    }

    @Override
    public void setCatchBackKey(boolean bl) {
        this.setCatchKey(4, bl);
    }

    @Override
    public void setCatchKey(int n, boolean bl) {
        if (!bl) {
            this.keysToCatch.remove(n);
        } else if (bl) {
            this.keysToCatch.add(n);
        }
    }

    @Override
    public void setCatchMenuKey(boolean bl) {
        this.setCatchKey(82, bl);
    }

    @Override
    public void setCursorCatched(boolean bl) {
    }

    @Override
    public void setCursorPosition(int n, int n2) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setInputProcessor(InputProcessor inputProcessor) {
        synchronized (this) {
            this.processor = inputProcessor;
            return;
        }
    }

    @Override
    public void setOnscreenKeyboardVisible(final boolean bl) {
        this.handle.post(new Runnable(){

            @Override
            public void run() {
                InputMethodManager inputMethodManager = (InputMethodManager)AndroidInput.this.context.getSystemService("input_method");
                if (bl) {
                    View view = ((AndroidGraphics)AndroidInput.this.app.getGraphics()).getView();
                    view.setFocusable(true);
                    view.setFocusableInTouchMode(true);
                    inputMethodManager.showSoftInput(((AndroidGraphics)AndroidInput.this.app.getGraphics()).getView(), 0);
                } else {
                    inputMethodManager.hideSoftInputFromWindow(((AndroidGraphics)AndroidInput.this.app.getGraphics()).getView().getWindowToken(), 0);
                }
            }
        });
    }

    void unregisterSensorListeners() {
        SensorManager sensorManager = this.manager;
        if (sensorManager != null) {
            SensorEventListener sensorEventListener = this.accelerometerListener;
            if (sensorEventListener != null) {
                sensorManager.unregisterListener(sensorEventListener);
                this.accelerometerListener = null;
            }
            if ((sensorEventListener = this.gyroscopeListener) != null) {
                this.manager.unregisterListener(sensorEventListener);
                this.gyroscopeListener = null;
            }
            if ((sensorEventListener = this.rotationVectorListener) != null) {
                this.manager.unregisterListener(sensorEventListener);
                this.rotationVectorListener = null;
            }
            if ((sensorEventListener = this.compassListener) != null) {
                this.manager.unregisterListener(sensorEventListener);
                this.compassListener = null;
            }
            this.manager = null;
        }
        Gdx.app.log("AndroidInput", "sensor listener tear down");
    }

    @Override
    public void vibrate(int n) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.vibrator.vibrate(VibrationEffect.createOneShot((long)n, (int)-1));
        } else {
            this.vibrator.vibrate((long)n);
        }
    }

    @Override
    public void vibrate(long[] lArray, int n) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.vibrator.vibrate(VibrationEffect.createWaveform((long[])lArray, (int)n));
        } else {
            this.vibrator.vibrate(lArray, n);
        }
    }

    static class KeyEvent {
        static final int KEY_DOWN = 0;
        static final int KEY_TYPED = 2;
        static final int KEY_UP = 1;
        char keyChar;
        int keyCode;
        long timeStamp;
        int type;

        KeyEvent() {
        }
    }

    private class SensorListener
    implements SensorEventListener {
        public void onAccuracyChanged(Sensor sensor, int n) {
        }

        public void onSensorChanged(SensorEvent sensorEvent) {
            if (sensorEvent.sensor.getType() == 1) {
                if (AndroidInput.this.nativeOrientation == Input.Orientation.Portrait) {
                    System.arraycopy(sensorEvent.values, 0, AndroidInput.this.accelerometerValues, 0, AndroidInput.this.accelerometerValues.length);
                } else {
                    AndroidInput.this.accelerometerValues[0] = sensorEvent.values[1];
                    AndroidInput.this.accelerometerValues[1] = -sensorEvent.values[0];
                    AndroidInput.this.accelerometerValues[2] = sensorEvent.values[2];
                }
            }
            if (sensorEvent.sensor.getType() == 2) {
                System.arraycopy(sensorEvent.values, 0, AndroidInput.this.magneticFieldValues, 0, AndroidInput.this.magneticFieldValues.length);
            }
            if (sensorEvent.sensor.getType() == 4) {
                if (AndroidInput.this.nativeOrientation == Input.Orientation.Portrait) {
                    System.arraycopy(sensorEvent.values, 0, AndroidInput.this.gyroscopeValues, 0, AndroidInput.this.gyroscopeValues.length);
                } else {
                    AndroidInput.this.gyroscopeValues[0] = sensorEvent.values[1];
                    AndroidInput.this.gyroscopeValues[1] = -sensorEvent.values[0];
                    AndroidInput.this.gyroscopeValues[2] = sensorEvent.values[2];
                }
            }
            if (sensorEvent.sensor.getType() == 11) {
                if (AndroidInput.this.nativeOrientation == Input.Orientation.Portrait) {
                    System.arraycopy(sensorEvent.values, 0, AndroidInput.this.rotationVectorValues, 0, AndroidInput.this.rotationVectorValues.length);
                } else {
                    AndroidInput.this.rotationVectorValues[0] = sensorEvent.values[1];
                    AndroidInput.this.rotationVectorValues[1] = -sensorEvent.values[0];
                    AndroidInput.this.rotationVectorValues[2] = sensorEvent.values[2];
                }
            }
        }
    }

    static class TouchEvent {
        static final int TOUCH_DOWN = 0;
        static final int TOUCH_DRAGGED = 2;
        static final int TOUCH_MOVED = 4;
        static final int TOUCH_SCROLLED = 3;
        static final int TOUCH_UP = 1;
        int button;
        int pointer;
        int scrollAmount;
        long timeStamp;
        int type;
        int x;
        int y;

        TouchEvent() {
        }
    }
}

