/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import com.badlogic.gdx.utils.Clipboard;

public class AndroidClipboard
implements Clipboard {
    private android.text.ClipboardManager clipboard;
    private ClipboardManager honeycombClipboard;

    public AndroidClipboard(Context context) {
        if (Build.VERSION.SDK_INT < 11) {
            this.clipboard = (android.text.ClipboardManager)context.getSystemService("clipboard");
        } else {
            this.honeycombClipboard = (ClipboardManager)context.getSystemService("clipboard");
        }
    }

    @Override
    public String getContents() {
        if (Build.VERSION.SDK_INT < 11) {
            if (this.clipboard.getText() == null) {
                return null;
            }
            return this.clipboard.getText().toString();
        }
        Object object = this.honeycombClipboard.getPrimaryClip();
        if (object == null) {
            return null;
        }
        if ((object = object.getItemAt(0).getText()) == null) {
            return null;
        }
        return object.toString();
    }

    @Override
    public void setContents(String string2) {
        if (Build.VERSION.SDK_INT < 11) {
            this.clipboard.setText((CharSequence)string2);
        } else {
            string2 = ClipData.newPlainText((CharSequence)string2, (CharSequence)string2);
            this.honeycombClipboard.setPrimaryClip((ClipData)string2);
        }
    }
}

