/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AssetLoader;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.TimeUtils;
import com.badlogic.gdx.utils.async.AsyncExecutor;
import com.badlogic.gdx.utils.async.AsyncResult;
import com.badlogic.gdx.utils.async.AsyncTask;

class AssetLoadingTask
implements AsyncTask<Void> {
    volatile Object asset = null;
    final AssetDescriptor assetDesc;
    volatile boolean asyncDone = false;
    volatile boolean cancel = false;
    volatile Array<AssetDescriptor> dependencies;
    volatile boolean dependenciesLoaded = false;
    volatile AsyncResult<Void> depsFuture = null;
    final AsyncExecutor executor;
    volatile AsyncResult<Void> loadFuture = null;
    final AssetLoader loader;
    AssetManager manager;
    final long startTime;
    int ticks = 0;

    public AssetLoadingTask(AssetManager assetManager, AssetDescriptor assetDescriptor, AssetLoader assetLoader, AsyncExecutor asyncExecutor) {
        this.manager = assetManager;
        this.assetDesc = assetDescriptor;
        this.loader = assetLoader;
        this.executor = asyncExecutor;
        long l = assetManager.log.getLevel() == 3 ? TimeUtils.nanoTime() : 0L;
        this.startTime = l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAsyncLoader() {
        Object object = (AsynchronousAssetLoader)this.loader;
        if (!this.dependenciesLoaded) {
            if (this.depsFuture == null) {
                this.depsFuture = this.executor.submit(this);
                return;
            } else {
                if (!this.depsFuture.isDone()) return;
                try {
                    this.depsFuture.get();
                    this.dependenciesLoaded = true;
                    if (!this.asyncDone) return;
                    this.asset = ((AsynchronousAssetLoader)object).loadSync(this.manager, this.assetDesc.fileName, this.resolve(this.loader, this.assetDesc), this.assetDesc.params);
                    return;
                }
                catch (Exception exception) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Couldn't load dependencies of asset: ");
                    ((StringBuilder)object).append(this.assetDesc.fileName);
                    throw new GdxRuntimeException(((StringBuilder)object).toString(), exception);
                }
            }
        }
        if (this.loadFuture == null && !this.asyncDone) {
            this.loadFuture = this.executor.submit(this);
            return;
        }
        if (this.asyncDone) {
            this.asset = ((AsynchronousAssetLoader)object).loadSync(this.manager, this.assetDesc.fileName, this.resolve(this.loader, this.assetDesc), this.assetDesc.params);
            return;
        }
        if (!this.loadFuture.isDone()) return;
        try {
            this.loadFuture.get();
            this.asset = ((AsynchronousAssetLoader)object).loadSync(this.manager, this.assetDesc.fileName, this.resolve(this.loader, this.assetDesc), this.assetDesc.params);
            return;
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Couldn't load asset: ");
            ((StringBuilder)object).append(this.assetDesc.fileName);
            throw new GdxRuntimeException(((StringBuilder)object).toString(), exception);
        }
    }

    private void handleSyncLoader() {
        SynchronousAssetLoader synchronousAssetLoader = (SynchronousAssetLoader)this.loader;
        if (!this.dependenciesLoaded) {
            this.dependenciesLoaded = true;
            this.dependencies = synchronousAssetLoader.getDependencies(this.assetDesc.fileName, this.resolve(this.loader, this.assetDesc), this.assetDesc.params);
            if (this.dependencies == null) {
                this.asset = synchronousAssetLoader.load(this.manager, this.assetDesc.fileName, this.resolve(this.loader, this.assetDesc), this.assetDesc.params);
                return;
            }
            this.removeDuplicates(this.dependencies);
            this.manager.injectDependencies(this.assetDesc.fileName, this.dependencies);
        } else {
            this.asset = synchronousAssetLoader.load(this.manager, this.assetDesc.fileName, this.resolve(this.loader, this.assetDesc), this.assetDesc.params);
        }
    }

    private void removeDuplicates(Array<AssetDescriptor> array) {
        boolean bl = array.ordered;
        array.ordered = true;
        for (int i = 0; i < array.size; ++i) {
            String string2 = array.get((int)i).fileName;
            Class clazz = array.get((int)i).type;
            for (int j = array.size - 1; j > i; --j) {
                if (clazz != array.get((int)j).type || !string2.equals(array.get((int)j).fileName)) continue;
                array.removeIndex(j);
            }
        }
        array.ordered = bl;
    }

    private FileHandle resolve(AssetLoader assetLoader, AssetDescriptor assetDescriptor) {
        if (assetDescriptor.file == null) {
            assetDescriptor.file = assetLoader.resolve(assetDescriptor.fileName);
        }
        return assetDescriptor.file;
    }

    @Override
    public Void call() throws Exception {
        AsynchronousAssetLoader asynchronousAssetLoader = (AsynchronousAssetLoader)this.loader;
        if (!this.dependenciesLoaded) {
            this.dependencies = asynchronousAssetLoader.getDependencies(this.assetDesc.fileName, this.resolve(this.loader, this.assetDesc), this.assetDesc.params);
            if (this.dependencies != null) {
                this.removeDuplicates(this.dependencies);
                this.manager.injectDependencies(this.assetDesc.fileName, this.dependencies);
            } else {
                asynchronousAssetLoader.loadAsync(this.manager, this.assetDesc.fileName, this.resolve(this.loader, this.assetDesc), this.assetDesc.params);
                this.asyncDone = true;
            }
        } else {
            asynchronousAssetLoader.loadAsync(this.manager, this.assetDesc.fileName, this.resolve(this.loader, this.assetDesc), this.assetDesc.params);
        }
        return null;
    }

    public Object getAsset() {
        return this.asset;
    }

    public boolean update() {
        int n = this.ticks;
        boolean bl = true;
        this.ticks = n + 1;
        if (this.loader instanceof SynchronousAssetLoader) {
            this.handleSyncLoader();
        } else {
            this.handleAsyncLoader();
        }
        if (this.asset == null) {
            bl = false;
        }
        return bl;
    }
}

