/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.ConfigINI;
import age.of.civilizations2.jakowski.lukasz.Game_Action;
import age.of.civilizations2.jakowski.lukasz.Game_Render;
import age.of.civilizations2.jakowski.lukasz.ImageManager;
import age.of.civilizations2.jakowski.lukasz.Images;
import age.of.civilizations2.jakowski.lukasz.InitGame;
import age.of.civilizations2.jakowski.lukasz.LinkHandler;
import age.of.civilizations2.jakowski.lukasz.MenuManager;
import age.of.civilizations2.jakowski.lukasz.SoundsManager;
import age.of.civilizations2.jakowski.lukasz.Steam_Game;
import age.of.civilizations2.jakowski.lukasz.Touch;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.codedisaster.steamworks.SteamAPI;
import java.lang.reflect.InvocationTargetException;

public class AoCGame
extends ApplicationAdapter
implements InputProcessor {
    public static final boolean STEAM_BUILD = true;
    private Touch touch = new Touch();
    public static int TOP = 0;
    public static int BOTTOM = 0;
    public static int LEFT = 0;
    public static int RIGHT = 0;
    protected static OrthographicCamera camera;
    protected static Viewport viewport;
    private SpriteBatch oSB;
    protected static Steam_Game steamGame;
    protected static LinkHandler mLinkHandler;
    private long lTimeFPS;
    private int iNumOfFPS = 0;
    protected static boolean drawFPS;
    private RequestRendering requestRendering;
    protected static ShaderProgram defaultShader;
    protected static ShaderProgram blackWhiteShader;
    protected static ShaderProgram nextPlayerTurnShader;
    protected static ShaderProgram shaderAlpha;
    protected static ShaderProgram shaderAlpha2;
    private final String VERTEX = "attribute vec4 a_position;attribute vec4 a_color;attribute vec2 a_texCoord0;uniform mat4 u_projTrans;varying vec4 vColor;varying vec2 vTexCoord;void main() {\tvColor = a_color;\tvTexCoord = a_texCoord0;\tgl_Position =  u_projTrans * a_position;}";
    private String vertexShader;
    private String fragmentShader;
    protected static int FPS_LIMIT;
    private long renderStart;
    private boolean MAP_MOVE_LEFT = false;
    private boolean MAP_MOVE_RIGHT = false;
    private boolean MAP_MOVE_TOP = false;
    private boolean MAP_MOVE_BOT = false;
    private static final int DEFAULT_SCROLL_MAP = 12;
    private float iScroll_MAP = 12.0f;
    private long lScrollTime_MAP = 0L;
    private float iScroll_MAPY = 12.0f;
    private long lScrollTime_MAPY = 0L;
    protected static final int TYPE_NUMBER_RESET_TIME = 625;
    protected static long TYPE_NUMER_TIME;
    protected static int TYPE_NUMBER;
    private static final int DEFAULT_SCROLL = 15;
    private int iScroll = 15;
    private long lScrollTime = 0L;
    private boolean quickActionMode = false;

    public AoCGame(LinkHandler linkHandler) {
        mLinkHandler = linkHandler;
    }

    private final void updateRequestRendering(boolean bl) {
        if (bl) {
            this.requestRendering = new RequestRendering(){

                @Override
                public void update() {
                }
            };
            CFG.setRender_3(true);
        } else {
            this.requestRendering = new RequestRendering(){

                @Override
                public void update() {
                }
            };
        }
    }

    private Vector2 getIOSSafeAreaInsets() {
        if (Gdx.app.getType() == Application.ApplicationType.iOS) {
            try {
                Class<?> clazz = Class.forName("age.of.civilizations2.jakowski.lukasz.IOSLauncher");
                return (Vector2)clazz.getDeclaredMethod("getSafeAreaInsets", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return new Vector2();
    }

    private Vector2 getIOSSafeAreaInsets_LeftRight() {
        if (Gdx.app.getType() == Application.ApplicationType.iOS) {
            try {
                Class<?> clazz = Class.forName("age.of.civilizations2.jakowski.lukasz.IOSLauncher");
                return (Vector2)clazz.getDeclaredMethod("getSafeAreaInsets_LeftRight", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return new Vector2();
    }

    @Override
    public void create() {
        Vector2 vector2;
        ConfigINI.readConfig();
        CFG.LANDSCAPE = ConfigINI.landscape;
        if (CFG.isAndroid()) {
            if (CFG.LANDSCAPE) {
                CFG.GAME_WIDTH = Gdx.graphics.getWidth();
                CFG.GAME_HEIGHT = Gdx.graphics.getHeight();
            } else if (Gdx.graphics.getHeight() < Gdx.graphics.getWidth()) {
                CFG.GAME_WIDTH = Gdx.graphics.getHeight();
                CFG.GAME_HEIGHT = Gdx.graphics.getWidth();
            } else {
                CFG.GAME_WIDTH = Gdx.graphics.getWidth();
                CFG.GAME_HEIGHT = Gdx.graphics.getHeight();
            }
        } else {
            CFG.GAME_WIDTH = Gdx.graphics.getWidth();
            CFG.GAME_HEIGHT = Gdx.graphics.getHeight();
        }
        try {
            vector2 = this.getIOSSafeAreaInsets();
            TOP = (int)vector2.x;
            BOTTOM = (int)vector2.y;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        try {
            vector2 = this.getIOSSafeAreaInsets_LeftRight();
            LEFT = (int)vector2.x;
            RIGHT = (int)vector2.y;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        camera = new OrthographicCamera(CFG.GAME_WIDTH, CFG.GAME_HEIGHT);
        camera.setToOrtho(false, CFG.GAME_WIDTH, -CFG.GAME_HEIGHT);
        viewport = new FitViewport(CFG.GAME_WIDTH, (float)CFG.GAME_HEIGHT, camera);
        CFG.updateRender(true);
        this.updateRequestRendering(true);
        CFG.loadSettings();
        CFG.DENSITY = Gdx.graphics.getDensity();
        if (CFG.DENSITY < 1.0f) {
            CFG.DENSITY = 1.0f;
        }
        if (ConfigINI.iUIScale <= 0) {
            if (CFG.isAndroid()) {
                CFG.XHDPI = Gdx.graphics.getPpiX() >= 300.0f || CFG.GAME_WIDTH >= 1200 || CFG.GAME_HEIGHT >= 1200;
                CFG.XXHDPI = Gdx.graphics.getPpiX() >= 380.0f || CFG.GAME_WIDTH >= 1800 || CFG.GAME_HEIGHT >= 1800;
            } else if (CFG.isDesktop()) {
                CFG.XHDPI = CFG.GAME_WIDTH >= 2400;
            }
        } else if (ConfigINI.iUIScale == 1) {
            CFG.XHDPI = false;
            CFG.XXHDPI = false;
            CFG.XXXHDPI = false;
            CFG.XXXXHDPI = false;
        } else if (ConfigINI.iUIScale == 2) {
            CFG.XHDPI = true;
            CFG.XXHDPI = false;
            CFG.XXXHDPI = false;
            CFG.XXXXHDPI = false;
        } else if (ConfigINI.iUIScale == 3) {
            CFG.XHDPI = true;
            CFG.XXHDPI = true;
            CFG.XXXHDPI = false;
            CFG.XXXXHDPI = false;
        } else if (ConfigINI.iUIScale == 4) {
            CFG.XHDPI = true;
            CFG.XXHDPI = true;
            CFG.XXXHDPI = true;
            CFG.XXXXHDPI = false;
        } else if (ConfigINI.iUIScale == 5) {
            CFG.XHDPI = true;
            CFG.XXHDPI = true;
            CFG.XXXHDPI = true;
            CFG.XXXXHDPI = true;
        }
        this.oSB = new SpriteBatch();
        Gdx.input.setInputProcessor(this);
        Gdx.input.setCatchBackKey(true);
        Images.btn_menu_h = ImageManager.addImage("UI/" + CFG.getRescouresPath() + "buttons/menu.png");
        Images.btn_clear = ImageManager.addImage("UI/" + CFG.getRescouresPath() + "buttons/clear.png");
        Images.btn_close = ImageManager.addImage("UI/" + CFG.getRescouresPath() + "buttons/close.png");
        Images.line_32_off1 = ImageManager.addImage("UI/lines/line_32_off1.png", Pixmap.Format.RGBA8888, Texture.TextureFilter.Linear, Texture.TextureWrap.Repeat);
        Images.gradient = ImageManager.addImage("UI/" + CFG.getRescouresPath() + "gradient.png");
        Images.loading_rect_edge = ImageManager.addImage("UI/" + CFG.getRescouresPath() + "loading/loading_edge.png", Pixmap.Format.RGBA8888, Texture.TextureFilter.Nearest, Texture.TextureWrap.ClampToEdge);
        Images.pix255_255_255 = ImageManager.addImage("UI/pix", Pixmap.Format.RGBA8888, Texture.TextureFilter.Linear, Texture.TextureWrap.Repeat);
        CFG.BUTTON_HEIGHT = ImageManager.getImage(Images.btn_menu_h).getHeight();
        CFG.BUTTON_WIDTH = CFG.XXXXHDPI ? 212 : (CFG.XXXHDPI ? 180 : (CFG.XXHDPI ? 160 : (CFG.XHDPI ? 120 : 90)));
        CFG.GUI_SCALE = 100.0f * (float)CFG.BUTTON_HEIGHT / 68.0f / 100.0f;
        CFG.PADDING = (int)(5.0f * CFG.GUI_SCALE);
        CFG.CIV_INFO_MENU_WIDTH = (int)((float)CFG.CIV_INFO_MENU_WIDTH * CFG.GUI_SCALE);
        CFG.CIV_COLOR_WIDTH = (int)((float)CFG.CIV_COLOR_WIDTH * CFG.GUI_SCALE);
        CFG.SERVICE_RIBBON_WIDTH = (int)((float)CFG.SERVICE_RIBBON_WIDTH * CFG.GUI_SCALE);
        CFG.SERVICE_RIBBON_HEIGHT = (int)((float)CFG.SERVICE_RIBBON_HEIGHT * CFG.GUI_SCALE);
        if (CFG.settingsManager.FONT_MAIN_SIZE < 0) {
            CFG.settingsManager.FONT_MAIN_SIZE = (int)(18.0f * CFG.GUI_SCALE);
        }
        AoCGame.updateArmyFontSize();
        Images.gameLogo = ImageManager.addImage("UI/" + CFG.getRescouresPath() + "game_logo.png");
        CFG.menuManager = new MenuManager();
        Game_Render.updateRenderer();
        Game_Render.updateDrawMoveUnits();
        CFG.soundsManager = new SoundsManager();
        new InitGame();
        ShaderProgram.pedantic = false;
        String string = Gdx.files.internal("game/shader/default_vertex.glsl").readString();
        String string2 = Gdx.files.internal("game/shader/flag_fragment.glsl").readString();
        String string3 = Gdx.files.internal("game/shader/nextPlayerTurn_vertex.glsl").readString();
        shaderAlpha = new ShaderProgram("attribute vec4 a_position;attribute vec4 a_color;attribute vec2 a_texCoord0;uniform mat4 u_projTrans;varying vec4 vColor;varying vec2 vTexCoord;void main() {\tvColor = a_color;\tvTexCoord = a_texCoord0;\tgl_Position =  u_projTrans * a_position;}", string2);
        shaderAlpha.begin();
        shaderAlpha.setUniformi("u_texture1", 1);
        shaderAlpha.setUniformi("u_mask", 2);
        shaderAlpha.end();
        this.vertexShader = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projTrans * a_position;\n}\n";
        this.fragmentShader = "#ifdef GL_ES\nprecision mediump float;\n#endif\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nuniform sampler2D u_texture2;\nuniform float u_maskScale;\nuniform float u_useMask;\nuniform vec2 u_maskOffset;\nvoid main()                                  \n{                                            \n vec2 newCoords = -1.0 * (u_maskScale - 1.0)/2.0 + (u_maskScale * v_texCoords) + u_maskOffset;\n vec4 mask = vec4(1.0, 1.0, 1.0, 1.0); \nif(u_useMask > 0.5) \n\tmask = texture2D(u_texture2, v_texCoords);\n vec4 color = v_color * texture2D(u_texture, newCoords);\n  gl_FragColor = vec4(color.rgb, color.a * mask.r);\n}";
        shaderAlpha2 = new ShaderProgram(this.vertexShader, this.fragmentShader);
        shaderAlpha2.begin();
        shaderAlpha2.setUniformi("u_texture", 0);
        shaderAlpha2.setUniformi("u_texture2", 1);
        shaderAlpha2.setUniformf("u_useMask", 1.0f);
        shaderAlpha2.setUniformf("u_maskScale", 20.0f);
        shaderAlpha2.setUniformf("u_maskOffset", 0.0f, 0.0f);
        String string4 = Gdx.files.internal("game/shader/default_fragment.glsl").readString();
        String string5 = Gdx.files.internal("game/shader/blackWhite_fragment.glsl").readString();
        String string6 = Gdx.files.internal("game/shader/nextPlayerTurn_fragment.glsl").readString();
        defaultShader = new ShaderProgram(string, string4);
        blackWhiteShader = new ShaderProgram(string, string5);
        nextPlayerTurnShader = new ShaderProgram(string3, string6);
        long l = System.currentTimeMillis();
        AoCGame.loadCursor(true);
        steamGame = new Steam_Game();
        Gdx.app.log("AoC", "LOAD TIME: " + (System.currentTimeMillis() - l));
    }

    protected static final void loadCursor(boolean bl) {
        if (CFG.settingsManager.loadCursor) {
            try {
                Pixmap pixmap = new Pixmap(Gdx.files.internal("UI/icons/cursor.png"));
                Cursor cursor = Gdx.graphics.newCursor(pixmap, 0, 0);
                Gdx.graphics.setCursor(cursor);
                pixmap.dispose();
            }
            catch (GdxRuntimeException gdxRuntimeException) {}
        } else if (!bl) {
            Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
        }
    }

    protected static final void updateArmyFontSize() {
        if (CFG.settingsManager.FONT_ARMY_SIZE < 0) {
            CFG.settingsManager.FONT_ARMY_SIZE = CFG.XXXHDPI || CFG.XXXXHDPI || CFG.XXHDPI ? 18 : 16;
        }
    }

    public void update() {
        block26: {
            block25: {
                block24: {
                    this.countFPS();
                    try {
                        CFG.game.update();
                    }
                    catch (NullPointerException nullPointerException) {
                        if (CFG.LOGS) {
                            CFG.exceptionStack(nullPointerException);
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        if (CFG.LOGS) {
                            CFG.exceptionStack(indexOutOfBoundsException);
                        }
                    }
                    catch (StackOverflowError stackOverflowError) {
                        if (CFG.LOGS) {
                            CFG.exceptionStack(stackOverflowError);
                        }
                    }
                    catch (ArithmeticException arithmeticException) {
                        if (!CFG.LOGS) break block24;
                        CFG.exceptionStack(arithmeticException);
                    }
                }
                try {
                    CFG.map.update();
                }
                catch (NullPointerException nullPointerException) {
                    if (CFG.LOGS) {
                        CFG.exceptionStack(nullPointerException);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (CFG.LOGS) {
                        CFG.exceptionStack(indexOutOfBoundsException);
                    }
                }
                catch (StackOverflowError stackOverflowError) {
                    if (CFG.LOGS) {
                        CFG.exceptionStack(stackOverflowError);
                    }
                }
                catch (ArithmeticException arithmeticException) {
                    if (!CFG.LOGS) break block25;
                    CFG.exceptionStack(arithmeticException);
                }
            }
            try {
                CFG.menuManager.update();
            }
            catch (NullPointerException nullPointerException) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(nullPointerException);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(indexOutOfBoundsException);
                }
            }
            catch (StackOverflowError stackOverflowError) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(stackOverflowError);
                }
            }
            catch (ArithmeticException arithmeticException) {
                if (!CFG.LOGS) break block26;
                CFG.exceptionStack(arithmeticException);
            }
        }
    }

    @Override
    public void render() {
        block34: {
            this.renderStart = System.currentTimeMillis();
            try {
                this.update();
                this.updateMoveMap();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            catch (NullPointerException nullPointerException) {
                CFG.exceptionStack(nullPointerException);
            }
            catch (ArithmeticException arithmeticException) {
                CFG.exceptionStack(arithmeticException);
            }
            catch (StackOverflowError stackOverflowError) {
                CFG.exceptionStack(stackOverflowError);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                CFG.exceptionStack(illegalArgumentException);
            }
            if (CFG.RENDER || CFG.settingsManager.CONTINUOUS_RENDERING) {
                try {
                    if (CFG.RENDER3) {
                        CFG.RENDER3 = false;
                    } else if (CFG.RENDER2) {
                        CFG.RENDER2 = false;
                    } else {
                        CFG.RENDER = false;
                    }
                    Gdx.gl.glClearColor(CFG.BACKGROUND_COLOR.r, CFG.BACKGROUND_COLOR.g, CFG.BACKGROUND_COLOR.b, CFG.BACKGROUND_COLOR.a);
                    Gdx.gl.glClear(16640);
                    viewport.setWorldSize((float)CFG.GAME_WIDTH / CFG.map.getMapScale().getCurrentScale(), (float)CFG.GAME_HEIGHT / CFG.map.getMapScale().getCurrentScale());
                    viewport.apply();
                    camera.setToOrtho(true, (float)CFG.GAME_WIDTH / CFG.map.getMapScale().getCurrentScale(), (float)(-CFG.GAME_HEIGHT) / CFG.map.getMapScale().getCurrentScale());
                    this.oSB.setProjectionMatrix(AoCGame.camera.combined);
                    this.oSB.begin();
                    this.oSB.setShader(defaultShader);
                    Game_Render.draw(this.oSB);
                    this.oSB.end();
                    camera.setToOrtho(false, CFG.GAME_WIDTH, -CFG.GAME_HEIGHT);
                    viewport.setWorldSize(CFG.GAME_WIDTH, CFG.GAME_HEIGHT);
                    viewport.apply();
                    this.oSB.setProjectionMatrix(AoCGame.camera.combined);
                    this.oSB.begin();
                    Game_Render.drawWithoutScale(this.oSB);
                    this.oSB.end();
                    viewport.setWorldSize((float)CFG.GAME_WIDTH / CFG.map.getMapScale().getCurrentScale(), (float)CFG.GAME_HEIGHT / CFG.map.getMapScale().getCurrentScale());
                    viewport.apply();
                    camera.setToOrtho(true, (float)CFG.GAME_WIDTH / CFG.map.getMapScale().getCurrentScale(), (float)(-CFG.GAME_HEIGHT) / CFG.map.getMapScale().getCurrentScale());
                    this.oSB.setProjectionMatrix(AoCGame.camera.combined);
                    this.oSB.begin();
                    this.oSB.setShader(defaultShader);
                    Game_Render.drawMapDetails(this.oSB);
                    this.oSB.end();
                    camera.setToOrtho(false, CFG.GAME_WIDTH, -CFG.GAME_HEIGHT);
                    viewport.setWorldSize(CFG.GAME_WIDTH, CFG.GAME_HEIGHT);
                    viewport.apply();
                    this.oSB.setProjectionMatrix(AoCGame.camera.combined);
                    this.oSB.begin();
                    this.oSB.setColor(Color.WHITE);
                    CFG.menuManager.draw(this.oSB);
                    CFG.editorManager.draw(this.oSB);
                    if (drawFPS) {
                        try {
                            CFG.fontMain.getData().setScale(0.8f);
                            CFG.drawTextWithShadow(this.oSB, "FPS: " + CFG.iNumOfFPS, CFG.PADDING * 2, CFG.PADDING * 2, Color.WHITE);
                            CFG.fontMain.getData().setScale(1.0f);
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    this.oSB.setColor(Color.WHITE);
                    this.oSB.end();
                }
                catch (IllegalStateException illegalStateException) {
                    if (CFG.LOGS) {
                        CFG.exceptionStack(illegalStateException);
                    }
                    CFG.setRender_3(true);
                    try {
                        this.oSB.end();
                    }
                    catch (IllegalStateException illegalStateException2) {
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if (CFG.LOGS) {
                        CFG.exceptionStack(nullPointerException);
                    }
                    CFG.setRender_3(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    CFG.exceptionStack(indexOutOfBoundsException);
                    CFG.setRender_3(true);
                }
                catch (StackOverflowError stackOverflowError) {
                    CFG.exceptionStack(stackOverflowError);
                    CFG.setRender_3(true);
                }
                catch (ArithmeticException arithmeticException) {
                    CFG.exceptionStack(arithmeticException);
                    CFG.setRender_3(true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    CFG.exceptionStack(illegalArgumentException);
                    CFG.setRender_3(true);
                }
            } else {
                try {
                    Thread.sleep((long)(1000.0f / (float)FPS_LIMIT - (float)(System.currentTimeMillis() - this.renderStart)));
                }
                catch (InterruptedException interruptedException) {
                    if (CFG.LOGS) {
                        CFG.exceptionStack(interruptedException);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (CFG.LOGS) {
                        CFG.exceptionStack(illegalArgumentException);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if (!CFG.LOGS) break block34;
                    CFG.exceptionStack(nullPointerException);
                }
            }
        }
        if (CFG.isDesktop() && SteamAPI.isSteamRunning()) {
            SteamAPI.runCallbacks();
        }
        this.requestRendering.update();
    }

    private void countFPS() {
        ++this.iNumOfFPS;
        if (System.currentTimeMillis() > this.lTimeFPS + 1000L) {
            this.lTimeFPS = System.currentTimeMillis();
            CFG.iNumOfFPS = this.iNumOfFPS;
            this.iNumOfFPS = 0;
        }
    }

    @Override
    public void resize(int n, int n2) {
        if (CFG.isAndroid()) {
            if (CFG.LANDSCAPE) {
                viewport.update(n, n2, false);
            } else {
                viewport.update(-n2, -n, false);
            }
        } else {
            viewport.update(n, n2, false);
        }
        CFG.setRender_3(true);
    }

    @Override
    public void dispose() {
        block6: {
            try {
                Gdx.app.log("AoC", "dispose");
                if (CFG.isDesktop()) {
                    SteamAPI.shutdown();
                }
                this.oSB.dispose();
                CFG.fontMain.dispose();
                CFG.fontBorder.dispose();
                for (int i = 0; i < ImageManager.getImagesSize(); ++i) {
                    ImageManager.getImage(i).getTexture().dispose();
                }
                CFG.map.getMapBG().disposeGameMap();
                CFG.soundsManager.dispose();
            }
            catch (GdxRuntimeException gdxRuntimeException) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(gdxRuntimeException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!CFG.LOGS) break block6;
                CFG.exceptionStack(nullPointerException);
            }
        }
    }

    @Override
    public boolean touchDown(int n, int n2, int n3, int n4) {
        try {
            Touch.setMousePosXY(n, n2);
            CFG.setRender_3(true);
            this.touch.actionDown(n, n2, n3);
            CFG.editorManager.touchDown(n, n2, n3, n4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CFG.exceptionStack(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CFG.exceptionStack(nullPointerException);
        }
        catch (StackOverflowError stackOverflowError) {
            CFG.exceptionStack(stackOverflowError);
        }
        catch (ArithmeticException arithmeticException) {
            CFG.exceptionStack(arithmeticException);
        }
        return true;
    }

    @Override
    public boolean touchDragged(int n, int n2, int n3) {
        try {
            Touch.setMousePosXY(n, n2);
            if (Gdx.input.isTouched(1) && n3 == 0) {
                this.touch.actionMove(Gdx.input.getX(0), Gdx.input.getY(0), Gdx.input.getX(1), Gdx.input.getY(1));
            } else {
                this.touch.actionMove(n, n2, n3);
            }
            CFG.editorManager.touchDragged(n, n2, n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CFG.exceptionStack(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CFG.exceptionStack(nullPointerException);
        }
        catch (StackOverflowError stackOverflowError) {
            CFG.exceptionStack(stackOverflowError);
        }
        catch (ArithmeticException arithmeticException) {
            CFG.exceptionStack(arithmeticException);
        }
        return true;
    }

    @Override
    public boolean touchUp(int n, int n2, int n3, int n4) {
        try {
            block15: {
                Touch.setMousePosXY(n, n2);
                CFG.setRender_3(true);
                try {
                    if (CFG.isDesktop()) {
                        if (CFG.menuManager.getInGameView() && CFG.map.getMapScale().getCurrentScale() >= 1.0f) {
                            if (n4 == 1 && !CFG.SPECTATOR_MODE && CFG.gameAction.getActiveTurnState() == Game_Action.TurnStates.INPUT_ORDERS && CFG.game.getCiv(CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID()).getMovePoints() >= CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getPlayer((int)CFG.PLAYER_TURNID).getCivID()).getIdeologyID()).COST_OF_MOVE_OWN_PROVINCE && CFG.game.getActiveProvinceID() >= 0 && CFG.gameAction.controlsArmyInProvince(CFG.game.getActiveProvinceID(), CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID()) && !CFG.menuManager.getVisible_InGame_FlagAction()) {
                                CFG.game.setProvinceID_PPM(n, n2);
                            } else {
                                this.touch.actionUp(n, n2, n3);
                            }
                        } else {
                            this.touch.actionUp(n, n2, n3);
                        }
                    } else {
                        this.touch.actionUp(n, n2, n3);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    this.touch.actionUp(n, n2, n3);
                    if (CFG.LOGS) {
                        CFG.exceptionStack(nullPointerException);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.touch.actionUp(n, n2, n3);
                    if (!CFG.LOGS) break block15;
                    CFG.exceptionStack(indexOutOfBoundsException);
                }
            }
            CFG.editorManager.touchUp(n, n2, n3, n4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CFG.exceptionStack(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CFG.exceptionStack(nullPointerException);
        }
        catch (StackOverflowError stackOverflowError) {
            CFG.exceptionStack(stackOverflowError);
        }
        catch (ArithmeticException arithmeticException) {
            CFG.exceptionStack(arithmeticException);
        }
        return true;
    }

    @Override
    public boolean mouseMoved(int n, int n2) {
        try {
            Touch.setMousePosXY(n, n2);
            if (CFG.isDesktop()) {
                if (n < CFG.PADDING) {
                    if (!this.MAP_MOVE_LEFT) {
                        this.MAP_MOVE_LEFT = true;
                        this.MAP_MOVE_RIGHT = false;
                        this.lScrollTime_MAP = System.currentTimeMillis();
                        this.iScroll_MAP = 15.0f;
                    }
                } else {
                    this.MAP_MOVE_LEFT = false;
                }
                if (n > CFG.GAME_WIDTH - CFG.PADDING) {
                    if (!this.MAP_MOVE_RIGHT) {
                        this.MAP_MOVE_RIGHT = true;
                        this.MAP_MOVE_LEFT = false;
                        this.lScrollTime_MAP = System.currentTimeMillis();
                        this.iScroll_MAP = 15.0f;
                    }
                } else {
                    this.MAP_MOVE_RIGHT = false;
                }
                if (n2 < CFG.PADDING) {
                    if (!this.MAP_MOVE_TOP) {
                        this.MAP_MOVE_TOP = true;
                        this.MAP_MOVE_BOT = false;
                        this.lScrollTime_MAPY = System.currentTimeMillis();
                        this.iScroll_MAPY = 15.0f;
                    }
                } else {
                    this.MAP_MOVE_TOP = false;
                }
                if (n2 > CFG.GAME_HEIGHT - CFG.PADDING) {
                    if (!this.MAP_MOVE_BOT) {
                        this.MAP_MOVE_BOT = true;
                        this.MAP_MOVE_TOP = false;
                        this.lScrollTime_MAPY = System.currentTimeMillis();
                        this.iScroll_MAPY = 15.0f;
                    }
                } else {
                    this.MAP_MOVE_BOT = false;
                }
            }
            this.touch.actionMove_Hover(n, n2);
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CFG.exceptionStack(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CFG.exceptionStack(nullPointerException);
        }
        catch (StackOverflowError stackOverflowError) {
            CFG.exceptionStack(stackOverflowError);
        }
        catch (ArithmeticException arithmeticException) {
            CFG.exceptionStack(arithmeticException);
        }
        return true;
    }

    private final void updateMoveMap() {
        block12: {
            try {
                if (this.MAP_MOVE_LEFT) {
                    this.updateScroll_Map();
                    CFG.map.getMapCoordinates().setNewPosX(CFG.map.getMapCoordinates().getPosX() + (int)this.iScroll_MAP);
                } else if (this.MAP_MOVE_RIGHT) {
                    this.updateScroll_Map();
                    CFG.map.getMapCoordinates().setNewPosX(CFG.map.getMapCoordinates().getPosX() - (int)this.iScroll_MAP);
                }
                if (this.MAP_MOVE_TOP) {
                    this.updateScroll_MapY();
                    CFG.map.getMapCoordinates().setNewPosY(CFG.map.getMapCoordinates().getPosY() + (int)this.iScroll_MAPY);
                } else if (this.MAP_MOVE_BOT) {
                    this.updateScroll_MapY();
                    CFG.map.getMapCoordinates().setNewPosY(CFG.map.getMapCoordinates().getPosY() - (int)this.iScroll_MAPY);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(indexOutOfBoundsException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(nullPointerException);
                }
            }
            catch (ArithmeticException arithmeticException) {
                if (!CFG.LOGS) break block12;
                CFG.exceptionStack(arithmeticException);
            }
        }
    }

    private final void updateScroll_Map() {
        if (this.lScrollTime_MAP + 150L < System.currentTimeMillis()) {
            float f;
            this.lScrollTime_MAP = System.currentTimeMillis();
            this.iScroll_MAP += this.iScroll_MAP * 0.475f;
            float f2 = f = CFG.map.getMapScale().getCurrentScale() < 1.0f ? 1.0f + (1.0f - CFG.map.getMapScale().getCurrentScale()) : 1.0f;
            if (this.iScroll_MAP > 35.0f * f) {
                this.iScroll_MAP = 35.0f * (CFG.map.getMapScale().getCurrentScale() < 1.0f ? 1.0f + (1.0f - CFG.map.getMapScale().getCurrentScale()) : 1.0f);
            }
        }
    }

    private final void updateScroll_MapY() {
        if (this.lScrollTime_MAPY + 150L < System.currentTimeMillis()) {
            float f;
            this.lScrollTime_MAPY = System.currentTimeMillis();
            this.iScroll_MAPY += this.iScroll_MAPY * 0.475f;
            float f2 = f = CFG.map.getMapScale().getCurrentScale() < 1.0f ? 1.0f + (1.0f - CFG.map.getMapScale().getCurrentScale()) : 1.0f;
            if (this.iScroll_MAPY > 35.0f * f) {
                this.iScroll_MAPY = 35.0f * (CFG.map.getMapScale().getCurrentScale() < 1.0f ? 1.0f + (1.0f - CFG.map.getMapScale().getCurrentScale()) : 1.0f);
            }
        }
    }

    @Override
    public boolean keyDown(int n) {
        try {
            CFG.setRender_3(true);
            if (!CFG.menuManager.getKeyboard().getVisible()) {
                if (CFG.editorManager.keyDown(n)) {
                    return true;
                }
                if (n == 21) {
                    this.MAP_MOVE_LEFT = true;
                    this.MAP_MOVE_RIGHT = false;
                    this.lScrollTime_MAP = System.currentTimeMillis();
                    this.iScroll_MAP = 15.0f;
                }
                if (n == 22) {
                    this.MAP_MOVE_RIGHT = true;
                    this.MAP_MOVE_LEFT = false;
                    this.lScrollTime_MAP = System.currentTimeMillis();
                    this.iScroll_MAP = 15.0f;
                }
                if (n == 19) {
                    this.MAP_MOVE_TOP = true;
                    this.MAP_MOVE_BOT = false;
                    this.lScrollTime_MAPY = System.currentTimeMillis();
                    this.iScroll_MAPY = 15.0f;
                }
                if (n == 20) {
                    this.MAP_MOVE_BOT = true;
                    this.MAP_MOVE_TOP = false;
                    this.lScrollTime_MAPY = System.currentTimeMillis();
                    this.iScroll_MAPY = 15.0f;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CFG.exceptionStack(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CFG.exceptionStack(nullPointerException);
        }
        catch (StackOverflowError stackOverflowError) {
            CFG.exceptionStack(stackOverflowError);
        }
        catch (ArithmeticException arithmeticException) {
            CFG.exceptionStack(arithmeticException);
        }
        return true;
    }

    protected final void typeNumber(int n) {
        if (System.currentTimeMillis() - 625L > TYPE_NUMER_TIME) {
            TYPE_NUMBER = n;
        } else {
            TYPE_NUMBER *= 10;
            TYPE_NUMBER += n;
        }
        TYPE_NUMER_TIME = System.currentTimeMillis();
    }

    protected static final void resetTypeNumber() {
        TYPE_NUMER_TIME = 0L;
        TYPE_NUMBER = 0;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean keyUp(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean keyTyped(char c) {
        CFG.setRender_3(true);
        Gdx.app.log("AoC", "" + c + " character: " + c);
        try {
            if (CFG.menuManager.getKeyboard().getVisible() && c > '\u0000') {
                if (c == '\u0012' || c == '\b') {
                    CFG.keyboardDelete.action();
                    CFG.menuManager.getKeyboard().onMenuPressed();
                } else if (c != '\r' && c != ';' && c != '<') {
                    CFG.keyboardWrite.action("" + c);
                    CFG.menuManager.getKeyboard().onMenuPressed();
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CFG.exceptionStack(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CFG.exceptionStack(nullPointerException);
        }
        catch (StackOverflowError stackOverflowError) {
            CFG.exceptionStack(stackOverflowError);
        }
        catch (ArithmeticException arithmeticException) {
            CFG.exceptionStack(arithmeticException);
        }
        try {
            CFG.soundsManager.playSound(SoundsManager.SOUND_CLICK, SoundsManager.PERC_VOLUME_KEYBOARD);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CFG.exceptionStack(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CFG.exceptionStack(nullPointerException);
        }
        catch (StackOverflowError stackOverflowError) {
            CFG.exceptionStack(stackOverflowError);
        }
        catch (ArithmeticException arithmeticException) {
            CFG.exceptionStack(arithmeticException);
        }
        return false;
    }

    protected float getScrolled_ScaleUpdate() {
        if (CFG.map.getMapScale().getCurrentScale() <= 1.0f) {
            if (CFG.map.getMapScale().getCurrentScale() >= 0.65f) {
                return 0.05f;
            }
            if (CFG.map.getMapScale().getCurrentScale() >= 0.4f) {
                return 0.02f;
            }
            return 0.01f;
        }
        return 0.1f;
    }

    @Override
    public boolean scrolled(int n) {
        try {
            if (CFG.menuManager.getIsScrollableY_MenuHovered()) {
                this.updateScroll();
                CFG.menuManager.scrollHoveredMenu_Y(n == 1 ? -this.iScroll : this.iScroll);
            } else if (CFG.menuManager.getIsScrollableX_MenuHovered()) {
                this.updateScroll();
                CFG.menuManager.scrollHoveredMenu_X(n == 1 ? -this.iScroll : this.iScroll);
            } else if (CFG.menuManager.getIsScrollable_Hovered_MenuElement()) {
                this.updateScroll();
                CFG.menuManager.scrollHoveredMenuElement(n == 1 ? -this.iScroll : this.iScroll);
            } else if (n == 1) {
                CFG.map.getMapScale().setNewCurrentScaleByButton2(-this.getScrolled_ScaleUpdate());
            } else if (n == -1) {
                CFG.map.getMapScale().setNewCurrentScaleByButton2(this.getScrolled_ScaleUpdate());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CFG.exceptionStack(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CFG.exceptionStack(nullPointerException);
        }
        catch (StackOverflowError stackOverflowError) {
            CFG.exceptionStack(stackOverflowError);
        }
        catch (ArithmeticException arithmeticException) {
            CFG.exceptionStack(arithmeticException);
        }
        try {
            CFG.soundsManager.playSound(SoundsManager.SOUND_CLICK, SoundsManager.PERC_VOLUME_KEYBOARD);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CFG.exceptionStack(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CFG.exceptionStack(nullPointerException);
        }
        catch (StackOverflowError stackOverflowError) {
            CFG.exceptionStack(stackOverflowError);
        }
        catch (ArithmeticException arithmeticException) {
            CFG.exceptionStack(arithmeticException);
        }
        return true;
    }

    private final void updateScroll() {
        if (this.lScrollTime + 50L > System.currentTimeMillis()) {
            this.lScrollTime = System.currentTimeMillis();
            this.iScroll += (int)((float)this.iScroll * 1.2f);
            if (this.iScroll > 75) {
                this.iScroll = 75;
            }
        } else {
            this.lScrollTime = System.currentTimeMillis();
            this.iScroll = 15;
        }
    }

    @Override
    public void resume() {
        CFG.updateRender(true);
        this.updateRequestRendering(true);
        Gdx.graphics.requestRendering();
        CFG.setRender_3(true);
        super.resume();
    }

    @Override
    public void pause() {
        this.updateRequestRendering(false);
        if (!CFG.menuManager.getInLoadMap() && !CFG.menuManager.getInInitMenu()) {
            CFG.updateRender(false);
        }
        CFG.setRender_3(true);
        super.pause();
    }

    static {
        drawFPS = false;
        FPS_LIMIT = 60;
        TYPE_NUMER_TIME = 0L;
        TYPE_NUMBER = 0;
    }

    static interface RequestRendering {
        public void update();
    }
}

